If you have handling problems or questions, consider to open a discussion https://github.com/Arduino-IRremote/Arduino-IRremote/discussions instead of an issue.

### Board
* [ ] Arduino ATmega328* board (UNO, Nano)
* [ ] Arduino ATmega2560 board (Mega)
* [ ] Arduino ATmega32U4 board (Leonardo)
* [ ] ATtiny85 board (ATTinyCore by Spence Conde)
* [ ] Digispark board
* [ ] ATtiny3217 board (TinyCore)
* [ ] Arduino SAM board (Due)
* [ ] Arduino SAMD board (Zero, MKR*)
* [ ] ESP32 board - first check https://github.com/crankyoldgit/IRremoteESP8266
* [ ] Teensy board
* [ ] STM32F1 board (BluePill)
* [ ] Other - please specify

<!-- Please specify board name if not included in board selection -->

### IDE
* [ ] Arduino IDE
* [ ] Arduino Web Editor
* [ ] Arduino Pro IDE
* [ ] Sloeber IDE
* [ ] PlatformIO IDE
* [ ] Other - please specify

### Protocol
* [ ] Unknown
* [ ] BoseWave
* [ ] Denon
* [ ] Dish
* [ ] JVC
* [ ] Lego
* [ ] LG
* [ ] NEC
* [ ] Panasonic
* [ ] RC5, RC6
* [ ] Samsung
* [ ] Sharp
* [ ] Sony
* [ ] Whynter
* [ ] Other - please specify

### Version
* [ ] Yes I use the [latest repo version](https://github.com/Arduino-IRremote/Arduino-IRremote/archive/master.zip) and verified this!
* [ ] Other - please specify

Please delete all unchecked lines above :-)

### Pin(s) used for IR-receive, if not default

[Use code blocks](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet#code); **it helps us help you when we can read your code!**
Please also refrain from pasting more than 50 lines of code in a post, instead **[create a gist](https://gist.github.com/) if you need to share large snippets**
**Code Block:**
```

#include <IRremote.h> 

.....

```


### Current behavior
<!-- Paste the code or repository link, if applicable. -->

<!-- Add a the serial output which indicates the error happened. -->

<!-- Add a clear and concise description of the behavior. -->

### Expected behavior
<!-- Add a clear and concise description of what you expected to happen. -->

### Additional context
<!-- (Optional) Add any other context about the problem here. -->


**checklist:**
- [] I have **read** the README.md file thoroughly.
- [] I have searched existing issues to see if there is anything I have missed.
- [] I have browsed the examples for one, that matches my use case.
- [] Any code referenced is provided and if over 30 lines a gist is linked INSTEAD of it being pasted in here.
- [] The title of the issue is helpful and relevant.
- [] I checked, if at least one of the examples was working.

** We will start to close issues that do not follow these guidelines as it doesn't help the contributors who spend time trying to solve issues if the community ignores guidelines!**
