#define LGFX_USE_V1
#include <LovyanGFX.hpp>

static LGFX lcd;
static LGFX_Sprite sprite[10];

static std::uint32_t count = 0;
static float zoom = 0;

extern const unsigned char parrot00[];
extern const unsigned char parrot01[];
extern const unsigned char parrot02[];
extern const unsigned char parrot03[];
extern const unsigned char parrot04[];
extern const unsigned char parrot05[];
extern const unsigned char parrot06[];
extern const unsigned char parrot07[];
extern const unsigned char parrot08[];
extern const unsigned char parrot09[];

void setup()
{
  lcd.init();
  lcd.setRotation(0);
  if (lcd.width() < lcd.height()) { lcd.setRotation(lcd.getRotation() ^ 1); }

  zoom = (float)lcd.width() / 128;
  float ztmp = (float)lcd.height() / 96;
  if (zoom > ztmp) { zoom = ztmp; }

  lcd.setPivot(lcd.width() >> 1, lcd.height() >> 1);
  lcd.fillScreen(0xFFFFFFU);

  sprite[0].createFromBmp(parrot00);
  sprite[1].createFromBmp(parrot01);
  sprite[2].createFromBmp(parrot02);
  sprite[3].createFromBmp(parrot03);
  sprite[4].createFromBmp(parrot04);
  sprite[5].createFromBmp(parrot05);
  sprite[6].createFromBmp(parrot06);
  sprite[7].createFromBmp(parrot07);
  sprite[8].createFromBmp(parrot08);
  sprite[9].createFromBmp(parrot09);
}

void loop() {
  if (++count == 10) count = 0;
  sprite[count].pushRotateZoom(&lcd, lcd.width() >> 1, lcd.height() >> 1, 0, zoom, zoom);
}

// The parrot image data is from this site.
// https://cultofthepartyparrot.com/

constexpr unsigned char parrot00[] = {
0x42, 0x4D, 0xEC, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x04, 0x00, 0x00, 0x28, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x01, 0x00, 
0x00, 0x00, 0xBA, 0x09, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0xFF, 0x00, 
0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x08, 0x04, 
0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x0B, 0x05, 0x08, 0x00, 0x06, 0x0A, 0x07, 0x00, 0x06, 0x08, 
0x0E, 0x00, 0x0E, 0x0B, 0x04, 0x00, 0x0F, 0x07, 0x12, 0x00, 0x0B, 0x0C, 0x12, 0x00, 0x16, 0x0B, 
0x12, 0x00, 0x0C, 0x0B, 0x17, 0x00, 0x0C, 0x10, 0x0D, 0x00, 0x13, 0x11, 0x08, 0x00, 0x12, 0x0C, 
0x1C, 0x00, 0x19, 0x0C, 0x1B, 0x00, 0x18, 0x10, 0x10, 0x00, 0x0A, 0x0D, 0x21, 0x00, 0x08, 0x13, 
0x10, 0x00, 0x1E, 0x0E, 0x1A, 0x00, 0x0A, 0x12, 0x18, 0x00, 0x1B, 0x15, 0x0E, 0x00, 0x1C, 0x10, 
0x1F, 0x00, 0x14, 0x11, 0x1F, 0x00, 0x12, 0x15, 0x13, 0x00, 0x23, 0x10, 0x24, 0x00, 0x1B, 0x10, 
0x28, 0x00, 0x0E, 0x15, 0x1C, 0x00, 0x0E, 0x1A, 0x0D, 0x00, 0x19, 0x19, 0x0D, 0x00, 0x11, 0x13, 
0x25, 0x00, 0x23, 0x13, 0x1F, 0x00, 0x12, 0x1A, 0x15, 0x00, 0x12, 0x13, 0x2E, 0x00, 0x25, 0x1A, 
0x16, 0x00, 0x2E, 0x14, 0x30, 0x00, 0x17, 0x18, 0x2C, 0x00, 0x20, 0x20, 0x0F, 0x00, 0x2D, 0x19, 
0x23, 0x00, 0x13, 0x1C, 0x23, 0x00, 0x13, 0x21, 0x13, 0x00, 0x17, 0x1F, 0x1A, 0x00, 0x24, 0x16, 
0x34, 0x00, 0x32, 0x14, 0x37, 0x00, 0x17, 0x17, 0x38, 0x00, 0x2E, 0x19, 0x2B, 0x00, 0x1C, 0x1D, 
0x32, 0x00, 0x15, 0x21, 0x29, 0x00, 0x32, 0x23, 0x1B, 0x00, 0x26, 0x26, 0x15, 0x00, 0x1D, 0x25, 
0x20, 0x00, 0x16, 0x29, 0x15, 0x00, 0x3B, 0x1A, 0x3B, 0x00, 0x1D, 0x1B, 0x43, 0x00, 0x2F, 0x1B, 
0x40, 0x00, 0x36, 0x1E, 0x34, 0x00, 0x3D, 0x20, 0x33, 0x00, 0x23, 0x21, 0x3D, 0x00, 0x3B, 0x20, 
0x3D, 0x00, 0x3A, 0x29, 0x22, 0x00, 0x44, 0x1D, 0x47, 0x00, 0x1F, 0x1F, 0x4D, 0x00, 0x2C, 0x2D, 
0x1A, 0x00, 0x1A, 0x28, 0x31, 0x00, 0x22, 0x2B, 0x27, 0x00, 0x37, 0x1F, 0x4D, 0x00, 0x3F, 0x23, 
0x41, 0x00, 0x26, 0x27, 0x48, 0x00, 0x47, 0x27, 0x3E, 0x00, 0x4E, 0x22, 0x4E, 0x00, 0x1F, 0x2F, 
0x39, 0x00, 0x25, 0x32, 0x2D, 0x00, 0x25, 0x26, 0x56, 0x00, 0x3F, 0x24, 0x59, 0x00, 0x1F, 0x39, 
0x1E, 0x00, 0x35, 0x37, 0x1E, 0x00, 0x47, 0x33, 0x27, 0x00, 0x53, 0x24, 0x58, 0x00, 0x4F, 0x2B, 
0x42, 0x00, 0x2B, 0x2C, 0x50, 0x00, 0x28, 0x28, 0x5F, 0x00, 0x4D, 0x2A, 0x4D, 0x00, 0x2A, 0x38, 
0x30, 0x00, 0x55, 0x30, 0x49, 0x00, 0x30, 0x2F, 0x59, 0x00, 0x60, 0x29, 0x62, 0x00, 0x2B, 0x2C, 
0x6B, 0x00, 0x49, 0x2B, 0x68, 0x00, 0x55, 0x2F, 0x59, 0x00, 0x26, 0x3A, 0x45, 0x00, 0x31, 0x3F, 
0x36, 0x00, 0x58, 0x3E, 0x2E, 0x00, 0x65, 0x2B, 0x6B, 0x00, 0x26, 0x46, 0x26, 0x00, 0x2F, 0x30, 
0x6F, 0x00, 0x5C, 0x32, 0x59, 0x00, 0x47, 0x46, 0x24, 0x00, 0x62, 0x36, 0x52, 0x00, 0x37, 0x36, 
0x61, 0x00, 0x51, 0x31, 0x75, 0x00, 0x32, 0x33, 0x7A, 0x00, 0x2A, 0x41, 0x4E, 0x00, 0x5E, 0x44, 
0x34, 0x00, 0x38, 0x47, 0x3D, 0x00, 0x65, 0x38, 0x66, 0x00, 0x75, 0x32, 0x79, 0x00, 0x2D, 0x52, 
0x2D, 0x00, 0x58, 0x35, 0x81, 0x00, 0x37, 0x37, 0x86, 0x00, 0x69, 0x4A, 0x37, 0x00, 0x3C, 0x3E, 
0x71, 0x00, 0x72, 0x3E, 0x61, 0x00, 0x53, 0x52, 0x2C, 0x00, 0x39, 0x4D, 0x46, 0x00, 0x30, 0x49, 
0x57, 0x00, 0x62, 0x37, 0x86, 0x00, 0x32, 0x58, 0x2B, 0x00, 0x72, 0x3D, 0x71, 0x00, 0x58, 0x56, 
0x30, 0x00, 0x2F, 0x5B, 0x31, 0x00, 0x3E, 0x3D, 0x93, 0x00, 0x86, 0x3A, 0x88, 0x00, 0x73, 0x52, 
0x3E, 0x00, 0x3F, 0x54, 0x4B, 0x00, 0x45, 0x45, 0x7E, 0x00, 0x69, 0x3D, 0x90, 0x00, 0x85, 0x48, 
0x6F, 0x00, 0x81, 0x45, 0x81, 0x00, 0x41, 0x43, 0xA1, 0x00, 0x37, 0x56, 0x66, 0x00, 0x7F, 0x5A, 
0x41, 0x00, 0x46, 0x5C, 0x4F, 0x00, 0x93, 0x3F, 0x98, 0x00, 0x38, 0x66, 0x36, 0x00, 0x63, 0x63, 
0x34, 0x00, 0x73, 0x43, 0xA0, 0x00, 0x4F, 0x4D, 0x8E, 0x00, 0x9C, 0x42, 0xA1, 0x00, 0x3D, 0x5D, 
0x6D, 0x00, 0x4C, 0x63, 0x55, 0x00, 0x95, 0x51, 0x7C, 0x00, 0x89, 0x62, 0x4A, 0x00, 0x9F, 0x45, 
0xA5, 0x00, 0x4B, 0x4B, 0xB3, 0x00, 0x50, 0x53, 0x97, 0x00, 0x51, 0x68, 0x5A, 0x00, 0x7E, 0x4A, 
0xB1, 0x00, 0x93, 0x51, 0x94, 0x00, 0x40, 0x75, 0x40, 0x00, 0xAB, 0x49, 0xB0, 0x00, 0x56, 0x57, 
0xA1, 0x00, 0x71, 0x72, 0x3F, 0x00, 0x50, 0x6C, 0x60, 0x00, 0x42, 0x67, 0x79, 0x00, 0x98, 0x6A, 
0x53, 0x00, 0x50, 0x50, 0xC3, 0x00, 0xA5, 0x5A, 0x8A, 0x00, 0xA0, 0x57, 0x9C, 0x00, 0x87, 0x4F, 
0xC1, 0x00, 0x56, 0x72, 0x66, 0x00, 0xB8, 0x4F, 0xBF, 0x00, 0x44, 0x80, 0x45, 0x00, 0x60, 0x60, 
0xAF, 0x00, 0xA8, 0x5C, 0xA9, 0x00, 0x7D, 0x7E, 0x46, 0x00, 0x59, 0x58, 0xD5, 0x00, 0x8F, 0x55, 
0xCD, 0x00, 0xA5, 0x75, 0x5D, 0x00, 0xB5, 0x63, 0x98, 0x00, 0x5D, 0x7A, 0x6D, 0x00, 0xC6, 0x54, 
0xCB, 0x00, 0x4C, 0x76, 0x8A, 0x00, 0x4B, 0x89, 0x4B, 0x00, 0x61, 0x7F, 0x6C, 0x00, 0x69, 0x68, 
0xBC, 0x00, 0x5E, 0x5F, 0xE4, 0x00, 0x9B, 0x5B, 0xDD, 0x00, 0xCD, 0x59, 0xD5, 0x00, 0xB9, 0x64, 
0xB8, 0x00, 0xB2, 0x7E, 0x63, 0x00, 0x88, 0x8B, 0x4D, 0x00, 0x66, 0x84, 0x71, 0x00, 0xD8, 0x5B, 
0xDD, 0x00, 0xC7, 0x6D, 0xA7, 0x00, 0x64, 0x62, 0xEE, 0x00, 0x9F, 0x60, 0xE5, 0x00, 0x51, 0x96, 
0x51, 0x00, 0x6E, 0x6F, 0xCC, 0x00, 0x54, 0x81, 0x9B, 0x00, 0x6B, 0x8A, 0x76, 0x00, 0xA9, 0x62, 
0xEB, 0x00, 0x68, 0x66, 0xF4, 0x00, 0xDD, 0x60, 0xE2, 0x00, 0xC3, 0x6B, 0xC6, 0x00, 0xC1, 0x88, 
0x69, 0x00, 0x68, 0x8C, 0x7B, 0x00, 0x96, 0x96, 0x51, 0x00, 0x68, 0x69, 0xFF, 0x00, 0xE4, 0x62, 
0xED, 0x00, 0xD6, 0x75, 0xB3, 0x00, 0xD0, 0x6F, 0xCF, 0x00, 0xB1, 0x66, 0xF8, 0x00, 0x5A, 0xA1, 
0x55, 0x00, 0x77, 0x77, 0xDB, 0x00, 0xCA, 0x8F, 0x6F, 0x00, 0xA1, 0x9F, 0x56, 0x00, 0xB7, 0x6C, 
0xFE, 0x00, 0x5D, 0x8E, 0xAB, 0x00, 0xD7, 0x76, 0xD6, 0x00, 0xF3, 0x69, 0xFA, 0x00, 0xF7, 0x68, 
0xFF, 0x00, 0x5A, 0xA9, 0x5D, 0x00, 0xD7, 0x98, 0x74, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0xEB, 0x80, 
0xC5, 0x00, 0xE0, 0x7B, 0xE3, 0x00, 0x85, 0x82, 0xF1, 0x00, 0xAD, 0xAC, 0x5A, 0x00, 0x64, 0x99, 
0xB8, 0x00, 0xE1, 0xA0, 0x7A, 0x00, 0x63, 0xB5, 0x62, 0x00, 0xF8, 0x87, 0xCF, 0x00, 0x85, 0x88, 
0xF9, 0x00, 0xF1, 0x83, 0xF1, 0x00, 0xE8, 0xA6, 0x81, 0x00, 0xFF, 0x8C, 0xD7, 0x00, 0x8B, 0x8D, 
0xFF, 0x00, 0xF3, 0xAB, 0x80, 0x00, 0xF8, 0x88, 0xFA, 0x00, 0x68, 0xC2, 0x68, 0x00, 0xBE, 0xBE, 
0x67, 0x00, 0x6D, 0xA9, 0xCB, 0x00, 0xF9, 0xB0, 0x86, 0x00, 0xFF, 0x8C, 0xFF, 0x00, 0x70, 0xCB, 
0x6E, 0x00, 0xFE, 0xB5, 0x8B, 0x00, 0xC6, 0xC6, 0x6A, 0x00, 0x71, 0xD3, 0x73, 0x00, 0x78, 0xB7, 
0xDA, 0x00, 0xCE, 0xCF, 0x72, 0x00, 0x78, 0xDB, 0x78, 0x00, 0x7C, 0xE5, 0x7C, 0x00, 0x7F, 0xC4, 
0xEA, 0x00, 0xDB, 0xDD, 0x78, 0x00, 0x81, 0xED, 0x81, 0x00, 0xE3, 0xE5, 0x7E, 0x00, 0x88, 0xCF, 
0xF5, 0x00, 0x87, 0xF5, 0x84, 0x00, 0xEC, 0xEF, 0x87, 0x00, 0x89, 0xD6, 0xFE, 0x00, 0x87, 0xFA, 
0x8C, 0x00, 0xF1, 0xF3, 0x8C, 0x00, 0x89, 0xFF, 0x88, 0x00, 0xFB, 0xF9, 0x80, 0x00, 0xFF, 0xFF, 
0x87, 0x00, 0x0B, 0xFE, 0x6A, 0x00, 0x0B, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x6A, 0x00, 0x0B, 0xFE, 
0x00, 0x00, 0x0B, 0xFE, 0x6A, 0x00, 0x0B, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 0x03, 0x00, 0x01, 0x01, 
0x60, 0x48, 0x01, 0x2C, 0x04, 0x00, 0x0B, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 0x04, 0x00, 0x01, 0x64, 
0x5F, 0xC5, 0x01, 0x6C, 0x03, 0x00, 0x0C, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 0x03, 0x00, 0x01, 0x01, 
0x01, 0x8F, 0x5E, 0xC5, 0x01, 0x35, 0x03, 0x00, 0x0C, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 0x04, 0x00, 
0x01, 0x06, 0x01, 0x9B, 0x5D, 0xC5, 0x01, 0x06, 0x03, 0x00, 0x0C, 0xFE, 0x00, 0x00, 0x0E, 0xFE, 
0x04, 0x00, 0x01, 0x01, 0x01, 0x8F, 0x5B, 0xC5, 0x01, 0xA5, 0x04, 0x00, 0x0C, 0xFE, 0x00, 0x00, 
0x0F, 0xFE, 0x04, 0x00, 0x01, 0x01, 0x01, 0x80, 0x5A, 0xC5, 0x01, 0x8F, 0x03, 0x00, 0x0D, 0xFE, 
0x00, 0x00, 0x10, 0xFE, 0x05, 0x00, 0x01, 0x6C, 0x59, 0xC5, 0x01, 0x80, 0x03, 0x00, 0x0D, 0xFE, 
0x00, 0x00, 0x11, 0xFE, 0x05, 0x00, 0x01, 0x56, 0x01, 0xBF, 0x33, 0xC5, 0x00, 0x07, 0xBF, 0xAF, 
0xA5, 0x9B, 0x8F, 0x80, 0xAF, 0x00, 0x1D, 0xC5, 0x01, 0x6C, 0x03, 0x00, 0x0D, 0xFE, 0x00, 0x00, 
0x12, 0xFE, 0x05, 0x00, 0x01, 0x21, 0x01, 0xA5, 0x2F, 0xC5, 0x00, 0x03, 0x9B, 0x5E, 0x11, 0x00, 
0x06, 0x00, 0x01, 0x01, 0x01, 0x8F, 0x1C, 0xC5, 0x01, 0x5E, 0x03, 0x00, 0x0D, 0xFE, 0x00, 0x00, 
0x13, 0xFE, 0x05, 0x00, 0x01, 0x01, 0x01, 0x6C, 0x2A, 0xC5, 0x00, 0x04, 0xBF, 0x8F, 0x50, 0x0B, 
0x0A, 0x00, 0x01, 0x64, 0x1C, 0xC5, 0x01, 0x5E, 0x03, 0x00, 0x0D, 0xFE, 0x00, 0x00, 0x15, 0xFE, 
0x05, 0x00, 0x01, 0x2C, 0x01, 0xAF, 0x26, 0xC5, 0x00, 0x03, 0xB8, 0x64, 0x06, 0x00, 0x0C, 0x00, 
0x01, 0x01, 0x01, 0xAF, 0x1C, 0xC5, 0x01, 0x6C, 0x03, 0x00, 0x0D, 0xFE, 0x00, 0x00, 0x16, 0xFE, 
0x05, 0x00, 0x01, 0x06, 0x01, 0x80, 0x23, 0xC5, 0x00, 0x03, 0xBF, 0x6C, 0x06, 0x00, 0x07, 0x00, 
0x00, 0x08, 0x06, 0x48, 0x56, 0x64, 0x78, 0x80, 0x8F, 0xB8, 0x1D, 0xC5, 0x01, 0x80, 0x03, 0x00, 
0x0D, 0xFE, 0x00, 0x00, 0x17, 0xFE, 0x06, 0x00, 0x01, 0x3D, 0x01, 0xAF, 0x20, 0xC5, 0x01, 0x78, 
0x01, 0x0B, 0x06, 0x00, 0x00, 0x03, 0x17, 0x56, 0x9B, 0x00, 0x25, 0xC5, 0x01, 0x8F, 0x03, 0x00, 
0x0D, 0xFE, 0x00, 0x00, 0x19, 0xFE, 0x05, 0x00, 0x01, 0x0B, 0x01, 0x8F, 0x1D, 0xC5, 0x01, 0x8F, 
0x01, 0x11, 0x05, 0x00, 0x00, 0x03, 0x01, 0x5E, 0xA5, 0x00, 0x28, 0xC5, 0x01, 0xB8, 0x01, 0x01, 
0x03, 0x00, 0x0C, 0xFE, 0x00, 0x00, 0x1A, 0xFE, 0x06, 0x00, 0x01, 0x50, 0x01, 0xBF, 0x1A, 0xC5, 
0x01, 0x64, 0x01, 0x01, 0x04, 0x00, 0x00, 0x03, 0x01, 0x50, 0xAF, 0x00, 0x2B, 0xC5, 0x01, 0x21, 
0x03, 0x00, 0x0C, 0xFE, 0x00, 0x00, 0x1C, 0xFE, 0x05, 0x00, 0x01, 0x21, 0x01, 0xAF, 0x17, 0xC5, 
0x01, 0xBF, 0x01, 0x3D, 0x05, 0x00, 0x01, 0x3D, 0x01, 0xA5, 0x2D, 0xC5, 0x01, 0x5E, 0x03, 0x00, 
0x0C, 0xFE, 0x00, 0x00, 0x1D, 0xFE, 0x05, 0x00, 0x01, 0x0B, 0x01, 0x9B, 0x15, 0xC5, 0x01, 0xAF, 
0x01, 0x21, 0x04, 0x00, 0x01, 0x2C, 0x01, 0x9B, 0x2F, 0xC5, 0x01, 0xA5, 0x04, 0x00, 0x0B, 0xFE, 
0x00, 0x00, 0x1F, 0xFE, 0x04, 0x00, 0x01, 0x01, 0x01, 0x80, 0x13, 0xC5, 0x01, 0x8F, 0x01, 0x06, 
0x04, 0x00, 0x01, 0x50, 0x32, 0xC5, 0x01, 0x2C, 0x03, 0x00, 0x0B, 0xFE, 0x00, 0x00, 0x20, 0xFE, 
0x05, 0x00, 0x01, 0x5E, 0x11, 0xC5, 0x01, 0x80, 0x01, 0x01, 0x03, 0x00, 0x01, 0x01, 0x01, 0x78, 
0x33, 0xC5, 0x01, 0x80, 0x04, 0x00, 0x0A, 0xFE, 0x00, 0x00, 0x21, 0xFE, 0x05, 0x00, 0x01, 0x64, 
0x0F, 0xC5, 0x01, 0x9B, 0x01, 0x01, 0x03, 0x00, 0x01, 0x0B, 0x01, 0x9B, 0x23, 0xC5, 0x01, 0xBF, 
0x10, 0xC5, 0x01, 0xBF, 0x01, 0x06, 0x03, 0x00, 0x0A, 0xFE, 0x00, 0x00, 0x22, 0xFE, 0x05, 0x00, 
0x01, 0x80, 0x0D, 0xC5, 0x01, 0xAF, 0x01, 0x0B, 0x03, 0x00, 0x01, 0x2C, 0x01, 0xAF, 0x23, 0xC5, 
0x00, 0x03, 0xBF, 0x2C, 0xBF, 0x00, 0x10, 0xC5, 0x01, 0x56, 0x03, 0x00, 0x0A, 0xFE, 0x00, 0x00, 
0x23, 0xFE, 0x04, 0x00, 0x01, 0x06, 0x01, 0xA5, 0x0B, 0xC5, 0x01, 0xBF, 0x01, 0x21, 0x03, 0x00, 
0x01, 0x21, 0x01, 0xBF, 0x24, 0xC5, 0x00, 0x03, 0x50, 0x00, 0x78, 0x00, 0x10, 0xC5, 0x01, 0xA5, 
0x04, 0x00, 0x09, 0xFE, 0x00, 0x00, 0x24, 0xFE, 0x04, 0x00, 0x01, 0x17, 0x01, 0xB8, 0x0A, 0xC5, 
0x01, 0x48, 0x03, 0x00, 0x01, 0x0B, 0x01, 0xAF, 0x24, 0xC5, 0x00, 0x04, 0x80, 0x00, 0x00, 0x1E, 
0x11, 0xC5, 0x01, 0x2C, 0x03, 0x00, 0x09, 0xFE, 0x00, 0x00, 0x25, 0xFE, 0x04, 0x00, 0x01, 0x48, 
0x09, 0xC5, 0x01, 0x6C, 0x03, 0x00, 0x01, 0x01, 0x01, 0x9B, 0x24, 0xC5, 0x01, 0xAF, 0x01, 0x06, 
0x03, 0x00, 0x01, 0x8F, 0x10, 0xC5, 0x01, 0x78, 0x03, 0x00, 0x09, 0xFE, 0x00, 0x00, 0x26, 0xFE, 
0x03, 0x00, 0x01, 0x01, 0x01, 0xA5, 0x07, 0xC5, 0x01, 0x9B, 0x01, 0x01, 0x03, 0x00, 0x01, 0x80, 
0x25, 0xC5, 0x01, 0x35, 0x04, 0x00, 0x01, 0x35, 0x10, 0xC5, 0x01, 0xAF, 0x01, 0x01, 0x03, 0x00, 
0x08, 0xFE, 0x00, 0x00, 0x27, 0xFE, 0x03, 0x00, 0x01, 0x35, 0x07, 0xC5, 0x01, 0x2C, 0x03, 0x00, 
0x01, 0x56, 0x25, 0xC5, 0x01, 0x78, 0x06, 0x00, 0x01, 0xA5, 0x10, 0xC5, 0x01, 0x3D, 0x03, 0x00, 
0x08, 0xFE, 0x00, 0x00, 0x27, 0xFE, 0x04, 0x00, 0x01, 0x9B, 0x05, 0xC5, 0x01, 0x80, 0x03, 0x00, 
0x01, 0x21, 0x25, 0xC5, 0x01, 0xA5, 0x01, 0x06, 0x06, 0x00, 0x01, 0x50, 0x10, 0xC5, 0x01, 0x80, 
0x04, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x28, 0xFE, 0x03, 0x00, 0x01, 0x2C, 0x05, 0xC5, 0x01, 0x11, 
0x03, 0x00, 0x01, 0x9B, 0x25, 0xC5, 0x01, 0x21, 0x03, 0x00, 0x00, 0x06, 0x47, 0x0C, 0x00, 0x00, 
0x01, 0xB8, 0x0F, 0xC5, 0x01, 0xBF, 0x01, 0x01, 0x03, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x28, 0xFE, 
0x04, 0x00, 0x01, 0xAF, 0x03, 0xC5, 0x01, 0x9B, 0x03, 0x00, 0x01, 0x35, 0x25, 0xC5, 0x01, 0x64, 
0x03, 0x00, 0x00, 0x03, 0x0C, 0xB5, 0x67, 0x00, 0x03, 0x00, 0x01, 0x6C, 0x10, 0xC5, 0x01, 0x21, 
0x03, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x29, 0xFE, 0x03, 0x00, 0x01, 0x64, 0x03, 0xC5, 0x01, 0x50, 
0x03, 0x00, 0x01, 0x9B, 0x24, 0xC5, 0x00, 0x0C, 0x9B, 0x01, 0x00, 0x00, 0x03, 0x98, 0xC3, 0xAD, 
0x03, 0x00, 0x00, 0x0B, 0x10, 0xC5, 0x01, 0x3D, 0x03, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x29, 0xFE, 
0x03, 0x00, 0x00, 0x08, 0x11, 0xC5, 0xC5, 0xBF, 0x06, 0x00, 0x00, 0x11, 0x25, 0xC5, 0x01, 0x21, 
0x03, 0x00, 0x01, 0x5A, 0x03, 0xC3, 0x01, 0x47, 0x03, 0x00, 0x01, 0x80, 0x0F, 0xC5, 0x01, 0x64, 
0x03, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x29, 0xFE, 0x04, 0x00, 0x00, 0x03, 0x9B, 0xC5, 0x8F, 0x00, 
0x03, 0x00, 0x01, 0x64, 0x24, 0xC5, 0x01, 0x8F, 0x03, 0x00, 0x01, 0x20, 0x01, 0xBD, 0x03, 0xC3, 
0x01, 0x9F, 0x03, 0x00, 0x01, 0x21, 0x0F, 0xC5, 0x01, 0x78, 0x03, 0x00, 0x07, 0xFE, 0x00, 0x00, 
0x2A, 0xFE, 0x03, 0x00, 0x00, 0x03, 0x56, 0xC5, 0x64, 0x00, 0x03, 0x00, 0x01, 0x9B, 0x24, 0xC5, 
0x01, 0x35, 0x03, 0x00, 0x01, 0x8B, 0x05, 0xC3, 0x01, 0x32, 0x03, 0x00, 0x01, 0x9B, 0x0E, 0xC5, 
0x01, 0x78, 0x03, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x2A, 0xFE, 0x03, 0x00, 0x00, 0x07, 0x06, 0xC5, 
0x3D, 0x00, 0x00, 0x01, 0xBF, 0x00, 0x23, 0xC5, 0x01, 0x9B, 0x03, 0x00, 0x01, 0x20, 0x06, 0xC3, 
0x01, 0x8B, 0x03, 0x00, 0x01, 0x5E, 0x0E, 0xC5, 0x01, 0x78, 0x03, 0x00, 0x07, 0xFE, 0x00, 0x00, 
0x2A, 0xFE, 0x04, 0x00, 0x00, 0x05, 0x80, 0x17, 0x00, 0x00, 0x21, 0x00, 0x24, 0xC5, 0x01, 0x50, 
0x03, 0x00, 0x01, 0x83, 0x06, 0xC3, 0x00, 0x05, 0xBD, 0x05, 0x00, 0x00, 0x21, 0x00, 0x0E, 0xC5, 
0x01, 0x78, 0x03, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x2B, 0xFE, 0x03, 0x00, 0x00, 0x05, 0x3D, 0x01, 
0x00, 0x00, 0x48, 0x00, 0x24, 0xC5, 0x00, 0x05, 0x06, 0x00, 0x00, 0x0C, 0xBD, 0x00, 0x07, 0xC3, 
0x00, 0x05, 0x40, 0x00, 0x00, 0x01, 0xB8, 0x00, 0x0D, 0xC5, 0x01, 0x6C, 0x03, 0x00, 0x07, 0xFE, 
0x00, 0x00, 0x2B, 0xFE, 0x03, 0x00, 0x01, 0x01, 0x03, 0x00, 0x01, 0x50, 0x23, 0xC5, 0x01, 0x9B, 
0x03, 0x00, 0x01, 0x5A, 0x08, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0x8F, 0x0D, 0xC5, 0x01, 0x48, 
0x03, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x2C, 0xFE, 0x06, 0x00, 0x01, 0x50, 0x23, 0xC5, 0x01, 0x56, 
0x03, 0x00, 0x01, 0x98, 0x08, 0xC3, 0x01, 0x9F, 0x03, 0x00, 0x01, 0x64, 0x0D, 0xC5, 0x01, 0x21, 
0x03, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x2C, 0xFE, 0x06, 0x00, 0x01, 0x50, 0x23, 0xC5, 0x00, 0x04, 
0x21, 0x00, 0x00, 0x05, 0x0A, 0xC3, 0x00, 0x04, 0x03, 0x00, 0x00, 0x2C, 0x0D, 0xC5, 0x01, 0x01, 
0x03, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x2C, 0xFE, 0x06, 0x00, 0x01, 0x35, 0x23, 0xC5, 0x00, 0x04, 
0x06, 0x00, 0x00, 0x32, 0x0A, 0xC3, 0x00, 0x05, 0x40, 0x00, 0x00, 0x01, 0xBF, 0x00, 0x0B, 0xC5, 
0x01, 0xA5, 0x04, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x2D, 0xFE, 0x05, 0x00, 0x01, 0x0B, 0x22, 0xC5, 
0x01, 0xAF, 0x03, 0x00, 0x01, 0x52, 0x0A, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0x8F, 0x0B, 0xC5, 
0x01, 0x8F, 0x03, 0x00, 0x08, 0xFE, 0x00, 0x00, 0x2D, 0xFE, 0x06, 0x00, 0x01, 0xB8, 0x21, 0xC5, 
0x01, 0x9B, 0x03, 0x00, 0x01, 0x71, 0x0A, 0xC3, 0x01, 0x98, 0x03, 0x00, 0x01, 0x64, 0x0B, 0xC5, 
0x01, 0x64, 0x03, 0x00, 0x08, 0xFE, 0x00, 0x00, 0x2E, 0xFE, 0x05, 0x00, 0x01, 0x8F, 0x21, 0xC5, 
0x01, 0x80, 0x03, 0x00, 0x01, 0x8B, 0x0B, 0xC3, 0x00, 0x04, 0x03, 0x00, 0x00, 0x35, 0x0B, 0xC5, 
0x01, 0x2C, 0x03, 0x00, 0x08, 0xFE, 0x00, 0x00, 0x2F, 0xFE, 0x04, 0x00, 0x01, 0x3D, 0x21, 0xC5, 
0x01, 0x64, 0x03, 0x00, 0x01, 0x9F, 0x0B, 0xC3, 0x00, 0x04, 0x12, 0x00, 0x00, 0x21, 0x0A, 0xC5, 
0x01, 0xAF, 0x01, 0x01, 0x03, 0x00, 0x08, 0xFE, 0x00, 0x00, 0x2F, 0xFE, 0x04, 0x00, 0x01, 0x01, 
0x01, 0xB8, 0x20, 0xC5, 0x00, 0x05, 0x50, 0x00, 0x00, 0x03, 0xB5, 0x00, 0x0B, 0xC3, 0x00, 0x04, 
0x29, 0x00, 0x00, 0x0E, 0x0A, 0xC5, 0x01, 0x78, 0x03, 0x00, 0x09, 0xFE, 0x00, 0x00, 0x30, 0xFE, 
0x04, 0x00, 0x01, 0x48, 0x20, 0xC5, 0x00, 0x04, 0x2C, 0x00, 0x00, 0x0C, 0x0C, 0xC3, 0x00, 0x04, 
0x32, 0x00, 0x00, 0x06, 0x0A, 0xC5, 0x01, 0x35, 0x03, 0x00, 0x09, 0xFE, 0x00, 0x00, 0x31, 0xFE, 
0x03, 0x00, 0x01, 0x01, 0x01, 0xA5, 0x1F, 0xC5, 0x00, 0x04, 0x0B, 0x00, 0x00, 0x29, 0x0C, 0xC3, 
0x01, 0x47, 0x03, 0x00, 0x09, 0xC5, 0x01, 0xB8, 0x01, 0x01, 0x03, 0x00, 0x09, 0xFE, 0x00, 0x00, 
0x31, 0xFE, 0x04, 0x00, 0x01, 0x21, 0x1F, 0xC5, 0x00, 0x04, 0x11, 0x00, 0x00, 0x29, 0x0C, 0xC3, 
0x01, 0x52, 0x03, 0x00, 0x01, 0xB8, 0x08, 0xC5, 0x01, 0x80, 0x03, 0x00, 0x0A, 0xFE, 0x00, 0x00, 
0x32, 0xFE, 0x04, 0x00, 0x01, 0x50, 0x1E, 0xC5, 0x00, 0x04, 0x21, 0x00, 0x00, 0x20, 0x0C, 0xC3, 
0x01, 0x5A, 0x03, 0x00, 0x01, 0xAF, 0x08, 0xC5, 0x01, 0x50, 0x03, 0x00, 0x0A, 0xFE, 0x00, 0x00, 
0x33, 0xFE, 0x04, 0x00, 0x01, 0x5E, 0x1D, 0xC5, 0x00, 0x04, 0x21, 0x00, 0x00, 0x0C, 0x0C, 0xC3, 
0x01, 0x67, 0x03, 0x00, 0x01, 0xA5, 0x08, 0xC5, 0x01, 0x0B, 0x03, 0x00, 0x0A, 0xFE, 0x00, 0x00, 
0x34, 0xFE, 0x04, 0x00, 0x01, 0x6C, 0x11, 0xC5, 0x00, 0x05, 0xAF, 0x50, 0x11, 0x50, 0xAF, 0x00, 
0x06, 0xC5, 0x00, 0x04, 0x2C, 0x00, 0x00, 0x0C, 0x0C, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x00, 0x09, 
0x9B, 0xBF, 0x56, 0x11, 0x3D, 0xA5, 0xC5, 0xC5, 0xA5, 0x00, 0x04, 0x00, 0x0A, 0xFE, 0x00, 0x00, 
0x34, 0xFE, 0x05, 0x00, 0x01, 0x80, 0x0F, 0xC5, 0x01, 0xBF, 0x01, 0x11, 0x03, 0x00, 0x01, 0x11, 
0x01, 0xBF, 0x05, 0xC5, 0x00, 0x04, 0x35, 0x00, 0x00, 0x03, 0x0C, 0xC3, 0x01, 0x5A, 0x03, 0x00, 
0x01, 0xA5, 0x01, 0x35, 0x03, 0x00, 0x00, 0x04, 0x06, 0xAF, 0xC5, 0x6C, 0x03, 0x00, 0x0B, 0xFE, 
0x00, 0x00, 0x35, 0xFE, 0x04, 0x00, 0x01, 0x01, 0x01, 0x8F, 0x0E, 0xC5, 0x01, 0x6C, 0x05, 0x00, 
0x01, 0x6C, 0x05, 0xC5, 0x00, 0x04, 0x3D, 0x00, 0x00, 0x03, 0x0C, 0xC3, 0x00, 0x05, 0x47, 0x00, 
0x00, 0x01, 0x80, 0x00, 0x05, 0x00, 0x00, 0x03, 0x50, 0xC5, 0x35, 0x00, 0x03, 0x00, 0x0B, 0xFE, 
0x00, 0x00, 0x36, 0xFE, 0x04, 0x00, 0x01, 0x01, 0x01, 0x9B, 0x0D, 0xC5, 0x01, 0x2C, 0x05, 0x00, 
0x01, 0x2C, 0x05, 0xC5, 0x01, 0x50, 0x03, 0x00, 0x01, 0xBD, 0x0B, 0xC3, 0x00, 0x05, 0x20, 0x00, 
0x00, 0x11, 0x56, 0x00, 0x05, 0x00, 0x00, 0x03, 0x0B, 0xBF, 0x01, 0x00, 0x03, 0x00, 0x0B, 0xFE, 
0x00, 0x00, 0x37, 0xFE, 0x04, 0x00, 0x01, 0x06, 0x01, 0xA5, 0x0C, 0xC5, 0x01, 0x0E, 0x05, 0x00, 
0x01, 0x0E, 0x05, 0xC5, 0x01, 0x50, 0x03, 0x00, 0x01, 0xB5, 0x0A, 0xC3, 0x00, 0x06, 0xBD, 0x03, 
0x00, 0x00, 0x3D, 0x35, 0x06, 0x00, 0x01, 0x80, 0x04, 0x00, 0x0B, 0xFE, 0x00, 0x00, 0x38, 0xFE, 
0x04, 0x00, 0x01, 0x0B, 0x01, 0xAF, 0x0B, 0xC5, 0x01, 0x21, 0x05, 0x00, 0x01, 0x21, 0x05, 0xC5, 
0x01, 0x56, 0x03, 0x00, 0x01, 0xAD, 0x0A, 0xC3, 0x01, 0xA9, 0x03, 0x00, 0x01, 0x56, 0x01, 0x50, 
0x05, 0x00, 0x01, 0x06, 0x01, 0x50, 0x03, 0x00, 0x0C, 0xFE, 0x00, 0x00, 0x39, 0xFE, 0x04, 0x00, 
0x01, 0x1E, 0x01, 0xB8, 0x0A, 0xC5, 0x01, 0x56, 0x05, 0x00, 0x01, 0x56, 0x05, 0xC5, 0x01, 0x78, 
0x03, 0x00, 0x01, 0x71, 0x0A, 0xC3, 0x01, 0x8B, 0x03, 0x00, 0x01, 0x78, 0x01, 0x78, 0x05, 0x00, 
0x01, 0x35, 0x01, 0x0B, 0x03, 0x00, 0x0C, 0xFE, 0x00, 0x00, 0x3A, 0xFE, 0x04, 0x00, 0x01, 0x2C, 
0x01, 0xBF, 0x09, 0xC5, 0x01, 0xAF, 0x01, 0x01, 0x03, 0x00, 0x01, 0x01, 0x01, 0xAF, 0x05, 0xC5, 
0x00, 0x06, 0xAF, 0x01, 0x00, 0x00, 0x0C, 0xA9, 0x08, 0xC3, 0x01, 0xB5, 0x01, 0x20, 0x03, 0x00, 
0x00, 0x03, 0x9B, 0xBF, 0x0B, 0x00, 0x04, 0x00, 0x01, 0x6C, 0x04, 0x00, 0x0C, 0xFE, 0x00, 0x00, 
0x3B, 0xFE, 0x04, 0x00, 0x01, 0x35, 0x0A, 0xC5, 0x00, 0x05, 0x8F, 0x06, 0x00, 0x06, 0x8F, 0x00, 
0x07, 0xC5, 0x01, 0x35, 0x03, 0x00, 0x00, 0x03, 0x05, 0x71, 0xB5, 0x00, 0x04, 0xC3, 0x00, 0x03, 
0xB5, 0x7B, 0x0C, 0x00, 0x03, 0x00, 0x00, 0x09, 0x21, 0xC5, 0xC5, 0xA5, 0x17, 0x00, 0x01, 0x78, 
0x2C, 0x00, 0x03, 0x00, 0x0D, 0xFE, 0x00, 0x00, 0x3C, 0xFE, 0x04, 0x00, 0x01, 0x50, 0x0B, 0xC5, 
0x01, 0xA5, 0x09, 0xC5, 0x01, 0x9B, 0x01, 0x06, 0x04, 0x00, 0x00, 0x06, 0x03, 0x0C, 0x29, 0x29, 
0x20, 0x03, 0x04, 0x00, 0x01, 0x01, 0x01, 0x9B, 0x04, 0xC5, 0x00, 0x03, 0xA5, 0xBF, 0x78, 0x00, 
0x04, 0x00, 0x0D, 0xFE, 0x00, 0x00, 0x3D, 0xFE, 0x04, 0x00, 0x01, 0x56, 0x15, 0xC5, 0x01, 0x9B, 
0x01, 0x06, 0x0C, 0x00, 0x01, 0x01, 0x01, 0x78, 0x06, 0xC5, 0x01, 0xB8, 0x01, 0x06, 0x03, 0x00, 
0x0E, 0xFE, 0x00, 0x00, 0x3E, 0xFE, 0x04, 0x00, 0x01, 0x56, 0x15, 0xC5, 0x00, 0x03, 0xA5, 0x48, 
0x01, 0x00, 0x09, 0x00, 0x01, 0x2C, 0x01, 0xA5, 0x07, 0xC5, 0x01, 0x3D, 0x04, 0x00, 0x0E, 0xFE, 
0x00, 0x00, 0x3E, 0xFE, 0x05, 0x00, 0x01, 0x50, 0x16, 0xC5, 0x00, 0x0A, 0xAF, 0x6C, 0x48, 0x21, 
0x06, 0x17, 0x21, 0x3D, 0x6C, 0xA5, 0x08, 0xC5, 0x01, 0x48, 0x04, 0x00, 0x0F, 0xFE, 0x00, 0x00, 
0x3F, 0xFE, 0x05, 0x00, 0x01, 0x3D, 0x26, 0xC5, 0x01, 0x48, 0x04, 0x00, 0x10, 0xFE, 0x00, 0x00, 
0x40, 0xFE, 0x05, 0x00, 0x01, 0x2C, 0x01, 0xAF, 0x22, 0xC5, 0x01, 0xBF, 0x01, 0x3D, 0x04, 0x00, 
0x11, 0xFE, 0x00, 0x00, 0x42, 0xFE, 0x04, 0x00, 0x01, 0x06, 0x01, 0x80, 0x20, 0xC5, 0x01, 0xA5, 
0x01, 0x11, 0x04, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x43, 0xFE, 0x05, 0x00, 0x01, 0x48, 0x01, 0xB8, 
0x1D, 0xC5, 0x01, 0x80, 0x01, 0x06, 0x05, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x44, 0xFE, 0x05, 0x00, 
0x00, 0x03, 0x06, 0x64, 0xB8, 0x00, 0x19, 0xC5, 0x01, 0x9B, 0x01, 0x3D, 0x05, 0x00, 0x14, 0xFE, 
0x00, 0x00, 0x45, 0xFE, 0x06, 0x00, 0x00, 0x03, 0x06, 0x64, 0xB8, 0x00, 0x15, 0xC5, 0x01, 0x8F, 
0x01, 0x2C, 0x06, 0x00, 0x15, 0xFE, 0x00, 0x00, 0x47, 0xFE, 0x06, 0x00, 0x00, 0x04, 0x06, 0x48, 
0x80, 0xB8, 0x0F, 0xC5, 0x00, 0x03, 0xA5, 0x6C, 0x21, 0x00, 0x07, 0x00, 0x16, 0xFE, 0x00, 0x00, 
0x48, 0xFE, 0x08, 0x00, 0x00, 0x06, 0x01, 0x35, 0x6C, 0x8F, 0xA5, 0xB8, 0x04, 0xC5, 0x00, 0x06, 
0xBF, 0xAF, 0xA5, 0x78, 0x3D, 0x06, 0x08, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x4A, 0xFE, 0x0C, 0x00, 
0x00, 0x04, 0x06, 0x11, 0x0B, 0x01, 0x0C, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x4C, 0xFE, 0x18, 0x00, 
0x1C, 0xFE, 0x00, 0x00, 0x50, 0xFE, 0x11, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x55, 0xFE, 0x07, 0x00, 
0x24, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x01, 
};

constexpr unsigned char parrot01[] = {
0x42, 0x4D, 0xFE, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x04, 0x00, 0x00, 0x28, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x01, 0x00, 
0x00, 0x00, 0xCC, 0x09, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0xFF, 0x00, 
0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x08, 0x04, 
0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x0B, 0x05, 0x08, 0x00, 0x06, 0x0A, 0x07, 0x00, 0x06, 0x08, 
0x0E, 0x00, 0x0E, 0x0B, 0x04, 0x00, 0x0F, 0x07, 0x12, 0x00, 0x0B, 0x0C, 0x12, 0x00, 0x16, 0x0B, 
0x12, 0x00, 0x0C, 0x0B, 0x17, 0x00, 0x0C, 0x10, 0x0D, 0x00, 0x13, 0x11, 0x08, 0x00, 0x12, 0x0C, 
0x1C, 0x00, 0x19, 0x0C, 0x1B, 0x00, 0x18, 0x10, 0x10, 0x00, 0x0A, 0x0D, 0x21, 0x00, 0x08, 0x13, 
0x10, 0x00, 0x1E, 0x0E, 0x1A, 0x00, 0x0A, 0x12, 0x18, 0x00, 0x1B, 0x15, 0x0E, 0x00, 0x1C, 0x10, 
0x1F, 0x00, 0x14, 0x11, 0x1F, 0x00, 0x12, 0x15, 0x13, 0x00, 0x23, 0x10, 0x24, 0x00, 0x1B, 0x10, 
0x28, 0x00, 0x0E, 0x15, 0x1C, 0x00, 0x0E, 0x1A, 0x0D, 0x00, 0x19, 0x19, 0x0D, 0x00, 0x11, 0x13, 
0x25, 0x00, 0x23, 0x13, 0x1F, 0x00, 0x12, 0x1A, 0x15, 0x00, 0x12, 0x13, 0x2E, 0x00, 0x25, 0x1A, 
0x16, 0x00, 0x2E, 0x14, 0x30, 0x00, 0x17, 0x18, 0x2C, 0x00, 0x20, 0x20, 0x0F, 0x00, 0x2D, 0x19, 
0x23, 0x00, 0x13, 0x1C, 0x23, 0x00, 0x13, 0x21, 0x13, 0x00, 0x17, 0x1F, 0x1A, 0x00, 0x24, 0x16, 
0x34, 0x00, 0x32, 0x14, 0x37, 0x00, 0x17, 0x17, 0x38, 0x00, 0x2E, 0x19, 0x2B, 0x00, 0x1C, 0x1D, 
0x32, 0x00, 0x15, 0x21, 0x29, 0x00, 0x32, 0x23, 0x1B, 0x00, 0x26, 0x26, 0x15, 0x00, 0x1D, 0x25, 
0x20, 0x00, 0x16, 0x29, 0x15, 0x00, 0x3B, 0x1A, 0x3B, 0x00, 0x1D, 0x1B, 0x43, 0x00, 0x2F, 0x1B, 
0x40, 0x00, 0x36, 0x1E, 0x34, 0x00, 0x3D, 0x20, 0x33, 0x00, 0x23, 0x21, 0x3D, 0x00, 0x3B, 0x20, 
0x3D, 0x00, 0x3A, 0x29, 0x22, 0x00, 0x44, 0x1D, 0x47, 0x00, 0x1F, 0x1F, 0x4D, 0x00, 0x2C, 0x2D, 
0x1A, 0x00, 0x1A, 0x28, 0x31, 0x00, 0x22, 0x2B, 0x27, 0x00, 0x37, 0x1F, 0x4D, 0x00, 0x3F, 0x23, 
0x41, 0x00, 0x26, 0x27, 0x48, 0x00, 0x47, 0x27, 0x3E, 0x00, 0x4E, 0x22, 0x4E, 0x00, 0x1F, 0x2F, 
0x39, 0x00, 0x25, 0x32, 0x2D, 0x00, 0x25, 0x26, 0x56, 0x00, 0x3F, 0x24, 0x59, 0x00, 0x1F, 0x39, 
0x1E, 0x00, 0x35, 0x37, 0x1E, 0x00, 0x47, 0x33, 0x27, 0x00, 0x53, 0x24, 0x58, 0x00, 0x4F, 0x2B, 
0x42, 0x00, 0x2B, 0x2C, 0x50, 0x00, 0x28, 0x28, 0x5F, 0x00, 0x4D, 0x2A, 0x4D, 0x00, 0x2A, 0x38, 
0x30, 0x00, 0x55, 0x30, 0x49, 0x00, 0x30, 0x2F, 0x59, 0x00, 0x60, 0x29, 0x62, 0x00, 0x2B, 0x2C, 
0x6B, 0x00, 0x49, 0x2B, 0x68, 0x00, 0x55, 0x2F, 0x59, 0x00, 0x26, 0x3A, 0x45, 0x00, 0x31, 0x3F, 
0x36, 0x00, 0x58, 0x3E, 0x2E, 0x00, 0x65, 0x2B, 0x6B, 0x00, 0x26, 0x46, 0x26, 0x00, 0x2F, 0x30, 
0x6F, 0x00, 0x5C, 0x32, 0x59, 0x00, 0x47, 0x46, 0x24, 0x00, 0x62, 0x36, 0x52, 0x00, 0x37, 0x36, 
0x61, 0x00, 0x51, 0x31, 0x75, 0x00, 0x32, 0x33, 0x7A, 0x00, 0x2A, 0x41, 0x4E, 0x00, 0x5E, 0x44, 
0x34, 0x00, 0x38, 0x47, 0x3D, 0x00, 0x65, 0x38, 0x66, 0x00, 0x75, 0x32, 0x79, 0x00, 0x2D, 0x52, 
0x2D, 0x00, 0x58, 0x35, 0x81, 0x00, 0x37, 0x37, 0x86, 0x00, 0x69, 0x4A, 0x37, 0x00, 0x3C, 0x3E, 
0x71, 0x00, 0x72, 0x3E, 0x61, 0x00, 0x53, 0x52, 0x2C, 0x00, 0x39, 0x4D, 0x46, 0x00, 0x30, 0x49, 
0x57, 0x00, 0x62, 0x37, 0x86, 0x00, 0x32, 0x58, 0x2B, 0x00, 0x72, 0x3D, 0x71, 0x00, 0x58, 0x56, 
0x30, 0x00, 0x2F, 0x5B, 0x31, 0x00, 0x3E, 0x3D, 0x93, 0x00, 0x86, 0x3A, 0x88, 0x00, 0x73, 0x52, 
0x3E, 0x00, 0x3F, 0x54, 0x4B, 0x00, 0x45, 0x45, 0x7E, 0x00, 0x69, 0x3D, 0x90, 0x00, 0x85, 0x48, 
0x6F, 0x00, 0x81, 0x45, 0x81, 0x00, 0x41, 0x43, 0xA1, 0x00, 0x37, 0x56, 0x66, 0x00, 0x7F, 0x5A, 
0x41, 0x00, 0x46, 0x5C, 0x4F, 0x00, 0x93, 0x3F, 0x98, 0x00, 0x38, 0x66, 0x36, 0x00, 0x63, 0x63, 
0x34, 0x00, 0x73, 0x43, 0xA0, 0x00, 0x4F, 0x4D, 0x8E, 0x00, 0x9C, 0x42, 0xA1, 0x00, 0x3D, 0x5D, 
0x6D, 0x00, 0x4C, 0x63, 0x55, 0x00, 0x95, 0x51, 0x7C, 0x00, 0x89, 0x62, 0x4A, 0x00, 0x9F, 0x45, 
0xA5, 0x00, 0x4B, 0x4B, 0xB3, 0x00, 0x50, 0x53, 0x97, 0x00, 0x51, 0x68, 0x5A, 0x00, 0x7E, 0x4A, 
0xB1, 0x00, 0x93, 0x51, 0x94, 0x00, 0x40, 0x75, 0x40, 0x00, 0xAB, 0x49, 0xB0, 0x00, 0x56, 0x57, 
0xA1, 0x00, 0x71, 0x72, 0x3F, 0x00, 0x50, 0x6C, 0x60, 0x00, 0x42, 0x67, 0x79, 0x00, 0x98, 0x6A, 
0x53, 0x00, 0x50, 0x50, 0xC3, 0x00, 0xA5, 0x5A, 0x8A, 0x00, 0xA0, 0x57, 0x9C, 0x00, 0x87, 0x4F, 
0xC1, 0x00, 0x56, 0x72, 0x66, 0x00, 0xB8, 0x4F, 0xBF, 0x00, 0x44, 0x80, 0x45, 0x00, 0x60, 0x60, 
0xAF, 0x00, 0xA8, 0x5C, 0xA9, 0x00, 0x7D, 0x7E, 0x46, 0x00, 0x59, 0x58, 0xD5, 0x00, 0x8F, 0x55, 
0xCD, 0x00, 0xA5, 0x75, 0x5D, 0x00, 0xB5, 0x63, 0x98, 0x00, 0x5D, 0x7A, 0x6D, 0x00, 0xC6, 0x54, 
0xCB, 0x00, 0x4C, 0x76, 0x8A, 0x00, 0x4B, 0x89, 0x4B, 0x00, 0x61, 0x7F, 0x6C, 0x00, 0x69, 0x68, 
0xBC, 0x00, 0x5E, 0x5F, 0xE4, 0x00, 0x9B, 0x5B, 0xDD, 0x00, 0xCD, 0x59, 0xD5, 0x00, 0xB9, 0x64, 
0xB8, 0x00, 0xB2, 0x7E, 0x63, 0x00, 0x88, 0x8B, 0x4D, 0x00, 0x66, 0x84, 0x71, 0x00, 0xD8, 0x5B, 
0xDD, 0x00, 0xC7, 0x6D, 0xA7, 0x00, 0x64, 0x62, 0xEE, 0x00, 0x9F, 0x60, 0xE5, 0x00, 0x51, 0x96, 
0x51, 0x00, 0x6E, 0x6F, 0xCC, 0x00, 0x54, 0x81, 0x9B, 0x00, 0x6B, 0x8A, 0x76, 0x00, 0xA9, 0x62, 
0xEB, 0x00, 0x68, 0x66, 0xF4, 0x00, 0xDD, 0x60, 0xE2, 0x00, 0xC3, 0x6B, 0xC6, 0x00, 0xC1, 0x88, 
0x69, 0x00, 0x68, 0x8C, 0x7B, 0x00, 0x96, 0x96, 0x51, 0x00, 0x68, 0x69, 0xFF, 0x00, 0xE4, 0x62, 
0xED, 0x00, 0xD6, 0x75, 0xB3, 0x00, 0xD0, 0x6F, 0xCF, 0x00, 0xB1, 0x66, 0xF8, 0x00, 0x5A, 0xA1, 
0x55, 0x00, 0x77, 0x77, 0xDB, 0x00, 0xCA, 0x8F, 0x6F, 0x00, 0xA1, 0x9F, 0x56, 0x00, 0xB7, 0x6C, 
0xFE, 0x00, 0x5D, 0x8E, 0xAB, 0x00, 0xD7, 0x76, 0xD6, 0x00, 0xF3, 0x69, 0xFA, 0x00, 0xF7, 0x68, 
0xFF, 0x00, 0x5A, 0xA9, 0x5D, 0x00, 0xD7, 0x98, 0x74, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0xEB, 0x80, 
0xC5, 0x00, 0xE0, 0x7B, 0xE3, 0x00, 0x85, 0x82, 0xF1, 0x00, 0xAD, 0xAC, 0x5A, 0x00, 0x64, 0x99, 
0xB8, 0x00, 0xE1, 0xA0, 0x7A, 0x00, 0x63, 0xB5, 0x62, 0x00, 0xF8, 0x87, 0xCF, 0x00, 0x85, 0x88, 
0xF9, 0x00, 0xF1, 0x83, 0xF1, 0x00, 0xE8, 0xA6, 0x81, 0x00, 0xFF, 0x8C, 0xD7, 0x00, 0x8B, 0x8D, 
0xFF, 0x00, 0xF3, 0xAB, 0x80, 0x00, 0xF8, 0x88, 0xFA, 0x00, 0x68, 0xC2, 0x68, 0x00, 0xBE, 0xBE, 
0x67, 0x00, 0x6D, 0xA9, 0xCB, 0x00, 0xF9, 0xB0, 0x86, 0x00, 0xFF, 0x8C, 0xFF, 0x00, 0x70, 0xCB, 
0x6E, 0x00, 0xFE, 0xB5, 0x8B, 0x00, 0xC6, 0xC6, 0x6A, 0x00, 0x71, 0xD3, 0x73, 0x00, 0x78, 0xB7, 
0xDA, 0x00, 0xCE, 0xCF, 0x72, 0x00, 0x78, 0xDB, 0x78, 0x00, 0x7C, 0xE5, 0x7C, 0x00, 0x7F, 0xC4, 
0xEA, 0x00, 0xDB, 0xDD, 0x78, 0x00, 0x81, 0xED, 0x81, 0x00, 0xE3, 0xE5, 0x7E, 0x00, 0x88, 0xCF, 
0xF5, 0x00, 0x87, 0xF5, 0x84, 0x00, 0xEC, 0xEF, 0x87, 0x00, 0x89, 0xD6, 0xFE, 0x00, 0x87, 0xFA, 
0x8C, 0x00, 0xF1, 0xF3, 0x8C, 0x00, 0x89, 0xFF, 0x88, 0x00, 0xFB, 0xF9, 0x80, 0x00, 0xFF, 0xFF, 
0x87, 0x00, 0x08, 0xFE, 0x6A, 0x00, 0x0E, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x6A, 0x00, 0x0E, 0xFE, 
0x00, 0x00, 0x08, 0xFE, 0x6A, 0x00, 0x0E, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x04, 0x00, 0x01, 0x43, 
0x60, 0x54, 0x01, 0x17, 0x03, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0xAE, 
0x60, 0xE2, 0x01, 0x0B, 0x03, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0x90, 
0x5F, 0xE2, 0x01, 0xAE, 0x04, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0x62, 
0x5F, 0xE2, 0x01, 0x62, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0x01, 
0x01, 0xD8, 0x5D, 0xE2, 0x01, 0xDE, 0x01, 0x06, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 
0x03, 0x00, 0x01, 0x88, 0x5D, 0xE2, 0x01, 0xA2, 0x04, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 
0x03, 0x00, 0x01, 0x1E, 0x01, 0xDE, 0x5C, 0xE2, 0x01, 0x4F, 0x03, 0x00, 0x11, 0xFE, 0x00, 0x00, 
0x0A, 0xFE, 0x04, 0x00, 0x01, 0x62, 0x5B, 0xE2, 0x01, 0xD8, 0x01, 0x01, 0x03, 0x00, 0x11, 0xFE, 
0x00, 0x00, 0x0B, 0xFE, 0x04, 0x00, 0x01, 0x96, 0x5A, 0xE2, 0x01, 0x90, 0x03, 0x00, 0x12, 0xFE, 
0x00, 0x00, 0x0C, 0xFE, 0x03, 0x00, 0x01, 0x06, 0x01, 0xAE, 0x59, 0xE2, 0x01, 0x39, 0x03, 0x00, 
0x12, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 0x04, 0x00, 0x01, 0x01, 0x01, 0x96, 0x57, 0xE2, 0x01, 0xD5, 
0x01, 0x01, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 0x04, 0x00, 0x00, 0x03, 0x03, 0x7C, 
0xDE, 0x00, 0x55, 0xE2, 0x01, 0x88, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x0E, 0xFE, 0x05, 0x00, 
0x01, 0x24, 0x01, 0xAE, 0x54, 0xE2, 0x01, 0x39, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x0F, 0xFE, 
0x06, 0x00, 0x01, 0x62, 0x01, 0xD5, 0x2A, 0xE2, 0x00, 0x04, 0xCB, 0xA2, 0x96, 0xCB, 0x23, 0xE2, 
0x01, 0xD5, 0x01, 0x03, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x06, 0x00, 0x01, 0x06, 
0x01, 0x90, 0x25, 0xE2, 0x00, 0x04, 0xAE, 0x62, 0x2E, 0x06, 0x03, 0x00, 0x01, 0x06, 0x01, 0xD5, 
0x22, 0xE2, 0x01, 0x96, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x06, 0x00, 0x01, 0x2E, 
0x01, 0xAE, 0x20, 0xE2, 0x00, 0x03, 0xCB, 0x7C, 0x17, 0x00, 0x08, 0x00, 0x01, 0xA2, 0x22, 0xE2, 
0x01, 0x7C, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x14, 0xFE, 0x06, 0x00, 0x01, 0x4F, 0x01, 0xCB, 
0x1C, 0xE2, 0x01, 0xBB, 0x01, 0x39, 0x0A, 0x00, 0x01, 0x24, 0x01, 0xDE, 0x22, 0xE2, 0x01, 0x4F, 
0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x15, 0xFE, 0x06, 0x00, 0x00, 0x03, 0x01, 0x6E, 0xDE, 0x00, 
0x18, 0xE2, 0x01, 0xD5, 0x01, 0x54, 0x07, 0x00, 0x00, 0x06, 0x06, 0x39, 0x6E, 0x90, 0xBB, 0xDE, 
0x23, 0xE2, 0x01, 0x1E, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x17, 0xFE, 0x06, 0x00, 0x01, 0x17, 
0x01, 0xBB, 0x15, 0xE2, 0x00, 0x03, 0xDE, 0x88, 0x06, 0x00, 0x05, 0x00, 0x00, 0x04, 0x06, 0x54, 
0xAE, 0xDE, 0x28, 0xE2, 0x01, 0x17, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x19, 0xFE, 0x05, 0x00, 
0x01, 0x06, 0x01, 0xA2, 0x13, 0xE2, 0x01, 0xCB, 0x01, 0x24, 0x05, 0x00, 0x00, 0x03, 0x24, 0x96, 
0xD8, 0x00, 0x2B, 0xE2, 0x01, 0x2E, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x1A, 0xFE, 0x05, 0x00, 
0x01, 0x03, 0x01, 0x7C, 0x11, 0xE2, 0x01, 0xBB, 0x01, 0x09, 0x04, 0x00, 0x00, 0x03, 0x09, 0x90, 
0xDE, 0x00, 0x2D, 0xE2, 0x01, 0x43, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x1C, 0xFE, 0x05, 0x00, 
0x01, 0x54, 0x01, 0xDE, 0x0E, 0xE2, 0x01, 0xA2, 0x01, 0x01, 0x03, 0x00, 0x00, 0x03, 0x01, 0x6E, 
0xD8, 0x00, 0x2F, 0xE2, 0x01, 0x54, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x1D, 0xFE, 0x05, 0x00, 
0x01, 0x39, 0x01, 0xDE, 0x0C, 0xE2, 0x01, 0x88, 0x01, 0x01, 0x03, 0x00, 0x01, 0x0B, 0x01, 0xBB, 
0x31, 0xE2, 0x01, 0x7C, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x05, 0x00, 0x01, 0x62, 
0x0B, 0xE2, 0x01, 0x88, 0x04, 0x00, 0x01, 0x24, 0x01, 0xCB, 0x32, 0xE2, 0x01, 0xA2, 0x03, 0x00, 
0x14, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x04, 0x00, 0x01, 0x90, 0x09, 0xE2, 0x01, 0xBB, 0x01, 0x01, 
0x03, 0x00, 0x01, 0x39, 0x01, 0xD8, 0x33, 0xE2, 0x01, 0xCB, 0x04, 0x00, 0x13, 0xFE, 0x00, 0x00, 
0x20, 0xFE, 0x04, 0x00, 0x01, 0x01, 0x01, 0xBB, 0x07, 0xE2, 0x01, 0xD8, 0x01, 0x17, 0x03, 0x00, 
0x01, 0x4F, 0x01, 0xDE, 0x35, 0xE2, 0x01, 0x0B, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x21, 0xFE, 
0x04, 0x00, 0x01, 0x0B, 0x01, 0xD8, 0x06, 0xE2, 0x01, 0x4F, 0x03, 0x00, 0x01, 0x1E, 0x01, 0xDE, 
0x36, 0xE2, 0x01, 0x4F, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x22, 0xFE, 0x04, 0x00, 0x01, 0x6E, 
0x05, 0xE2, 0x01, 0x90, 0x03, 0x00, 0x01, 0x06, 0x01, 0xBB, 0x25, 0xE2, 0x01, 0xBB, 0x01, 0xDE, 
0x10, 0xE2, 0x01, 0x90, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x23, 0xFE, 0x03, 0x00, 0x01, 0x06, 
0x01, 0xD5, 0x03, 0xE2, 0x01, 0xDE, 0x01, 0x0B, 0x03, 0x00, 0x01, 0x90, 0x25, 0xE2, 0x00, 0x03, 
0xD8, 0x1E, 0x96, 0x00, 0x10, 0xE2, 0x01, 0xCB, 0x04, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x23, 0xFE, 
0x04, 0x00, 0x01, 0x62, 0x03, 0xE2, 0x01, 0x96, 0x03, 0x00, 0x01, 0x54, 0x26, 0xE2, 0x00, 0x03, 
0x62, 0x00, 0x24, 0x00, 0x11, 0xE2, 0x01, 0x0B, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x24, 0xFE, 
0x03, 0x00, 0x00, 0x05, 0x01, 0xCB, 0xE2, 0xE2, 0x2E, 0x00, 0x03, 0x00, 0x01, 0xBB, 0x25, 0xE2, 
0x01, 0xA2, 0x03, 0x00, 0x01, 0xAE, 0x10, 0xE2, 0x01, 0x62, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 
0x25, 0xFE, 0x03, 0x00, 0x00, 0x03, 0x6E, 0xE2, 0xBB, 0x00, 0x03, 0x00, 0x01, 0x39, 0x25, 0xE2, 
0x01, 0xD5, 0x01, 0x09, 0x03, 0x00, 0x01, 0x4F, 0x10, 0xE2, 0x01, 0x96, 0x03, 0x00, 0x12, 0xFE, 
0x00, 0x00, 0x25, 0xFE, 0x03, 0x00, 0x00, 0x03, 0x0B, 0xDE, 0x62, 0x00, 0x03, 0x00, 0x01, 0x96, 
0x25, 0xE2, 0x01, 0x43, 0x04, 0x00, 0x01, 0x01, 0x01, 0xCB, 0x0F, 0xE2, 0x01, 0xD5, 0x04, 0x00, 
0x11, 0xFE, 0x00, 0x00, 0x25, 0xFE, 0x04, 0x00, 0x00, 0x06, 0xA2, 0x06, 0x00, 0x00, 0x0B, 0xDE, 
0x24, 0xE2, 0x01, 0x90, 0x06, 0x00, 0x01, 0x6E, 0x10, 0xE2, 0x01, 0x1E, 0x03, 0x00, 0x11, 0xFE, 
0x00, 0x00, 0x26, 0xFE, 0x03, 0x00, 0x01, 0x4F, 0x03, 0x00, 0x01, 0x6E, 0x24, 0xE2, 0x01, 0xCB, 
0x01, 0x06, 0x03, 0x00, 0x00, 0x05, 0x03, 0x00, 0x00, 0x06, 0xD8, 0x00, 0x0F, 0xE2, 0x01, 0x62, 
0x03, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x26, 0xFE, 0x03, 0x00, 0x01, 0x06, 0x03, 0x00, 0x01, 0x90, 
0x23, 0xE2, 0x01, 0xDE, 0x01, 0x2E, 0x03, 0x00, 0x01, 0x47, 0x01, 0x5A, 0x03, 0x00, 0x01, 0x88, 
0x0F, 0xE2, 0x01, 0x88, 0x03, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x26, 0xFE, 0x07, 0x00, 0x01, 0xAE, 
0x23, 0xE2, 0x01, 0x7C, 0x03, 0x00, 0x00, 0x08, 0x0C, 0xB5, 0xAD, 0x03, 0x00, 0x00, 0x17, 0xDE, 
0x0E, 0xE2, 0x01, 0xA2, 0x03, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x27, 0xFE, 0x06, 0x00, 0x01, 0xBB, 
0x22, 0xE2, 0x00, 0x09, 0xBB, 0x01, 0x00, 0x00, 0x03, 0x98, 0xC3, 0xC3, 0x47, 0x00, 0x03, 0x00, 
0x01, 0xA2, 0x0E, 0xE2, 0x01, 0xCB, 0x04, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x27, 0xFE, 0x06, 0x00, 
0x01, 0xD8, 0x22, 0xE2, 0x01, 0x43, 0x03, 0x00, 0x01, 0x5A, 0x03, 0xC3, 0x01, 0x98, 0x03, 0x00, 
0x01, 0x39, 0x0E, 0xE2, 0x01, 0xDE, 0x04, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x28, 0xFE, 0x04, 0x00, 
0x01, 0x06, 0x22, 0xE2, 0x01, 0xBB, 0x03, 0x00, 0x01, 0x0C, 0x05, 0xC3, 0x01, 0x29, 0x03, 0x00, 
0x01, 0xBB, 0x0E, 0xE2, 0x01, 0x01, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x28, 0xFE, 0x04, 0x00, 
0x01, 0x01, 0x01, 0xDE, 0x21, 0xE2, 0x01, 0x54, 0x03, 0x00, 0x01, 0x7B, 0x05, 0xC3, 0x01, 0x83, 
0x03, 0x00, 0x01, 0x62, 0x0E, 0xE2, 0x01, 0x01, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x28, 0xFE, 
0x05, 0x00, 0x01, 0xBB, 0x20, 0xE2, 0x00, 0x05, 0xCB, 0x01, 0x00, 0x00, 0x0C, 0x00, 0x07, 0xC3, 
0x00, 0x04, 0x0C, 0x00, 0x00, 0x0B, 0x0E, 0xE2, 0x01, 0x01, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 
0x29, 0xFE, 0x04, 0x00, 0x01, 0x96, 0x20, 0xE2, 0x01, 0x7C, 0x03, 0x00, 0x01, 0x71, 0x07, 0xC3, 
0x01, 0x47, 0x03, 0x00, 0x01, 0xCB, 0x0C, 0xE2, 0x01, 0xDE, 0x01, 0x01, 0x03, 0x00, 0x10, 0xFE, 
0x00, 0x00, 0x29, 0xFE, 0x04, 0x00, 0x01, 0x6E, 0x20, 0xE2, 0x00, 0x05, 0x2E, 0x00, 0x00, 0x03, 
0xB5, 0x00, 0x07, 0xC3, 0x01, 0x7B, 0x03, 0x00, 0x01, 0x90, 0x0C, 0xE2, 0x01, 0xCB, 0x04, 0x00, 
0x10, 0xFE, 0x00, 0x00, 0x29, 0xFE, 0x04, 0x00, 0x01, 0x2E, 0x1F, 0xE2, 0x01, 0xCB, 0x03, 0x00, 
0x01, 0x32, 0x08, 0xC3, 0x01, 0xAD, 0x03, 0x00, 0x01, 0x54, 0x0C, 0xE2, 0x01, 0xA2, 0x03, 0x00, 
0x11, 0xFE, 0x00, 0x00, 0x2A, 0xFE, 0x03, 0x00, 0x01, 0x01, 0x1F, 0xE2, 0x01, 0x88, 0x03, 0x00, 
0x01, 0x71, 0x09, 0xC3, 0x00, 0x04, 0x0C, 0x00, 0x00, 0x0B, 0x0C, 0xE2, 0x01, 0x7C, 0x03, 0x00, 
0x11, 0xFE, 0x00, 0x00, 0x2A, 0xFE, 0x04, 0x00, 0x01, 0x96, 0x1E, 0xE2, 0x01, 0x62, 0x03, 0x00, 
0x01, 0xA9, 0x09, 0xC3, 0x01, 0x47, 0x03, 0x00, 0x01, 0xCB, 0x0B, 0xE2, 0x01, 0x54, 0x03, 0x00, 
0x11, 0xFE, 0x00, 0x00, 0x2B, 0xFE, 0x03, 0x00, 0x01, 0x1E, 0x01, 0xDE, 0x1D, 0xE2, 0x00, 0x04, 
0x39, 0x00, 0x00, 0x03, 0x0A, 0xC3, 0x01, 0x7B, 0x03, 0x00, 0x01, 0x96, 0x0B, 0xE2, 0x01, 0x24, 
0x03, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x2B, 0xFE, 0x04, 0x00, 0x01, 0x96, 0x1D, 0xE2, 0x00, 0x04, 
0x17, 0x00, 0x00, 0x20, 0x0A, 0xC3, 0x01, 0xAD, 0x03, 0x00, 0x01, 0x62, 0x0A, 0xE2, 0x01, 0xDE, 
0x01, 0x01, 0x03, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x2C, 0xFE, 0x03, 0x00, 0x01, 0x17, 0x01, 0xDE, 
0x1B, 0xE2, 0x00, 0x05, 0xDE, 0x01, 0x00, 0x00, 0x47, 0x00, 0x0B, 0xC3, 0x00, 0x04, 0x0C, 0x00, 
0x00, 0x17, 0x0A, 0xE2, 0x01, 0xAE, 0x04, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x2C, 0xFE, 0x04, 0x00, 
0x01, 0x90, 0x1B, 0xE2, 0x01, 0xCB, 0x03, 0x00, 0x01, 0x5A, 0x0B, 0xC3, 0x01, 0x47, 0x03, 0x00, 
0x01, 0xDE, 0x09, 0xE2, 0x01, 0x6E, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x2D, 0xFE, 0x03, 0x00, 
0x01, 0x0B, 0x01, 0xDE, 0x1A, 0xE2, 0x01, 0xAE, 0x03, 0x00, 0x01, 0x7B, 0x0B, 0xC3, 0x01, 0x5A, 
0x03, 0x00, 0x01, 0xD5, 0x09, 0xE2, 0x01, 0x17, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x2D, 0xFE, 
0x04, 0x00, 0x01, 0x88, 0x1A, 0xE2, 0x01, 0x88, 0x03, 0x00, 0x01, 0x91, 0x0B, 0xC3, 0x01, 0x67, 
0x03, 0x00, 0x01, 0xCB, 0x08, 0xE2, 0x01, 0xBB, 0x04, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x2E, 0xFE, 
0x03, 0x00, 0x01, 0x0B, 0x01, 0xD8, 0x19, 0xE2, 0x01, 0x6E, 0x03, 0x00, 0x01, 0xA9, 0x0B, 0xC3, 
0x01, 0x71, 0x03, 0x00, 0x01, 0xBB, 0x08, 0xE2, 0x01, 0x7C, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 
0x2E, 0xFE, 0x04, 0x00, 0x01, 0x62, 0x19, 0xE2, 0x01, 0x54, 0x03, 0x00, 0x0C, 0xC3, 0x01, 0x7B, 
0x03, 0x00, 0x01, 0xAE, 0x08, 0xE2, 0x01, 0x24, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x2F, 0xFE, 
0x04, 0x00, 0x01, 0xAE, 0x18, 0xE2, 0x01, 0x62, 0x03, 0x00, 0x01, 0xB5, 0x0B, 0xC3, 0x01, 0x83, 
0x03, 0x00, 0x01, 0xA2, 0x07, 0xE2, 0x01, 0xD5, 0x01, 0x03, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 
0x30, 0xFE, 0x03, 0x00, 0x01, 0x0B, 0x01, 0xD8, 0x17, 0xE2, 0x01, 0x6E, 0x03, 0x00, 0x01, 0xAD, 
0x0B, 0xC3, 0x01, 0x91, 0x03, 0x00, 0x01, 0x90, 0x07, 0xE2, 0x01, 0x96, 0x03, 0x00, 0x14, 0xFE, 
0x00, 0x00, 0x30, 0xFE, 0x04, 0x00, 0x01, 0x62, 0x0E, 0xE2, 0x01, 0xBB, 0x01, 0xD8, 0x07, 0xE2, 
0x01, 0x6E, 0x03, 0x00, 0x01, 0xA9, 0x0B, 0xC3, 0x01, 0x9F, 0x03, 0x00, 0x00, 0x05, 0x88, 0xE2, 
0xE2, 0xCB, 0xD5, 0x00, 0x03, 0xE2, 0x01, 0x54, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x31, 0xFE, 
0x04, 0x00, 0x01, 0xAE, 0x0B, 0xE2, 0x00, 0x05, 0xCB, 0x1E, 0x00, 0x01, 0x6E, 0x00, 0x06, 0xE2, 
0x01, 0x7C, 0x03, 0x00, 0x01, 0x9F, 0x0B, 0xC3, 0x01, 0x9F, 0x03, 0x00, 0x00, 0x09, 0x7C, 0xD8, 
0x39, 0x00, 0x00, 0x54, 0xDE, 0xE2, 0x0B, 0x00, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x32, 0xFE, 
0x03, 0x00, 0x01, 0x17, 0x01, 0xD8, 0x09, 0xE2, 0x01, 0xDE, 0x01, 0x1E, 0x04, 0x00, 0x01, 0x90, 
0x05, 0xE2, 0x01, 0x88, 0x03, 0x00, 0x01, 0x98, 0x0B, 0xC3, 0x01, 0x83, 0x03, 0x00, 0x01, 0x96, 
0x01, 0x43, 0x04, 0x00, 0x01, 0x6E, 0x01, 0xBB, 0x04, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x32, 0xFE, 
0x04, 0x00, 0x01, 0x62, 0x09, 0xE2, 0x01, 0x96, 0x05, 0x00, 0x01, 0x1E, 0x05, 0xE2, 0x01, 0x90, 
0x03, 0x00, 0x01, 0x91, 0x0B, 0xC3, 0x01, 0x67, 0x03, 0x00, 0x01, 0x96, 0x05, 0x00, 0x01, 0x01, 
0x01, 0x7C, 0x03, 0x00, 0x15, 0xFE, 0x00, 0x00, 0x33, 0xFE, 0x04, 0x00, 0x01, 0xAE, 0x08, 0xE2, 
0x01, 0x6E, 0x06, 0x00, 0x01, 0xDE, 0x04, 0xE2, 0x01, 0x96, 0x03, 0x00, 0x01, 0x8B, 0x0B, 0xC3, 
0x01, 0x47, 0x03, 0x00, 0x01, 0x88, 0x06, 0x00, 0x01, 0x39, 0x03, 0x00, 0x15, 0xFE, 0x00, 0x00, 
0x34, 0xFE, 0x03, 0x00, 0x01, 0x06, 0x01, 0xCB, 0x07, 0xE2, 0x01, 0x62, 0x06, 0x00, 0x01, 0xCB, 
0x04, 0xE2, 0x01, 0xA2, 0x03, 0x00, 0x01, 0x83, 0x0B, 0xC3, 0x00, 0x05, 0x29, 0x00, 0x00, 0x06, 
0x88, 0x00, 0x06, 0x00, 0x01, 0x01, 0x03, 0x00, 0x15, 0xFE, 0x00, 0x00, 0x34, 0xFE, 0x04, 0x00, 
0x01, 0x24, 0x01, 0xDE, 0x06, 0xE2, 0x01, 0x7C, 0x05, 0x00, 0x01, 0x01, 0x01, 0xDE, 0x04, 0xE2, 
0x01, 0xAE, 0x03, 0x00, 0x01, 0x71, 0x0B, 0xC3, 0x00, 0x05, 0x05, 0x00, 0x00, 0x39, 0xA2, 0x00, 
0x0A, 0x00, 0x15, 0xFE, 0x00, 0x00, 0x35, 0xFE, 0x04, 0x00, 0x01, 0x4F, 0x06, 0xE2, 0x01, 0xBB, 
0x05, 0x00, 0x01, 0x43, 0x05, 0xE2, 0x00, 0x06, 0xD5, 0x01, 0x00, 0x00, 0x20, 0xBD, 0x09, 0xC3, 
0x01, 0x9F, 0x03, 0x00, 0x00, 0x03, 0x62, 0xD5, 0x06, 0x00, 0x04, 0x00, 0x01, 0x06, 0x03, 0x00, 
0x16, 0xFE, 0x00, 0x00, 0x36, 0xFE, 0x04, 0x00, 0x01, 0x7C, 0x06, 0xE2, 0x01, 0x62, 0x03, 0x00, 
0x01, 0x06, 0x01, 0xBB, 0x06, 0xE2, 0x01, 0x43, 0x03, 0x00, 0x01, 0x52, 0x01, 0xBD, 0x07, 0xC3, 
0x01, 0xA9, 0x01, 0x20, 0x03, 0x00, 0x00, 0x03, 0x90, 0xE2, 0x7C, 0x00, 0x03, 0x00, 0x01, 0x01, 
0x01, 0x09, 0x03, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x37, 0xFE, 0x03, 0x00, 0x01, 0x01, 0x01, 0xAE, 
0x05, 0xE2, 0x00, 0x05, 0xDE, 0x7C, 0x24, 0x43, 0xBB, 0x00, 0x07, 0xE2, 0x01, 0x96, 0x04, 0x00, 
0x00, 0x09, 0x0C, 0x67, 0x98, 0xAD, 0xAD, 0x9F, 0x83, 0x47, 0x03, 0x00, 0x03, 0x00, 0x00, 0x08, 
0x1E, 0xDE, 0xE2, 0xE2, 0x88, 0x2E, 0x39, 0x62, 0x04, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x37, 0xFE, 
0x04, 0x00, 0x01, 0x06, 0x01, 0xCB, 0x11, 0xE2, 0x01, 0x6E, 0x0F, 0x00, 0x01, 0xAE, 0x05, 0xE2, 
0x01, 0xD8, 0x01, 0x06, 0x03, 0x00, 0x17, 0xFE, 0x00, 0x00, 0x38, 0xFE, 0x04, 0x00, 0x01, 0x1E, 
0x01, 0xD5, 0x11, 0xE2, 0x01, 0x6E, 0x0C, 0x00, 0x01, 0x0B, 0x01, 0xA2, 0x06, 0xE2, 0x01, 0x6E, 
0x04, 0x00, 0x17, 0xFE, 0x00, 0x00, 0x39, 0xFE, 0x04, 0x00, 0x01, 0x1E, 0x01, 0xD5, 0x11, 0xE2, 
0x00, 0x03, 0xBB, 0x54, 0x01, 0x00, 0x07, 0x00, 0x00, 0x03, 0x0B, 0x6E, 0xD5, 0x00, 0x06, 0xE2, 
0x01, 0xAE, 0x01, 0x01, 0x03, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x3A, 0xFE, 0x04, 0x00, 0x01, 0x1E, 
0x01, 0xD5, 0x12, 0xE2, 0x00, 0x08, 0xD5, 0xA2, 0x88, 0x62, 0x62, 0x7C, 0x88, 0xBB, 0x08, 0xE2, 
0x01, 0xBB, 0x01, 0x06, 0x04, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x3B, 0xFE, 0x04, 0x00, 0x01, 0x17, 
0x01, 0xCB, 0x20, 0xE2, 0x01, 0xD5, 0x01, 0x17, 0x04, 0x00, 0x19, 0xFE, 0x00, 0x00, 0x3C, 0xFE, 
0x04, 0x00, 0x01, 0x06, 0x01, 0xA2, 0x1E, 0xE2, 0x01, 0xCB, 0x01, 0x1E, 0x04, 0x00, 0x1A, 0xFE, 
0x00, 0x00, 0x3D, 0xFE, 0x05, 0x00, 0x01, 0x6E, 0x1C, 0xE2, 0x01, 0xA2, 0x01, 0x06, 0x04, 0x00, 
0x1B, 0xFE, 0x00, 0x00, 0x3E, 0xFE, 0x05, 0x00, 0x01, 0x39, 0x01, 0xCB, 0x18, 0xE2, 0x00, 0x03, 
0xDE, 0x7C, 0x03, 0x00, 0x04, 0x00, 0x1C, 0xFE, 0x00, 0x00, 0x3F, 0xFE, 0x05, 0x00, 0x00, 0x03, 
0x01, 0x6E, 0xD8, 0x00, 0x14, 0xE2, 0x00, 0x03, 0xD8, 0x7C, 0x0B, 0x00, 0x05, 0x00, 0x1D, 0xFE, 
0x00, 0x00, 0x40, 0xFE, 0x06, 0x00, 0x00, 0x03, 0x0B, 0x88, 0xD5, 0x00, 0x10, 0xE2, 0x00, 0x03, 
0xD5, 0x6E, 0x06, 0x00, 0x06, 0x00, 0x1E, 0xFE, 0x00, 0x00, 0x42, 0xFE, 0x06, 0x00, 0x00, 0x04, 
0x01, 0x4F, 0xA2, 0xDE, 0x0A, 0xE2, 0x00, 0x04, 0xCB, 0x88, 0x4F, 0x01, 0x07, 0x00, 0x1F, 0xFE, 
0x00, 0x00, 0x43, 0xFE, 0x08, 0x00, 0x00, 0x0B, 0x06, 0x2E, 0x54, 0x7C, 0x96, 0x96, 0x90, 0x88, 
0x7C, 0x62, 0x0B, 0x00, 0x09, 0x00, 0x21, 0xFE, 0x00, 0x00, 0x45, 0xFE, 0x18, 0x00, 0x23, 0xFE, 
0x00, 0x00, 0x48, 0xFE, 0x13, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x4A, 0xFE, 0x0D, 0x00, 0x29, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x01, 
};

constexpr unsigned char parrot02[] = {
0x42, 0x4D, 0x22, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x04, 0x00, 0x00, 0x28, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x01, 0x00, 
0x00, 0x00, 0xF0, 0x09, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0xFF, 0x00, 
0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x08, 0x04, 
0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x0B, 0x05, 0x08, 0x00, 0x06, 0x0A, 0x07, 0x00, 0x06, 0x08, 
0x0E, 0x00, 0x0E, 0x0B, 0x04, 0x00, 0x0F, 0x07, 0x12, 0x00, 0x0B, 0x0C, 0x12, 0x00, 0x16, 0x0B, 
0x12, 0x00, 0x0C, 0x0B, 0x17, 0x00, 0x0C, 0x10, 0x0D, 0x00, 0x13, 0x11, 0x08, 0x00, 0x12, 0x0C, 
0x1C, 0x00, 0x19, 0x0C, 0x1B, 0x00, 0x18, 0x10, 0x10, 0x00, 0x0A, 0x0D, 0x21, 0x00, 0x08, 0x13, 
0x10, 0x00, 0x1E, 0x0E, 0x1A, 0x00, 0x0A, 0x12, 0x18, 0x00, 0x1B, 0x15, 0x0E, 0x00, 0x1C, 0x10, 
0x1F, 0x00, 0x14, 0x11, 0x1F, 0x00, 0x12, 0x15, 0x13, 0x00, 0x23, 0x10, 0x24, 0x00, 0x1B, 0x10, 
0x28, 0x00, 0x0E, 0x15, 0x1C, 0x00, 0x0E, 0x1A, 0x0D, 0x00, 0x19, 0x19, 0x0D, 0x00, 0x11, 0x13, 
0x25, 0x00, 0x23, 0x13, 0x1F, 0x00, 0x12, 0x1A, 0x15, 0x00, 0x12, 0x13, 0x2E, 0x00, 0x25, 0x1A, 
0x16, 0x00, 0x2E, 0x14, 0x30, 0x00, 0x17, 0x18, 0x2C, 0x00, 0x20, 0x20, 0x0F, 0x00, 0x2D, 0x19, 
0x23, 0x00, 0x13, 0x1C, 0x23, 0x00, 0x13, 0x21, 0x13, 0x00, 0x17, 0x1F, 0x1A, 0x00, 0x24, 0x16, 
0x34, 0x00, 0x32, 0x14, 0x37, 0x00, 0x17, 0x17, 0x38, 0x00, 0x2E, 0x19, 0x2B, 0x00, 0x1C, 0x1D, 
0x32, 0x00, 0x15, 0x21, 0x29, 0x00, 0x32, 0x23, 0x1B, 0x00, 0x26, 0x26, 0x15, 0x00, 0x1D, 0x25, 
0x20, 0x00, 0x16, 0x29, 0x15, 0x00, 0x3B, 0x1A, 0x3B, 0x00, 0x1D, 0x1B, 0x43, 0x00, 0x2F, 0x1B, 
0x40, 0x00, 0x36, 0x1E, 0x34, 0x00, 0x3D, 0x20, 0x33, 0x00, 0x23, 0x21, 0x3D, 0x00, 0x3B, 0x20, 
0x3D, 0x00, 0x3A, 0x29, 0x22, 0x00, 0x44, 0x1D, 0x47, 0x00, 0x1F, 0x1F, 0x4D, 0x00, 0x2C, 0x2D, 
0x1A, 0x00, 0x1A, 0x28, 0x31, 0x00, 0x22, 0x2B, 0x27, 0x00, 0x37, 0x1F, 0x4D, 0x00, 0x3F, 0x23, 
0x41, 0x00, 0x26, 0x27, 0x48, 0x00, 0x47, 0x27, 0x3E, 0x00, 0x4E, 0x22, 0x4E, 0x00, 0x1F, 0x2F, 
0x39, 0x00, 0x25, 0x32, 0x2D, 0x00, 0x25, 0x26, 0x56, 0x00, 0x3F, 0x24, 0x59, 0x00, 0x1F, 0x39, 
0x1E, 0x00, 0x35, 0x37, 0x1E, 0x00, 0x47, 0x33, 0x27, 0x00, 0x53, 0x24, 0x58, 0x00, 0x4F, 0x2B, 
0x42, 0x00, 0x2B, 0x2C, 0x50, 0x00, 0x28, 0x28, 0x5F, 0x00, 0x4D, 0x2A, 0x4D, 0x00, 0x2A, 0x38, 
0x30, 0x00, 0x55, 0x30, 0x49, 0x00, 0x30, 0x2F, 0x59, 0x00, 0x60, 0x29, 0x62, 0x00, 0x2B, 0x2C, 
0x6B, 0x00, 0x49, 0x2B, 0x68, 0x00, 0x55, 0x2F, 0x59, 0x00, 0x26, 0x3A, 0x45, 0x00, 0x31, 0x3F, 
0x36, 0x00, 0x58, 0x3E, 0x2E, 0x00, 0x65, 0x2B, 0x6B, 0x00, 0x26, 0x46, 0x26, 0x00, 0x2F, 0x30, 
0x6F, 0x00, 0x5C, 0x32, 0x59, 0x00, 0x47, 0x46, 0x24, 0x00, 0x62, 0x36, 0x52, 0x00, 0x37, 0x36, 
0x61, 0x00, 0x51, 0x31, 0x75, 0x00, 0x32, 0x33, 0x7A, 0x00, 0x2A, 0x41, 0x4E, 0x00, 0x5E, 0x44, 
0x34, 0x00, 0x38, 0x47, 0x3D, 0x00, 0x65, 0x38, 0x66, 0x00, 0x75, 0x32, 0x79, 0x00, 0x2D, 0x52, 
0x2D, 0x00, 0x58, 0x35, 0x81, 0x00, 0x37, 0x37, 0x86, 0x00, 0x69, 0x4A, 0x37, 0x00, 0x3C, 0x3E, 
0x71, 0x00, 0x72, 0x3E, 0x61, 0x00, 0x53, 0x52, 0x2C, 0x00, 0x39, 0x4D, 0x46, 0x00, 0x30, 0x49, 
0x57, 0x00, 0x62, 0x37, 0x86, 0x00, 0x32, 0x58, 0x2B, 0x00, 0x72, 0x3D, 0x71, 0x00, 0x58, 0x56, 
0x30, 0x00, 0x2F, 0x5B, 0x31, 0x00, 0x3E, 0x3D, 0x93, 0x00, 0x86, 0x3A, 0x88, 0x00, 0x73, 0x52, 
0x3E, 0x00, 0x3F, 0x54, 0x4B, 0x00, 0x45, 0x45, 0x7E, 0x00, 0x69, 0x3D, 0x90, 0x00, 0x85, 0x48, 
0x6F, 0x00, 0x81, 0x45, 0x81, 0x00, 0x41, 0x43, 0xA1, 0x00, 0x37, 0x56, 0x66, 0x00, 0x7F, 0x5A, 
0x41, 0x00, 0x46, 0x5C, 0x4F, 0x00, 0x93, 0x3F, 0x98, 0x00, 0x38, 0x66, 0x36, 0x00, 0x63, 0x63, 
0x34, 0x00, 0x73, 0x43, 0xA0, 0x00, 0x4F, 0x4D, 0x8E, 0x00, 0x9C, 0x42, 0xA1, 0x00, 0x3D, 0x5D, 
0x6D, 0x00, 0x4C, 0x63, 0x55, 0x00, 0x95, 0x51, 0x7C, 0x00, 0x89, 0x62, 0x4A, 0x00, 0x9F, 0x45, 
0xA5, 0x00, 0x4B, 0x4B, 0xB3, 0x00, 0x50, 0x53, 0x97, 0x00, 0x51, 0x68, 0x5A, 0x00, 0x7E, 0x4A, 
0xB1, 0x00, 0x93, 0x51, 0x94, 0x00, 0x40, 0x75, 0x40, 0x00, 0xAB, 0x49, 0xB0, 0x00, 0x56, 0x57, 
0xA1, 0x00, 0x71, 0x72, 0x3F, 0x00, 0x50, 0x6C, 0x60, 0x00, 0x42, 0x67, 0x79, 0x00, 0x98, 0x6A, 
0x53, 0x00, 0x50, 0x50, 0xC3, 0x00, 0xA5, 0x5A, 0x8A, 0x00, 0xA0, 0x57, 0x9C, 0x00, 0x87, 0x4F, 
0xC1, 0x00, 0x56, 0x72, 0x66, 0x00, 0xB8, 0x4F, 0xBF, 0x00, 0x44, 0x80, 0x45, 0x00, 0x60, 0x60, 
0xAF, 0x00, 0xA8, 0x5C, 0xA9, 0x00, 0x7D, 0x7E, 0x46, 0x00, 0x59, 0x58, 0xD5, 0x00, 0x8F, 0x55, 
0xCD, 0x00, 0xA5, 0x75, 0x5D, 0x00, 0xB5, 0x63, 0x98, 0x00, 0x5D, 0x7A, 0x6D, 0x00, 0xC6, 0x54, 
0xCB, 0x00, 0x4C, 0x76, 0x8A, 0x00, 0x4B, 0x89, 0x4B, 0x00, 0x61, 0x7F, 0x6C, 0x00, 0x69, 0x68, 
0xBC, 0x00, 0x5E, 0x5F, 0xE4, 0x00, 0x9B, 0x5B, 0xDD, 0x00, 0xCD, 0x59, 0xD5, 0x00, 0xB9, 0x64, 
0xB8, 0x00, 0xB2, 0x7E, 0x63, 0x00, 0x88, 0x8B, 0x4D, 0x00, 0x66, 0x84, 0x71, 0x00, 0xD8, 0x5B, 
0xDD, 0x00, 0xC7, 0x6D, 0xA7, 0x00, 0x64, 0x62, 0xEE, 0x00, 0x9F, 0x60, 0xE5, 0x00, 0x51, 0x96, 
0x51, 0x00, 0x6E, 0x6F, 0xCC, 0x00, 0x54, 0x81, 0x9B, 0x00, 0x6B, 0x8A, 0x76, 0x00, 0xA9, 0x62, 
0xEB, 0x00, 0x68, 0x66, 0xF4, 0x00, 0xDD, 0x60, 0xE2, 0x00, 0xC3, 0x6B, 0xC6, 0x00, 0xC1, 0x88, 
0x69, 0x00, 0x68, 0x8C, 0x7B, 0x00, 0x96, 0x96, 0x51, 0x00, 0x68, 0x69, 0xFF, 0x00, 0xE4, 0x62, 
0xED, 0x00, 0xD6, 0x75, 0xB3, 0x00, 0xD0, 0x6F, 0xCF, 0x00, 0xB1, 0x66, 0xF8, 0x00, 0x5A, 0xA1, 
0x55, 0x00, 0x77, 0x77, 0xDB, 0x00, 0xCA, 0x8F, 0x6F, 0x00, 0xA1, 0x9F, 0x56, 0x00, 0xB7, 0x6C, 
0xFE, 0x00, 0x5D, 0x8E, 0xAB, 0x00, 0xD7, 0x76, 0xD6, 0x00, 0xF3, 0x69, 0xFA, 0x00, 0xF7, 0x68, 
0xFF, 0x00, 0x5A, 0xA9, 0x5D, 0x00, 0xD7, 0x98, 0x74, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0xEB, 0x80, 
0xC5, 0x00, 0xE0, 0x7B, 0xE3, 0x00, 0x85, 0x82, 0xF1, 0x00, 0xAD, 0xAC, 0x5A, 0x00, 0x64, 0x99, 
0xB8, 0x00, 0xE1, 0xA0, 0x7A, 0x00, 0x63, 0xB5, 0x62, 0x00, 0xF8, 0x87, 0xCF, 0x00, 0x85, 0x88, 
0xF9, 0x00, 0xF1, 0x83, 0xF1, 0x00, 0xE8, 0xA6, 0x81, 0x00, 0xFF, 0x8C, 0xD7, 0x00, 0x8B, 0x8D, 
0xFF, 0x00, 0xF3, 0xAB, 0x80, 0x00, 0xF8, 0x88, 0xFA, 0x00, 0x68, 0xC2, 0x68, 0x00, 0xBE, 0xBE, 
0x67, 0x00, 0x6D, 0xA9, 0xCB, 0x00, 0xF9, 0xB0, 0x86, 0x00, 0xFF, 0x8C, 0xFF, 0x00, 0x70, 0xCB, 
0x6E, 0x00, 0xFE, 0xB5, 0x8B, 0x00, 0xC6, 0xC6, 0x6A, 0x00, 0x71, 0xD3, 0x73, 0x00, 0x78, 0xB7, 
0xDA, 0x00, 0xCE, 0xCF, 0x72, 0x00, 0x78, 0xDB, 0x78, 0x00, 0x7C, 0xE5, 0x7C, 0x00, 0x7F, 0xC4, 
0xEA, 0x00, 0xDB, 0xDD, 0x78, 0x00, 0x81, 0xED, 0x81, 0x00, 0xE3, 0xE5, 0x7E, 0x00, 0x88, 0xCF, 
0xF5, 0x00, 0x87, 0xF5, 0x84, 0x00, 0xEC, 0xEF, 0x87, 0x00, 0x89, 0xD6, 0xFE, 0x00, 0x87, 0xFA, 
0x8C, 0x00, 0xF1, 0xF3, 0x8C, 0x00, 0x89, 0xFF, 0x88, 0x00, 0xFB, 0xF9, 0x80, 0x00, 0xFF, 0xFF, 
0x87, 0x00, 0x0A, 0xFE, 0x66, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x66, 0x00, 0x10, 0xFE, 
0x00, 0x00, 0x0A, 0xFE, 0x66, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 0x01, 0x2F, 
0x5E, 0x72, 0x01, 0x59, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 0x01, 0x81, 
0x5E, 0xF9, 0x01, 0xDA, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 0x01, 0x65, 
0x5E, 0xF9, 0x01, 0xDA, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 0x01, 0x27, 
0x5E, 0xF9, 0x01, 0xCF, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x04, 0x00, 0x01, 0xEE, 
0x5D, 0xF9, 0x01, 0xAB, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x03, 0x00, 0x01, 0x99, 
0x5D, 0xF9, 0x01, 0x81, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x03, 0x00, 0x01, 0x3F, 
0x5D, 0xF9, 0x01, 0x59, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x04, 0x00, 0x01, 0xE7, 
0x5C, 0xF9, 0x01, 0x1B, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 0x03, 0x00, 0x01, 0x46, 
0x5B, 0xF9, 0x01, 0xEE, 0x04, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 0x04, 0x00, 0x01, 0xCF, 
0x5A, 0xF9, 0x01, 0x99, 0x03, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 0x03, 0x00, 0x01, 0x27, 
0x01, 0xF6, 0x59, 0xF9, 0x01, 0x3F, 0x03, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 0x04, 0x00, 
0x01, 0x81, 0x58, 0xF9, 0x01, 0xEE, 0x04, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x0E, 0xFE, 0x04, 0x00, 
0x01, 0xBC, 0x57, 0xF9, 0x01, 0xAB, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x0F, 0xFE, 0x03, 0x00, 
0x01, 0x05, 0x01, 0xE7, 0x56, 0xF9, 0x01, 0x59, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x0F, 0xFE, 
0x04, 0x00, 0x01, 0x09, 0x01, 0xE7, 0x54, 0xF9, 0x01, 0xF2, 0x01, 0x03, 0x03, 0x00, 0x12, 0xFE, 
0x00, 0x00, 0x10, 0xFE, 0x04, 0x00, 0x01, 0x05, 0x01, 0xDA, 0x20, 0xF9, 0x00, 0x03, 0xEE, 0xCF, 
0xE7, 0x00, 0x30, 0xF9, 0x01, 0x99, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x11, 0xFE, 0x04, 0x00, 
0x01, 0x03, 0x01, 0xDA, 0x1B, 0xF9, 0x00, 0x04, 0xE7, 0x8A, 0x46, 0x05, 0x03, 0x00, 0x01, 0xAB, 
0x2E, 0xF9, 0x01, 0xF2, 0x01, 0x0C, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x04, 0x00, 
0x01, 0x03, 0x01, 0xCF, 0x17, 0xF9, 0x00, 0x03, 0xF2, 0xAB, 0x2F, 0x00, 0x07, 0x00, 0x01, 0x59, 
0x2E, 0xF9, 0x01, 0x99, 0x04, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x13, 0xFE, 0x04, 0x00, 0x01, 0x03, 
0x01, 0xBC, 0x14, 0xF9, 0x00, 0x03, 0xF6, 0x99, 0x05, 0x00, 0x08, 0x00, 0x01, 0x03, 0x01, 0xDA, 
0x2D, 0xF9, 0x01, 0xF2, 0x01, 0x05, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x14, 0xFE, 0x05, 0x00, 
0x01, 0x81, 0x01, 0xF6, 0x11, 0xF9, 0x01, 0xDA, 0x01, 0x27, 0x06, 0x00, 0x00, 0x05, 0x09, 0x59, 
0x8A, 0xCF, 0xF2, 0x00, 0x2E, 0xF9, 0x01, 0x81, 0x04, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x15, 0xFE, 
0x05, 0x00, 0x01, 0x46, 0x01, 0xF2, 0x0F, 0xF9, 0x01, 0x8A, 0x05, 0x00, 0x00, 0x03, 0x03, 0x72, 
0xDA, 0x00, 0x32, 0xF9, 0x01, 0xEE, 0x01, 0x03, 0x03, 0x00, 0x15, 0xFE, 0x00, 0x00, 0x16, 0xFE, 
0x05, 0x00, 0x01, 0x14, 0x01, 0xE7, 0x0C, 0xF9, 0x01, 0xF6, 0x01, 0x65, 0x04, 0x00, 0x00, 0x03, 
0x03, 0x8A, 0xF2, 0x00, 0x34, 0xF9, 0x01, 0x59, 0x03, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x18, 0xFE, 
0x04, 0x00, 0x01, 0x03, 0x01, 0xDA, 0x0A, 0xF9, 0x01, 0xF2, 0x01, 0x3F, 0x04, 0x00, 0x01, 0x46, 
0x01, 0xE7, 0x35, 0xF9, 0x01, 0xBC, 0x04, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x19, 0xFE, 0x04, 0x00, 
0x01, 0x05, 0x01, 0xE7, 0x08, 0xF9, 0x01, 0xF6, 0x01, 0x3F, 0x04, 0x00, 0x01, 0x99, 0x36, 0xF9, 
0x01, 0xEE, 0x01, 0x05, 0x03, 0x00, 0x17, 0xFE, 0x00, 0x00, 0x1A, 0xFE, 0x04, 0x00, 0x01, 0x14, 
0x01, 0xEE, 0x07, 0xF9, 0x01, 0x72, 0x03, 0x00, 0x01, 0x03, 0x01, 0xBC, 0x37, 0xF9, 0x01, 0x59, 
0x04, 0x00, 0x17, 0xFE, 0x00, 0x00, 0x1B, 0xFE, 0x04, 0x00, 0x01, 0x27, 0x01, 0xF2, 0x05, 0xF9, 
0x01, 0xAB, 0x03, 0x00, 0x01, 0x03, 0x01, 0xDA, 0x37, 0xF9, 0x01, 0xAB, 0x04, 0x00, 0x18, 0xFE, 
0x00, 0x00, 0x1C, 0xFE, 0x04, 0x00, 0x01, 0x46, 0x01, 0xF6, 0x03, 0xF9, 0x01, 0xDA, 0x01, 0x03, 
0x03, 0x00, 0x01, 0xAB, 0x37, 0xF9, 0x01, 0xF6, 0x01, 0x12, 0x03, 0x00, 0x19, 0xFE, 0x00, 0x00, 
0x1D, 0xFE, 0x04, 0x00, 0x00, 0x05, 0x65, 0xF9, 0xF9, 0xEE, 0x09, 0x00, 0x03, 0x00, 0x01, 0x72, 
0x38, 0xF9, 0x01, 0xAB, 0x04, 0x00, 0x19, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x04, 0x00, 0x00, 0x03, 
0x99, 0xF6, 0x2F, 0x00, 0x03, 0x00, 0x01, 0x3F, 0x01, 0xF6, 0x37, 0xF9, 0x01, 0xF6, 0x01, 0x12, 
0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x03, 0x00, 0x01, 0x0C, 0x01, 0x99, 0x03, 0x00, 
0x01, 0x1B, 0x01, 0xF2, 0x38, 0xF9, 0x01, 0xBC, 0x04, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 
0x04, 0x00, 0x00, 0x05, 0x03, 0x00, 0x00, 0x03, 0xE7, 0x00, 0x39, 0xF9, 0x01, 0x8A, 0x03, 0x00, 
0x1B, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x06, 0x00, 0x01, 0x8A, 0x3A, 0xF9, 0x01, 0x65, 0x03, 0x00, 
0x1B, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x05, 0x00, 0x01, 0x1B, 0x01, 0xF6, 0x3A, 0xF9, 0x01, 0x2F, 
0x03, 0x00, 0x1B, 0xFE, 0x00, 0x00, 0x21, 0xFE, 0x04, 0x00, 0x01, 0xCF, 0x21, 0xF9, 0x01, 0xE7, 
0x19, 0xF9, 0x01, 0x27, 0x03, 0x00, 0x1B, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x04, 0x00, 0x01, 0x46, 
0x21, 0xF9, 0x00, 0x03, 0xE7, 0x05, 0xF2, 0x00, 0x18, 0xF9, 0x01, 0x59, 0x03, 0x00, 0x1B, 0xFE, 
0x00, 0x00, 0x20, 0xFE, 0x03, 0x00, 0x01, 0x01, 0x01, 0xEE, 0x20, 0xF9, 0x00, 0x04, 0xF6, 0x27, 
0x00, 0xAB, 0x18, 0xF9, 0x01, 0x81, 0x03, 0x00, 0x1B, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x03, 0x00, 
0x01, 0x72, 0x21, 0xF9, 0x00, 0x04, 0x81, 0x00, 0x00, 0x1B, 0x18, 0xF9, 0x01, 0xAB, 0x03, 0x00, 
0x1B, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x04, 0x00, 0x01, 0xDA, 0x20, 0xF9, 0x01, 0xDA, 0x04, 0x00, 
0x01, 0xCF, 0x17, 0xF9, 0x01, 0xCF, 0x03, 0x00, 0x1B, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x03, 0x00, 
0x01, 0x14, 0x20, 0xF9, 0x01, 0xF2, 0x01, 0x14, 0x04, 0x00, 0x01, 0x3F, 0x17, 0xF9, 0x01, 0xF2, 
0x04, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x03, 0x00, 0x01, 0x81, 0x20, 0xF9, 0x01, 0x65, 
0x06, 0x00, 0x01, 0xE7, 0x17, 0xF9, 0x01, 0x27, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 
0x04, 0x00, 0x01, 0xDA, 0x1F, 0xF9, 0x01, 0xBC, 0x03, 0x00, 0x01, 0x03, 0x03, 0x00, 0x01, 0x72, 
0x17, 0xF9, 0x01, 0x72, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 0x01, 0x05, 
0x1F, 0xF9, 0x01, 0xEE, 0x01, 0x05, 0x03, 0x00, 0x00, 0x06, 0x7B, 0x18, 0x00, 0x00, 0x03, 0xEE, 
0x16, 0xF9, 0x01, 0xBC, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 0x01, 0x27, 
0x1F, 0xF9, 0x01, 0x46, 0x03, 0x00, 0x00, 0x03, 0x40, 0xC3, 0x71, 0x00, 0x03, 0x00, 0x01, 0x8A, 
0x16, 0xF9, 0x01, 0xE7, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 0x01, 0x46, 
0x1E, 0xF9, 0x01, 0xAB, 0x03, 0x00, 0x00, 0x09, 0x0C, 0xB5, 0xC3, 0xB5, 0x03, 0x00, 0x00, 0x0C, 
0xF6, 0x00, 0x15, 0xF9, 0x01, 0xEE, 0x04, 0x00, 0x19, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 
0x01, 0x72, 0x1D, 0xF9, 0x01, 0xF2, 0x01, 0x05, 0x03, 0x00, 0x01, 0x8B, 0x03, 0xC3, 0x01, 0x5A, 
0x03, 0x00, 0x01, 0xAB, 0x15, 0xF9, 0x01, 0xF2, 0x04, 0x00, 0x19, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 
0x03, 0x00, 0x01, 0x8A, 0x1D, 0xF9, 0x01, 0x99, 0x03, 0x00, 0x01, 0x47, 0x04, 0xC3, 0x00, 0x05, 
0xA9, 0x03, 0x00, 0x00, 0x27, 0x00, 0x16, 0xF9, 0x01, 0x03, 0x03, 0x00, 0x19, 0xFE, 0x00, 0x00, 
0x1E, 0xFE, 0x03, 0x00, 0x01, 0x99, 0x1C, 0xF9, 0x00, 0x06, 0xF6, 0x12, 0x00, 0x00, 0x03, 0xAD, 
0x05, 0xC3, 0x01, 0x47, 0x03, 0x00, 0x01, 0xDA, 0x15, 0xF9, 0x01, 0x03, 0x03, 0x00, 0x19, 0xFE, 
0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 0x01, 0x99, 0x1C, 0xF9, 0x01, 0xBC, 0x03, 0x00, 0x01, 0x52, 
0x06, 0xC3, 0x01, 0x98, 0x03, 0x00, 0x01, 0x8A, 0x14, 0xF9, 0x01, 0xE7, 0x04, 0x00, 0x19, 0xFE, 
0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 0x01, 0x72, 0x1C, 0xF9, 0x00, 0x05, 0x46, 0x00, 0x00, 0x03, 
0xA9, 0x00, 0x07, 0xC3, 0x00, 0x04, 0x05, 0x00, 0x00, 0x3F, 0x14, 0xF9, 0x01, 0xBC, 0x03, 0x00, 
0x1A, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 0x01, 0x59, 0x1B, 0xF9, 0x00, 0x05, 0xF2, 0x03, 
0x00, 0x00, 0x32, 0x00, 0x08, 0xC3, 0x00, 0x05, 0x47, 0x00, 0x00, 0x03, 0xF2, 0x00, 0x13, 0xF9, 
0x01, 0x81, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 0x01, 0x3F, 0x1B, 0xF9, 
0x01, 0xBC, 0x03, 0x00, 0x01, 0x71, 0x08, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0xDA, 0x12, 0xF9, 
0x01, 0xF6, 0x01, 0x12, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 0x01, 0x14, 
0x1B, 0xF9, 0x00, 0x05, 0x59, 0x00, 0x00, 0x03, 0xAD, 0x00, 0x08, 0xC3, 0x01, 0x9F, 0x03, 0x00, 
0x01, 0x8A, 0x12, 0xF9, 0x01, 0xCF, 0x04, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 
0x01, 0x03, 0x01, 0xF2, 0x1A, 0xF9, 0x00, 0x04, 0x12, 0x00, 0x00, 0x29, 0x0A, 0xC3, 0x00, 0x04, 
0x05, 0x00, 0x00, 0x3F, 0x12, 0xF9, 0x01, 0x3F, 0x03, 0x00, 0x1B, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 
0x03, 0x00, 0x01, 0xDA, 0x19, 0xF9, 0x01, 0xF2, 0x03, 0x00, 0x01, 0x47, 0x0A, 0xC3, 0x00, 0x05, 
0x40, 0x00, 0x00, 0x03, 0xF2, 0x00, 0x10, 0xF9, 0x01, 0xCF, 0x04, 0x00, 0x1B, 0xFE, 0x00, 0x00, 
0x1F, 0xFE, 0x03, 0x00, 0x01, 0x99, 0x19, 0xF9, 0x01, 0xE7, 0x03, 0x00, 0x01, 0x67, 0x0A, 0xC3, 
0x01, 0x71, 0x03, 0x00, 0x01, 0xDA, 0x0F, 0xF9, 0x01, 0xF6, 0x01, 0x27, 0x03, 0x00, 0x1C, 0xFE, 
0x00, 0x00, 0x1F, 0xFE, 0x03, 0x00, 0x01, 0x59, 0x19, 0xF9, 0x01, 0xCF, 0x03, 0x00, 0x01, 0x7B, 
0x0A, 0xC3, 0x01, 0x98, 0x03, 0x00, 0x01, 0x99, 0x0F, 0xF9, 0x01, 0x99, 0x04, 0x00, 0x1C, 0xFE, 
0x00, 0x00, 0x1F, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x01, 0xF6, 0x18, 0xF9, 0x01, 0xAB, 0x03, 0x00, 
0x01, 0x98, 0x0B, 0xC3, 0x00, 0x04, 0x03, 0x00, 0x00, 0x59, 0x0E, 0xF9, 0x01, 0xE7, 0x01, 0x03, 
0x03, 0x00, 0x1D, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x04, 0x00, 0x01, 0xE7, 0x18, 0xF9, 0x01, 0x81, 
0x03, 0x00, 0x01, 0xAD, 0x0B, 0xC3, 0x00, 0x04, 0x0C, 0x00, 0x00, 0x3F, 0x0D, 0xF9, 0x01, 0xF6, 
0x01, 0x2F, 0x04, 0x00, 0x1D, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x03, 0x00, 0x01, 0x8A, 0x18, 0xF9, 
0x00, 0x04, 0x59, 0x00, 0x00, 0x03, 0x0C, 0xC3, 0x00, 0x04, 0x20, 0x00, 0x00, 0x27, 0x0D, 0xF9, 
0x01, 0x81, 0x04, 0x00, 0x1E, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x03, 0x00, 0x01, 0x1B, 0x18, 0xF9, 
0x00, 0x04, 0x27, 0x00, 0x00, 0x20, 0x0C, 0xC3, 0x00, 0x04, 0x29, 0x00, 0x00, 0x1B, 0x0C, 0xF9, 
0x01, 0xDA, 0x04, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x04, 0x00, 0x01, 0xDA, 0x17, 0xF9, 
0x00, 0x04, 0x05, 0x00, 0x00, 0x40, 0x0C, 0xC3, 0x00, 0x04, 0x40, 0x00, 0x00, 0x05, 0x0B, 0xF9, 
0x01, 0xF2, 0x01, 0x12, 0x03, 0x00, 0x20, 0xFE, 0x00, 0x00, 0x21, 0xFE, 0x03, 0x00, 0x01, 0x72, 
0x17, 0xF9, 0x00, 0x04, 0x12, 0x00, 0x00, 0x32, 0x0C, 0xC3, 0x01, 0x47, 0x03, 0x00, 0x0B, 0xF9, 
0x01, 0x59, 0x04, 0x00, 0x20, 0xFE, 0x00, 0x00, 0x21, 0xFE, 0x03, 0x00, 0x01, 0x05, 0x01, 0xF6, 
0x16, 0xF9, 0x00, 0x04, 0x27, 0x00, 0x00, 0x29, 0x0C, 0xC3, 0x01, 0x52, 0x03, 0x00, 0x01, 0xF2, 
0x09, 0xF9, 0x01, 0xBC, 0x04, 0x00, 0x21, 0xFE, 0x00, 0x00, 0x21, 0xFE, 0x04, 0x00, 0x01, 0xBC, 
0x0D, 0xF9, 0x01, 0xEE, 0x08, 0xF9, 0x00, 0x04, 0x2F, 0x00, 0x00, 0x20, 0x0C, 0xC3, 0x01, 0x5A, 
0x03, 0x00, 0x00, 0x04, 0xEE, 0xF9, 0xF9, 0xEE, 0x05, 0xF9, 0x01, 0xF2, 0x01, 0x0C, 0x03, 0x00, 
0x22, 0xFE, 0x00, 0x00, 0x22, 0xFE, 0x03, 0x00, 0x01, 0x2F, 0x0B, 0xF9, 0x00, 0x05, 0xCF, 0x0C, 
0x00, 0x1B, 0xE7, 0x00, 0x06, 0xF9, 0x00, 0x04, 0x3F, 0x00, 0x00, 0x18, 0x0C, 0xC3, 0x01, 0x67, 
0x03, 0x00, 0x00, 0x06, 0xE7, 0xE7, 0x27, 0x00, 0x0C, 0xCF, 0x03, 0xF9, 0x01, 0x72, 0x04, 0x00, 
0x22, 0xFE, 0x00, 0x00, 0x22, 0xFE, 0x04, 0x00, 0x01, 0xCF, 0x09, 0xF9, 0x01, 0xEE, 0x01, 0x03, 
0x03, 0x00, 0x01, 0x05, 0x01, 0xF2, 0x05, 0xF9, 0x00, 0x04, 0x46, 0x00, 0x00, 0x0C, 0x0C, 0xC3, 
0x01, 0x47, 0x03, 0x00, 0x01, 0xEE, 0x01, 0x09, 0x03, 0x00, 0x00, 0x04, 0x03, 0xE7, 0xF9, 0xEE, 
0x04, 0x00, 0x23, 0xFE, 0x00, 0x00, 0x23, 0xFE, 0x03, 0x00, 0x01, 0x3F, 0x09, 0xF9, 0x01, 0x72, 
0x05, 0x00, 0x01, 0x99, 0x05, 0xF9, 0x00, 0x04, 0x59, 0x00, 0x00, 0x05, 0x0C, 0xC3, 0x00, 0x05, 
0x29, 0x00, 0x00, 0x12, 0x99, 0x00, 0x05, 0x00, 0x00, 0x03, 0x72, 0xF9, 0xAB, 0x00, 0x03, 0x00, 
0x24, 0xFE, 0x00, 0x00, 0x23, 0xFE, 0x04, 0x00, 0x01, 0xDA, 0x08, 0xF9, 0x01, 0x27, 0x05, 0x00, 
0x01, 0x59, 0x05, 0xF9, 0x00, 0x04, 0x65, 0x00, 0x00, 0x03, 0x0C, 0xC3, 0x00, 0x05, 0x05, 0x00, 
0x00, 0x46, 0x65, 0x00, 0x05, 0x00, 0x00, 0x03, 0x1B, 0xF9, 0x3F, 0x00, 0x03, 0x00, 0x24, 0xFE, 
0x00, 0x00, 0x24, 0xFE, 0x03, 0x00, 0x01, 0x46, 0x08, 0xF9, 0x01, 0x05, 0x05, 0x00, 0x01, 0x2F, 
0x05, 0xF9, 0x00, 0x05, 0x72, 0x00, 0x00, 0x03, 0xBD, 0x00, 0x0A, 0xC3, 0x01, 0xB5, 0x03, 0x00, 
0x01, 0x81, 0x01, 0x46, 0x05, 0x00, 0x01, 0x03, 0x01, 0xEE, 0x04, 0x00, 0x24, 0xFE, 0x00, 0x00, 
0x24, 0xFE, 0x04, 0x00, 0x01, 0xBC, 0x07, 0xF9, 0x01, 0x3F, 0x05, 0x00, 0x01, 0x65, 0x05, 0xF9, 
0x01, 0x81, 0x03, 0x00, 0x01, 0xAD, 0x0A, 0xC3, 0x01, 0x98, 0x03, 0x00, 0x01, 0xAB, 0x01, 0x72, 
0x05, 0x00, 0x01, 0x27, 0x01, 0xBC, 0x03, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x25, 0xFE, 0x03, 0x00, 
0x01, 0x12, 0x01, 0xF2, 0x06, 0xF9, 0x01, 0x99, 0x05, 0x00, 0x01, 0xBC, 0x05, 0xF9, 0x01, 0xBC, 
0x03, 0x00, 0x01, 0x71, 0x0A, 0xC3, 0x01, 0x67, 0x03, 0x00, 0x01, 0xCF, 0x01, 0xBC, 0x05, 0x00, 
0x01, 0x8A, 0x01, 0x72, 0x03, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x25, 0xFE, 0x04, 0x00, 0x01, 0x81, 
0x06, 0xF9, 0x01, 0xF2, 0x01, 0x14, 0x03, 0x00, 0x01, 0x27, 0x01, 0xF6, 0x05, 0xF9, 0x00, 0x06, 
0xF2, 0x03, 0x00, 0x00, 0x03, 0x8B, 0x08, 0xC3, 0x00, 0x08, 0x91, 0x03, 0x00, 0x00, 0x03, 0xEE, 
0xF9, 0x3F, 0x03, 0x00, 0x00, 0x03, 0x09, 0xEE, 0x12, 0x00, 0x03, 0x00, 0x25, 0xFE, 0x00, 0x00, 
0x26, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x01, 0xE7, 0x06, 0xF9, 0x00, 0x05, 0xEE, 0x65, 0x1B, 0x72, 
0xF2, 0x00, 0x07, 0xF9, 0x01, 0x65, 0x03, 0x00, 0x00, 0x09, 0x03, 0x32, 0x83, 0x9F, 0xB5, 0xB5, 
0xA9, 0x83, 0x40, 0x00, 0x04, 0x00, 0x00, 0x09, 0x81, 0xF9, 0xF9, 0xF2, 0x72, 0x1B, 0x59, 0xEE, 
0xE7, 0x00, 0x04, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x27, 0xFE, 0x03, 0x00, 0x01, 0x27, 0x01, 0xF2, 
0x11, 0xF9, 0x01, 0xF2, 0x01, 0x2F, 0x0E, 0x00, 0x01, 0x12, 0x01, 0xF2, 0x07, 0xF9, 0x01, 0x81, 
0x03, 0x00, 0x26, 0xFE, 0x00, 0x00, 0x27, 0xFE, 0x04, 0x00, 0x01, 0x65, 0x12, 0xF9, 0x01, 0xF2, 
0x01, 0x3F, 0x0C, 0x00, 0x01, 0x46, 0x01, 0xEE, 0x07, 0xF9, 0x01, 0xEE, 0x01, 0x03, 0x03, 0x00, 
0x26, 0xFE, 0x00, 0x00, 0x28, 0xFE, 0x04, 0x00, 0x01, 0xAB, 0x12, 0xF9, 0x00, 0x03, 0xF6, 0xBC, 
0x3F, 0x00, 0x08, 0x00, 0x01, 0x2F, 0x01, 0xAB, 0x09, 0xF9, 0x01, 0x65, 0x03, 0x00, 0x27, 0xFE, 
0x00, 0x00, 0x29, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x01, 0xDA, 0x14, 0xF9, 0x00, 0x08, 0xE7, 0xBC, 
0x8A, 0x72, 0x81, 0x99, 0xAB, 0xEE, 0x0A, 0xF9, 0x01, 0xE7, 0x04, 0x00, 0x27, 0xFE, 0x00, 0x00, 
0x29, 0xFE, 0x04, 0x00, 0x01, 0x03, 0x01, 0xCF, 0x24, 0xF9, 0x01, 0xF2, 0x01, 0x27, 0x03, 0x00, 
0x28, 0xFE, 0x00, 0x00, 0x2A, 0xFE, 0x04, 0x00, 0x01, 0x03, 0x01, 0xCF, 0x22, 0xF9, 0x01, 0xF6, 
0x01, 0x46, 0x04, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x2B, 0xFE, 0x04, 0x00, 0x01, 0x03, 0x01, 0xBC, 
0x21, 0xF9, 0x01, 0x72, 0x04, 0x00, 0x29, 0xFE, 0x00, 0x00, 0x2C, 0xFE, 0x05, 0x00, 0x01, 0x8A, 
0x1E, 0xF9, 0x01, 0xF6, 0x01, 0x72, 0x04, 0x00, 0x2A, 0xFE, 0x00, 0x00, 0x2D, 0xFE, 0x05, 0x00, 
0x01, 0x46, 0x01, 0xF2, 0x1B, 0xF9, 0x01, 0xEE, 0x01, 0x3F, 0x04, 0x00, 0x2B, 0xFE, 0x00, 0x00, 
0x2E, 0xFE, 0x05, 0x00, 0x01, 0x14, 0x01, 0xCF, 0x19, 0xF9, 0x01, 0xDA, 0x01, 0x12, 0x05, 0x00, 
0x2B, 0xFE, 0x00, 0x00, 0x30, 0xFE, 0x05, 0x00, 0x01, 0x46, 0x01, 0xE7, 0x15, 0xF9, 0x01, 0xCF, 
0x01, 0x3F, 0x05, 0x00, 0x2D, 0xFE, 0x00, 0x00, 0x31, 0xFE, 0x05, 0x00, 0x00, 0x03, 0x03, 0x81, 
0xE7, 0x00, 0x11, 0xF9, 0x01, 0xCF, 0x01, 0x2F, 0x06, 0x00, 0x2E, 0xFE, 0x00, 0x00, 0x32, 0xFE, 
0x07, 0x00, 0x00, 0x03, 0x3F, 0xAB, 0xF2, 0x00, 0x0A, 0xF9, 0x00, 0x04, 0xF2, 0xCF, 0x81, 0x1B, 
0x07, 0x00, 0x2F, 0xFE, 0x00, 0x00, 0x34, 0xFE, 0x07, 0x00, 0x00, 0x0C, 0x03, 0x2F, 0x65, 0x8A, 
0xBC, 0xCF, 0xBC, 0xAB, 0x99, 0x8A, 0x3F, 0x03, 0x08, 0x00, 0x31, 0xFE, 0x00, 0x00, 0x36, 0xFE, 
0x17, 0x00, 0x33, 0xFE, 0x00, 0x00, 0x38, 0xFE, 0x13, 0x00, 0x35, 0xFE, 0x00, 0x00, 0x3B, 0xFE, 
0x0C, 0x00, 0x39, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x01, 
};

constexpr unsigned char parrot03[] = {
0x42, 0x4D, 0xFA, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x04, 0x00, 0x00, 0x28, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x01, 0x00, 
0x00, 0x00, 0xC8, 0x09, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0xFF, 0x00, 
0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x08, 0x04, 
0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x0B, 0x05, 0x08, 0x00, 0x06, 0x0A, 0x07, 0x00, 0x06, 0x08, 
0x0E, 0x00, 0x0E, 0x0B, 0x04, 0x00, 0x0F, 0x07, 0x12, 0x00, 0x0B, 0x0C, 0x12, 0x00, 0x16, 0x0B, 
0x12, 0x00, 0x0C, 0x0B, 0x17, 0x00, 0x0C, 0x10, 0x0D, 0x00, 0x13, 0x11, 0x08, 0x00, 0x12, 0x0C, 
0x1C, 0x00, 0x19, 0x0C, 0x1B, 0x00, 0x18, 0x10, 0x10, 0x00, 0x0A, 0x0D, 0x21, 0x00, 0x08, 0x13, 
0x10, 0x00, 0x1E, 0x0E, 0x1A, 0x00, 0x0A, 0x12, 0x18, 0x00, 0x1B, 0x15, 0x0E, 0x00, 0x1C, 0x10, 
0x1F, 0x00, 0x14, 0x11, 0x1F, 0x00, 0x12, 0x15, 0x13, 0x00, 0x23, 0x10, 0x24, 0x00, 0x1B, 0x10, 
0x28, 0x00, 0x0E, 0x15, 0x1C, 0x00, 0x0E, 0x1A, 0x0D, 0x00, 0x19, 0x19, 0x0D, 0x00, 0x11, 0x13, 
0x25, 0x00, 0x23, 0x13, 0x1F, 0x00, 0x12, 0x1A, 0x15, 0x00, 0x12, 0x13, 0x2E, 0x00, 0x25, 0x1A, 
0x16, 0x00, 0x2E, 0x14, 0x30, 0x00, 0x17, 0x18, 0x2C, 0x00, 0x20, 0x20, 0x0F, 0x00, 0x2D, 0x19, 
0x23, 0x00, 0x13, 0x1C, 0x23, 0x00, 0x13, 0x21, 0x13, 0x00, 0x17, 0x1F, 0x1A, 0x00, 0x24, 0x16, 
0x34, 0x00, 0x32, 0x14, 0x37, 0x00, 0x17, 0x17, 0x38, 0x00, 0x2E, 0x19, 0x2B, 0x00, 0x1C, 0x1D, 
0x32, 0x00, 0x15, 0x21, 0x29, 0x00, 0x32, 0x23, 0x1B, 0x00, 0x26, 0x26, 0x15, 0x00, 0x1D, 0x25, 
0x20, 0x00, 0x16, 0x29, 0x15, 0x00, 0x3B, 0x1A, 0x3B, 0x00, 0x1D, 0x1B, 0x43, 0x00, 0x2F, 0x1B, 
0x40, 0x00, 0x36, 0x1E, 0x34, 0x00, 0x3D, 0x20, 0x33, 0x00, 0x23, 0x21, 0x3D, 0x00, 0x3B, 0x20, 
0x3D, 0x00, 0x3A, 0x29, 0x22, 0x00, 0x44, 0x1D, 0x47, 0x00, 0x1F, 0x1F, 0x4D, 0x00, 0x2C, 0x2D, 
0x1A, 0x00, 0x1A, 0x28, 0x31, 0x00, 0x22, 0x2B, 0x27, 0x00, 0x37, 0x1F, 0x4D, 0x00, 0x3F, 0x23, 
0x41, 0x00, 0x26, 0x27, 0x48, 0x00, 0x47, 0x27, 0x3E, 0x00, 0x4E, 0x22, 0x4E, 0x00, 0x1F, 0x2F, 
0x39, 0x00, 0x25, 0x32, 0x2D, 0x00, 0x25, 0x26, 0x56, 0x00, 0x3F, 0x24, 0x59, 0x00, 0x1F, 0x39, 
0x1E, 0x00, 0x35, 0x37, 0x1E, 0x00, 0x47, 0x33, 0x27, 0x00, 0x53, 0x24, 0x58, 0x00, 0x4F, 0x2B, 
0x42, 0x00, 0x2B, 0x2C, 0x50, 0x00, 0x28, 0x28, 0x5F, 0x00, 0x4D, 0x2A, 0x4D, 0x00, 0x2A, 0x38, 
0x30, 0x00, 0x55, 0x30, 0x49, 0x00, 0x30, 0x2F, 0x59, 0x00, 0x60, 0x29, 0x62, 0x00, 0x2B, 0x2C, 
0x6B, 0x00, 0x49, 0x2B, 0x68, 0x00, 0x55, 0x2F, 0x59, 0x00, 0x26, 0x3A, 0x45, 0x00, 0x31, 0x3F, 
0x36, 0x00, 0x58, 0x3E, 0x2E, 0x00, 0x65, 0x2B, 0x6B, 0x00, 0x26, 0x46, 0x26, 0x00, 0x2F, 0x30, 
0x6F, 0x00, 0x5C, 0x32, 0x59, 0x00, 0x47, 0x46, 0x24, 0x00, 0x62, 0x36, 0x52, 0x00, 0x37, 0x36, 
0x61, 0x00, 0x51, 0x31, 0x75, 0x00, 0x32, 0x33, 0x7A, 0x00, 0x2A, 0x41, 0x4E, 0x00, 0x5E, 0x44, 
0x34, 0x00, 0x38, 0x47, 0x3D, 0x00, 0x65, 0x38, 0x66, 0x00, 0x75, 0x32, 0x79, 0x00, 0x2D, 0x52, 
0x2D, 0x00, 0x58, 0x35, 0x81, 0x00, 0x37, 0x37, 0x86, 0x00, 0x69, 0x4A, 0x37, 0x00, 0x3C, 0x3E, 
0x71, 0x00, 0x72, 0x3E, 0x61, 0x00, 0x53, 0x52, 0x2C, 0x00, 0x39, 0x4D, 0x46, 0x00, 0x30, 0x49, 
0x57, 0x00, 0x62, 0x37, 0x86, 0x00, 0x32, 0x58, 0x2B, 0x00, 0x72, 0x3D, 0x71, 0x00, 0x58, 0x56, 
0x30, 0x00, 0x2F, 0x5B, 0x31, 0x00, 0x3E, 0x3D, 0x93, 0x00, 0x86, 0x3A, 0x88, 0x00, 0x73, 0x52, 
0x3E, 0x00, 0x3F, 0x54, 0x4B, 0x00, 0x45, 0x45, 0x7E, 0x00, 0x69, 0x3D, 0x90, 0x00, 0x85, 0x48, 
0x6F, 0x00, 0x81, 0x45, 0x81, 0x00, 0x41, 0x43, 0xA1, 0x00, 0x37, 0x56, 0x66, 0x00, 0x7F, 0x5A, 
0x41, 0x00, 0x46, 0x5C, 0x4F, 0x00, 0x93, 0x3F, 0x98, 0x00, 0x38, 0x66, 0x36, 0x00, 0x63, 0x63, 
0x34, 0x00, 0x73, 0x43, 0xA0, 0x00, 0x4F, 0x4D, 0x8E, 0x00, 0x9C, 0x42, 0xA1, 0x00, 0x3D, 0x5D, 
0x6D, 0x00, 0x4C, 0x63, 0x55, 0x00, 0x95, 0x51, 0x7C, 0x00, 0x89, 0x62, 0x4A, 0x00, 0x9F, 0x45, 
0xA5, 0x00, 0x4B, 0x4B, 0xB3, 0x00, 0x50, 0x53, 0x97, 0x00, 0x51, 0x68, 0x5A, 0x00, 0x7E, 0x4A, 
0xB1, 0x00, 0x93, 0x51, 0x94, 0x00, 0x40, 0x75, 0x40, 0x00, 0xAB, 0x49, 0xB0, 0x00, 0x56, 0x57, 
0xA1, 0x00, 0x71, 0x72, 0x3F, 0x00, 0x50, 0x6C, 0x60, 0x00, 0x42, 0x67, 0x79, 0x00, 0x98, 0x6A, 
0x53, 0x00, 0x50, 0x50, 0xC3, 0x00, 0xA5, 0x5A, 0x8A, 0x00, 0xA0, 0x57, 0x9C, 0x00, 0x87, 0x4F, 
0xC1, 0x00, 0x56, 0x72, 0x66, 0x00, 0xB8, 0x4F, 0xBF, 0x00, 0x44, 0x80, 0x45, 0x00, 0x60, 0x60, 
0xAF, 0x00, 0xA8, 0x5C, 0xA9, 0x00, 0x7D, 0x7E, 0x46, 0x00, 0x59, 0x58, 0xD5, 0x00, 0x8F, 0x55, 
0xCD, 0x00, 0xA5, 0x75, 0x5D, 0x00, 0xB5, 0x63, 0x98, 0x00, 0x5D, 0x7A, 0x6D, 0x00, 0xC6, 0x54, 
0xCB, 0x00, 0x4C, 0x76, 0x8A, 0x00, 0x4B, 0x89, 0x4B, 0x00, 0x61, 0x7F, 0x6C, 0x00, 0x69, 0x68, 
0xBC, 0x00, 0x5E, 0x5F, 0xE4, 0x00, 0x9B, 0x5B, 0xDD, 0x00, 0xCD, 0x59, 0xD5, 0x00, 0xB9, 0x64, 
0xB8, 0x00, 0xB2, 0x7E, 0x63, 0x00, 0x88, 0x8B, 0x4D, 0x00, 0x66, 0x84, 0x71, 0x00, 0xD8, 0x5B, 
0xDD, 0x00, 0xC7, 0x6D, 0xA7, 0x00, 0x64, 0x62, 0xEE, 0x00, 0x9F, 0x60, 0xE5, 0x00, 0x51, 0x96, 
0x51, 0x00, 0x6E, 0x6F, 0xCC, 0x00, 0x54, 0x81, 0x9B, 0x00, 0x6B, 0x8A, 0x76, 0x00, 0xA9, 0x62, 
0xEB, 0x00, 0x68, 0x66, 0xF4, 0x00, 0xDD, 0x60, 0xE2, 0x00, 0xC3, 0x6B, 0xC6, 0x00, 0xC1, 0x88, 
0x69, 0x00, 0x68, 0x8C, 0x7B, 0x00, 0x96, 0x96, 0x51, 0x00, 0x68, 0x69, 0xFF, 0x00, 0xE4, 0x62, 
0xED, 0x00, 0xD6, 0x75, 0xB3, 0x00, 0xD0, 0x6F, 0xCF, 0x00, 0xB1, 0x66, 0xF8, 0x00, 0x5A, 0xA1, 
0x55, 0x00, 0x77, 0x77, 0xDB, 0x00, 0xCA, 0x8F, 0x6F, 0x00, 0xA1, 0x9F, 0x56, 0x00, 0xB7, 0x6C, 
0xFE, 0x00, 0x5D, 0x8E, 0xAB, 0x00, 0xD7, 0x76, 0xD6, 0x00, 0xF3, 0x69, 0xFA, 0x00, 0xF7, 0x68, 
0xFF, 0x00, 0x5A, 0xA9, 0x5D, 0x00, 0xD7, 0x98, 0x74, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0xEB, 0x80, 
0xC5, 0x00, 0xE0, 0x7B, 0xE3, 0x00, 0x85, 0x82, 0xF1, 0x00, 0xAD, 0xAC, 0x5A, 0x00, 0x64, 0x99, 
0xB8, 0x00, 0xE1, 0xA0, 0x7A, 0x00, 0x63, 0xB5, 0x62, 0x00, 0xF8, 0x87, 0xCF, 0x00, 0x85, 0x88, 
0xF9, 0x00, 0xF1, 0x83, 0xF1, 0x00, 0xE8, 0xA6, 0x81, 0x00, 0xFF, 0x8C, 0xD7, 0x00, 0x8B, 0x8D, 
0xFF, 0x00, 0xF3, 0xAB, 0x80, 0x00, 0xF8, 0x88, 0xFA, 0x00, 0x68, 0xC2, 0x68, 0x00, 0xBE, 0xBE, 
0x67, 0x00, 0x6D, 0xA9, 0xCB, 0x00, 0xF9, 0xB0, 0x86, 0x00, 0xFF, 0x8C, 0xFF, 0x00, 0x70, 0xCB, 
0x6E, 0x00, 0xFE, 0xB5, 0x8B, 0x00, 0xC6, 0xC6, 0x6A, 0x00, 0x71, 0xD3, 0x73, 0x00, 0x78, 0xB7, 
0xDA, 0x00, 0xCE, 0xCF, 0x72, 0x00, 0x78, 0xDB, 0x78, 0x00, 0x7C, 0xE5, 0x7C, 0x00, 0x7F, 0xC4, 
0xEA, 0x00, 0xDB, 0xDD, 0x78, 0x00, 0x81, 0xED, 0x81, 0x00, 0xE3, 0xE5, 0x7E, 0x00, 0x88, 0xCF, 
0xF5, 0x00, 0x87, 0xF5, 0x84, 0x00, 0xEC, 0xEF, 0x87, 0x00, 0x89, 0xD6, 0xFE, 0x00, 0x87, 0xFA, 
0x8C, 0x00, 0xF1, 0xF3, 0x8C, 0x00, 0x89, 0xFF, 0x88, 0x00, 0xFB, 0xF9, 0x80, 0x00, 0xFF, 0xFF, 
0x87, 0x00, 0x0A, 0xFE, 0x73, 0x00, 0x03, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x72, 0x00, 0x04, 0xFE, 
0x00, 0x00, 0x0A, 0xFE, 0x71, 0x00, 0x05, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x04, 0x00, 0x01, 0x5D, 
0x66, 0x74, 0x01, 0x4A, 0x05, 0x00, 0x05, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x03, 0x00, 0x01, 0xEA, 
0x65, 0xFC, 0x01, 0xF7, 0x01, 0x4A, 0x04, 0x00, 0x06, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x03, 0x00, 
0x01, 0xE5, 0x65, 0xFC, 0x01, 0x85, 0x04, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x03, 0x00, 
0x01, 0xD3, 0x64, 0xFC, 0x01, 0xBA, 0x04, 0x00, 0x08, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x03, 0x00, 
0x01, 0xA1, 0x63, 0xFC, 0x01, 0xEA, 0x01, 0x03, 0x04, 0x00, 0x08, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 
0x03, 0x00, 0x01, 0x6A, 0x62, 0xFC, 0x01, 0xF1, 0x01, 0x28, 0x04, 0x00, 0x09, 0xFE, 0x00, 0x00, 
0x0B, 0xFE, 0x03, 0x00, 0x01, 0x33, 0x61, 0xFC, 0x01, 0xF0, 0x01, 0x28, 0x04, 0x00, 0x0A, 0xFE, 
0x00, 0x00, 0x0B, 0xFE, 0x04, 0x00, 0x01, 0xED, 0x5F, 0xFC, 0x01, 0xF0, 0x01, 0x28, 0x04, 0x00, 
0x0B, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 0x03, 0x00, 0x01, 0x94, 0x5E, 0xFC, 0x01, 0xED, 0x01, 0x1C, 
0x04, 0x00, 0x0C, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 0x03, 0x00, 0x01, 0x0C, 0x01, 0xF7, 0x5C, 0xFC, 
0x01, 0xEA, 0x01, 0x12, 0x04, 0x00, 0x0D, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 0x04, 0x00, 0x01, 0xCA, 
0x5B, 0xFC, 0x01, 0xE5, 0x01, 0x0C, 0x04, 0x00, 0x0E, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 0x03, 0x00, 
0x01, 0x4A, 0x5A, 0xFC, 0x01, 0xDC, 0x01, 0x05, 0x04, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 
0x04, 0x00, 0x01, 0xD3, 0x57, 0xFC, 0x00, 0x03, 0xF7, 0x94, 0x03, 0x00, 0x04, 0x00, 0x10, 0xFE, 
0x00, 0x00, 0x0E, 0xFE, 0x03, 0x00, 0x01, 0x12, 0x01, 0xF1, 0x18, 0xFC, 0x00, 0x04, 0xFA, 0xE5, 
0xE5, 0xF7, 0x39, 0xFC, 0x01, 0xE5, 0x01, 0x28, 0x05, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x0E, 0xFE, 
0x04, 0x00, 0x01, 0x6A, 0x15, 0xFC, 0x00, 0x07, 0xFA, 0xDC, 0x85, 0x12, 0x00, 0x00, 0x77, 0x00, 
0x37, 0xFC, 0x00, 0x03, 0xF4, 0x85, 0x03, 0x00, 0x05, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x0F, 0xFE, 
0x04, 0x00, 0x01, 0xD3, 0x11, 0xFC, 0x00, 0x04, 0xF7, 0xDC, 0x77, 0x0C, 0x05, 0x00, 0x01, 0x12, 
0x36, 0xFC, 0x01, 0xDC, 0x01, 0x28, 0x05, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 
0x01, 0x1C, 0x01, 0xF4, 0x0E, 0xFC, 0x00, 0x03, 0xEA, 0x77, 0x05, 0x00, 0x08, 0x00, 0x01, 0x94, 
0x34, 0xFC, 0x01, 0xF4, 0x01, 0x77, 0x06, 0x00, 0x15, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x04, 0x00, 
0x01, 0x94, 0x0C, 0xFC, 0x00, 0x03, 0xED, 0x6A, 0x03, 0x00, 0x07, 0x00, 0x00, 0x03, 0x1C, 0x85, 
0xE5, 0x00, 0x33, 0xFC, 0x00, 0x03, 0xF0, 0x94, 0x0C, 0x00, 0x05, 0x00, 0x17, 0xFE, 0x00, 0x00, 
0x11, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x01, 0xF0, 0x09, 0xFC, 0x00, 0x03, 0xF0, 0x77, 0x03, 0x00, 
0x06, 0x00, 0x00, 0x03, 0x28, 0x94, 0xE5, 0x00, 0x34, 0xFC, 0x00, 0x03, 0xEA, 0x77, 0x03, 0x00, 
0x06, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x03, 0x00, 0x01, 0xA1, 0x07, 0xFC, 0x00, 0x03, 
0xF0, 0x85, 0x03, 0x00, 0x05, 0x00, 0x00, 0x03, 0x28, 0x94, 0xEA, 0x00, 0x35, 0xFC, 0x01, 0xDC, 
0x01, 0x4A, 0x07, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x03, 0x00, 0x01, 0x33, 0x05, 0xFC, 
0x00, 0x03, 0xFA, 0x94, 0x03, 0x00, 0x05, 0x00, 0x00, 0x03, 0x28, 0xCA, 0xFA, 0x00, 0x34, 0xFC, 
0x00, 0x03, 0xF7, 0xBA, 0x33, 0x00, 0x08, 0x00, 0x1B, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x04, 0x00, 
0x01, 0xED, 0x03, 0xFC, 0x01, 0xF1, 0x01, 0x4A, 0x05, 0x00, 0x00, 0x03, 0x1C, 0xBA, 0xFA, 0x00, 
0x34, 0xFC, 0x00, 0x03, 0xF4, 0xA1, 0x12, 0x00, 0x07, 0x00, 0x1E, 0xFE, 0x00, 0x00, 0x13, 0xFE, 
0x03, 0x00, 0x00, 0x05, 0xBA, 0xFC, 0xFC, 0xE5, 0x1C, 0x00, 0x04, 0x00, 0x00, 0x03, 0x12, 0xAC, 
0xF7, 0x00, 0x34, 0xFC, 0x00, 0x03, 0xF7, 0x94, 0x0C, 0x00, 0x07, 0x00, 0x20, 0xFE, 0x00, 0x00, 
0x13, 0xFE, 0x03, 0x00, 0x00, 0x04, 0x94, 0xFC, 0xBA, 0x03, 0x04, 0x00, 0x01, 0x94, 0x01, 0xF4, 
0x35, 0xFC, 0x01, 0xF1, 0x01, 0x4A, 0x07, 0x00, 0x22, 0xFE, 0x00, 0x00, 0x13, 0xFE, 0x03, 0x00, 
0x01, 0x4A, 0x01, 0x77, 0x04, 0x00, 0x01, 0x05, 0x01, 0xD3, 0x36, 0xFC, 0x01, 0xF7, 0x01, 0x33, 
0x06, 0x00, 0x24, 0xFE, 0x00, 0x00, 0x13, 0xFE, 0x03, 0x00, 0x01, 0x05, 0x04, 0x00, 0x01, 0x33, 
0x01, 0xED, 0x37, 0xFC, 0x01, 0x94, 0x05, 0x00, 0x26, 0xFE, 0x00, 0x00, 0x13, 0xFE, 0x07, 0x00, 
0x01, 0x6A, 0x01, 0xF4, 0x37, 0xFC, 0x01, 0xF4, 0x01, 0x03, 0x03, 0x00, 0x28, 0xFE, 0x00, 0x00, 
0x13, 0xFE, 0x05, 0x00, 0x01, 0x03, 0x01, 0xA1, 0x39, 0xFC, 0x01, 0xCA, 0x04, 0x00, 0x28, 0xFE, 
0x00, 0x00, 0x13, 0xFE, 0x05, 0x00, 0x01, 0xA1, 0x3A, 0xFC, 0x01, 0x85, 0x03, 0x00, 0x29, 0xFE, 
0x00, 0x00, 0x12, 0xFE, 0x05, 0x00, 0x01, 0x6A, 0x3B, 0xFC, 0x01, 0x85, 0x03, 0x00, 0x29, 0xFE, 
0x00, 0x00, 0x12, 0xFE, 0x04, 0x00, 0x01, 0x28, 0x01, 0xF4, 0x3B, 0xFC, 0x01, 0x94, 0x03, 0x00, 
0x29, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x01, 0xED, 0x22, 0xFC, 0x01, 0xDC, 
0x01, 0xED, 0x18, 0xFC, 0x01, 0x94, 0x03, 0x00, 0x29, 0xFE, 0x00, 0x00, 0x11, 0xFE, 0x04, 0x00, 
0x01, 0x94, 0x22, 0xFC, 0x00, 0x03, 0xF4, 0x1C, 0x85, 0x00, 0x18, 0xFC, 0x01, 0xA1, 0x03, 0x00, 
0x29, 0xFE, 0x00, 0x00, 0x11, 0xFE, 0x03, 0x00, 0x01, 0x0C, 0x01, 0xFA, 0x22, 0xFC, 0x00, 0x04, 
0x74, 0x00, 0x03, 0xF1, 0x17, 0xFC, 0x01, 0xCA, 0x03, 0x00, 0x29, 0xFE, 0x00, 0x00, 0x11, 0xFE, 
0x03, 0x00, 0x01, 0x77, 0x22, 0xFC, 0x01, 0xCA, 0x03, 0x00, 0x01, 0xA1, 0x17, 0xFC, 0x01, 0xED, 
0x04, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x04, 0x00, 0x01, 0xDC, 0x21, 0xFC, 0x01, 0xF0, 
0x01, 0x0C, 0x03, 0x00, 0x01, 0x1C, 0x01, 0xF7, 0x17, 0xFC, 0x01, 0x0C, 0x03, 0x00, 0x28, 0xFE, 
0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 0x01, 0x05, 0x01, 0xF7, 0x21, 0xFC, 0x01, 0x5D, 0x05, 0x00, 
0x01, 0xCA, 0x17, 0xFC, 0x01, 0x5D, 0x03, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 
0x01, 0x5D, 0x21, 0xFC, 0x01, 0xAC, 0x06, 0x00, 0x01, 0x4A, 0x17, 0xFC, 0x01, 0x94, 0x03, 0x00, 
0x28, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 0x01, 0x77, 0x20, 0xFC, 0x01, 0xED, 0x01, 0x03, 
0x03, 0x00, 0x01, 0x0C, 0x03, 0x00, 0x01, 0xE5, 0x16, 0xFC, 0x01, 0xCA, 0x03, 0x00, 0x28, 0xFE, 
0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 0x01, 0x94, 0x1F, 0xFC, 0x01, 0xF7, 0x01, 0x33, 0x03, 0x00, 
0x01, 0x47, 0x01, 0x8B, 0x03, 0x00, 0x01, 0x6A, 0x16, 0xFC, 0x01, 0xD3, 0x03, 0x00, 0x28, 0xFE, 
0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 0x01, 0xAC, 0x1F, 0xFC, 0x01, 0x94, 0x03, 0x00, 0x00, 0x08, 
0x0C, 0xB5, 0xC3, 0x18, 0x00, 0x00, 0x03, 0xF0, 0x15, 0xFC, 0x01, 0xE5, 0x03, 0x00, 0x28, 0xFE, 
0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 0x01, 0xCA, 0x1E, 0xFC, 0x00, 0x09, 0xE5, 0x03, 0x00, 0x00, 
0x03, 0x98, 0xC3, 0xC3, 0x71, 0x00, 0x03, 0x00, 0x01, 0x94, 0x15, 0xFC, 0x01, 0xED, 0x03, 0x00, 
0x28, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 0x01, 0xDC, 0x1E, 0xFC, 0x01, 0x5D, 0x03, 0x00, 
0x01, 0x5A, 0x03, 0xC3, 0x00, 0x06, 0xB5, 0x03, 0x00, 0x00, 0x05, 0xF4, 0x14, 0xFC, 0x01, 0xE5, 
0x03, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 0x01, 0xCA, 0x1D, 0xFC, 0x01, 0xED, 
0x03, 0x00, 0x01, 0x18, 0x01, 0xBD, 0x04, 0xC3, 0x01, 0x5A, 0x03, 0x00, 0x01, 0xAC, 0x14, 0xFC, 
0x01, 0xAC, 0x03, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 0x01, 0xAC, 0x1D, 0xFC, 
0x01, 0x77, 0x03, 0x00, 0x01, 0x7B, 0x05, 0xC3, 0x00, 0x05, 0xA9, 0x03, 0x00, 0x00, 0x33, 0x00, 
0x14, 0xFC, 0x01, 0x77, 0x03, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 0x01, 0x94, 
0x1C, 0xFC, 0x00, 0x05, 0xF1, 0x03, 0x00, 0x00, 0x0C, 0x00, 0x07, 0xC3, 0x01, 0x40, 0x03, 0x00, 
0x01, 0xF1, 0x13, 0xFC, 0x01, 0x28, 0x03, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 
0x01, 0x74, 0x1C, 0xFC, 0x01, 0xBA, 0x03, 0x00, 0x01, 0x71, 0x07, 0xC3, 0x01, 0x7B, 0x03, 0x00, 
0x01, 0xD3, 0x12, 0xFC, 0x01, 0xE5, 0x04, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 
0x01, 0x4A, 0x1C, 0xFC, 0x00, 0x05, 0x4A, 0x00, 0x00, 0x03, 0xA9, 0x00, 0x07, 0xC3, 0x01, 0x9F, 
0x03, 0x00, 0x01, 0x85, 0x12, 0xFC, 0x01, 0x6A, 0x03, 0x00, 0x29, 0xFE, 0x00, 0x00, 0x10, 0xFE, 
0x03, 0x00, 0x01, 0x1C, 0x1B, 0xFC, 0x00, 0x05, 0xF1, 0x03, 0x00, 0x00, 0x29, 0x00, 0x09, 0xC3, 
0x00, 0x04, 0x05, 0x00, 0x00, 0x33, 0x11, 0xFC, 0x01, 0xF0, 0x01, 0x03, 0x03, 0x00, 0x29, 0xFE, 
0x00, 0x00, 0x10, 0xFE, 0x04, 0x00, 0x01, 0xF0, 0x1A, 0xFC, 0x01, 0xCA, 0x03, 0x00, 0x01, 0x71, 
0x09, 0xC3, 0x01, 0x47, 0x03, 0x00, 0x01, 0xF1, 0x10, 0xFC, 0x01, 0x6A, 0x03, 0x00, 0x2A, 0xFE, 
0x00, 0x00, 0x11, 0xFE, 0x03, 0x00, 0x01, 0xCA, 0x1A, 0xFC, 0x01, 0x94, 0x03, 0x00, 0x01, 0x9F, 
0x09, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0xD3, 0x0F, 0xFC, 0x01, 0xDC, 0x04, 0x00, 0x2A, 0xFE, 
0x00, 0x00, 0x11, 0xFE, 0x03, 0x00, 0x01, 0x85, 0x1A, 0xFC, 0x00, 0x05, 0x77, 0x00, 0x00, 0x03, 
0xB5, 0x00, 0x09, 0xC3, 0x01, 0x9F, 0x03, 0x00, 0x01, 0x94, 0x0E, 0xFC, 0x01, 0xF7, 0x01, 0x33, 
0x03, 0x00, 0x2B, 0xFE, 0x00, 0x00, 0x11, 0xFE, 0x03, 0x00, 0x01, 0x33, 0x1A, 0xFC, 0x00, 0x04, 
0x4A, 0x00, 0x00, 0x0C, 0x0A, 0xC3, 0x00, 0x05, 0xBD, 0x05, 0x00, 0x00, 0x33, 0x00, 0x0E, 0xFC, 
0x01, 0x94, 0x04, 0x00, 0x2B, 0xFE, 0x00, 0x00, 0x11, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x01, 0xF1, 
0x19, 0xFC, 0x00, 0x04, 0x12, 0x00, 0x00, 0x29, 0x0B, 0xC3, 0x00, 0x05, 0x40, 0x00, 0x00, 0x03, 
0xF4, 0x00, 0x0C, 0xFC, 0x01, 0xE5, 0x01, 0x03, 0x03, 0x00, 0x2C, 0xFE, 0x00, 0x00, 0x12, 0xFE, 
0x03, 0x00, 0x01, 0xBA, 0x18, 0xFC, 0x01, 0xF4, 0x03, 0x00, 0x01, 0x52, 0x0B, 0xC3, 0x01, 0x67, 
0x03, 0x00, 0x01, 0xED, 0x0B, 0xFC, 0x01, 0xF4, 0x01, 0x28, 0x04, 0x00, 0x2C, 0xFE, 0x00, 0x00, 
0x12, 0xFE, 0x03, 0x00, 0x01, 0x4A, 0x18, 0xFC, 0x01, 0xEA, 0x03, 0x00, 0x01, 0x67, 0x0B, 0xC3, 
0x01, 0x71, 0x03, 0x00, 0x01, 0xE5, 0x0B, 0xFC, 0x01, 0x6A, 0x04, 0x00, 0x2D, 0xFE, 0x00, 0x00, 
0x12, 0xFE, 0x04, 0x00, 0x01, 0xF0, 0x17, 0xFC, 0x01, 0xD3, 0x03, 0x00, 0x01, 0x83, 0x0B, 0xC3, 
0x01, 0x83, 0x03, 0x00, 0x01, 0xDC, 0x0A, 0xFC, 0x01, 0xBA, 0x04, 0x00, 0x2E, 0xFE, 0x00, 0x00, 
0x13, 0xFE, 0x03, 0x00, 0x01, 0xA1, 0x17, 0xFC, 0x01, 0xAC, 0x03, 0x00, 0x01, 0x98, 0x0B, 0xC3, 
0x01, 0x8B, 0x03, 0x00, 0x01, 0xCA, 0x09, 0xFC, 0x01, 0xF0, 0x01, 0x05, 0x03, 0x00, 0x2F, 0xFE, 
0x00, 0x00, 0x13, 0xFE, 0x03, 0x00, 0x01, 0x28, 0x17, 0xFC, 0x01, 0x94, 0x03, 0x00, 0x01, 0xA9, 
0x0B, 0xC3, 0x01, 0x98, 0x03, 0x00, 0x01, 0xBA, 0x09, 0xFC, 0x01, 0x4A, 0x04, 0x00, 0x2F, 0xFE, 
0x00, 0x00, 0x13, 0xFE, 0x04, 0x00, 0x01, 0xDC, 0x16, 0xFC, 0x01, 0xAC, 0x03, 0x00, 0x01, 0x9F, 
0x0B, 0xC3, 0x01, 0x9F, 0x03, 0x00, 0x01, 0xAC, 0x08, 0xFC, 0x01, 0xBA, 0x04, 0x00, 0x30, 0xFE, 
0x00, 0x00, 0x14, 0xFE, 0x03, 0x00, 0x01, 0x4A, 0x16, 0xFC, 0x01, 0xBA, 0x03, 0x00, 0x01, 0x98, 
0x0B, 0xC3, 0x01, 0xA9, 0x03, 0x00, 0x01, 0x94, 0x07, 0xFC, 0x01, 0xF4, 0x01, 0x12, 0x03, 0x00, 
0x31, 0xFE, 0x00, 0x00, 0x14, 0xFE, 0x04, 0x00, 0x01, 0xE5, 0x0B, 0xFC, 0x00, 0x04, 0xF1, 0xBA, 
0xD3, 0xF7, 0x06, 0xFC, 0x01, 0xBA, 0x03, 0x00, 0x01, 0x91, 0x0B, 0xC3, 0x01, 0xB5, 0x03, 0x00, 
0x00, 0x09, 0x85, 0xFC, 0xF4, 0xD3, 0xCA, 0xF4, 0xFC, 0xFC, 0xBA, 0x00, 0x04, 0x00, 0x31, 0xFE, 
0x00, 0x00, 0x15, 0xFE, 0x03, 0x00, 0x01, 0x6A, 0x0A, 0xFC, 0x00, 0x06, 0xEA, 0x12, 0x00, 0x00, 
0x33, 0xF1, 0x05, 0xFC, 0x01, 0xCA, 0x03, 0x00, 0x01, 0x8B, 0x0B, 0xC3, 0x01, 0xA9, 0x03, 0x00, 
0x00, 0x09, 0x85, 0xF0, 0x33, 0x00, 0x00, 0x1C, 0xED, 0xFC, 0x4A, 0x00, 0x03, 0x00, 0x32, 0xFE, 
0x00, 0x00, 0x15, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x01, 0xED, 0x08, 0xFC, 0x01, 0xFA, 0x01, 0x33, 
0x04, 0x00, 0x01, 0x77, 0x05, 0xFC, 0x01, 0xDC, 0x03, 0x00, 0x01, 0x83, 0x0B, 0xC3, 0x01, 0x91, 
0x03, 0x00, 0x01, 0xAC, 0x01, 0x5D, 0x04, 0x00, 0x01, 0x4A, 0x01, 0xF0, 0x04, 0x00, 0x32, 0xFE, 
0x00, 0x00, 0x16, 0xFE, 0x03, 0x00, 0x01, 0x5D, 0x08, 0xFC, 0x01, 0xDC, 0x05, 0x00, 0x01, 0x03, 
0x01, 0xF4, 0x04, 0xFC, 0x01, 0xDC, 0x03, 0x00, 0x01, 0x7B, 0x0B, 0xC3, 0x01, 0x7B, 0x03, 0x00, 
0x01, 0xBA, 0x06, 0x00, 0x01, 0x94, 0x03, 0x00, 0x33, 0xFE, 0x00, 0x00, 0x16, 0xFE, 0x04, 0x00, 
0x01, 0xD3, 0x07, 0xFC, 0x01, 0xAC, 0x06, 0x00, 0x01, 0xE5, 0x04, 0xFC, 0x01, 0xE5, 0x03, 0x00, 
0x01, 0x71, 0x0B, 0xC3, 0x01, 0x5A, 0x03, 0x00, 0x01, 0xBA, 0x06, 0x00, 0x01, 0x4A, 0x03, 0x00, 
0x33, 0xFE, 0x00, 0x00, 0x17, 0xFE, 0x03, 0x00, 0x01, 0x28, 0x01, 0xF7, 0x06, 0xFC, 0x01, 0xAC, 
0x06, 0x00, 0x01, 0xE5, 0x04, 0xFC, 0x01, 0xED, 0x03, 0x00, 0x01, 0x71, 0x0B, 0xC3, 0x00, 0x05, 
0x40, 0x00, 0x00, 0x03, 0xD3, 0x00, 0x06, 0x00, 0x01, 0x05, 0x03, 0x00, 0x33, 0xFE, 0x00, 0x00, 
0x17, 0xFE, 0x04, 0x00, 0x01, 0x94, 0x06, 0xFC, 0x01, 0xD3, 0x06, 0x00, 0x01, 0xF1, 0x04, 0xFC, 
0x01, 0xF0, 0x03, 0x00, 0x01, 0x47, 0x0B, 0xC3, 0x00, 0x05, 0x18, 0x00, 0x00, 0x28, 0xED, 0x00, 
0x0A, 0x00, 0x33, 0xFE, 0x00, 0x00, 0x18, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x01, 0xED, 0x05, 0xFC, 
0x01, 0xF7, 0x01, 0x1C, 0x04, 0x00, 0x01, 0x5D, 0x06, 0xFC, 0x00, 0x05, 0x28, 0x00, 0x00, 0x03, 
0xA9, 0x00, 0x09, 0xC3, 0x00, 0x07, 0x9F, 0x03, 0x00, 0x00, 0x5D, 0xFC, 0x4A, 0x00, 0x04, 0x00, 
0x01, 0x12, 0x03, 0x00, 0x34, 0xFE, 0x00, 0x00, 0x18, 0xFE, 0x04, 0x00, 0x01, 0x33, 0x01, 0xF7, 
0x05, 0xFC, 0x00, 0x06, 0xD3, 0x03, 0x00, 0x00, 0x1C, 0xED, 0x06, 0xFC, 0x01, 0x94, 0x03, 0x00, 
0x01, 0x18, 0x01, 0x98, 0x07, 0xC3, 0x01, 0x91, 0x01, 0x0C, 0x03, 0x00, 0x00, 0x08, 0xBA, 0xFC, 
0xEA, 0x0C, 0x00, 0x00, 0x03, 0x12, 0x03, 0x00, 0x34, 0xFE, 0x00, 0x00, 0x19, 0xFE, 0x04, 0x00, 
0x01, 0x77, 0x06, 0xFC, 0x00, 0x04, 0xE5, 0x94, 0xA1, 0xF0, 0x07, 0xFC, 0x01, 0xF0, 0x01, 0x05, 
0x04, 0x00, 0x00, 0x07, 0x29, 0x67, 0x83, 0x83, 0x7B, 0x5A, 0x18, 0x00, 0x04, 0x00, 0x00, 0x05, 
0x33, 0xFA, 0xFC, 0xFC, 0xF0, 0x00, 0x03, 0x94, 0x04, 0x00, 0x34, 0xFE, 0x00, 0x00, 0x1A, 0xFE, 
0x04, 0x00, 0x01, 0xBA, 0x11, 0xFC, 0x01, 0xE5, 0x01, 0x05, 0x0D, 0x00, 0x01, 0x03, 0x01, 0xE5, 
0x05, 0xFC, 0x01, 0xF4, 0x01, 0x0C, 0x03, 0x00, 0x35, 0xFE, 0x00, 0x00, 0x1B, 0xFE, 0x03, 0x00, 
0x01, 0x03, 0x01, 0xD3, 0x11, 0xFC, 0x01, 0xE5, 0x01, 0x1C, 0x0B, 0x00, 0x01, 0x4A, 0x01, 0xED, 
0x06, 0xFC, 0x01, 0x85, 0x04, 0x00, 0x35, 0xFE, 0x00, 0x00, 0x1B, 0xFE, 0x04, 0x00, 0x01, 0x03, 
0x01, 0xCA, 0x11, 0xFC, 0x00, 0x04, 0xFA, 0xD3, 0x4A, 0x03, 0x05, 0x00, 0x00, 0x04, 0x03, 0x6A, 
0xCA, 0xFA, 0x06, 0xFC, 0x01, 0xCA, 0x04, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x1C, 0xFE, 0x04, 0x00, 
0x01, 0x03, 0x01, 0xCA, 0x13, 0xFC, 0x00, 0x07, 0xF7, 0xED, 0xD3, 0xD3, 0xDC, 0xEA, 0xF7, 0x00, 
0x08, 0xFC, 0x01, 0xE5, 0x01, 0x03, 0x04, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x1D, 0xFE, 0x04, 0x00, 
0x01, 0x03, 0x01, 0xAC, 0x20, 0xFC, 0x01, 0xED, 0x01, 0x12, 0x04, 0x00, 0x37, 0xFE, 0x00, 0x00, 
0x1E, 0xFE, 0x05, 0x00, 0x01, 0x6A, 0x01, 0xF7, 0x1D, 0xFC, 0x01, 0xDC, 0x01, 0x0C, 0x04, 0x00, 
0x38, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x05, 0x00, 0x01, 0x33, 0x01, 0xF0, 0x1B, 0xFC, 0x01, 0xAC, 
0x01, 0x03, 0x04, 0x00, 0x39, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x05, 0x00, 0x00, 0x03, 0x05, 0xAC, 
0xF7, 0x00, 0x17, 0xFC, 0x01, 0xF0, 0x01, 0x6A, 0x05, 0x00, 0x3A, 0xFE, 0x00, 0x00, 0x22, 0xFE, 
0x05, 0x00, 0x01, 0x28, 0x01, 0xDC, 0x14, 0xFC, 0x00, 0x03, 0xEA, 0x6A, 0x03, 0x00, 0x05, 0x00, 
0x3B, 0xFE, 0x00, 0x00, 0x23, 0xFE, 0x06, 0x00, 0x00, 0x03, 0x4A, 0xCA, 0xF7, 0x00, 0x0F, 0xFC, 
0x01, 0xE5, 0x01, 0x5D, 0x07, 0x00, 0x3C, 0xFE, 0x00, 0x00, 0x24, 0xFE, 0x07, 0x00, 0x00, 0x04, 
0x05, 0x77, 0xDC, 0xF4, 0x08, 0xFC, 0x00, 0x04, 0xF1, 0xBA, 0x77, 0x12, 0x07, 0x00, 0x3E, 0xFE, 
0x00, 0x00, 0x26, 0xFE, 0x09, 0x00, 0x00, 0x08, 0x1C, 0x5D, 0x85, 0x94, 0x77, 0x6A, 0x4A, 0x33, 
0x09, 0x00, 0x40, 0xFE, 0x00, 0x00, 0x28, 0xFE, 0x16, 0x00, 0x42, 0xFE, 0x00, 0x00, 0x2A, 0xFE, 
0x12, 0x00, 0x44, 0xFE, 0x00, 0x00, 0x2E, 0xFE, 0x0A, 0x00, 0x48, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x01, 
};

constexpr unsigned char parrot04[] = {
0x42, 0x4D, 0xE8, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x04, 0x00, 0x00, 0x28, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x01, 0x00, 
0x00, 0x00, 0xB6, 0x09, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0xFF, 0x00, 
0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x08, 0x04, 
0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x0B, 0x05, 0x08, 0x00, 0x06, 0x0A, 0x07, 0x00, 0x06, 0x08, 
0x0E, 0x00, 0x0E, 0x0B, 0x04, 0x00, 0x0F, 0x07, 0x12, 0x00, 0x0B, 0x0C, 0x12, 0x00, 0x16, 0x0B, 
0x12, 0x00, 0x0C, 0x0B, 0x17, 0x00, 0x0C, 0x10, 0x0D, 0x00, 0x13, 0x11, 0x08, 0x00, 0x12, 0x0C, 
0x1C, 0x00, 0x19, 0x0C, 0x1B, 0x00, 0x18, 0x10, 0x10, 0x00, 0x0A, 0x0D, 0x21, 0x00, 0x08, 0x13, 
0x10, 0x00, 0x1E, 0x0E, 0x1A, 0x00, 0x0A, 0x12, 0x18, 0x00, 0x1B, 0x15, 0x0E, 0x00, 0x1C, 0x10, 
0x1F, 0x00, 0x14, 0x11, 0x1F, 0x00, 0x12, 0x15, 0x13, 0x00, 0x23, 0x10, 0x24, 0x00, 0x1B, 0x10, 
0x28, 0x00, 0x0E, 0x15, 0x1C, 0x00, 0x0E, 0x1A, 0x0D, 0x00, 0x19, 0x19, 0x0D, 0x00, 0x11, 0x13, 
0x25, 0x00, 0x23, 0x13, 0x1F, 0x00, 0x12, 0x1A, 0x15, 0x00, 0x12, 0x13, 0x2E, 0x00, 0x25, 0x1A, 
0x16, 0x00, 0x2E, 0x14, 0x30, 0x00, 0x17, 0x18, 0x2C, 0x00, 0x20, 0x20, 0x0F, 0x00, 0x2D, 0x19, 
0x23, 0x00, 0x13, 0x1C, 0x23, 0x00, 0x13, 0x21, 0x13, 0x00, 0x17, 0x1F, 0x1A, 0x00, 0x24, 0x16, 
0x34, 0x00, 0x32, 0x14, 0x37, 0x00, 0x17, 0x17, 0x38, 0x00, 0x2E, 0x19, 0x2B, 0x00, 0x1C, 0x1D, 
0x32, 0x00, 0x15, 0x21, 0x29, 0x00, 0x32, 0x23, 0x1B, 0x00, 0x26, 0x26, 0x15, 0x00, 0x1D, 0x25, 
0x20, 0x00, 0x16, 0x29, 0x15, 0x00, 0x3B, 0x1A, 0x3B, 0x00, 0x1D, 0x1B, 0x43, 0x00, 0x2F, 0x1B, 
0x40, 0x00, 0x36, 0x1E, 0x34, 0x00, 0x3D, 0x20, 0x33, 0x00, 0x23, 0x21, 0x3D, 0x00, 0x3B, 0x20, 
0x3D, 0x00, 0x3A, 0x29, 0x22, 0x00, 0x44, 0x1D, 0x47, 0x00, 0x1F, 0x1F, 0x4D, 0x00, 0x2C, 0x2D, 
0x1A, 0x00, 0x1A, 0x28, 0x31, 0x00, 0x22, 0x2B, 0x27, 0x00, 0x37, 0x1F, 0x4D, 0x00, 0x3F, 0x23, 
0x41, 0x00, 0x26, 0x27, 0x48, 0x00, 0x47, 0x27, 0x3E, 0x00, 0x4E, 0x22, 0x4E, 0x00, 0x1F, 0x2F, 
0x39, 0x00, 0x25, 0x32, 0x2D, 0x00, 0x25, 0x26, 0x56, 0x00, 0x3F, 0x24, 0x59, 0x00, 0x1F, 0x39, 
0x1E, 0x00, 0x35, 0x37, 0x1E, 0x00, 0x47, 0x33, 0x27, 0x00, 0x53, 0x24, 0x58, 0x00, 0x4F, 0x2B, 
0x42, 0x00, 0x2B, 0x2C, 0x50, 0x00, 0x28, 0x28, 0x5F, 0x00, 0x4D, 0x2A, 0x4D, 0x00, 0x2A, 0x38, 
0x30, 0x00, 0x55, 0x30, 0x49, 0x00, 0x30, 0x2F, 0x59, 0x00, 0x60, 0x29, 0x62, 0x00, 0x2B, 0x2C, 
0x6B, 0x00, 0x49, 0x2B, 0x68, 0x00, 0x55, 0x2F, 0x59, 0x00, 0x26, 0x3A, 0x45, 0x00, 0x31, 0x3F, 
0x36, 0x00, 0x58, 0x3E, 0x2E, 0x00, 0x65, 0x2B, 0x6B, 0x00, 0x26, 0x46, 0x26, 0x00, 0x2F, 0x30, 
0x6F, 0x00, 0x5C, 0x32, 0x59, 0x00, 0x47, 0x46, 0x24, 0x00, 0x62, 0x36, 0x52, 0x00, 0x37, 0x36, 
0x61, 0x00, 0x51, 0x31, 0x75, 0x00, 0x32, 0x33, 0x7A, 0x00, 0x2A, 0x41, 0x4E, 0x00, 0x5E, 0x44, 
0x34, 0x00, 0x38, 0x47, 0x3D, 0x00, 0x65, 0x38, 0x66, 0x00, 0x75, 0x32, 0x79, 0x00, 0x2D, 0x52, 
0x2D, 0x00, 0x58, 0x35, 0x81, 0x00, 0x37, 0x37, 0x86, 0x00, 0x69, 0x4A, 0x37, 0x00, 0x3C, 0x3E, 
0x71, 0x00, 0x72, 0x3E, 0x61, 0x00, 0x53, 0x52, 0x2C, 0x00, 0x39, 0x4D, 0x46, 0x00, 0x30, 0x49, 
0x57, 0x00, 0x62, 0x37, 0x86, 0x00, 0x32, 0x58, 0x2B, 0x00, 0x72, 0x3D, 0x71, 0x00, 0x58, 0x56, 
0x30, 0x00, 0x2F, 0x5B, 0x31, 0x00, 0x3E, 0x3D, 0x93, 0x00, 0x86, 0x3A, 0x88, 0x00, 0x73, 0x52, 
0x3E, 0x00, 0x3F, 0x54, 0x4B, 0x00, 0x45, 0x45, 0x7E, 0x00, 0x69, 0x3D, 0x90, 0x00, 0x85, 0x48, 
0x6F, 0x00, 0x81, 0x45, 0x81, 0x00, 0x41, 0x43, 0xA1, 0x00, 0x37, 0x56, 0x66, 0x00, 0x7F, 0x5A, 
0x41, 0x00, 0x46, 0x5C, 0x4F, 0x00, 0x93, 0x3F, 0x98, 0x00, 0x38, 0x66, 0x36, 0x00, 0x63, 0x63, 
0x34, 0x00, 0x73, 0x43, 0xA0, 0x00, 0x4F, 0x4D, 0x8E, 0x00, 0x9C, 0x42, 0xA1, 0x00, 0x3D, 0x5D, 
0x6D, 0x00, 0x4C, 0x63, 0x55, 0x00, 0x95, 0x51, 0x7C, 0x00, 0x89, 0x62, 0x4A, 0x00, 0x9F, 0x45, 
0xA5, 0x00, 0x4B, 0x4B, 0xB3, 0x00, 0x50, 0x53, 0x97, 0x00, 0x51, 0x68, 0x5A, 0x00, 0x7E, 0x4A, 
0xB1, 0x00, 0x93, 0x51, 0x94, 0x00, 0x40, 0x75, 0x40, 0x00, 0xAB, 0x49, 0xB0, 0x00, 0x56, 0x57, 
0xA1, 0x00, 0x71, 0x72, 0x3F, 0x00, 0x50, 0x6C, 0x60, 0x00, 0x42, 0x67, 0x79, 0x00, 0x98, 0x6A, 
0x53, 0x00, 0x50, 0x50, 0xC3, 0x00, 0xA5, 0x5A, 0x8A, 0x00, 0xA0, 0x57, 0x9C, 0x00, 0x87, 0x4F, 
0xC1, 0x00, 0x56, 0x72, 0x66, 0x00, 0xB8, 0x4F, 0xBF, 0x00, 0x44, 0x80, 0x45, 0x00, 0x60, 0x60, 
0xAF, 0x00, 0xA8, 0x5C, 0xA9, 0x00, 0x7D, 0x7E, 0x46, 0x00, 0x59, 0x58, 0xD5, 0x00, 0x8F, 0x55, 
0xCD, 0x00, 0xA5, 0x75, 0x5D, 0x00, 0xB5, 0x63, 0x98, 0x00, 0x5D, 0x7A, 0x6D, 0x00, 0xC6, 0x54, 
0xCB, 0x00, 0x4C, 0x76, 0x8A, 0x00, 0x4B, 0x89, 0x4B, 0x00, 0x61, 0x7F, 0x6C, 0x00, 0x69, 0x68, 
0xBC, 0x00, 0x5E, 0x5F, 0xE4, 0x00, 0x9B, 0x5B, 0xDD, 0x00, 0xCD, 0x59, 0xD5, 0x00, 0xB9, 0x64, 
0xB8, 0x00, 0xB2, 0x7E, 0x63, 0x00, 0x88, 0x8B, 0x4D, 0x00, 0x66, 0x84, 0x71, 0x00, 0xD8, 0x5B, 
0xDD, 0x00, 0xC7, 0x6D, 0xA7, 0x00, 0x64, 0x62, 0xEE, 0x00, 0x9F, 0x60, 0xE5, 0x00, 0x51, 0x96, 
0x51, 0x00, 0x6E, 0x6F, 0xCC, 0x00, 0x54, 0x81, 0x9B, 0x00, 0x6B, 0x8A, 0x76, 0x00, 0xA9, 0x62, 
0xEB, 0x00, 0x68, 0x66, 0xF4, 0x00, 0xDD, 0x60, 0xE2, 0x00, 0xC3, 0x6B, 0xC6, 0x00, 0xC1, 0x88, 
0x69, 0x00, 0x68, 0x8C, 0x7B, 0x00, 0x96, 0x96, 0x51, 0x00, 0x68, 0x69, 0xFF, 0x00, 0xE4, 0x62, 
0xED, 0x00, 0xD6, 0x75, 0xB3, 0x00, 0xD0, 0x6F, 0xCF, 0x00, 0xB1, 0x66, 0xF8, 0x00, 0x5A, 0xA1, 
0x55, 0x00, 0x77, 0x77, 0xDB, 0x00, 0xCA, 0x8F, 0x6F, 0x00, 0xA1, 0x9F, 0x56, 0x00, 0xB7, 0x6C, 
0xFE, 0x00, 0x5D, 0x8E, 0xAB, 0x00, 0xD7, 0x76, 0xD6, 0x00, 0xF3, 0x69, 0xFA, 0x00, 0xF7, 0x68, 
0xFF, 0x00, 0x5A, 0xA9, 0x5D, 0x00, 0xD7, 0x98, 0x74, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0xEB, 0x80, 
0xC5, 0x00, 0xE0, 0x7B, 0xE3, 0x00, 0x85, 0x82, 0xF1, 0x00, 0xAD, 0xAC, 0x5A, 0x00, 0x64, 0x99, 
0xB8, 0x00, 0xE1, 0xA0, 0x7A, 0x00, 0x63, 0xB5, 0x62, 0x00, 0xF8, 0x87, 0xCF, 0x00, 0x85, 0x88, 
0xF9, 0x00, 0xF1, 0x83, 0xF1, 0x00, 0xE8, 0xA6, 0x81, 0x00, 0xFF, 0x8C, 0xD7, 0x00, 0x8B, 0x8D, 
0xFF, 0x00, 0xF3, 0xAB, 0x80, 0x00, 0xF8, 0x88, 0xFA, 0x00, 0x68, 0xC2, 0x68, 0x00, 0xBE, 0xBE, 
0x67, 0x00, 0x6D, 0xA9, 0xCB, 0x00, 0xF9, 0xB0, 0x86, 0x00, 0xFF, 0x8C, 0xFF, 0x00, 0x70, 0xCB, 
0x6E, 0x00, 0xFE, 0xB5, 0x8B, 0x00, 0xC6, 0xC6, 0x6A, 0x00, 0x71, 0xD3, 0x73, 0x00, 0x78, 0xB7, 
0xDA, 0x00, 0xCE, 0xCF, 0x72, 0x00, 0x78, 0xDB, 0x78, 0x00, 0x7C, 0xE5, 0x7C, 0x00, 0x7F, 0xC4, 
0xEA, 0x00, 0xDB, 0xDD, 0x78, 0x00, 0x81, 0xED, 0x81, 0x00, 0xE3, 0xE5, 0x7E, 0x00, 0x88, 0xCF, 
0xF5, 0x00, 0x87, 0xF5, 0x84, 0x00, 0xEC, 0xEF, 0x87, 0x00, 0x89, 0xD6, 0xFE, 0x00, 0x87, 0xFA, 
0x8C, 0x00, 0xF1, 0xF3, 0x8C, 0x00, 0x89, 0xFF, 0x88, 0x00, 0xFB, 0xF9, 0x80, 0x00, 0xFF, 0xFF, 
0x87, 0x00, 0x0A, 0xFE, 0x74, 0x00, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x72, 0x00, 
0x04, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x72, 0x00, 0x05, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 
0x01, 0x0D, 0x65, 0x76, 0x01, 0x31, 0x07, 0x00, 0x06, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 
0x01, 0x86, 0x63, 0xFE, 0x00, 0x03, 0xFD, 0xA4, 0x03, 0x00, 0x05, 0x00, 0x08, 0xFE, 0x00, 0x00, 
0x09, 0xFE, 0x03, 0x00, 0x01, 0xB4, 0x62, 0xFE, 0x01, 0xEF, 0x01, 0x3E, 0x06, 0x00, 0x09, 0xFE, 
0x00, 0x00, 0x08, 0xFE, 0x04, 0x00, 0x01, 0xEC, 0x12, 0xFE, 0x00, 0x07, 0xFD, 0xEF, 0xC4, 0x86, 
0x3E, 0x76, 0xF5, 0x00, 0x47, 0xFE, 0x00, 0x03, 0xFD, 0xA4, 0x03, 0x00, 0x05, 0x00, 0x0B, 0xFE, 
0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x01, 0xFD, 0x0F, 0xFE, 0x00, 0x04, 0xFD, 0xD9, 
0x60, 0x07, 0x05, 0x00, 0x01, 0x86, 0x46, 0xFE, 0x01, 0xE6, 0x01, 0x31, 0x06, 0x00, 0x0C, 0xFE, 
0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0x3E, 0x0E, 0xFE, 0x00, 0x03, 0xF3, 0xA4, 0x1D, 0x00, 
0x08, 0x00, 0x01, 0x97, 0x44, 0xFE, 0x01, 0xF3, 0x01, 0x70, 0x06, 0x00, 0x0E, 0xFE, 0x00, 0x00, 
0x08, 0xFE, 0x03, 0x00, 0x01, 0x86, 0x0C, 0xFE, 0x00, 0x03, 0xF3, 0x70, 0x03, 0x00, 0x08, 0x00, 
0x00, 0x03, 0x25, 0x86, 0xF8, 0x00, 0x42, 0xFE, 0x00, 0x03, 0xFD, 0xB4, 0x07, 0x00, 0x06, 0x00, 
0x0F, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0xB4, 0x0A, 0xFE, 0x00, 0x03, 0xFD, 0xA4, 
0x07, 0x00, 0x06, 0x00, 0x00, 0x04, 0x3E, 0x97, 0xD9, 0xF5, 0x44, 0xFE, 0x01, 0xE6, 0x01, 0x31, 
0x06, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0xCD, 0x09, 0xFE, 0x01, 0xE6, 
0x01, 0x31, 0x05, 0x00, 0x00, 0x03, 0x07, 0x86, 0xEF, 0x00, 0x46, 0xFE, 0x01, 0xF3, 0x01, 0x70, 
0x06, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0xD9, 0x08, 0xFE, 0x01, 0xA4, 
0x01, 0x03, 0x04, 0x00, 0x00, 0x03, 0x1D, 0xC4, 0xFB, 0x00, 0x46, 0xFE, 0x00, 0x03, 0xFB, 0xA4, 
0x07, 0x00, 0x06, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0xE6, 0x06, 0xFE, 
0x01, 0xFB, 0x01, 0x70, 0x04, 0x00, 0x00, 0x03, 0x03, 0x97, 0xFB, 0x00, 0x46, 0xFE, 0x00, 0x03, 
0xFD, 0xB4, 0x1D, 0x00, 0x06, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0xEF, 
0x05, 0xFE, 0x01, 0xF3, 0x01, 0x31, 0x04, 0x00, 0x01, 0x4B, 0x01, 0xEF, 0x46, 0xFE, 0x00, 0x03, 
0xFD, 0xC4, 0x1D, 0x00, 0x06, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0xF3, 
0x04, 0xFE, 0x01, 0xF5, 0x01, 0x1D, 0x04, 0x00, 0x01, 0x97, 0x01, 0xFD, 0x45, 0xFE, 0x00, 0x03, 
0xFD, 0xCD, 0x25, 0x00, 0x07, 0x00, 0x19, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0xEC, 
0x03, 0xFE, 0x01, 0xF8, 0x01, 0x3E, 0x03, 0x00, 0x01, 0x03, 0x01, 0xCD, 0x46, 0xFE, 0x01, 0xCD, 
0x01, 0x31, 0x07, 0x00, 0x1B, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x00, 0x05, 0xCD, 0xFE, 
0xFE, 0xFD, 0x4B, 0x00, 0x03, 0x00, 0x01, 0x07, 0x01, 0xEC, 0x44, 0xFE, 0x00, 0x03, 0xFD, 0xCD, 
0x31, 0x00, 0x07, 0x00, 0x1D, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x00, 0x04, 0xA4, 0xFE, 
0xFD, 0x70, 0x03, 0x00, 0x01, 0x02, 0x01, 0xE6, 0x43, 0xFE, 0x00, 0x03, 0xF5, 0xA4, 0x1D, 0x00, 
0x07, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x00, 0x03, 0x86, 0xFE, 0x86, 0x00, 
0x03, 0x00, 0x01, 0x03, 0x01, 0xD9, 0x42, 0xFE, 0x00, 0x03, 0xEC, 0x76, 0x03, 0x00, 0x07, 0x00, 
0x21, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0x4B, 0x01, 0xA4, 0x04, 0x00, 0x01, 0xCD, 
0x40, 0xFE, 0x00, 0x03, 0xFD, 0xCD, 0x3E, 0x00, 0x08, 0x00, 0x23, 0xFE, 0x00, 0x00, 0x08, 0xFE, 
0x03, 0x00, 0x01, 0x0D, 0x04, 0x00, 0x01, 0xA4, 0x3F, 0xFE, 0x00, 0x03, 0xF3, 0xA4, 0x0D, 0x00, 
0x08, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x03, 0x00, 0x01, 0x97, 
0x3E, 0xFE, 0x00, 0x03, 0xEC, 0x70, 0x03, 0x00, 0x07, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x08, 0xFE, 
0x06, 0x00, 0x01, 0x60, 0x3C, 0xFE, 0x00, 0x03, 0xFD, 0xCD, 0x4B, 0x00, 0x08, 0x00, 0x2A, 0xFE, 
0x00, 0x00, 0x08, 0xFE, 0x05, 0x00, 0x01, 0x0D, 0x01, 0xF5, 0x3C, 0xFE, 0x01, 0x76, 0x08, 0x00, 
0x2C, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x05, 0x00, 0x01, 0xCD, 0x3C, 0xFE, 0x01, 0x86, 0x06, 0x00, 
0x2F, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x04, 0x00, 0x01, 0x60, 0x3C, 0xFE, 0x01, 0xC4, 0x05, 0x00, 
0x31, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x01, 0xF3, 0x20, 0xFE, 0x01, 0xEF, 
0x1B, 0xFE, 0x01, 0x97, 0x04, 0x00, 0x32, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x04, 0x00, 0x01, 0x97, 
0x20, 0xFE, 0x00, 0x03, 0xD9, 0x1D, 0xFD, 0x00, 0x1A, 0xFE, 0x01, 0x97, 0x03, 0x00, 0x33, 0xFE, 
0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x07, 0x01, 0xFD, 0x1F, 0xFE, 0x00, 0x04, 0xF5, 0x1D, 
0x00, 0xD9, 0x1A, 0xFE, 0x01, 0x86, 0x03, 0x00, 0x33, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 
0x01, 0x86, 0x20, 0xFE, 0x00, 0x04, 0x70, 0x00, 0x00, 0x4B, 0x1A, 0xFE, 0x01, 0xA4, 0x03, 0x00, 
0x33, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x04, 0x00, 0x01, 0xD9, 0x1F, 0xFE, 0x01, 0xCD, 0x04, 0x00, 
0x01, 0xEC, 0x19, 0xFE, 0x01, 0xE6, 0x03, 0x00, 0x33, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 
0x01, 0x07, 0x01, 0xFD, 0x1E, 0xFE, 0x01, 0xF3, 0x01, 0x07, 0x04, 0x00, 0x01, 0x70, 0x19, 0xFE, 
0x01, 0xFB, 0x01, 0x03, 0x03, 0x00, 0x32, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 0x01, 0x76, 
0x1E, 0xFE, 0x01, 0xFD, 0x01, 0x4B, 0x05, 0x00, 0x01, 0x03, 0x01, 0xF3, 0x19, 0xFE, 0x01, 0x3E, 
0x03, 0x00, 0x32, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 0x01, 0xA4, 0x1E, 0xFE, 0x01, 0xA4, 
0x03, 0x00, 0x01, 0x03, 0x03, 0x00, 0x01, 0x97, 0x19, 0xFE, 0x01, 0x86, 0x03, 0x00, 0x32, 0xFE, 
0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 0x01, 0xC4, 0x1D, 0xFE, 0x01, 0xEC, 0x01, 0x03, 0x03, 0x00, 
0x00, 0x06, 0x83, 0x03, 0x00, 0x00, 0x07, 0xFB, 0x18, 0xFE, 0x01, 0xA4, 0x03, 0x00, 0x32, 0xFE, 
0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 0x01, 0xD9, 0x1C, 0xFE, 0x01, 0xFB, 0x01, 0x31, 0x03, 0x00, 
0x00, 0x03, 0x52, 0xC3, 0x5A, 0x00, 0x03, 0x00, 0x01, 0xC4, 0x18, 0xFE, 0x01, 0xB4, 0x03, 0x00, 
0x32, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 0x01, 0xEC, 0x1C, 0xFE, 0x01, 0x86, 0x03, 0x00, 
0x00, 0x08, 0x18, 0xB5, 0xC3, 0xA9, 0x03, 0x00, 0x00, 0x31, 0x18, 0xFE, 0x01, 0xCD, 0x03, 0x00, 
0x32, 0xFE, 0x00, 0x00, 0x05, 0xFE, 0x04, 0x00, 0x01, 0xF3, 0x1B, 0xFE, 0x00, 0x06, 0xF3, 0x03, 
0x00, 0x00, 0x03, 0x9F, 0x03, 0xC3, 0x01, 0x40, 0x03, 0x00, 0x01, 0xD9, 0x17, 0xFE, 0x01, 0xD9, 
0x03, 0x00, 0x32, 0xFE, 0x00, 0x00, 0x05, 0xFE, 0x04, 0x00, 0x01, 0xF3, 0x1B, 0xFE, 0x01, 0x86, 
0x03, 0x00, 0x01, 0x67, 0x04, 0xC3, 0x01, 0x98, 0x03, 0x00, 0x01, 0x60, 0x17, 0xFE, 0x01, 0xA4, 
0x03, 0x00, 0x32, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 0x01, 0xEC, 0x1A, 0xFE, 0x00, 0x06, 
0xF5, 0x03, 0x00, 0x00, 0x05, 0xB5, 0x05, 0xC3, 0x01, 0x20, 0x03, 0x00, 0x01, 0xEF, 0x16, 0xFE, 
0x01, 0x70, 0x03, 0x00, 0x32, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 0x01, 0xD9, 0x1A, 0xFE, 
0x01, 0xA4, 0x03, 0x00, 0x01, 0x67, 0x06, 0xC3, 0x01, 0x83, 0x03, 0x00, 0x01, 0xB4, 0x16, 0xFE, 
0x01, 0x25, 0x03, 0x00, 0x32, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 0x01, 0xC4, 0x1A, 0xFE, 
0x00, 0x05, 0x25, 0x00, 0x00, 0x03, 0xB5, 0x00, 0x06, 0xC3, 0x00, 0x05, 0xB5, 0x03, 0x00, 0x00, 
0x60, 0x00, 0x15, 0xFE, 0x01, 0xEF, 0x04, 0x00, 0x32, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 
0x01, 0xA4, 0x19, 0xFE, 0x01, 0xEF, 0x03, 0x00, 0x01, 0x47, 0x08, 0xC3, 0x00, 0x05, 0x20, 0x00, 
0x00, 0x07, 0xFD, 0x00, 0x14, 0xFE, 0x01, 0x86, 0x03, 0x00, 0x33, 0xFE, 0x00, 0x00, 0x06, 0xFE, 
0x03, 0x00, 0x01, 0x86, 0x19, 0xFE, 0x01, 0x97, 0x03, 0x00, 0x01, 0x8B, 0x08, 0xC3, 0x01, 0x5A, 
0x03, 0x00, 0x01, 0xEC, 0x13, 0xFE, 0x01, 0xF8, 0x01, 0x07, 0x03, 0x00, 0x33, 0xFE, 0x00, 0x00, 
0x06, 0xFE, 0x03, 0x00, 0x01, 0x31, 0x19, 0xFE, 0x00, 0x05, 0x31, 0x00, 0x00, 0x03, 0xB5, 0x00, 
0x08, 0xC3, 0x01, 0x8B, 0x03, 0x00, 0x01, 0xB4, 0x13, 0xFE, 0x01, 0xA4, 0x03, 0x00, 0x34, 0xFE, 
0x00, 0x00, 0x06, 0xFE, 0x04, 0x00, 0x01, 0xF5, 0x17, 0xFE, 0x01, 0xFB, 0x03, 0x00, 0x01, 0x40, 
0x09, 0xC3, 0x00, 0x05, 0xB5, 0x03, 0x00, 0x00, 0x60, 0x00, 0x12, 0xFE, 0x01, 0xF3, 0x01, 0x03, 
0x03, 0x00, 0x34, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0xD9, 0x17, 0xFE, 0x01, 0xEF, 
0x03, 0x00, 0x01, 0x67, 0x0A, 0xC3, 0x00, 0x05, 0x20, 0x00, 0x00, 0x07, 0xFD, 0x00, 0x11, 0xFE, 
0x01, 0x60, 0x04, 0x00, 0x34, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x97, 0x17, 0xFE, 
0x01, 0xD9, 0x03, 0x00, 0x01, 0x83, 0x0A, 0xC3, 0x01, 0x52, 0x03, 0x00, 0x01, 0xEF, 0x10, 0xFE, 
0x01, 0xD9, 0x04, 0x00, 0x35, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x4B, 0x17, 0xFE, 
0x01, 0xB4, 0x03, 0x00, 0x01, 0x98, 0x0A, 0xC3, 0x01, 0x83, 0x03, 0x00, 0x01, 0xB4, 0x0F, 0xFE, 
0x01, 0xF5, 0x01, 0x0D, 0x03, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x03, 
0x01, 0xF5, 0x16, 0xFE, 0x01, 0x86, 0x03, 0x00, 0x01, 0xAD, 0x0A, 0xC3, 0x01, 0xA9, 0x03, 0x00, 
0x01, 0x86, 0x0F, 0xFE, 0x01, 0x60, 0x04, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 
0x01, 0xB4, 0x16, 0xFE, 0x00, 0x05, 0x60, 0x00, 0x00, 0x03, 0xBD, 0x00, 0x0A, 0xC3, 0x01, 0xBD, 
0x03, 0x00, 0x01, 0x70, 0x0E, 0xFE, 0x01, 0xB4, 0x04, 0x00, 0x37, 0xFE, 0x00, 0x00, 0x08, 0xFE, 
0x03, 0x00, 0x01, 0x4B, 0x16, 0xFE, 0x00, 0x04, 0x31, 0x00, 0x00, 0x20, 0x0C, 0xC3, 0x00, 0x04, 
0x03, 0x00, 0x00, 0x60, 0x0D, 0xFE, 0x01, 0xEF, 0x01, 0x03, 0x03, 0x00, 0x38, 0xFE, 0x00, 0x00, 
0x08, 0xFE, 0x04, 0x00, 0x01, 0xEF, 0x15, 0xFE, 0x00, 0x04, 0x03, 0x00, 0x00, 0x40, 0x0C, 0xC3, 
0x00, 0x04, 0x0C, 0x00, 0x00, 0x4B, 0x0C, 0xFE, 0x01, 0xFB, 0x01, 0x31, 0x04, 0x00, 0x38, 0xFE, 
0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0xA4, 0x14, 0xFE, 0x01, 0xF8, 0x03, 0x00, 0x01, 0x52, 
0x0C, 0xC3, 0x00, 0x04, 0x20, 0x00, 0x00, 0x31, 0x0C, 0xFE, 0x01, 0x86, 0x04, 0x00, 0x39, 0xFE, 
0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0x25, 0x01, 0xFD, 0x13, 0xFE, 0x01, 0xFB, 0x03, 0x00, 
0x01, 0x47, 0x0C, 0xC3, 0x00, 0x04, 0x29, 0x00, 0x00, 0x0D, 0x0B, 0xFE, 0x01, 0xEC, 0x01, 0x03, 
0x03, 0x00, 0x3A, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x04, 0x00, 0x01, 0xCD, 0x14, 0xFE, 0x03, 0x00, 
0x01, 0x47, 0x0C, 0xC3, 0x00, 0x04, 0x40, 0x00, 0x00, 0x03, 0x0A, 0xFE, 0x01, 0xFD, 0x01, 0x3E, 
0x03, 0x00, 0x3B, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 0x01, 0x3E, 0x0A, 0xFE, 0x01, 0xFD, 
0x01, 0xF3, 0x08, 0xFE, 0x00, 0x04, 0x02, 0x00, 0x00, 0x40, 0x0C, 0xC3, 0x01, 0x47, 0x03, 0x00, 
0x00, 0x04, 0xFB, 0xFE, 0xFE, 0xF3, 0x06, 0xFE, 0x01, 0xCD, 0x04, 0x00, 0x3B, 0xFE, 0x00, 0x00, 
0x0A, 0xFE, 0x04, 0x00, 0x01, 0xD9, 0x08, 0xFE, 0x00, 0x05, 0xCD, 0x07, 0x00, 0x31, 0xEF, 0x00, 
0x06, 0xFE, 0x00, 0x04, 0x0D, 0x00, 0x00, 0x32, 0x0C, 0xC3, 0x01, 0x52, 0x03, 0x00, 0x00, 0x06, 
0xF8, 0xE6, 0x0D, 0x00, 0x1D, 0xE6, 0x04, 0xFE, 0x01, 0x4B, 0x03, 0x00, 0x3C, 0xFE, 0x00, 0x00, 
0x0B, 0xFE, 0x03, 0x00, 0x01, 0x4B, 0x07, 0xFE, 0x01, 0xE6, 0x04, 0x00, 0x01, 0x1D, 0x01, 0xFD, 
0x05, 0xFE, 0x00, 0x04, 0x1D, 0x00, 0x00, 0x29, 0x0C, 0xC3, 0x00, 0x06, 0x29, 0x00, 0x00, 0x07, 
0xF3, 0x03, 0x03, 0x00, 0x00, 0x06, 0x07, 0xF3, 0xFE, 0xFE, 0xF5, 0x03, 0x03, 0x00, 0x3C, 0xFE, 
0x00, 0x00, 0x0B, 0xFE, 0x04, 0x00, 0x01, 0xE6, 0x06, 0xFE, 0x01, 0x4B, 0x05, 0x00, 0x01, 0xC4, 
0x05, 0xFE, 0x00, 0x04, 0x31, 0x00, 0x00, 0x20, 0x0C, 0xC3, 0x00, 0x05, 0x05, 0x00, 0x00, 0x4B, 
0x86, 0x00, 0x05, 0x00, 0x00, 0x04, 0x97, 0xFE, 0xFE, 0xC4, 0x03, 0x00, 0x3D, 0xFE, 0x00, 0x00, 
0x0C, 0xFE, 0x03, 0x00, 0x01, 0x31, 0x01, 0xFD, 0x05, 0xFE, 0x01, 0x02, 0x05, 0x00, 0x01, 0x86, 
0x05, 0xFE, 0x00, 0x04, 0x3E, 0x00, 0x00, 0x18, 0x0B, 0xC3, 0x01, 0xB5, 0x03, 0x00, 0x01, 0x76, 
0x01, 0x4B, 0x05, 0x00, 0x00, 0x04, 0x4B, 0xFE, 0xFE, 0x70, 0x03, 0x00, 0x3D, 0xFE, 0x00, 0x00, 
0x0C, 0xFE, 0x04, 0x00, 0x01, 0xB4, 0x04, 0xFE, 0x01, 0xFB, 0x06, 0x00, 0x01, 0x60, 0x05, 0xFE, 
0x00, 0x04, 0x4B, 0x00, 0x00, 0x0C, 0x0B, 0xC3, 0x01, 0x98, 0x03, 0x00, 0x01, 0xA4, 0x01, 0x1D, 
0x05, 0x00, 0x00, 0x04, 0x25, 0xFE, 0xFE, 0x0D, 0x03, 0x00, 0x3D, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 
0x03, 0x00, 0x01, 0x07, 0x01, 0xF5, 0x04, 0xFE, 0x01, 0x0D, 0x05, 0x00, 0x01, 0x86, 0x05, 0xFE, 
0x00, 0x05, 0x60, 0x00, 0x00, 0x03, 0xB5, 0x00, 0x0A, 0xC3, 0x01, 0x83, 0x03, 0x00, 0x01, 0xD9, 
0x01, 0x4B, 0x05, 0x00, 0x00, 0x03, 0x4B, 0xFE, 0xEF, 0x00, 0x04, 0x00, 0x3D, 0xFE, 0x00, 0x00, 
0x0D, 0xFE, 0x04, 0x00, 0x01, 0x76, 0x04, 0xFE, 0x01, 0x76, 0x05, 0x00, 0x01, 0xD9, 0x05, 0xFE, 
0x01, 0xA4, 0x03, 0x00, 0x01, 0x83, 0x0A, 0xC3, 0x01, 0x52, 0x03, 0x00, 0x01, 0xEF, 0x01, 0xA4, 
0x05, 0x00, 0x00, 0x03, 0xB4, 0xFE, 0xB4, 0x00, 0x03, 0x00, 0x3E, 0xFE, 0x00, 0x00, 0x0E, 0xFE, 
0x04, 0x00, 0x01, 0xD9, 0x03, 0xFE, 0x01, 0xEF, 0x01, 0x07, 0x03, 0x00, 0x01, 0x4B, 0x06, 0xFE, 
0x01, 0xEF, 0x03, 0x00, 0x01, 0x05, 0x01, 0x9F, 0x08, 0xC3, 0x00, 0x08, 0x83, 0x03, 0x00, 0x00, 
0x07, 0xFB, 0xF8, 0x1D, 0x03, 0x00, 0x00, 0x04, 0x25, 0xFB, 0xFE, 0x4B, 0x03, 0x00, 0x3E, 0xFE, 
0x00, 0x00, 0x0F, 0xFE, 0x03, 0x00, 0x01, 0x07, 0x01, 0xF3, 0x03, 0xFE, 0x00, 0x05, 0xEF, 0x60, 
0x1D, 0x86, 0xFB, 0x00, 0x07, 0xFE, 0x01, 0x3E, 0x03, 0x00, 0x00, 0x09, 0x03, 0x47, 0x8B, 0xA9, 
0xBD, 0xB5, 0xA9, 0x7B, 0x32, 0x00, 0x04, 0x00, 0x00, 0x0A, 0xA4, 0xFE, 0xFE, 0xF3, 0x70, 0x1D, 
0x70, 0xF5, 0xFE, 0xD9, 0x04, 0x00, 0x3E, 0xFE, 0x00, 0x00, 0x0F, 0xFE, 0x04, 0x00, 0x01, 0x3E, 
0x01, 0xFD, 0x0E, 0xFE, 0x01, 0xEF, 0x01, 0x1D, 0x0E, 0x00, 0x01, 0x25, 0x01, 0xFD, 0x07, 0xFE, 
0x01, 0xFD, 0x01, 0x31, 0x03, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x04, 0x00, 0x01, 0x76, 
0x0F, 0xFE, 0x01, 0xEF, 0x01, 0x1D, 0x0C, 0x00, 0x01, 0x60, 0x01, 0xF5, 0x08, 0xFE, 0x01, 0xCD, 
0x04, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x11, 0xFE, 0x04, 0x00, 0x01, 0x86, 0x0F, 0xFE, 0x00, 0x03, 
0xF8, 0xB4, 0x25, 0x00, 0x08, 0x00, 0x01, 0x3E, 0x01, 0xCD, 0x09, 0xFE, 0x01, 0xF3, 0x01, 0x1D, 
0x03, 0x00, 0x40, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x04, 0x00, 0x01, 0x76, 0x01, 0xFD, 0x0F, 0xFE, 
0x00, 0x09, 0xFD, 0xE6, 0xC4, 0x97, 0x70, 0x86, 0x97, 0xC4, 0xF3, 0x00, 0x0A, 0xFE, 0x01, 0xF8, 
0x01, 0x3E, 0x04, 0x00, 0x40, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x05, 0x00, 0x01, 0x76, 0x01, 0xFD, 
0x20, 0xFE, 0x01, 0xFD, 0x01, 0x60, 0x04, 0x00, 0x41, 0xFE, 0x00, 0x00, 0x13, 0xFE, 0x05, 0x00, 
0x01, 0x4B, 0x01, 0xF5, 0x1E, 0xFE, 0x01, 0xFB, 0x01, 0x70, 0x04, 0x00, 0x42, 0xFE, 0x00, 0x00, 
0x14, 0xFE, 0x05, 0x00, 0x01, 0x1D, 0x01, 0xE6, 0x1C, 0xFE, 0x01, 0xF3, 0x01, 0x3E, 0x04, 0x00, 
0x43, 0xFE, 0x00, 0x00, 0x16, 0xFE, 0x04, 0x00, 0x01, 0x03, 0x01, 0xB4, 0x1A, 0xFE, 0x01, 0xE6, 
0x01, 0x0D, 0x04, 0x00, 0x44, 0xFE, 0x00, 0x00, 0x17, 0xFE, 0x05, 0x00, 0x01, 0x3E, 0x01, 0xE6, 
0x16, 0xFE, 0x00, 0x03, 0xEF, 0x76, 0x03, 0x00, 0x04, 0x00, 0x45, 0xFE, 0x00, 0x00, 0x18, 0xFE, 
0x06, 0x00, 0x01, 0x70, 0x01, 0xF3, 0x12, 0xFE, 0x01, 0xE6, 0x01, 0x60, 0x06, 0x00, 0x46, 0xFE, 
0x00, 0x00, 0x19, 0xFE, 0x06, 0x00, 0x00, 0x04, 0x03, 0x60, 0xCD, 0xFB, 0x0C, 0xFE, 0x00, 0x03, 
0xF3, 0xC4, 0x4B, 0x00, 0x07, 0x00, 0x47, 0xFE, 0x00, 0x00, 0x1B, 0xFE, 0x07, 0x00, 0x00, 0x0D, 
0x07, 0x70, 0xA4, 0xD9, 0xEF, 0xFB, 0xFB, 0xF5, 0xEF, 0xEC, 0xCD, 0x86, 0x25, 0x00, 0x08, 0x00, 
0x49, 0xFE, 0x00, 0x00, 0x1D, 0xFE, 0x18, 0x00, 0x4B, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x14, 0x00, 
0x4D, 0xFE, 0x00, 0x00, 0x21, 0xFE, 0x0F, 0x00, 0x50, 0xFE, 0x00, 0x00, 0x27, 0xFE, 0x03, 0x00, 
0x56, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x01, 
};

constexpr unsigned char parrot05[] = {
0x42, 0x4D, 0xE2, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x04, 0x00, 0x00, 0x28, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x01, 0x00, 
0x00, 0x00, 0xB0, 0x09, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0xFF, 0x00, 
0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x08, 0x04, 
0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x0B, 0x05, 0x08, 0x00, 0x06, 0x0A, 0x07, 0x00, 0x06, 0x08, 
0x0E, 0x00, 0x0E, 0x0B, 0x04, 0x00, 0x0F, 0x07, 0x12, 0x00, 0x0B, 0x0C, 0x12, 0x00, 0x16, 0x0B, 
0x12, 0x00, 0x0C, 0x0B, 0x17, 0x00, 0x0C, 0x10, 0x0D, 0x00, 0x13, 0x11, 0x08, 0x00, 0x12, 0x0C, 
0x1C, 0x00, 0x19, 0x0C, 0x1B, 0x00, 0x18, 0x10, 0x10, 0x00, 0x0A, 0x0D, 0x21, 0x00, 0x08, 0x13, 
0x10, 0x00, 0x1E, 0x0E, 0x1A, 0x00, 0x0A, 0x12, 0x18, 0x00, 0x1B, 0x15, 0x0E, 0x00, 0x1C, 0x10, 
0x1F, 0x00, 0x14, 0x11, 0x1F, 0x00, 0x12, 0x15, 0x13, 0x00, 0x23, 0x10, 0x24, 0x00, 0x1B, 0x10, 
0x28, 0x00, 0x0E, 0x15, 0x1C, 0x00, 0x0E, 0x1A, 0x0D, 0x00, 0x19, 0x19, 0x0D, 0x00, 0x11, 0x13, 
0x25, 0x00, 0x23, 0x13, 0x1F, 0x00, 0x12, 0x1A, 0x15, 0x00, 0x12, 0x13, 0x2E, 0x00, 0x25, 0x1A, 
0x16, 0x00, 0x2E, 0x14, 0x30, 0x00, 0x17, 0x18, 0x2C, 0x00, 0x20, 0x20, 0x0F, 0x00, 0x2D, 0x19, 
0x23, 0x00, 0x13, 0x1C, 0x23, 0x00, 0x13, 0x21, 0x13, 0x00, 0x17, 0x1F, 0x1A, 0x00, 0x24, 0x16, 
0x34, 0x00, 0x32, 0x14, 0x37, 0x00, 0x17, 0x17, 0x38, 0x00, 0x2E, 0x19, 0x2B, 0x00, 0x1C, 0x1D, 
0x32, 0x00, 0x15, 0x21, 0x29, 0x00, 0x32, 0x23, 0x1B, 0x00, 0x26, 0x26, 0x15, 0x00, 0x1D, 0x25, 
0x20, 0x00, 0x16, 0x29, 0x15, 0x00, 0x3B, 0x1A, 0x3B, 0x00, 0x1D, 0x1B, 0x43, 0x00, 0x2F, 0x1B, 
0x40, 0x00, 0x36, 0x1E, 0x34, 0x00, 0x3D, 0x20, 0x33, 0x00, 0x23, 0x21, 0x3D, 0x00, 0x3B, 0x20, 
0x3D, 0x00, 0x3A, 0x29, 0x22, 0x00, 0x44, 0x1D, 0x47, 0x00, 0x1F, 0x1F, 0x4D, 0x00, 0x2C, 0x2D, 
0x1A, 0x00, 0x1A, 0x28, 0x31, 0x00, 0x22, 0x2B, 0x27, 0x00, 0x37, 0x1F, 0x4D, 0x00, 0x3F, 0x23, 
0x41, 0x00, 0x26, 0x27, 0x48, 0x00, 0x47, 0x27, 0x3E, 0x00, 0x4E, 0x22, 0x4E, 0x00, 0x1F, 0x2F, 
0x39, 0x00, 0x25, 0x32, 0x2D, 0x00, 0x25, 0x26, 0x56, 0x00, 0x3F, 0x24, 0x59, 0x00, 0x1F, 0x39, 
0x1E, 0x00, 0x35, 0x37, 0x1E, 0x00, 0x47, 0x33, 0x27, 0x00, 0x53, 0x24, 0x58, 0x00, 0x4F, 0x2B, 
0x42, 0x00, 0x2B, 0x2C, 0x50, 0x00, 0x28, 0x28, 0x5F, 0x00, 0x4D, 0x2A, 0x4D, 0x00, 0x2A, 0x38, 
0x30, 0x00, 0x55, 0x30, 0x49, 0x00, 0x30, 0x2F, 0x59, 0x00, 0x60, 0x29, 0x62, 0x00, 0x2B, 0x2C, 
0x6B, 0x00, 0x49, 0x2B, 0x68, 0x00, 0x55, 0x2F, 0x59, 0x00, 0x26, 0x3A, 0x45, 0x00, 0x31, 0x3F, 
0x36, 0x00, 0x58, 0x3E, 0x2E, 0x00, 0x65, 0x2B, 0x6B, 0x00, 0x26, 0x46, 0x26, 0x00, 0x2F, 0x30, 
0x6F, 0x00, 0x5C, 0x32, 0x59, 0x00, 0x47, 0x46, 0x24, 0x00, 0x62, 0x36, 0x52, 0x00, 0x37, 0x36, 
0x61, 0x00, 0x51, 0x31, 0x75, 0x00, 0x32, 0x33, 0x7A, 0x00, 0x2A, 0x41, 0x4E, 0x00, 0x5E, 0x44, 
0x34, 0x00, 0x38, 0x47, 0x3D, 0x00, 0x65, 0x38, 0x66, 0x00, 0x75, 0x32, 0x79, 0x00, 0x2D, 0x52, 
0x2D, 0x00, 0x58, 0x35, 0x81, 0x00, 0x37, 0x37, 0x86, 0x00, 0x69, 0x4A, 0x37, 0x00, 0x3C, 0x3E, 
0x71, 0x00, 0x72, 0x3E, 0x61, 0x00, 0x53, 0x52, 0x2C, 0x00, 0x39, 0x4D, 0x46, 0x00, 0x30, 0x49, 
0x57, 0x00, 0x62, 0x37, 0x86, 0x00, 0x32, 0x58, 0x2B, 0x00, 0x72, 0x3D, 0x71, 0x00, 0x58, 0x56, 
0x30, 0x00, 0x2F, 0x5B, 0x31, 0x00, 0x3E, 0x3D, 0x93, 0x00, 0x86, 0x3A, 0x88, 0x00, 0x73, 0x52, 
0x3E, 0x00, 0x3F, 0x54, 0x4B, 0x00, 0x45, 0x45, 0x7E, 0x00, 0x69, 0x3D, 0x90, 0x00, 0x85, 0x48, 
0x6F, 0x00, 0x81, 0x45, 0x81, 0x00, 0x41, 0x43, 0xA1, 0x00, 0x37, 0x56, 0x66, 0x00, 0x7F, 0x5A, 
0x41, 0x00, 0x46, 0x5C, 0x4F, 0x00, 0x93, 0x3F, 0x98, 0x00, 0x38, 0x66, 0x36, 0x00, 0x63, 0x63, 
0x34, 0x00, 0x73, 0x43, 0xA0, 0x00, 0x4F, 0x4D, 0x8E, 0x00, 0x9C, 0x42, 0xA1, 0x00, 0x3D, 0x5D, 
0x6D, 0x00, 0x4C, 0x63, 0x55, 0x00, 0x95, 0x51, 0x7C, 0x00, 0x89, 0x62, 0x4A, 0x00, 0x9F, 0x45, 
0xA5, 0x00, 0x4B, 0x4B, 0xB3, 0x00, 0x50, 0x53, 0x97, 0x00, 0x51, 0x68, 0x5A, 0x00, 0x7E, 0x4A, 
0xB1, 0x00, 0x93, 0x51, 0x94, 0x00, 0x40, 0x75, 0x40, 0x00, 0xAB, 0x49, 0xB0, 0x00, 0x56, 0x57, 
0xA1, 0x00, 0x71, 0x72, 0x3F, 0x00, 0x50, 0x6C, 0x60, 0x00, 0x42, 0x67, 0x79, 0x00, 0x98, 0x6A, 
0x53, 0x00, 0x50, 0x50, 0xC3, 0x00, 0xA5, 0x5A, 0x8A, 0x00, 0xA0, 0x57, 0x9C, 0x00, 0x87, 0x4F, 
0xC1, 0x00, 0x56, 0x72, 0x66, 0x00, 0xB8, 0x4F, 0xBF, 0x00, 0x44, 0x80, 0x45, 0x00, 0x60, 0x60, 
0xAF, 0x00, 0xA8, 0x5C, 0xA9, 0x00, 0x7D, 0x7E, 0x46, 0x00, 0x59, 0x58, 0xD5, 0x00, 0x8F, 0x55, 
0xCD, 0x00, 0xA5, 0x75, 0x5D, 0x00, 0xB5, 0x63, 0x98, 0x00, 0x5D, 0x7A, 0x6D, 0x00, 0xC6, 0x54, 
0xCB, 0x00, 0x4C, 0x76, 0x8A, 0x00, 0x4B, 0x89, 0x4B, 0x00, 0x61, 0x7F, 0x6C, 0x00, 0x69, 0x68, 
0xBC, 0x00, 0x5E, 0x5F, 0xE4, 0x00, 0x9B, 0x5B, 0xDD, 0x00, 0xCD, 0x59, 0xD5, 0x00, 0xB9, 0x64, 
0xB8, 0x00, 0xB2, 0x7E, 0x63, 0x00, 0x88, 0x8B, 0x4D, 0x00, 0x66, 0x84, 0x71, 0x00, 0xD8, 0x5B, 
0xDD, 0x00, 0xC7, 0x6D, 0xA7, 0x00, 0x64, 0x62, 0xEE, 0x00, 0x9F, 0x60, 0xE5, 0x00, 0x51, 0x96, 
0x51, 0x00, 0x6E, 0x6F, 0xCC, 0x00, 0x54, 0x81, 0x9B, 0x00, 0x6B, 0x8A, 0x76, 0x00, 0xA9, 0x62, 
0xEB, 0x00, 0x68, 0x66, 0xF4, 0x00, 0xDD, 0x60, 0xE2, 0x00, 0xC3, 0x6B, 0xC6, 0x00, 0xC1, 0x88, 
0x69, 0x00, 0x68, 0x8C, 0x7B, 0x00, 0x96, 0x96, 0x51, 0x00, 0x68, 0x69, 0xFF, 0x00, 0xE4, 0x62, 
0xED, 0x00, 0xD6, 0x75, 0xB3, 0x00, 0xD0, 0x6F, 0xCF, 0x00, 0xB1, 0x66, 0xF8, 0x00, 0x5A, 0xA1, 
0x55, 0x00, 0x77, 0x77, 0xDB, 0x00, 0xCA, 0x8F, 0x6F, 0x00, 0xA1, 0x9F, 0x56, 0x00, 0xB7, 0x6C, 
0xFE, 0x00, 0x5D, 0x8E, 0xAB, 0x00, 0xD7, 0x76, 0xD6, 0x00, 0xF3, 0x69, 0xFA, 0x00, 0xF7, 0x68, 
0xFF, 0x00, 0x5A, 0xA9, 0x5D, 0x00, 0xD7, 0x98, 0x74, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0xEB, 0x80, 
0xC5, 0x00, 0xE0, 0x7B, 0xE3, 0x00, 0x85, 0x82, 0xF1, 0x00, 0xAD, 0xAC, 0x5A, 0x00, 0x64, 0x99, 
0xB8, 0x00, 0xE1, 0xA0, 0x7A, 0x00, 0x63, 0xB5, 0x62, 0x00, 0xF8, 0x87, 0xCF, 0x00, 0x85, 0x88, 
0xF9, 0x00, 0xF1, 0x83, 0xF1, 0x00, 0xE8, 0xA6, 0x81, 0x00, 0xFF, 0x8C, 0xD7, 0x00, 0x8B, 0x8D, 
0xFF, 0x00, 0xF3, 0xAB, 0x80, 0x00, 0xF8, 0x88, 0xFA, 0x00, 0x68, 0xC2, 0x68, 0x00, 0xBE, 0xBE, 
0x67, 0x00, 0x6D, 0xA9, 0xCB, 0x00, 0xF9, 0xB0, 0x86, 0x00, 0xFF, 0x8C, 0xFF, 0x00, 0x70, 0xCB, 
0x6E, 0x00, 0xFE, 0xB5, 0x8B, 0x00, 0xC6, 0xC6, 0x6A, 0x00, 0x71, 0xD3, 0x73, 0x00, 0x78, 0xB7, 
0xDA, 0x00, 0xCE, 0xCF, 0x72, 0x00, 0x78, 0xDB, 0x78, 0x00, 0x7C, 0xE5, 0x7C, 0x00, 0x7F, 0xC4, 
0xEA, 0x00, 0xDB, 0xDD, 0x78, 0x00, 0x81, 0xED, 0x81, 0x00, 0xE3, 0xE5, 0x7E, 0x00, 0x88, 0xCF, 
0xF5, 0x00, 0x87, 0xF5, 0x84, 0x00, 0xEC, 0xEF, 0x87, 0x00, 0x89, 0xD6, 0xFE, 0x00, 0x87, 0xFA, 
0x8C, 0x00, 0xF1, 0xF3, 0x8C, 0x00, 0x89, 0xFF, 0x88, 0x00, 0xFB, 0xF9, 0x80, 0x00, 0xFF, 0xFF, 
0x87, 0x00, 0x06, 0xFE, 0x6E, 0x00, 0x0C, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x6C, 0x00, 0x0E, 0xFE, 
0x00, 0x00, 0x06, 0xFE, 0x6B, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x05, 0xFE, 0x04, 0x00, 0x01, 0x4C, 
0x60, 0x5B, 0x01, 0x07, 0x05, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x05, 0xFE, 0x03, 0x00, 0x01, 0x02, 
0x01, 0xE8, 0x5F, 0xEB, 0x01, 0x6D, 0x05, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x05, 0xFE, 0x03, 0x00, 
0x01, 0x30, 0x5E, 0xEB, 0x01, 0xE3, 0x01, 0x4C, 0x05, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x05, 0xFE, 
0x03, 0x00, 0x01, 0x6D, 0x16, 0xEB, 0x00, 0x08, 0xE8, 0xDB, 0xC2, 0xA7, 0x8D, 0x6D, 0x82, 0xDB, 
0x3F, 0xEB, 0x01, 0xDB, 0x01, 0x30, 0x05, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x05, 0xFE, 0x03, 0x00, 
0x01, 0x9A, 0x12, 0xEB, 0x00, 0x05, 0xE8, 0xB3, 0x6D, 0x22, 0x02, 0x00, 0x06, 0x00, 0x01, 0x4C, 
0x3E, 0xEB, 0x01, 0xCC, 0x01, 0x15, 0x05, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x04, 0xFE, 0x04, 0x00, 
0x01, 0xCC, 0x0F, 0xEB, 0x00, 0x04, 0xE0, 0x9A, 0x4C, 0x02, 0x0A, 0x00, 0x01, 0x22, 0x3D, 0xEB, 
0x01, 0x9A, 0x01, 0x02, 0x04, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x04, 0xFE, 0x03, 0x00, 0x01, 0x02, 
0x0E, 0xEB, 0x00, 0x03, 0xDB, 0x6D, 0x02, 0x00, 0x0C, 0x00, 0x01, 0x15, 0x01, 0xB3, 0x3B, 0xEB, 
0x01, 0xE3, 0x01, 0x66, 0x05, 0x00, 0x17, 0xFE, 0x00, 0x00, 0x04, 0xFE, 0x03, 0x00, 0x01, 0x22, 
0x0C, 0xEB, 0x00, 0x03, 0xD4, 0x66, 0x02, 0x00, 0x07, 0x00, 0x00, 0x07, 0x07, 0x4C, 0x6D, 0x8D, 
0xB3, 0xCC, 0xE0, 0x00, 0x3C, 0xEB, 0x01, 0xCC, 0x01, 0x22, 0x05, 0x00, 0x18, 0xFE, 0x00, 0x00, 
0x04, 0xFE, 0x03, 0x00, 0x01, 0x3B, 0x0A, 0xEB, 0x00, 0x03, 0xE3, 0x66, 0x02, 0x00, 0x06, 0x00, 
0x00, 0x03, 0x22, 0x7A, 0xC2, 0x00, 0x42, 0xEB, 0x01, 0x9A, 0x01, 0x02, 0x05, 0x00, 0x19, 0xFE, 
0x00, 0x00, 0x04, 0xFE, 0x03, 0x00, 0x01, 0x4C, 0x09, 0xEB, 0x01, 0xB3, 0x01, 0x10, 0x05, 0x00, 
0x00, 0x03, 0x07, 0x82, 0xDB, 0x00, 0x43, 0xEB, 0x01, 0xE3, 0x01, 0x5B, 0x05, 0x00, 0x1B, 0xFE, 
0x00, 0x00, 0x04, 0xFE, 0x03, 0x00, 0x01, 0x5B, 0x07, 0xEB, 0x01, 0xE3, 0x01, 0x66, 0x05, 0x00, 
0x00, 0x03, 0x10, 0x8D, 0xE3, 0x00, 0x44, 0xEB, 0x01, 0xB3, 0x01, 0x22, 0x05, 0x00, 0x1C, 0xFE, 
0x00, 0x00, 0x04, 0xFE, 0x03, 0x00, 0x01, 0x66, 0x06, 0xEB, 0x01, 0xD4, 0x01, 0x22, 0x04, 0x00, 
0x00, 0x03, 0x07, 0x9A, 0xE8, 0x00, 0x44, 0xEB, 0x01, 0xD4, 0x01, 0x4C, 0x06, 0x00, 0x1D, 0xFE, 
0x00, 0x00, 0x04, 0xFE, 0x03, 0x00, 0x01, 0x7A, 0x05, 0xEB, 0x01, 0xC2, 0x01, 0x07, 0x04, 0x00, 
0x01, 0x3B, 0x01, 0xDB, 0x44, 0xEB, 0x00, 0x03, 0xE0, 0x6D, 0x02, 0x00, 0x05, 0x00, 0x1F, 0xFE, 
0x00, 0x00, 0x04, 0xFE, 0x03, 0x00, 0x01, 0x66, 0x04, 0xEB, 0x01, 0xB3, 0x01, 0x02, 0x03, 0x00, 
0x01, 0x02, 0x01, 0x8D, 0x45, 0xEB, 0x01, 0x9A, 0x01, 0x07, 0x06, 0x00, 0x20, 0xFE, 0x00, 0x00, 
0x04, 0xFE, 0x03, 0x00, 0x01, 0x4C, 0x03, 0xEB, 0x01, 0x9A, 0x01, 0x02, 0x03, 0x00, 0x01, 0x10, 
0x01, 0xCC, 0x44, 0xEB, 0x01, 0xB3, 0x01, 0x22, 0x06, 0x00, 0x22, 0xFE, 0x00, 0x00, 0x04, 0xFE, 
0x03, 0x00, 0x00, 0x05, 0x22, 0xEB, 0xEB, 0xB3, 0x02, 0x00, 0x03, 0x00, 0x01, 0x22, 0x01, 0xDB, 
0x42, 0xEB, 0x00, 0x03, 0xE8, 0x9A, 0x22, 0x00, 0x06, 0x00, 0x24, 0xFE, 0x00, 0x00, 0x04, 0xFE, 
0x03, 0x00, 0x00, 0x04, 0x02, 0xE8, 0xCC, 0x02, 0x03, 0x00, 0x01, 0x3B, 0x01, 0xE3, 0x41, 0xEB, 
0x00, 0x03, 0xDB, 0x7A, 0x07, 0x00, 0x07, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x04, 0xFE, 0x04, 0x00, 
0x01, 0xC2, 0x01, 0x15, 0x03, 0x00, 0x01, 0x3B, 0x01, 0xE8, 0x40, 0xEB, 0x00, 0x03, 0xC2, 0x5B, 
0x02, 0x00, 0x07, 0x00, 0x27, 0xFE, 0x00, 0x00, 0x05, 0xFE, 0x03, 0x00, 0x01, 0x22, 0x03, 0x00, 
0x01, 0x22, 0x01, 0xE0, 0x3E, 0xEB, 0x00, 0x03, 0xE8, 0xA7, 0x30, 0x00, 0x08, 0x00, 0x29, 0xFE, 
0x00, 0x00, 0x05, 0xFE, 0x06, 0x00, 0x01, 0x10, 0x01, 0xDB, 0x3D, 0xEB, 0x00, 0x03, 0xDB, 0x82, 
0x10, 0x00, 0x08, 0x00, 0x2B, 0xFE, 0x00, 0x00, 0x05, 0xFE, 0x05, 0x00, 0x01, 0x02, 0x01, 0xCC, 
0x3C, 0xEB, 0x00, 0x03, 0xCC, 0x66, 0x02, 0x00, 0x07, 0x00, 0x2E, 0xFE, 0x00, 0x00, 0x05, 0xFE, 
0x05, 0x00, 0x01, 0x7A, 0x3C, 0xEB, 0x01, 0xB3, 0x01, 0x02, 0x07, 0x00, 0x30, 0xFE, 0x00, 0x00, 
0x05, 0xFE, 0x04, 0x00, 0x01, 0x22, 0x01, 0xE8, 0x21, 0xEB, 0x01, 0xD4, 0x01, 0xE0, 0x18, 0xEB, 
0x01, 0xB3, 0x01, 0x02, 0x06, 0x00, 0x32, 0xFE, 0x00, 0x00, 0x04, 0xFE, 0x04, 0x00, 0x01, 0x02, 
0x01, 0xCC, 0x22, 0xEB, 0x01, 0x30, 0x01, 0x82, 0x17, 0xEB, 0x01, 0xE0, 0x01, 0x07, 0x04, 0x00, 
0x35, 0xFE, 0x00, 0x00, 0x04, 0xFE, 0x04, 0x00, 0x01, 0x82, 0x22, 0xEB, 0x00, 0x04, 0x82, 0x00, 
0x10, 0xE8, 0x16, 0xEB, 0x01, 0xD4, 0x04, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x04, 0xFE, 0x03, 0x00, 
0x01, 0x07, 0x01, 0xE8, 0x21, 0xEB, 0x00, 0x05, 0xCC, 0x02, 0x00, 0x00, 0xA7, 0x00, 0x16, 0xEB, 
0x01, 0xD4, 0x03, 0x00, 0x37, 0xFE, 0x00, 0x00, 0x03, 0xFE, 0x04, 0x00, 0x01, 0x9A, 0x21, 0xEB, 
0x01, 0xE8, 0x01, 0x22, 0x03, 0x00, 0x01, 0x30, 0x16, 0xEB, 0x01, 0xCC, 0x03, 0x00, 0x37, 0xFE, 
0x00, 0x00, 0x03, 0xFE, 0x03, 0x00, 0x01, 0x02, 0x01, 0xE8, 0x21, 0xEB, 0x01, 0x66, 0x05, 0x00, 
0x01, 0xC2, 0x15, 0xEB, 0x01, 0xDB, 0x04, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x03, 0xFE, 0x03, 0x00, 
0x01, 0x5B, 0x21, 0xEB, 0x01, 0xB3, 0x06, 0x00, 0x01, 0x4C, 0x16, 0xEB, 0x01, 0x15, 0x03, 0x00, 
0x36, 0xFE, 0x00, 0x00, 0x03, 0xFE, 0x03, 0x00, 0x01, 0xA7, 0x20, 0xEB, 0x01, 0xE0, 0x01, 0x10, 
0x03, 0x00, 0x00, 0x05, 0x03, 0x00, 0x00, 0x02, 0xD4, 0x00, 0x15, 0xEB, 0x01, 0x5B, 0x03, 0x00, 
0x36, 0xFE, 0x00, 0x00, 0x01, 0xFE, 0x01, 0xFE, 0x03, 0x00, 0x01, 0x02, 0x01, 0xE3, 0x20, 0xEB, 
0x01, 0x4C, 0x03, 0x00, 0x01, 0x32, 0x01, 0x71, 0x03, 0x00, 0x01, 0x6D, 0x15, 0xEB, 0x01, 0x8D, 
0x03, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x01, 0xFE, 0x01, 0xFE, 0x03, 0x00, 0x01, 0x10, 0x20, 0xEB, 
0x01, 0x9A, 0x03, 0x00, 0x00, 0x08, 0x05, 0xA9, 0xB5, 0x05, 0x00, 0x00, 0x02, 0xE3, 0x14, 0xEB, 
0x01, 0xC2, 0x03, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x01, 0xFE, 0x01, 0xFE, 0x03, 0x00, 0x01, 0x30, 
0x1F, 0xEB, 0x01, 0xD4, 0x01, 0x02, 0x03, 0x00, 0x00, 0x04, 0x83, 0xC3, 0xC3, 0x5A, 0x03, 0x00, 
0x01, 0x8D, 0x14, 0xEB, 0x01, 0xDB, 0x04, 0x00, 0x35, 0xFE, 0x00, 0x00, 0x01, 0xFE, 0x01, 0xFE, 
0x03, 0x00, 0x01, 0x4C, 0x1F, 0xEB, 0x01, 0x66, 0x03, 0x00, 0x01, 0x52, 0x03, 0xC3, 0x00, 0x05, 
0xA9, 0x03, 0x00, 0x00, 0x15, 0x00, 0x14, 0xEB, 0x01, 0xE3, 0x04, 0x00, 0x35, 0xFE, 0x00, 0x00, 
0x01, 0xFE, 0x01, 0xFE, 0x03, 0x00, 0x01, 0x66, 0x1E, 0xEB, 0x00, 0x06, 0xDB, 0x02, 0x00, 0x00, 
0x0C, 0xB5, 0x04, 0xC3, 0x01, 0x47, 0x03, 0x00, 0x01, 0xA7, 0x14, 0xEB, 0x01, 0x03, 0x03, 0x00, 
0x35, 0xFE, 0x00, 0x00, 0x01, 0xFE, 0x01, 0xFE, 0x03, 0x00, 0x01, 0x7A, 0x1E, 0xEB, 0x01, 0x7A, 
0x03, 0x00, 0x01, 0x71, 0x05, 0xC3, 0x01, 0x98, 0x03, 0x00, 0x01, 0x3B, 0x14, 0xEB, 0x01, 0x02, 
0x03, 0x00, 0x35, 0xFE, 0x00, 0x00, 0x01, 0xFE, 0x01, 0xFE, 0x03, 0x00, 0x01, 0x7A, 0x1D, 0xEB, 
0x00, 0x06, 0xE3, 0x07, 0x00, 0x00, 0x03, 0xB5, 0x06, 0xC3, 0x00, 0x05, 0x29, 0x00, 0x00, 0x02, 
0xE8, 0x00, 0x12, 0xEB, 0x01, 0xDB, 0x04, 0x00, 0x35, 0xFE, 0x00, 0x00, 0x01, 0xFE, 0x01, 0xFE, 
0x03, 0x00, 0x01, 0x66, 0x1D, 0xEB, 0x01, 0xA7, 0x03, 0x00, 0x01, 0x5A, 0x07, 0xC3, 0x01, 0x67, 
0x03, 0x00, 0x01, 0xB3, 0x12, 0xEB, 0x01, 0xB3, 0x03, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x01, 0xFE, 
0x01, 0xFE, 0x03, 0x00, 0x01, 0x4C, 0x1D, 0xEB, 0x01, 0x4C, 0x03, 0x00, 0x01, 0xA9, 0x07, 0xC3, 
0x01, 0x98, 0x03, 0x00, 0x01, 0x82, 0x12, 0xEB, 0x01, 0x82, 0x03, 0x00, 0x36, 0xFE, 0x00, 0x00, 
0x01, 0xFE, 0x01, 0xFE, 0x03, 0x00, 0x01, 0x22, 0x1C, 0xEB, 0x00, 0x05, 0xE8, 0x02, 0x00, 0x00, 
0x20, 0x00, 0x08, 0xC3, 0x00, 0x05, 0xB5, 0x03, 0x00, 0x00, 0x3B, 0x00, 0x12, 0xEB, 0x01, 0x30, 
0x03, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x01, 0xFE, 0x01, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x1C, 0xEB, 
0x01, 0xB3, 0x03, 0x00, 0x01, 0x67, 0x09, 0xC3, 0x00, 0x05, 0x29, 0x00, 0x00, 0x02, 0xE8, 0x00, 
0x10, 0xEB, 0x01, 0xC2, 0x04, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x01, 0xFE, 0x01, 0xFE, 0x03, 0x00, 
0x01, 0x03, 0x01, 0xE8, 0x1B, 0xEB, 0x01, 0x7A, 0x03, 0x00, 0x01, 0x9F, 0x09, 0xC3, 0x01, 0x5A, 
0x03, 0x00, 0x01, 0xC2, 0x10, 0xEB, 0x01, 0x5B, 0x03, 0x00, 0x37, 0xFE, 0x00, 0x00, 0x01, 0xFE, 
0x01, 0xFE, 0x04, 0x00, 0x01, 0xC2, 0x1B, 0xEB, 0x00, 0x05, 0x5B, 0x00, 0x00, 0x03, 0xBD, 0x00, 
0x09, 0xC3, 0x01, 0x8B, 0x03, 0x00, 0x01, 0x82, 0x0F, 0xEB, 0x01, 0xDB, 0x01, 0x02, 0x03, 0x00, 
0x37, 0xFE, 0x00, 0x00, 0x03, 0xFE, 0x03, 0x00, 0x01, 0x8D, 0x1B, 0xEB, 0x00, 0x04, 0x30, 0x00, 
0x00, 0x0C, 0x0A, 0xC3, 0x00, 0x05, 0xB5, 0x03, 0x00, 0x00, 0x3B, 0x00, 0x0F, 0xEB, 0x01, 0x4C, 
0x03, 0x00, 0x38, 0xFE, 0x00, 0x00, 0x03, 0xFE, 0x03, 0x00, 0x01, 0x4C, 0x1B, 0xEB, 0x00, 0x04, 
0x07, 0x00, 0x00, 0x29, 0x0B, 0xC3, 0x00, 0x05, 0x29, 0x00, 0x00, 0x02, 0xE8, 0x00, 0x0D, 0xEB, 
0x01, 0xB3, 0x04, 0x00, 0x38, 0xFE, 0x00, 0x00, 0x03, 0xFE, 0x03, 0x00, 0x01, 0x07, 0x1A, 0xEB, 
0x01, 0xE3, 0x03, 0x00, 0x01, 0x52, 0x0B, 0xC3, 0x01, 0x5A, 0x03, 0x00, 0x01, 0xD4, 0x0C, 0xEB, 
0x01, 0xE3, 0x01, 0x10, 0x03, 0x00, 0x39, 0xFE, 0x00, 0x00, 0x03, 0xFE, 0x04, 0x00, 0x01, 0xD4, 
0x19, 0xEB, 0x01, 0xCC, 0x03, 0x00, 0x01, 0x67, 0x0B, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0xC2, 
0x0C, 0xEB, 0x01, 0x66, 0x04, 0x00, 0x39, 0xFE, 0x00, 0x00, 0x04, 0xFE, 0x03, 0x00, 0x01, 0x8D, 
0x19, 0xEB, 0x01, 0xB3, 0x03, 0x00, 0x01, 0x83, 0x0B, 0xC3, 0x01, 0x7B, 0x03, 0x00, 0x01, 0xB3, 
0x0B, 0xEB, 0x01, 0xA7, 0x04, 0x00, 0x3A, 0xFE, 0x00, 0x00, 0x04, 0xFE, 0x03, 0x00, 0x01, 0x30, 
0x19, 0xEB, 0x01, 0x8D, 0x03, 0x00, 0x01, 0x98, 0x0B, 0xC3, 0x01, 0x8B, 0x03, 0x00, 0x01, 0xA7, 
0x0A, 0xEB, 0x01, 0xDB, 0x01, 0x07, 0x03, 0x00, 0x3B, 0xFE, 0x00, 0x00, 0x04, 0xFE, 0x04, 0x00, 
0x01, 0xD4, 0x18, 0xEB, 0x01, 0x7A, 0x03, 0x00, 0x01, 0xA9, 0x0B, 0xC3, 0x01, 0x98, 0x03, 0x00, 
0x01, 0x9A, 0x0A, 0xEB, 0x01, 0x3B, 0x04, 0x00, 0x3B, 0xFE, 0x00, 0x00, 0x05, 0xFE, 0x03, 0x00, 
0x01, 0x7A, 0x18, 0xEB, 0x01, 0x82, 0x03, 0x00, 0x01, 0x9F, 0x0B, 0xC3, 0x01, 0x9F, 0x03, 0x00, 
0x01, 0x8D, 0x09, 0xEB, 0x01, 0x82, 0x04, 0x00, 0x3C, 0xFE, 0x00, 0x00, 0x05, 0xFE, 0x03, 0x00, 
0x01, 0x15, 0x18, 0xEB, 0x01, 0x8D, 0x03, 0x00, 0x01, 0x98, 0x0B, 0xC3, 0x01, 0xA9, 0x03, 0x00, 
0x01, 0x7A, 0x08, 0xEB, 0x01, 0xCC, 0x01, 0x02, 0x03, 0x00, 0x3D, 0xFE, 0x00, 0x00, 0x05, 0xFE, 
0x04, 0x00, 0x01, 0xB3, 0x0E, 0xEB, 0x01, 0xD4, 0x01, 0xDB, 0x07, 0xEB, 0x01, 0x9A, 0x03, 0x00, 
0x01, 0x98, 0x0B, 0xC3, 0x01, 0xB5, 0x03, 0x00, 0x00, 0x05, 0x6D, 0xEB, 0xEB, 0xDB, 0xD4, 0x00, 
0x04, 0xEB, 0x01, 0x30, 0x04, 0x00, 0x3D, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 0x01, 0x4C, 
0x0C, 0xEB, 0x00, 0x06, 0xDB, 0x30, 0x00, 0x00, 0x66, 0xE8, 0x05, 0xEB, 0x01, 0xA7, 0x03, 0x00, 
0x01, 0x8B, 0x0B, 0xC3, 0x01, 0xB5, 0x03, 0x00, 0x00, 0x09, 0x6D, 0xE3, 0x4C, 0x00, 0x00, 0x3B, 
0xE3, 0xEB, 0x8D, 0x00, 0x04, 0x00, 0x3E, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x04, 0x00, 0x01, 0xCC, 
0x0B, 0xEB, 0x01, 0x3B, 0x04, 0x00, 0x01, 0x82, 0x05, 0xEB, 0x01, 0xA7, 0x03, 0x00, 0x01, 0x83, 
0x0B, 0xC3, 0x01, 0x98, 0x03, 0x00, 0x01, 0x8D, 0x01, 0x66, 0x04, 0x00, 0x00, 0x03, 0x5B, 0xE8, 
0x07, 0x00, 0x03, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x4C, 0x0A, 0xEB, 
0x01, 0xCC, 0x05, 0x00, 0x01, 0x07, 0x01, 0xE8, 0x04, 0xEB, 0x01, 0xB3, 0x03, 0x00, 0x01, 0x83, 
0x0B, 0xC3, 0x01, 0x83, 0x03, 0x00, 0x01, 0x9A, 0x01, 0x02, 0x04, 0x00, 0x01, 0x03, 0x01, 0x9A, 
0x04, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x03, 0x01, 0xD4, 0x09, 0xEB, 
0x01, 0x9A, 0x06, 0x00, 0x01, 0xD4, 0x04, 0xEB, 0x01, 0xB3, 0x03, 0x00, 0x01, 0x7B, 0x0B, 0xC3, 
0x01, 0x67, 0x03, 0x00, 0x01, 0x9A, 0x06, 0x00, 0x01, 0x30, 0x03, 0x00, 0x40, 0xFE, 0x00, 0x00, 
0x08, 0xFE, 0x03, 0x00, 0x01, 0x5B, 0x09, 0xEB, 0x01, 0x82, 0x06, 0x00, 0x01, 0xC2, 0x04, 0xEB, 
0x01, 0xCC, 0x03, 0x00, 0x01, 0x71, 0x0B, 0xC3, 0x00, 0x05, 0x47, 0x00, 0x00, 0x02, 0xA7, 0x00, 
0x06, 0x00, 0x01, 0x03, 0x03, 0x00, 0x40, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x04, 0x00, 0x01, 0xC2, 
0x08, 0xEB, 0x01, 0xA7, 0x06, 0x00, 0x01, 0xDB, 0x04, 0xEB, 0x01, 0xCC, 0x03, 0x00, 0x01, 0x52, 
0x0B, 0xC3, 0x00, 0x05, 0x20, 0x00, 0x00, 0x22, 0xCC, 0x00, 0x09, 0x00, 0x41, 0xFE, 0x00, 0x00, 
0x09, 0xFE, 0x03, 0x00, 0x01, 0x22, 0x08, 0xEB, 0x01, 0xDB, 0x01, 0x02, 0x04, 0x00, 0x01, 0x30, 
0x05, 0xEB, 0x00, 0x05, 0xE8, 0x07, 0x00, 0x00, 0x0C, 0x00, 0x0A, 0xC3, 0x00, 0x07, 0xAD, 0x03, 
0x00, 0x00, 0x4C, 0xE8, 0x10, 0x00, 0x04, 0x00, 0x01, 0x02, 0x03, 0x00, 0x41, 0xFE, 0x00, 0x00, 
0x09, 0xFE, 0x04, 0x00, 0x01, 0x8D, 0x08, 0xEB, 0x01, 0x82, 0x03, 0x00, 0x01, 0x02, 0x01, 0xC2, 
0x06, 0xEB, 0x01, 0x66, 0x03, 0x00, 0x01, 0x32, 0x01, 0xB5, 0x07, 0xC3, 0x01, 0xA9, 0x01, 0x32, 
0x03, 0x00, 0x00, 0x04, 0x7A, 0xEB, 0xA7, 0x03, 0x03, 0x00, 0x01, 0x10, 0x03, 0x00, 0x41, 0xFE, 
0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 0x01, 0x07, 0x01, 0xDB, 0x08, 0xEB, 0x00, 0x04, 0x9A, 0x3B, 
0x4C, 0xC2, 0x07, 0xEB, 0x01, 0xC2, 0x04, 0x00, 0x00, 0x09, 0x03, 0x5A, 0x8B, 0xA9, 0xA9, 0x9F, 
0x83, 0x52, 0x03, 0x00, 0x03, 0x00, 0x00, 0x09, 0x10, 0xE3, 0xEB, 0xEB, 0xB3, 0x4C, 0x3B, 0x9A, 
0x03, 0x00, 0x03, 0x00, 0x41, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x04, 0x00, 0x01, 0x4C, 0x14, 0xEB, 
0x01, 0x8D, 0x0F, 0x00, 0x01, 0x9A, 0x06, 0xEB, 0x01, 0x9A, 0x03, 0x00, 0x42, 0xFE, 0x00, 0x00, 
0x0B, 0xFE, 0x04, 0x00, 0x01, 0x8D, 0x14, 0xEB, 0x01, 0x9A, 0x01, 0x03, 0x0B, 0x00, 0x01, 0x04, 
0x01, 0xA7, 0x06, 0xEB, 0x01, 0xE8, 0x01, 0x10, 0x03, 0x00, 0x42, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 
0x03, 0x00, 0x01, 0x02, 0x01, 0xC2, 0x14, 0xEB, 0x00, 0x03, 0xD4, 0x6D, 0x07, 0x00, 0x07, 0x00, 
0x00, 0x03, 0x10, 0x6D, 0xE0, 0x00, 0x07, 0xEB, 0x01, 0x8D, 0x04, 0x00, 0x42, 0xFE, 0x00, 0x00, 
0x0C, 0xFE, 0x04, 0x00, 0x01, 0x10, 0x01, 0xD4, 0x15, 0xEB, 0x00, 0x08, 0xE3, 0xC2, 0x9A, 0x7A, 
0x7A, 0x82, 0x9A, 0xCC, 0x09, 0xEB, 0x01, 0xE3, 0x01, 0x07, 0x03, 0x00, 0x43, 0xFE, 0x00, 0x00, 
0x0D, 0xFE, 0x04, 0x00, 0x01, 0x10, 0x01, 0xD4, 0x25, 0xEB, 0x01, 0x5B, 0x04, 0x00, 0x43, 0xFE, 
0x00, 0x00, 0x0E, 0xFE, 0x04, 0x00, 0x01, 0x10, 0x01, 0xD4, 0x23, 0xEB, 0x01, 0x82, 0x04, 0x00, 
0x44, 0xFE, 0x00, 0x00, 0x0F, 0xFE, 0x04, 0x00, 0x01, 0x10, 0x01, 0xD4, 0x21, 0xEB, 0x01, 0x9A, 
0x04, 0x00, 0x45, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x04, 0x00, 0x01, 0x07, 0x01, 0xB3, 0x1F, 0xEB, 
0x01, 0xA7, 0x01, 0x02, 0x04, 0x00, 0x45, 0xFE, 0x00, 0x00, 0x11, 0xFE, 0x05, 0x00, 0x01, 0x7A, 
0x1D, 0xEB, 0x01, 0x7A, 0x05, 0x00, 0x46, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x05, 0x00, 0x01, 0x4C, 
0x01, 0xE0, 0x19, 0xEB, 0x01, 0xE3, 0x01, 0x4C, 0x05, 0x00, 0x47, 0xFE, 0x00, 0x00, 0x13, 0xFE, 
0x05, 0x00, 0x00, 0x03, 0x07, 0x8D, 0xE8, 0x00, 0x15, 0xEB, 0x00, 0x03, 0xE3, 0x8D, 0x10, 0x00, 
0x05, 0x00, 0x48, 0xFE, 0x00, 0x00, 0x14, 0xFE, 0x06, 0x00, 0x01, 0x22, 0x01, 0xB3, 0x12, 0xEB, 
0x00, 0x03, 0xE0, 0x7A, 0x07, 0x00, 0x06, 0x00, 0x49, 0xFE, 0x00, 0x00, 0x16, 0xFE, 0x06, 0x00, 
0x00, 0x03, 0x22, 0x82, 0xD4, 0x00, 0x0C, 0xEB, 0x00, 0x04, 0xE3, 0xB3, 0x6D, 0x02, 0x06, 0x00, 
0x4B, 0xFE, 0x00, 0x00, 0x17, 0xFE, 0x08, 0x00, 0x00, 0x0D, 0x30, 0x7A, 0x9A, 0xC2, 0xE0, 0xE8, 
0xE0, 0xD4, 0xCC, 0xB3, 0x82, 0x3B, 0x02, 0x00, 0x08, 0x00, 0x4C, 0xFE, 0x00, 0x00, 0x19, 0xFE, 
0x19, 0x00, 0x4E, 0xFE, 0x00, 0x00, 0x1B, 0xFE, 0x15, 0x00, 0x50, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 
0x0E, 0x00, 0x54, 0xFE, 0x00, 0x00, 0x23, 0xFE, 0x04, 0x00, 0x59, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x01, 
};

constexpr unsigned char parrot06[] = {
0x42, 0x4D, 0x64, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x04, 0x00, 0x00, 0x28, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x01, 0x00, 
0x00, 0x00, 0x32, 0x09, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0xFF, 0x00, 
0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x08, 0x04, 
0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x0B, 0x05, 0x08, 0x00, 0x06, 0x0A, 0x07, 0x00, 0x06, 0x08, 
0x0E, 0x00, 0x0E, 0x0B, 0x04, 0x00, 0x0F, 0x07, 0x12, 0x00, 0x0B, 0x0C, 0x12, 0x00, 0x16, 0x0B, 
0x12, 0x00, 0x0C, 0x0B, 0x17, 0x00, 0x0C, 0x10, 0x0D, 0x00, 0x13, 0x11, 0x08, 0x00, 0x12, 0x0C, 
0x1C, 0x00, 0x19, 0x0C, 0x1B, 0x00, 0x18, 0x10, 0x10, 0x00, 0x0A, 0x0D, 0x21, 0x00, 0x08, 0x13, 
0x10, 0x00, 0x1E, 0x0E, 0x1A, 0x00, 0x0A, 0x12, 0x18, 0x00, 0x1B, 0x15, 0x0E, 0x00, 0x1C, 0x10, 
0x1F, 0x00, 0x14, 0x11, 0x1F, 0x00, 0x12, 0x15, 0x13, 0x00, 0x23, 0x10, 0x24, 0x00, 0x1B, 0x10, 
0x28, 0x00, 0x0E, 0x15, 0x1C, 0x00, 0x0E, 0x1A, 0x0D, 0x00, 0x19, 0x19, 0x0D, 0x00, 0x11, 0x13, 
0x25, 0x00, 0x23, 0x13, 0x1F, 0x00, 0x12, 0x1A, 0x15, 0x00, 0x12, 0x13, 0x2E, 0x00, 0x25, 0x1A, 
0x16, 0x00, 0x2E, 0x14, 0x30, 0x00, 0x17, 0x18, 0x2C, 0x00, 0x20, 0x20, 0x0F, 0x00, 0x2D, 0x19, 
0x23, 0x00, 0x13, 0x1C, 0x23, 0x00, 0x13, 0x21, 0x13, 0x00, 0x17, 0x1F, 0x1A, 0x00, 0x24, 0x16, 
0x34, 0x00, 0x32, 0x14, 0x37, 0x00, 0x17, 0x17, 0x38, 0x00, 0x2E, 0x19, 0x2B, 0x00, 0x1C, 0x1D, 
0x32, 0x00, 0x15, 0x21, 0x29, 0x00, 0x32, 0x23, 0x1B, 0x00, 0x26, 0x26, 0x15, 0x00, 0x1D, 0x25, 
0x20, 0x00, 0x16, 0x29, 0x15, 0x00, 0x3B, 0x1A, 0x3B, 0x00, 0x1D, 0x1B, 0x43, 0x00, 0x2F, 0x1B, 
0x40, 0x00, 0x36, 0x1E, 0x34, 0x00, 0x3D, 0x20, 0x33, 0x00, 0x23, 0x21, 0x3D, 0x00, 0x3B, 0x20, 
0x3D, 0x00, 0x3A, 0x29, 0x22, 0x00, 0x44, 0x1D, 0x47, 0x00, 0x1F, 0x1F, 0x4D, 0x00, 0x2C, 0x2D, 
0x1A, 0x00, 0x1A, 0x28, 0x31, 0x00, 0x22, 0x2B, 0x27, 0x00, 0x37, 0x1F, 0x4D, 0x00, 0x3F, 0x23, 
0x41, 0x00, 0x26, 0x27, 0x48, 0x00, 0x47, 0x27, 0x3E, 0x00, 0x4E, 0x22, 0x4E, 0x00, 0x1F, 0x2F, 
0x39, 0x00, 0x25, 0x32, 0x2D, 0x00, 0x25, 0x26, 0x56, 0x00, 0x3F, 0x24, 0x59, 0x00, 0x1F, 0x39, 
0x1E, 0x00, 0x35, 0x37, 0x1E, 0x00, 0x47, 0x33, 0x27, 0x00, 0x53, 0x24, 0x58, 0x00, 0x4F, 0x2B, 
0x42, 0x00, 0x2B, 0x2C, 0x50, 0x00, 0x28, 0x28, 0x5F, 0x00, 0x4D, 0x2A, 0x4D, 0x00, 0x2A, 0x38, 
0x30, 0x00, 0x55, 0x30, 0x49, 0x00, 0x30, 0x2F, 0x59, 0x00, 0x60, 0x29, 0x62, 0x00, 0x2B, 0x2C, 
0x6B, 0x00, 0x49, 0x2B, 0x68, 0x00, 0x55, 0x2F, 0x59, 0x00, 0x26, 0x3A, 0x45, 0x00, 0x31, 0x3F, 
0x36, 0x00, 0x58, 0x3E, 0x2E, 0x00, 0x65, 0x2B, 0x6B, 0x00, 0x26, 0x46, 0x26, 0x00, 0x2F, 0x30, 
0x6F, 0x00, 0x5C, 0x32, 0x59, 0x00, 0x47, 0x46, 0x24, 0x00, 0x62, 0x36, 0x52, 0x00, 0x37, 0x36, 
0x61, 0x00, 0x51, 0x31, 0x75, 0x00, 0x32, 0x33, 0x7A, 0x00, 0x2A, 0x41, 0x4E, 0x00, 0x5E, 0x44, 
0x34, 0x00, 0x38, 0x47, 0x3D, 0x00, 0x65, 0x38, 0x66, 0x00, 0x75, 0x32, 0x79, 0x00, 0x2D, 0x52, 
0x2D, 0x00, 0x58, 0x35, 0x81, 0x00, 0x37, 0x37, 0x86, 0x00, 0x69, 0x4A, 0x37, 0x00, 0x3C, 0x3E, 
0x71, 0x00, 0x72, 0x3E, 0x61, 0x00, 0x53, 0x52, 0x2C, 0x00, 0x39, 0x4D, 0x46, 0x00, 0x30, 0x49, 
0x57, 0x00, 0x62, 0x37, 0x86, 0x00, 0x32, 0x58, 0x2B, 0x00, 0x72, 0x3D, 0x71, 0x00, 0x58, 0x56, 
0x30, 0x00, 0x2F, 0x5B, 0x31, 0x00, 0x3E, 0x3D, 0x93, 0x00, 0x86, 0x3A, 0x88, 0x00, 0x73, 0x52, 
0x3E, 0x00, 0x3F, 0x54, 0x4B, 0x00, 0x45, 0x45, 0x7E, 0x00, 0x69, 0x3D, 0x90, 0x00, 0x85, 0x48, 
0x6F, 0x00, 0x81, 0x45, 0x81, 0x00, 0x41, 0x43, 0xA1, 0x00, 0x37, 0x56, 0x66, 0x00, 0x7F, 0x5A, 
0x41, 0x00, 0x46, 0x5C, 0x4F, 0x00, 0x93, 0x3F, 0x98, 0x00, 0x38, 0x66, 0x36, 0x00, 0x63, 0x63, 
0x34, 0x00, 0x73, 0x43, 0xA0, 0x00, 0x4F, 0x4D, 0x8E, 0x00, 0x9C, 0x42, 0xA1, 0x00, 0x3D, 0x5D, 
0x6D, 0x00, 0x4C, 0x63, 0x55, 0x00, 0x95, 0x51, 0x7C, 0x00, 0x89, 0x62, 0x4A, 0x00, 0x9F, 0x45, 
0xA5, 0x00, 0x4B, 0x4B, 0xB3, 0x00, 0x50, 0x53, 0x97, 0x00, 0x51, 0x68, 0x5A, 0x00, 0x7E, 0x4A, 
0xB1, 0x00, 0x93, 0x51, 0x94, 0x00, 0x40, 0x75, 0x40, 0x00, 0xAB, 0x49, 0xB0, 0x00, 0x56, 0x57, 
0xA1, 0x00, 0x71, 0x72, 0x3F, 0x00, 0x50, 0x6C, 0x60, 0x00, 0x42, 0x67, 0x79, 0x00, 0x98, 0x6A, 
0x53, 0x00, 0x50, 0x50, 0xC3, 0x00, 0xA5, 0x5A, 0x8A, 0x00, 0xA0, 0x57, 0x9C, 0x00, 0x87, 0x4F, 
0xC1, 0x00, 0x56, 0x72, 0x66, 0x00, 0xB8, 0x4F, 0xBF, 0x00, 0x44, 0x80, 0x45, 0x00, 0x60, 0x60, 
0xAF, 0x00, 0xA8, 0x5C, 0xA9, 0x00, 0x7D, 0x7E, 0x46, 0x00, 0x59, 0x58, 0xD5, 0x00, 0x8F, 0x55, 
0xCD, 0x00, 0xA5, 0x75, 0x5D, 0x00, 0xB5, 0x63, 0x98, 0x00, 0x5D, 0x7A, 0x6D, 0x00, 0xC6, 0x54, 
0xCB, 0x00, 0x4C, 0x76, 0x8A, 0x00, 0x4B, 0x89, 0x4B, 0x00, 0x61, 0x7F, 0x6C, 0x00, 0x69, 0x68, 
0xBC, 0x00, 0x5E, 0x5F, 0xE4, 0x00, 0x9B, 0x5B, 0xDD, 0x00, 0xCD, 0x59, 0xD5, 0x00, 0xB9, 0x64, 
0xB8, 0x00, 0xB2, 0x7E, 0x63, 0x00, 0x88, 0x8B, 0x4D, 0x00, 0x66, 0x84, 0x71, 0x00, 0xD8, 0x5B, 
0xDD, 0x00, 0xC7, 0x6D, 0xA7, 0x00, 0x64, 0x62, 0xEE, 0x00, 0x9F, 0x60, 0xE5, 0x00, 0x51, 0x96, 
0x51, 0x00, 0x6E, 0x6F, 0xCC, 0x00, 0x54, 0x81, 0x9B, 0x00, 0x6B, 0x8A, 0x76, 0x00, 0xA9, 0x62, 
0xEB, 0x00, 0x68, 0x66, 0xF4, 0x00, 0xDD, 0x60, 0xE2, 0x00, 0xC3, 0x6B, 0xC6, 0x00, 0xC1, 0x88, 
0x69, 0x00, 0x68, 0x8C, 0x7B, 0x00, 0x96, 0x96, 0x51, 0x00, 0x68, 0x69, 0xFF, 0x00, 0xE4, 0x62, 
0xED, 0x00, 0xD6, 0x75, 0xB3, 0x00, 0xD0, 0x6F, 0xCF, 0x00, 0xB1, 0x66, 0xF8, 0x00, 0x5A, 0xA1, 
0x55, 0x00, 0x77, 0x77, 0xDB, 0x00, 0xCA, 0x8F, 0x6F, 0x00, 0xA1, 0x9F, 0x56, 0x00, 0xB7, 0x6C, 
0xFE, 0x00, 0x5D, 0x8E, 0xAB, 0x00, 0xD7, 0x76, 0xD6, 0x00, 0xF3, 0x69, 0xFA, 0x00, 0xF7, 0x68, 
0xFF, 0x00, 0x5A, 0xA9, 0x5D, 0x00, 0xD7, 0x98, 0x74, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0xEB, 0x80, 
0xC5, 0x00, 0xE0, 0x7B, 0xE3, 0x00, 0x85, 0x82, 0xF1, 0x00, 0xAD, 0xAC, 0x5A, 0x00, 0x64, 0x99, 
0xB8, 0x00, 0xE1, 0xA0, 0x7A, 0x00, 0x63, 0xB5, 0x62, 0x00, 0xF8, 0x87, 0xCF, 0x00, 0x85, 0x88, 
0xF9, 0x00, 0xF1, 0x83, 0xF1, 0x00, 0xE8, 0xA6, 0x81, 0x00, 0xFF, 0x8C, 0xD7, 0x00, 0x8B, 0x8D, 
0xFF, 0x00, 0xF3, 0xAB, 0x80, 0x00, 0xF8, 0x88, 0xFA, 0x00, 0x68, 0xC2, 0x68, 0x00, 0xBE, 0xBE, 
0x67, 0x00, 0x6D, 0xA9, 0xCB, 0x00, 0xF9, 0xB0, 0x86, 0x00, 0xFF, 0x8C, 0xFF, 0x00, 0x70, 0xCB, 
0x6E, 0x00, 0xFE, 0xB5, 0x8B, 0x00, 0xC6, 0xC6, 0x6A, 0x00, 0x71, 0xD3, 0x73, 0x00, 0x78, 0xB7, 
0xDA, 0x00, 0xCE, 0xCF, 0x72, 0x00, 0x78, 0xDB, 0x78, 0x00, 0x7C, 0xE5, 0x7C, 0x00, 0x7F, 0xC4, 
0xEA, 0x00, 0xDB, 0xDD, 0x78, 0x00, 0x81, 0xED, 0x81, 0x00, 0xE3, 0xE5, 0x7E, 0x00, 0x88, 0xCF, 
0xF5, 0x00, 0x87, 0xF5, 0x84, 0x00, 0xEC, 0xEF, 0x87, 0x00, 0x89, 0xD6, 0xFE, 0x00, 0x87, 0xFA, 
0x8C, 0x00, 0xF1, 0xF3, 0x8C, 0x00, 0x89, 0xFF, 0x88, 0x00, 0xFB, 0xF9, 0x80, 0x00, 0xFF, 0xFF, 
0x87, 0x00, 0x07, 0xFE, 0x5D, 0x00, 0x1C, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x5D, 0x00, 0x1C, 0xFE, 
0x00, 0x00, 0x07, 0xFE, 0x5C, 0x00, 0x1D, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x1F, 
0x53, 0x53, 0x01, 0x13, 0x04, 0x00, 0x1D, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x6F, 
0x1A, 0xE1, 0x00, 0x05, 0xD6, 0x9C, 0x61, 0x61, 0xA8, 0x00, 0x33, 0xE1, 0x01, 0xD6, 0x01, 0x0A, 
0x03, 0x00, 0x1E, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x7E, 0x16, 0xE1, 0x00, 0x04, 
0xD6, 0x9C, 0x6F, 0x26, 0x04, 0x00, 0x01, 0x04, 0x01, 0xD6, 0x32, 0xE1, 0x01, 0x6F, 0x04, 0x00, 
0x1E, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x8C, 0x14, 0xE1, 0x00, 0x03, 0x9C, 0x38, 
0x03, 0x00, 0x07, 0x00, 0x01, 0x04, 0x01, 0xD6, 0x31, 0xE1, 0x01, 0xB7, 0x01, 0x01, 0x03, 0x00, 
0x1F, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x9C, 0x11, 0xE1, 0x00, 0x03, 0xC7, 0x6F, 
0x0A, 0x00, 0x09, 0x00, 0x01, 0x04, 0x01, 0x8C, 0x32, 0xE1, 0x01, 0x2D, 0x04, 0x00, 0x1F, 0xFE, 
0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x9C, 0x0F, 0xE1, 0x00, 0x03, 0xB7, 0x44, 0x01, 0x00, 
0x07, 0x00, 0x00, 0x04, 0x04, 0x4E, 0x8C, 0xC7, 0x33, 0xE1, 0x01, 0x61, 0x04, 0x00, 0x20, 0xFE, 
0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0xA8, 0x0D, 0xE1, 0x00, 0x03, 0xD6, 0x61, 0x03, 0x00, 
0x06, 0x00, 0x00, 0x03, 0x38, 0x8C, 0xB7, 0x00, 0x36, 0xE1, 0x01, 0x7E, 0x04, 0x00, 0x21, 0xFE, 
0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 0x01, 0x9C, 0x0C, 0xE1, 0x01, 0x9C, 0x01, 0x0A, 0x05, 0x00, 
0x00, 0x03, 0x04, 0x61, 0xB7, 0x00, 0x38, 0xE1, 0x01, 0x8C, 0x05, 0x00, 0x21, 0xFE, 0x00, 0x00, 
0x07, 0xFE, 0x03, 0x00, 0x01, 0x7E, 0x0A, 0xE1, 0x01, 0xD6, 0x01, 0x38, 0x05, 0x00, 0x00, 0x03, 
0x26, 0x8C, 0xD6, 0x00, 0x39, 0xE1, 0x01, 0x9C, 0x01, 0x01, 0x04, 0x00, 0x22, 0xFE, 0x00, 0x00, 
0x07, 0xFE, 0x03, 0x00, 0x01, 0x53, 0x09, 0xE1, 0x01, 0xC7, 0x01, 0x0F, 0x04, 0x00, 0x01, 0x04, 
0x01, 0x8C, 0x3B, 0xE1, 0x01, 0xA8, 0x01, 0x04, 0x04, 0x00, 0x23, 0xFE, 0x00, 0x00, 0x07, 0xFE, 
0x03, 0x00, 0x01, 0x2D, 0x08, 0xE1, 0x01, 0xA8, 0x01, 0x04, 0x04, 0x00, 0x01, 0x4E, 0x01, 0xD6, 
0x3B, 0xE1, 0x01, 0x7E, 0x01, 0x01, 0x04, 0x00, 0x24, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x03, 0x00, 
0x01, 0x04, 0x01, 0xDD, 0x06, 0xE1, 0x01, 0x9C, 0x01, 0x04, 0x03, 0x00, 0x01, 0x04, 0x01, 0xA8, 
0x3B, 0xE1, 0x01, 0xD6, 0x01, 0x44, 0x05, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x04, 0x00, 
0x01, 0x9C, 0x05, 0xE1, 0x01, 0xA8, 0x01, 0x01, 0x03, 0x00, 0x01, 0x13, 0x01, 0xC7, 0x3B, 0xE1, 
0x01, 0xA8, 0x01, 0x0A, 0x05, 0x00, 0x26, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0x4E, 
0x04, 0xE1, 0x01, 0xC7, 0x01, 0x04, 0x03, 0x00, 0x01, 0x2D, 0x01, 0xD6, 0x3A, 0xE1, 0x01, 0xD6, 
0x01, 0x53, 0x06, 0x00, 0x27, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x00, 0x06, 0x04, 0xD6, 
0xE1, 0xE1, 0xD6, 0x13, 0x03, 0x00, 0x01, 0x2D, 0x01, 0xD6, 0x3A, 0xE1, 0x01, 0xB7, 0x01, 0x0A, 
0x05, 0x00, 0x29, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x00, 0x04, 0x7E, 0xE1, 0xE1, 0x4E, 
0x03, 0x00, 0x01, 0x0A, 0x01, 0xD6, 0x3A, 0xE1, 0x01, 0xB7, 0x01, 0x04, 0x05, 0x00, 0x2A, 0xFE, 
0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x00, 0x03, 0x2D, 0xE1, 0x9C, 0x00, 0x03, 0x00, 0x01, 0x04, 
0x01, 0xB7, 0x1E, 0xE1, 0x01, 0xD6, 0x1B, 0xE1, 0x01, 0xD6, 0x01, 0x0A, 0x04, 0x00, 0x2C, 0xFE, 
0x00, 0x00, 0x09, 0xFE, 0x04, 0x00, 0x01, 0xA8, 0x01, 0x0A, 0x03, 0x00, 0x01, 0x9C, 0x1F, 0xE1, 
0x01, 0x44, 0x01, 0xA8, 0x1A, 0xE1, 0x01, 0x61, 0x04, 0x00, 0x2D, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 
0x03, 0x00, 0x01, 0x26, 0x03, 0x00, 0x01, 0x44, 0x1F, 0xE1, 0x00, 0x03, 0x8C, 0x00, 0x4E, 0x00, 
0x19, 0xE1, 0x01, 0xC7, 0x01, 0x01, 0x03, 0x00, 0x2E, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x06, 0x00, 
0x01, 0x04, 0x01, 0xD6, 0x1E, 0xE1, 0x00, 0x05, 0xC7, 0x04, 0x00, 0x01, 0xC7, 0x00, 0x18, 0xE1, 
0x01, 0x61, 0x03, 0x00, 0x2F, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x06, 0x00, 0x01, 0x8C, 0x1F, 0xE1, 
0x01, 0x2D, 0x03, 0x00, 0x01, 0x6F, 0x18, 0xE1, 0x01, 0x0A, 0x03, 0x00, 0x2F, 0xFE, 0x00, 0x00, 
0x0A, 0xFE, 0x05, 0x00, 0x01, 0x1F, 0x1F, 0xE1, 0x01, 0x6F, 0x04, 0x00, 0x01, 0x04, 0x01, 0xD6, 
0x16, 0xE1, 0x01, 0xB7, 0x04, 0x00, 0x2F, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x04, 0x00, 0x01, 0x9C, 
0x1E, 0xE1, 0x01, 0xB7, 0x01, 0x01, 0x05, 0x00, 0x01, 0x7E, 0x16, 0xE1, 0x01, 0x8C, 0x03, 0x00, 
0x30, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x04, 0x00, 0x01, 0x38, 0x1E, 0xE1, 0x01, 0xD6, 0x01, 0x13, 
0x06, 0x00, 0x01, 0x13, 0x16, 0xE1, 0x01, 0x8C, 0x03, 0x00, 0x30, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 
0x04, 0x00, 0x01, 0xB7, 0x1E, 0xE1, 0x01, 0x61, 0x03, 0x00, 0x01, 0x20, 0x01, 0x40, 0x03, 0x00, 
0x01, 0x9C, 0x15, 0xE1, 0x01, 0x9C, 0x03, 0x00, 0x30, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 
0x01, 0x1F, 0x1E, 0xE1, 0x01, 0xA8, 0x03, 0x00, 0x00, 0x03, 0x03, 0x9F, 0x98, 0x00, 0x03, 0x00, 
0x01, 0x38, 0x15, 0xE1, 0x01, 0x9C, 0x03, 0x00, 0x30, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x04, 0x00, 
0x01, 0x9C, 0x1D, 0xE1, 0x01, 0xD6, 0x01, 0x0A, 0x03, 0x00, 0x00, 0x04, 0x71, 0xC3, 0xC3, 0x29, 
0x03, 0x00, 0x01, 0xB7, 0x14, 0xE1, 0x01, 0xA8, 0x03, 0x00, 0x30, 0xFE, 0x00, 0x00, 0x09, 0xFE, 
0x03, 0x00, 0x01, 0x04, 0x1E, 0xE1, 0x01, 0x61, 0x03, 0x00, 0x00, 0x05, 0x32, 0xBD, 0xC3, 0xC3, 
0x83, 0x00, 0x03, 0x00, 0x01, 0x61, 0x14, 0xE1, 0x01, 0xB7, 0x03, 0x00, 0x30, 0xFE, 0x00, 0x00, 
0x09, 0xFE, 0x03, 0x00, 0x01, 0x4E, 0x1D, 0xE1, 0x00, 0x06, 0xD6, 0x04, 0x00, 0x00, 0x03, 0xA9, 
0x03, 0xC3, 0x00, 0x06, 0xBD, 0x0C, 0x00, 0x00, 0x04, 0xD6, 0x13, 0xE1, 0x01, 0xC7, 0x04, 0x00, 
0x2F, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0x7E, 0x1D, 0xE1, 0x01, 0x6F, 0x03, 0x00, 
0x01, 0x67, 0x05, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0x6F, 0x13, 0xE1, 0x01, 0xD6, 0x04, 0x00, 
0x2F, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0x8C, 0x1C, 0xE1, 0x00, 0x06, 0xD6, 0x04, 
0x00, 0x00, 0x03, 0xB5, 0x05, 0xC3, 0x00, 0x05, 0xB5, 0x03, 0x00, 0x00, 0x1F, 0x00, 0x13, 0xE1, 
0x01, 0xC7, 0x04, 0x00, 0x2F, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0x9C, 0x1C, 0xE1, 
0x01, 0x8C, 0x03, 0x00, 0x01, 0x5A, 0x07, 0xC3, 0x01, 0x47, 0x03, 0x00, 0x01, 0xD6, 0x12, 0xE1, 
0x01, 0x9C, 0x03, 0x00, 0x30, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0xA8, 0x1C, 0xE1, 
0x01, 0x44, 0x03, 0x00, 0x01, 0xA9, 0x07, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0x9C, 0x12, 0xE1, 
0x01, 0x6F, 0x03, 0x00, 0x30, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0x9C, 0x1B, 0xE1, 
0x00, 0x05, 0xD6, 0x04, 0x00, 0x00, 0x29, 0x00, 0x08, 0xC3, 0x01, 0x9F, 0x03, 0x00, 0x01, 0x6F, 
0x12, 0xE1, 0x01, 0x2D, 0x03, 0x00, 0x30, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0x7E, 
0x1B, 0xE1, 0x01, 0x9C, 0x03, 0x00, 0x01, 0x71, 0x08, 0xC3, 0x00, 0x05, 0xBD, 0x05, 0x00, 0x00, 
0x26, 0x00, 0x11, 0xE1, 0x01, 0xB7, 0x04, 0x00, 0x30, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 
0x01, 0x6F, 0x1B, 0xE1, 0x01, 0x6F, 0x03, 0x00, 0x01, 0xA9, 0x09, 0xC3, 0x00, 0x05, 0x40, 0x00, 
0x00, 0x03, 0xD6, 0x00, 0x10, 0xE1, 0x01, 0x53, 0x03, 0x00, 0x31, 0xFE, 0x00, 0x00, 0x09, 0xFE, 
0x03, 0x00, 0x01, 0x4E, 0x1B, 0xE1, 0x00, 0x04, 0x44, 0x00, 0x00, 0x03, 0x0A, 0xC3, 0x01, 0x71, 
0x03, 0x00, 0x01, 0xA8, 0x0F, 0xE1, 0x01, 0xD6, 0x01, 0x04, 0x03, 0x00, 0x31, 0xFE, 0x00, 0x00, 
0x09, 0xFE, 0x03, 0x00, 0x01, 0x2D, 0x1B, 0xE1, 0x00, 0x04, 0x1F, 0x00, 0x00, 0x18, 0x0A, 0xC3, 
0x01, 0x9F, 0x03, 0x00, 0x01, 0x6F, 0x0F, 0xE1, 0x01, 0x53, 0x03, 0x00, 0x32, 0xFE, 0x00, 0x00, 
0x09, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x01, 0xDD, 0x1A, 0xE1, 0x00, 0x04, 0x04, 0x00, 0x00, 0x32, 
0x0B, 0xC3, 0x00, 0x04, 0x03, 0x00, 0x00, 0x2D, 0x0E, 0xE1, 0x01, 0xA8, 0x04, 0x00, 0x32, 0xFE, 
0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 0x01, 0xA8, 0x19, 0xE1, 0x01, 0xD6, 0x03, 0x00, 0x01, 0x52, 
0x0B, 0xC3, 0x00, 0x05, 0x32, 0x00, 0x00, 0x01, 0xDD, 0x00, 0x0C, 0xE1, 0x01, 0xDD, 0x01, 0x26, 
0x03, 0x00, 0x33, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 0x01, 0x7E, 0x19, 0xE1, 0x01, 0xA8, 
0x03, 0x00, 0x01, 0x71, 0x0B, 0xC3, 0x01, 0x52, 0x03, 0x00, 0x01, 0xD6, 0x0C, 0xE1, 0x01, 0x6F, 
0x04, 0x00, 0x33, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 0x01, 0x38, 0x19, 0xE1, 0x01, 0x8C, 
0x03, 0x00, 0x01, 0x8B, 0x0B, 0xC3, 0x01, 0x5A, 0x03, 0x00, 0x01, 0xC7, 0x0B, 0xE1, 0x01, 0xA8, 
0x01, 0x03, 0x03, 0x00, 0x34, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x01, 0xD6, 
0x18, 0xE1, 0x01, 0x6F, 0x03, 0x00, 0x01, 0x9F, 0x0B, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0xB7, 
0x0A, 0xE1, 0x01, 0xD6, 0x01, 0x0A, 0x03, 0x00, 0x35, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x03, 0x00, 
0x01, 0x8C, 0x18, 0xE1, 0x01, 0x61, 0x03, 0x00, 0x01, 0xBD, 0x0B, 0xC3, 0x01, 0x7B, 0x03, 0x00, 
0x01, 0xA8, 0x0A, 0xE1, 0x01, 0x44, 0x04, 0x00, 0x35, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x03, 0x00, 
0x01, 0x2D, 0x18, 0xE1, 0x01, 0x61, 0x03, 0x00, 0x01, 0xBD, 0x0B, 0xC3, 0x01, 0x83, 0x03, 0x00, 
0x01, 0x9C, 0x09, 0xE1, 0x01, 0x8C, 0x04, 0x00, 0x36, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x04, 0x00, 
0x01, 0xB7, 0x17, 0xE1, 0x01, 0x6F, 0x03, 0x00, 0x01, 0xB5, 0x0B, 0xC3, 0x01, 0x8B, 0x03, 0x00, 
0x01, 0x9C, 0x08, 0xE1, 0x01, 0xC7, 0x01, 0x04, 0x03, 0x00, 0x37, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 
0x03, 0x00, 0x01, 0x61, 0x17, 0xE1, 0x01, 0x6F, 0x03, 0x00, 0x01, 0xA9, 0x0B, 0xC3, 0x01, 0x98, 
0x03, 0x00, 0x01, 0x8C, 0x08, 0xE1, 0x01, 0x38, 0x04, 0x00, 0x37, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 
0x03, 0x00, 0x01, 0x04, 0x01, 0xD6, 0x0B, 0xE1, 0x00, 0x05, 0xDD, 0x61, 0x0A, 0x2D, 0xA8, 0x00, 
0x06, 0xE1, 0x01, 0x7E, 0x03, 0x00, 0x01, 0xA9, 0x0B, 0xC3, 0x01, 0x9F, 0x03, 0x00, 0x00, 0x09, 
0x7E, 0xE1, 0x7E, 0x13, 0x26, 0x9C, 0xE1, 0xE1, 0x8C, 0x00, 0x04, 0x00, 0x38, 0xFE, 0x00, 0x00, 
0x0C, 0xFE, 0x04, 0x00, 0x01, 0x8C, 0x0B, 0xE1, 0x01, 0x44, 0x03, 0x00, 0x01, 0x04, 0x01, 0xB7, 
0x05, 0xE1, 0x01, 0x7E, 0x03, 0x00, 0x01, 0x9F, 0x0B, 0xC3, 0x01, 0x8B, 0x03, 0x00, 0x01, 0x8C, 
0x01, 0x6F, 0x04, 0x00, 0x00, 0x03, 0x9C, 0xD6, 0x04, 0x00, 0x03, 0x00, 0x39, 0xFE, 0x00, 0x00, 
0x0D, 0xFE, 0x03, 0x00, 0x01, 0x26, 0x0A, 0xE1, 0x01, 0xB7, 0x05, 0x00, 0x01, 0x38, 0x05, 0xE1, 
0x01, 0x8C, 0x03, 0x00, 0x01, 0x98, 0x0B, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0x9C, 0x01, 0x04, 
0x04, 0x00, 0x01, 0x13, 0x01, 0x9C, 0x04, 0x00, 0x39, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 0x04, 0x00, 
0x01, 0xB7, 0x09, 0xE1, 0x01, 0x7E, 0x05, 0x00, 0x01, 0x01, 0x01, 0xDD, 0x04, 0xE1, 0x01, 0x9C, 
0x03, 0x00, 0x01, 0x91, 0x0B, 0xC3, 0x01, 0x52, 0x03, 0x00, 0x01, 0x8C, 0x06, 0x00, 0x01, 0x38, 
0x03, 0x00, 0x3A, 0xFE, 0x00, 0x00, 0x0E, 0xFE, 0x03, 0x00, 0x01, 0x61, 0x09, 0xE1, 0x01, 0x61, 
0x06, 0x00, 0x01, 0xC7, 0x04, 0xE1, 0x01, 0x9C, 0x03, 0x00, 0x01, 0x8B, 0x0B, 0xC3, 0x00, 0x05, 
0x32, 0x00, 0x00, 0x04, 0x7E, 0x00, 0x06, 0x00, 0x01, 0x01, 0x03, 0x00, 0x3A, 0xFE, 0x00, 0x00, 
0x0E, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x01, 0xD6, 0x08, 0xE1, 0x01, 0x6F, 0x06, 0x00, 0x01, 0xD6, 
0x04, 0xE1, 0x01, 0xA8, 0x03, 0x00, 0x01, 0x83, 0x0B, 0xC3, 0x00, 0x05, 0x0C, 0x00, 0x00, 0x2D, 
0x9C, 0x00, 0x09, 0x00, 0x3B, 0xFE, 0x00, 0x00, 0x0E, 0xFE, 0x04, 0x00, 0x01, 0x53, 0x08, 0xE1, 
0x01, 0x9C, 0x05, 0x00, 0x01, 0x26, 0x05, 0xE1, 0x01, 0xC7, 0x03, 0x00, 0x01, 0x40, 0x0A, 0xC3, 
0x00, 0x07, 0xAD, 0x03, 0x00, 0x00, 0x53, 0xC7, 0x03, 0x00, 0x04, 0x00, 0x01, 0x04, 0x03, 0x00, 
0x3B, 0xFE, 0x00, 0x00, 0x0F, 0xFE, 0x04, 0x00, 0x01, 0xB7, 0x08, 0xE1, 0x01, 0x2D, 0x04, 0x00, 
0x01, 0x9C, 0x06, 0xE1, 0x00, 0x05, 0x2D, 0x00, 0x00, 0x03, 0x83, 0x00, 0x08, 0xC3, 0x01, 0xBD, 
0x01, 0x47, 0x03, 0x00, 0x00, 0x03, 0x7E, 0xE1, 0x53, 0x00, 0x04, 0x00, 0x01, 0x04, 0x03, 0x00, 
0x3B, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x03, 0x00, 0x01, 0x2D, 0x08, 0xE1, 0x00, 0x05, 0xD6, 0x2D, 
0x00, 0x04, 0x7E, 0x00, 0x07, 0xE1, 0x01, 0x7E, 0x03, 0x00, 0x00, 0x04, 0x03, 0x47, 0x98, 0xBD, 
0x03, 0xC3, 0x00, 0x03, 0xB5, 0x83, 0x20, 0x00, 0x03, 0x00, 0x00, 0x08, 0x04, 0xD6, 0xE1, 0xD6, 
0x4E, 0x01, 0x04, 0x61, 0x04, 0x00, 0x3B, 0xFE, 0x00, 0x00, 0x10, 0xFE, 0x04, 0x00, 0x01, 0x8C, 
0x09, 0xE1, 0x01, 0xD6, 0x09, 0xE1, 0x01, 0xD6, 0x01, 0x38, 0x05, 0x00, 0x00, 0x05, 0x03, 0x18, 
0x20, 0x0C, 0x03, 0x00, 0x05, 0x00, 0x01, 0x8C, 0x04, 0xE1, 0x00, 0x03, 0xD6, 0xD6, 0x8C, 0x00, 
0x03, 0x00, 0x3C, 0xFE, 0x00, 0x00, 0x11, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x01, 0xC7, 0x13, 0xE1, 
0x01, 0xD6, 0x01, 0x38, 0x0C, 0x00, 0x01, 0x01, 0x01, 0x6F, 0x06, 0xE1, 0x01, 0xDD, 0x01, 0x13, 
0x03, 0x00, 0x3C, 0xFE, 0x00, 0x00, 0x11, 0xFE, 0x04, 0x00, 0x01, 0x1F, 0x01, 0xD6, 0x13, 0xE1, 
0x00, 0x03, 0xD6, 0x7E, 0x13, 0x00, 0x09, 0x00, 0x01, 0x26, 0x01, 0xB7, 0x07, 0xE1, 0x01, 0x7E, 
0x04, 0x00, 0x3C, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x04, 0x00, 0x01, 0x53, 0x16, 0xE1, 0x00, 0x09, 
0x9C, 0x6F, 0x44, 0x1F, 0x26, 0x38, 0x4E, 0x7E, 0xC7, 0x00, 0x08, 0xE1, 0x01, 0xD6, 0x01, 0x04, 
0x03, 0x00, 0x3D, 0xFE, 0x00, 0x00, 0x13, 0xFE, 0x04, 0x00, 0x01, 0x61, 0x26, 0xE1, 0x01, 0x6F, 
0x04, 0x00, 0x3D, 0xFE, 0x00, 0x00, 0x14, 0xFE, 0x04, 0x00, 0x01, 0x61, 0x24, 0xE1, 0x01, 0x8C, 
0x04, 0x00, 0x3E, 0xFE, 0x00, 0x00, 0x14, 0xFE, 0x05, 0x00, 0x01, 0x61, 0x22, 0xE1, 0x01, 0xA8, 
0x01, 0x04, 0x04, 0x00, 0x3E, 0xFE, 0x00, 0x00, 0x15, 0xFE, 0x05, 0x00, 0x01, 0x4E, 0x01, 0xD6, 
0x1F, 0xE1, 0x01, 0xC7, 0x01, 0x04, 0x04, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x16, 0xFE, 0x05, 0x00, 
0x01, 0x1F, 0x01, 0xC7, 0x1D, 0xE1, 0x01, 0x9C, 0x01, 0x04, 0x04, 0x00, 0x40, 0xFE, 0x00, 0x00, 
0x17, 0xFE, 0x05, 0x00, 0x01, 0x04, 0x01, 0x9C, 0x1B, 0xE1, 0x01, 0x6F, 0x05, 0x00, 0x41, 0xFE, 
0x00, 0x00, 0x19, 0xFE, 0x05, 0x00, 0x01, 0x44, 0x01, 0xC7, 0x17, 0xE1, 0x01, 0xB7, 0x01, 0x38, 
0x05, 0x00, 0x42, 0xFE, 0x00, 0x00, 0x1A, 0xFE, 0x05, 0x00, 0x00, 0x03, 0x04, 0x6F, 0xD6, 0x00, 
0x13, 0xE1, 0x01, 0xA8, 0x01, 0x38, 0x06, 0x00, 0x43, 0xFE, 0x00, 0x00, 0x1B, 0xFE, 0x06, 0x00, 
0x00, 0x03, 0x0A, 0x6F, 0xC7, 0x00, 0x0E, 0xE1, 0x00, 0x03, 0xD6, 0x9C, 0x26, 0x00, 0x07, 0x00, 
0x44, 0xFE, 0x00, 0x00, 0x1D, 0xFE, 0x07, 0x00, 0x00, 0x04, 0x26, 0x7E, 0xA8, 0xD6, 0x07, 0xE1, 
0x00, 0x04, 0xB7, 0x7E, 0x38, 0x04, 0x07, 0x00, 0x46, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x0A, 0x00, 
0x00, 0x07, 0x04, 0x2D, 0x38, 0x26, 0x13, 0x04, 0x01, 0x00, 0x09, 0x00, 0x48, 0xFE, 0x00, 0x00, 
0x20, 0xFE, 0x16, 0x00, 0x4A, 0xFE, 0x00, 0x00, 0x23, 0xFE, 0x10, 0x00, 0x4D, 0xFE, 0x00, 0x00, 
0x27, 0xFE, 0x09, 0x00, 0x50, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x01, 
};

constexpr unsigned char parrot07[] = {
0x42, 0x4D, 0x02, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x04, 0x00, 0x00, 0x28, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x01, 0x00, 
0x00, 0x00, 0xD0, 0x08, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0xFF, 0x00, 
0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x08, 0x04, 
0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x0B, 0x05, 0x08, 0x00, 0x06, 0x0A, 0x07, 0x00, 0x06, 0x08, 
0x0E, 0x00, 0x0E, 0x0B, 0x04, 0x00, 0x0F, 0x07, 0x12, 0x00, 0x0B, 0x0C, 0x12, 0x00, 0x16, 0x0B, 
0x12, 0x00, 0x0C, 0x0B, 0x17, 0x00, 0x0C, 0x10, 0x0D, 0x00, 0x13, 0x11, 0x08, 0x00, 0x12, 0x0C, 
0x1C, 0x00, 0x19, 0x0C, 0x1B, 0x00, 0x18, 0x10, 0x10, 0x00, 0x0A, 0x0D, 0x21, 0x00, 0x08, 0x13, 
0x10, 0x00, 0x1E, 0x0E, 0x1A, 0x00, 0x0A, 0x12, 0x18, 0x00, 0x1B, 0x15, 0x0E, 0x00, 0x1C, 0x10, 
0x1F, 0x00, 0x14, 0x11, 0x1F, 0x00, 0x12, 0x15, 0x13, 0x00, 0x23, 0x10, 0x24, 0x00, 0x1B, 0x10, 
0x28, 0x00, 0x0E, 0x15, 0x1C, 0x00, 0x0E, 0x1A, 0x0D, 0x00, 0x19, 0x19, 0x0D, 0x00, 0x11, 0x13, 
0x25, 0x00, 0x23, 0x13, 0x1F, 0x00, 0x12, 0x1A, 0x15, 0x00, 0x12, 0x13, 0x2E, 0x00, 0x25, 0x1A, 
0x16, 0x00, 0x2E, 0x14, 0x30, 0x00, 0x17, 0x18, 0x2C, 0x00, 0x20, 0x20, 0x0F, 0x00, 0x2D, 0x19, 
0x23, 0x00, 0x13, 0x1C, 0x23, 0x00, 0x13, 0x21, 0x13, 0x00, 0x17, 0x1F, 0x1A, 0x00, 0x24, 0x16, 
0x34, 0x00, 0x32, 0x14, 0x37, 0x00, 0x17, 0x17, 0x38, 0x00, 0x2E, 0x19, 0x2B, 0x00, 0x1C, 0x1D, 
0x32, 0x00, 0x15, 0x21, 0x29, 0x00, 0x32, 0x23, 0x1B, 0x00, 0x26, 0x26, 0x15, 0x00, 0x1D, 0x25, 
0x20, 0x00, 0x16, 0x29, 0x15, 0x00, 0x3B, 0x1A, 0x3B, 0x00, 0x1D, 0x1B, 0x43, 0x00, 0x2F, 0x1B, 
0x40, 0x00, 0x36, 0x1E, 0x34, 0x00, 0x3D, 0x20, 0x33, 0x00, 0x23, 0x21, 0x3D, 0x00, 0x3B, 0x20, 
0x3D, 0x00, 0x3A, 0x29, 0x22, 0x00, 0x44, 0x1D, 0x47, 0x00, 0x1F, 0x1F, 0x4D, 0x00, 0x2C, 0x2D, 
0x1A, 0x00, 0x1A, 0x28, 0x31, 0x00, 0x22, 0x2B, 0x27, 0x00, 0x37, 0x1F, 0x4D, 0x00, 0x3F, 0x23, 
0x41, 0x00, 0x26, 0x27, 0x48, 0x00, 0x47, 0x27, 0x3E, 0x00, 0x4E, 0x22, 0x4E, 0x00, 0x1F, 0x2F, 
0x39, 0x00, 0x25, 0x32, 0x2D, 0x00, 0x25, 0x26, 0x56, 0x00, 0x3F, 0x24, 0x59, 0x00, 0x1F, 0x39, 
0x1E, 0x00, 0x35, 0x37, 0x1E, 0x00, 0x47, 0x33, 0x27, 0x00, 0x53, 0x24, 0x58, 0x00, 0x4F, 0x2B, 
0x42, 0x00, 0x2B, 0x2C, 0x50, 0x00, 0x28, 0x28, 0x5F, 0x00, 0x4D, 0x2A, 0x4D, 0x00, 0x2A, 0x38, 
0x30, 0x00, 0x55, 0x30, 0x49, 0x00, 0x30, 0x2F, 0x59, 0x00, 0x60, 0x29, 0x62, 0x00, 0x2B, 0x2C, 
0x6B, 0x00, 0x49, 0x2B, 0x68, 0x00, 0x55, 0x2F, 0x59, 0x00, 0x26, 0x3A, 0x45, 0x00, 0x31, 0x3F, 
0x36, 0x00, 0x58, 0x3E, 0x2E, 0x00, 0x65, 0x2B, 0x6B, 0x00, 0x26, 0x46, 0x26, 0x00, 0x2F, 0x30, 
0x6F, 0x00, 0x5C, 0x32, 0x59, 0x00, 0x47, 0x46, 0x24, 0x00, 0x62, 0x36, 0x52, 0x00, 0x37, 0x36, 
0x61, 0x00, 0x51, 0x31, 0x75, 0x00, 0x32, 0x33, 0x7A, 0x00, 0x2A, 0x41, 0x4E, 0x00, 0x5E, 0x44, 
0x34, 0x00, 0x38, 0x47, 0x3D, 0x00, 0x65, 0x38, 0x66, 0x00, 0x75, 0x32, 0x79, 0x00, 0x2D, 0x52, 
0x2D, 0x00, 0x58, 0x35, 0x81, 0x00, 0x37, 0x37, 0x86, 0x00, 0x69, 0x4A, 0x37, 0x00, 0x3C, 0x3E, 
0x71, 0x00, 0x72, 0x3E, 0x61, 0x00, 0x53, 0x52, 0x2C, 0x00, 0x39, 0x4D, 0x46, 0x00, 0x30, 0x49, 
0x57, 0x00, 0x62, 0x37, 0x86, 0x00, 0x32, 0x58, 0x2B, 0x00, 0x72, 0x3D, 0x71, 0x00, 0x58, 0x56, 
0x30, 0x00, 0x2F, 0x5B, 0x31, 0x00, 0x3E, 0x3D, 0x93, 0x00, 0x86, 0x3A, 0x88, 0x00, 0x73, 0x52, 
0x3E, 0x00, 0x3F, 0x54, 0x4B, 0x00, 0x45, 0x45, 0x7E, 0x00, 0x69, 0x3D, 0x90, 0x00, 0x85, 0x48, 
0x6F, 0x00, 0x81, 0x45, 0x81, 0x00, 0x41, 0x43, 0xA1, 0x00, 0x37, 0x56, 0x66, 0x00, 0x7F, 0x5A, 
0x41, 0x00, 0x46, 0x5C, 0x4F, 0x00, 0x93, 0x3F, 0x98, 0x00, 0x38, 0x66, 0x36, 0x00, 0x63, 0x63, 
0x34, 0x00, 0x73, 0x43, 0xA0, 0x00, 0x4F, 0x4D, 0x8E, 0x00, 0x9C, 0x42, 0xA1, 0x00, 0x3D, 0x5D, 
0x6D, 0x00, 0x4C, 0x63, 0x55, 0x00, 0x95, 0x51, 0x7C, 0x00, 0x89, 0x62, 0x4A, 0x00, 0x9F, 0x45, 
0xA5, 0x00, 0x4B, 0x4B, 0xB3, 0x00, 0x50, 0x53, 0x97, 0x00, 0x51, 0x68, 0x5A, 0x00, 0x7E, 0x4A, 
0xB1, 0x00, 0x93, 0x51, 0x94, 0x00, 0x40, 0x75, 0x40, 0x00, 0xAB, 0x49, 0xB0, 0x00, 0x56, 0x57, 
0xA1, 0x00, 0x71, 0x72, 0x3F, 0x00, 0x50, 0x6C, 0x60, 0x00, 0x42, 0x67, 0x79, 0x00, 0x98, 0x6A, 
0x53, 0x00, 0x50, 0x50, 0xC3, 0x00, 0xA5, 0x5A, 0x8A, 0x00, 0xA0, 0x57, 0x9C, 0x00, 0x87, 0x4F, 
0xC1, 0x00, 0x56, 0x72, 0x66, 0x00, 0xB8, 0x4F, 0xBF, 0x00, 0x44, 0x80, 0x45, 0x00, 0x60, 0x60, 
0xAF, 0x00, 0xA8, 0x5C, 0xA9, 0x00, 0x7D, 0x7E, 0x46, 0x00, 0x59, 0x58, 0xD5, 0x00, 0x8F, 0x55, 
0xCD, 0x00, 0xA5, 0x75, 0x5D, 0x00, 0xB5, 0x63, 0x98, 0x00, 0x5D, 0x7A, 0x6D, 0x00, 0xC6, 0x54, 
0xCB, 0x00, 0x4C, 0x76, 0x8A, 0x00, 0x4B, 0x89, 0x4B, 0x00, 0x61, 0x7F, 0x6C, 0x00, 0x69, 0x68, 
0xBC, 0x00, 0x5E, 0x5F, 0xE4, 0x00, 0x9B, 0x5B, 0xDD, 0x00, 0xCD, 0x59, 0xD5, 0x00, 0xB9, 0x64, 
0xB8, 0x00, 0xB2, 0x7E, 0x63, 0x00, 0x88, 0x8B, 0x4D, 0x00, 0x66, 0x84, 0x71, 0x00, 0xD8, 0x5B, 
0xDD, 0x00, 0xC7, 0x6D, 0xA7, 0x00, 0x64, 0x62, 0xEE, 0x00, 0x9F, 0x60, 0xE5, 0x00, 0x51, 0x96, 
0x51, 0x00, 0x6E, 0x6F, 0xCC, 0x00, 0x54, 0x81, 0x9B, 0x00, 0x6B, 0x8A, 0x76, 0x00, 0xA9, 0x62, 
0xEB, 0x00, 0x68, 0x66, 0xF4, 0x00, 0xDD, 0x60, 0xE2, 0x00, 0xC3, 0x6B, 0xC6, 0x00, 0xC1, 0x88, 
0x69, 0x00, 0x68, 0x8C, 0x7B, 0x00, 0x96, 0x96, 0x51, 0x00, 0x68, 0x69, 0xFF, 0x00, 0xE4, 0x62, 
0xED, 0x00, 0xD6, 0x75, 0xB3, 0x00, 0xD0, 0x6F, 0xCF, 0x00, 0xB1, 0x66, 0xF8, 0x00, 0x5A, 0xA1, 
0x55, 0x00, 0x77, 0x77, 0xDB, 0x00, 0xCA, 0x8F, 0x6F, 0x00, 0xA1, 0x9F, 0x56, 0x00, 0xB7, 0x6C, 
0xFE, 0x00, 0x5D, 0x8E, 0xAB, 0x00, 0xD7, 0x76, 0xD6, 0x00, 0xF3, 0x69, 0xFA, 0x00, 0xF7, 0x68, 
0xFF, 0x00, 0x5A, 0xA9, 0x5D, 0x00, 0xD7, 0x98, 0x74, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0xEB, 0x80, 
0xC5, 0x00, 0xE0, 0x7B, 0xE3, 0x00, 0x85, 0x82, 0xF1, 0x00, 0xAD, 0xAC, 0x5A, 0x00, 0x64, 0x99, 
0xB8, 0x00, 0xE1, 0xA0, 0x7A, 0x00, 0x63, 0xB5, 0x62, 0x00, 0xF8, 0x87, 0xCF, 0x00, 0x85, 0x88, 
0xF9, 0x00, 0xF1, 0x83, 0xF1, 0x00, 0xE8, 0xA6, 0x81, 0x00, 0xFF, 0x8C, 0xD7, 0x00, 0x8B, 0x8D, 
0xFF, 0x00, 0xF3, 0xAB, 0x80, 0x00, 0xF8, 0x88, 0xFA, 0x00, 0x68, 0xC2, 0x68, 0x00, 0xBE, 0xBE, 
0x67, 0x00, 0x6D, 0xA9, 0xCB, 0x00, 0xF9, 0xB0, 0x86, 0x00, 0xFF, 0x8C, 0xFF, 0x00, 0x70, 0xCB, 
0x6E, 0x00, 0xFE, 0xB5, 0x8B, 0x00, 0xC6, 0xC6, 0x6A, 0x00, 0x71, 0xD3, 0x73, 0x00, 0x78, 0xB7, 
0xDA, 0x00, 0xCE, 0xCF, 0x72, 0x00, 0x78, 0xDB, 0x78, 0x00, 0x7C, 0xE5, 0x7C, 0x00, 0x7F, 0xC4, 
0xEA, 0x00, 0xDB, 0xDD, 0x78, 0x00, 0x81, 0xED, 0x81, 0x00, 0xE3, 0xE5, 0x7E, 0x00, 0x88, 0xCF, 
0xF5, 0x00, 0x87, 0xF5, 0x84, 0x00, 0xEC, 0xEF, 0x87, 0x00, 0x89, 0xD6, 0xFE, 0x00, 0x87, 0xFA, 
0x8C, 0x00, 0xF1, 0xF3, 0x8C, 0x00, 0x89, 0xFF, 0x88, 0x00, 0xFB, 0xF9, 0x80, 0x00, 0xFF, 0xFF, 
0x87, 0x00, 0x08, 0xFE, 0x56, 0x00, 0x22, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x55, 0x00, 0x23, 0xFE, 
0x00, 0x00, 0x08, 0xFE, 0x55, 0x00, 0x23, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0x16, 
0x4B, 0x58, 0x01, 0x37, 0x04, 0x00, 0x23, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x03, 0x00, 0x01, 0x1F, 
0x23, 0xE9, 0x01, 0xE4, 0x27, 0xE9, 0x01, 0x5F, 0x03, 0x00, 0x24, 0xFE, 0x00, 0x00, 0x09, 0xFE, 
0x04, 0x00, 0x01, 0xC8, 0x1A, 0xE9, 0x00, 0x0A, 0xDF, 0xB2, 0x7F, 0x68, 0x51, 0x37, 0x16, 0x04, 
0x04, 0x68, 0x26, 0xE9, 0x01, 0x04, 0x03, 0x00, 0x24, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 
0x01, 0x58, 0x16, 0xE9, 0x00, 0x05, 0xDF, 0x9D, 0x68, 0x2D, 0x03, 0x00, 0x09, 0x00, 0x01, 0xD0, 
0x24, 0xE9, 0x01, 0xD7, 0x04, 0x00, 0x24, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x03, 0x00, 0x01, 0x03, 
0x01, 0xD0, 0x13, 0xE9, 0x00, 0x03, 0xB2, 0x5F, 0x04, 0x00, 0x0C, 0x00, 0x01, 0x0A, 0x01, 0xDF, 
0x24, 0xE9, 0x01, 0xA3, 0x03, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x03, 0x00, 0x01, 0x3A, 
0x01, 0xE4, 0x10, 0xE9, 0x01, 0x9D, 0x01, 0x1F, 0x0A, 0x00, 0x00, 0x06, 0x04, 0x1F, 0x37, 0x51, 
0x68, 0xC8, 0x25, 0xE9, 0x01, 0x7F, 0x03, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x04, 0x00, 
0x01, 0x51, 0x0E, 0xE9, 0x01, 0xC8, 0x01, 0x37, 0x07, 0x00, 0x00, 0x05, 0x0F, 0x58, 0x93, 0xC1, 
0xDF, 0x00, 0x2B, 0xE9, 0x01, 0x68, 0x03, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 0x04, 0x00, 
0x01, 0x68, 0x0B, 0xE9, 0x00, 0x03, 0xDF, 0x68, 0x01, 0x00, 0x05, 0x00, 0x00, 0x03, 0x0F, 0x75, 
0xD0, 0x00, 0x30, 0xE9, 0x01, 0x75, 0x03, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 0x04, 0x00, 
0x01, 0x68, 0x09, 0xE9, 0x01, 0xDF, 0x01, 0x37, 0x05, 0x00, 0x01, 0x51, 0x01, 0xB2, 0x33, 0xE9, 
0x01, 0x7F, 0x03, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 0x05, 0x00, 0x01, 0x51, 0x01, 0xDF, 
0x06, 0xE9, 0x01, 0xD7, 0x01, 0x2D, 0x04, 0x00, 0x01, 0x2D, 0x01, 0xC1, 0x35, 0xE9, 0x01, 0x7F, 
0x03, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x0E, 0xFE, 0x05, 0x00, 0x01, 0x37, 0x01, 0xDF, 0x04, 0xE9, 
0x01, 0xD7, 0x01, 0x16, 0x03, 0x00, 0x00, 0x03, 0x01, 0x7F, 0xE4, 0x00, 0x36, 0xE9, 0x01, 0xA3, 
0x03, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x0F, 0xFE, 0x05, 0x00, 0x01, 0x37, 0x01, 0xDF, 0x03, 0xE9, 
0x01, 0x42, 0x03, 0x00, 0x01, 0x04, 0x01, 0xA3, 0x38, 0xE9, 0x01, 0xD7, 0x04, 0x00, 0x24, 0xFE, 
0x00, 0x00, 0x11, 0xFE, 0x04, 0x00, 0x00, 0x04, 0x51, 0xE9, 0xE9, 0x93, 0x03, 0x00, 0x01, 0x04, 
0x01, 0xC1, 0x3A, 0xE9, 0x01, 0x16, 0x03, 0x00, 0x24, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x04, 0x00, 
0x00, 0x03, 0x75, 0xD0, 0x04, 0x00, 0x03, 0x00, 0x01, 0xA3, 0x27, 0xE9, 0x01, 0xB2, 0x01, 0xD7, 
0x12, 0xE9, 0x01, 0x5F, 0x03, 0x00, 0x24, 0xFE, 0x00, 0x00, 0x13, 0xFE, 0x04, 0x00, 0x01, 0x51, 
0x03, 0x00, 0x01, 0x5F, 0x27, 0xE9, 0x00, 0x03, 0xDF, 0x0F, 0x7F, 0x00, 0x12, 0xE9, 0x01, 0xA3, 
0x03, 0x00, 0x24, 0xFE, 0x00, 0x00, 0x13, 0xFE, 0x04, 0x00, 0x00, 0x05, 0x04, 0x00, 0x00, 0x08, 
0xDF, 0x00, 0x27, 0xE9, 0x00, 0x04, 0x51, 0x00, 0x0A, 0xE4, 0x11, 0xE9, 0x01, 0xDF, 0x01, 0x01, 
0x03, 0x00, 0x23, 0xFE, 0x00, 0x00, 0x14, 0xFE, 0x06, 0x00, 0x01, 0x75, 0x27, 0xE9, 0x01, 0x93, 
0x03, 0x00, 0x01, 0xA3, 0x12, 0xE9, 0x01, 0x3A, 0x03, 0x00, 0x23, 0xFE, 0x00, 0x00, 0x15, 0xFE, 
0x05, 0x00, 0x01, 0xC8, 0x26, 0xE9, 0x01, 0xD7, 0x01, 0x04, 0x03, 0x00, 0x01, 0x37, 0x12, 0xE9, 
0x01, 0x7F, 0x03, 0x00, 0x23, 0xFE, 0x00, 0x00, 0x15, 0xFE, 0x04, 0x00, 0x01, 0x2D, 0x26, 0xE9, 
0x01, 0xE4, 0x01, 0x37, 0x05, 0x00, 0x01, 0xC1, 0x11, 0xE9, 0x01, 0xC8, 0x04, 0x00, 0x22, 0xFE, 
0x00, 0x00, 0x15, 0xFE, 0x04, 0x00, 0x01, 0x58, 0x26, 0xE9, 0x01, 0x7F, 0x06, 0x00, 0x01, 0x51, 
0x12, 0xE9, 0x01, 0x16, 0x03, 0x00, 0x22, 0xFE, 0x00, 0x00, 0x15, 0xFE, 0x04, 0x00, 0x01, 0x68, 
0x25, 0xE9, 0x00, 0x0A, 0xC1, 0x01, 0x00, 0x00, 0x03, 0x05, 0x00, 0x00, 0x03, 0xD0, 0x11, 0xE9, 
0x01, 0x68, 0x03, 0x00, 0x22, 0xFE, 0x00, 0x00, 0x15, 0xFE, 0x04, 0x00, 0x01, 0x68, 0x24, 0xE9, 
0x01, 0xDF, 0x01, 0x1F, 0x03, 0x00, 0x01, 0x5A, 0x01, 0x7B, 0x03, 0x00, 0x01, 0x68, 0x11, 0xE9, 
0x01, 0xB2, 0x04, 0x00, 0x21, 0xFE, 0x00, 0x00, 0x16, 0xFE, 0x03, 0x00, 0x01, 0x75, 0x24, 0xE9, 
0x01, 0x68, 0x03, 0x00, 0x00, 0x08, 0x20, 0xBD, 0xB5, 0x05, 0x00, 0x00, 0x04, 0xDF, 0x10, 0xE9, 
0x01, 0xDF, 0x01, 0x04, 0x03, 0x00, 0x21, 0xFE, 0x00, 0x00, 0x16, 0xFE, 0x03, 0x00, 0x01, 0x68, 
0x23, 0xE9, 0x01, 0xB2, 0x03, 0x00, 0x00, 0x05, 0x03, 0x9F, 0xC3, 0xC3, 0x5A, 0x00, 0x03, 0x00, 
0x01, 0x7F, 0x11, 0xE9, 0x01, 0x51, 0x03, 0x00, 0x21, 0xFE, 0x00, 0x00, 0x16, 0xFE, 0x03, 0x00, 
0x01, 0x37, 0x23, 0xE9, 0x01, 0x3A, 0x03, 0x00, 0x01, 0x71, 0x03, 0xC3, 0x00, 0x06, 0xA9, 0x03, 
0x00, 0x00, 0x16, 0xE4, 0x10, 0xE9, 0x01, 0x93, 0x03, 0x00, 0x21, 0xFE, 0x00, 0x00, 0x16, 0xFE, 
0x03, 0x00, 0x01, 0x0A, 0x22, 0xE9, 0x01, 0xC1, 0x03, 0x00, 0x01, 0x29, 0x01, 0xBD, 0x04, 0xC3, 
0x01, 0x52, 0x03, 0x00, 0x01, 0xA3, 0x10, 0xE9, 0x01, 0xA3, 0x03, 0x00, 0x21, 0xFE, 0x00, 0x00, 
0x16, 0xFE, 0x04, 0x00, 0x01, 0xDF, 0x21, 0xE9, 0x01, 0x51, 0x03, 0x00, 0x01, 0x8B, 0x05, 0xC3, 
0x01, 0x9F, 0x03, 0x00, 0x01, 0x42, 0x10, 0xE9, 0x01, 0xC1, 0x03, 0x00, 0x21, 0xFE, 0x00, 0x00, 
0x17, 0xFE, 0x03, 0x00, 0x01, 0xC8, 0x20, 0xE9, 0x00, 0x05, 0xD0, 0x03, 0x00, 0x00, 0x18, 0x00, 
0x07, 0xC3, 0x00, 0x05, 0x29, 0x00, 0x00, 0x04, 0xE4, 0x00, 0x0F, 0xE9, 0x01, 0xD7, 0x04, 0x00, 
0x20, 0xFE, 0x00, 0x00, 0x17, 0xFE, 0x03, 0x00, 0x01, 0xA3, 0x20, 0xE9, 0x01, 0x7F, 0x03, 0x00, 
0x01, 0x7B, 0x07, 0xC3, 0x01, 0x67, 0x03, 0x00, 0x01, 0xC1, 0x0F, 0xE9, 0x01, 0xDF, 0x04, 0x00, 
0x20, 0xFE, 0x00, 0x00, 0x17, 0xFE, 0x03, 0x00, 0x01, 0x7F, 0x20, 0xE9, 0x00, 0x05, 0x37, 0x00, 
0x00, 0x03, 0xB5, 0x00, 0x07, 0xC3, 0x01, 0x91, 0x03, 0x00, 0x01, 0x7F, 0x0F, 0xE9, 0x01, 0xD0, 
0x04, 0x00, 0x20, 0xFE, 0x00, 0x00, 0x17, 0xFE, 0x03, 0x00, 0x01, 0x58, 0x1F, 0xE9, 0x01, 0xD7, 
0x03, 0x00, 0x01, 0x40, 0x08, 0xC3, 0x00, 0x05, 0xB5, 0x03, 0x00, 0x00, 0x42, 0x00, 0x0F, 0xE9, 
0x01, 0xB2, 0x03, 0x00, 0x21, 0xFE, 0x00, 0x00, 0x17, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x01, 0xE4, 
0x1E, 0xE9, 0x01, 0x93, 0x03, 0x00, 0x01, 0x7B, 0x09, 0xC3, 0x00, 0x05, 0x29, 0x00, 0x00, 0x04, 
0xE4, 0x00, 0x0E, 0xE9, 0x01, 0x9D, 0x03, 0x00, 0x21, 0xFE, 0x00, 0x00, 0x17, 0xFE, 0x04, 0x00, 
0x01, 0xB2, 0x1E, 0xE9, 0x01, 0x68, 0x03, 0x00, 0x01, 0xAD, 0x09, 0xC3, 0x01, 0x5A, 0x03, 0x00, 
0x01, 0xC1, 0x0E, 0xE9, 0x01, 0x5F, 0x03, 0x00, 0x21, 0xFE, 0x00, 0x00, 0x18, 0xFE, 0x03, 0x00, 
0x01, 0x68, 0x1E, 0xE9, 0x00, 0x04, 0x42, 0x00, 0x00, 0x03, 0x0A, 0xC3, 0x01, 0x8B, 0x03, 0x00, 
0x01, 0x7F, 0x0D, 0xE9, 0x01, 0xE4, 0x01, 0x04, 0x03, 0x00, 0x21, 0xFE, 0x00, 0x00, 0x18, 0xFE, 
0x03, 0x00, 0x01, 0x0A, 0x1E, 0xE9, 0x00, 0x04, 0x1F, 0x00, 0x00, 0x20, 0x0A, 0xC3, 0x00, 0x05, 
0xB5, 0x03, 0x00, 0x00, 0x42, 0x00, 0x0D, 0xE9, 0x01, 0xB2, 0x04, 0x00, 0x21, 0xFE, 0x00, 0x00, 
0x18, 0xFE, 0x04, 0x00, 0x01, 0xC1, 0x1C, 0xE9, 0x00, 0x05, 0xE4, 0x01, 0x00, 0x00, 0x47, 0x00, 
0x0B, 0xC3, 0x00, 0x05, 0x29, 0x00, 0x00, 0x04, 0xE4, 0x00, 0x0C, 0xE9, 0x01, 0x42, 0x03, 0x00, 
0x22, 0xFE, 0x00, 0x00, 0x19, 0xFE, 0x03, 0x00, 0x01, 0x75, 0x1C, 0xE9, 0x01, 0xD0, 0x03, 0x00, 
0x01, 0x5A, 0x0B, 0xC3, 0x01, 0x5A, 0x03, 0x00, 0x01, 0xD7, 0x0B, 0xE9, 0x01, 0xC1, 0x04, 0x00, 
0x22, 0xFE, 0x00, 0x00, 0x19, 0xFE, 0x03, 0x00, 0x01, 0x1F, 0x1C, 0xE9, 0x01, 0xB2, 0x03, 0x00, 
0x01, 0x7B, 0x0B, 0xC3, 0x01, 0x67, 0x03, 0x00, 0x01, 0xD0, 0x0B, 0xE9, 0x01, 0x42, 0x03, 0x00, 
0x23, 0xFE, 0x00, 0x00, 0x19, 0xFE, 0x04, 0x00, 0x01, 0xC8, 0x1B, 0xE9, 0x01, 0x93, 0x03, 0x00, 
0x01, 0x91, 0x0B, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0xC1, 0x0A, 0xE9, 0x01, 0xA3, 0x04, 0x00, 
0x23, 0xFE, 0x00, 0x00, 0x1A, 0xFE, 0x03, 0x00, 0x01, 0x7F, 0x1B, 0xE9, 0x01, 0x75, 0x03, 0x00, 
0x01, 0xA9, 0x0B, 0xC3, 0x01, 0x83, 0x03, 0x00, 0x01, 0xB2, 0x09, 0xE9, 0x01, 0xE4, 0x01, 0x1F, 
0x03, 0x00, 0x24, 0xFE, 0x00, 0x00, 0x1A, 0xFE, 0x03, 0x00, 0x01, 0x16, 0x01, 0xE4, 0x1A, 0xE9, 
0x01, 0x68, 0x03, 0x00, 0x01, 0xB5, 0x0B, 0xC3, 0x01, 0x8B, 0x03, 0x00, 0x01, 0xA3, 0x09, 0xE9, 
0x01, 0x7F, 0x04, 0x00, 0x24, 0xFE, 0x00, 0x00, 0x1A, 0xFE, 0x04, 0x00, 0x01, 0x93, 0x1A, 0xE9, 
0x01, 0x75, 0x03, 0x00, 0x01, 0xAD, 0x0B, 0xC3, 0x01, 0x91, 0x03, 0x00, 0x01, 0x93, 0x08, 0xE9, 
0x01, 0xD7, 0x01, 0x04, 0x03, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x1B, 0xFE, 0x03, 0x00, 0x01, 0x1F, 
0x1A, 0xE9, 0x01, 0x7F, 0x03, 0x00, 0x01, 0x9F, 0x0B, 0xC3, 0x01, 0x9F, 0x03, 0x00, 0x01, 0x7F, 
0x08, 0xE9, 0x01, 0x51, 0x04, 0x00, 0x25, 0xFE, 0x00, 0x00, 0x1B, 0xFE, 0x04, 0x00, 0x01, 0xA3, 
0x0F, 0xE9, 0x00, 0x04, 0xD7, 0x9D, 0xB2, 0xE4, 0x06, 0xE9, 0x01, 0x7F, 0x03, 0x00, 0x01, 0x9F, 
0x0B, 0xC3, 0x01, 0xA9, 0x03, 0x00, 0x00, 0x09, 0x75, 0xE9, 0xDF, 0xA3, 0xA3, 0xDF, 0xE9, 0xE9, 
0xC1, 0x00, 0x04, 0x00, 0x26, 0xFE, 0x00, 0x00, 0x1C, 0xFE, 0x03, 0x00, 0x01, 0x2D, 0x0E, 0xE9, 
0x00, 0x06, 0xC1, 0x04, 0x00, 0x00, 0x42, 0xDF, 0x05, 0xE9, 0x01, 0x93, 0x03, 0x00, 0x01, 0x98, 
0x0B, 0xC3, 0x01, 0xA9, 0x03, 0x00, 0x00, 0x09, 0x7F, 0xD0, 0x1F, 0x00, 0x00, 0x19, 0xD7, 0xE9, 
0x3A, 0x00, 0x03, 0x00, 0x27, 0xFE, 0x00, 0x00, 0x1C, 0xFE, 0x04, 0x00, 0x01, 0xA3, 0x0C, 0xE9, 
0x01, 0xE4, 0x01, 0x0F, 0x04, 0x00, 0x01, 0x75, 0x05, 0xE9, 0x01, 0x93, 0x03, 0x00, 0x01, 0x91, 
0x0B, 0xC3, 0x01, 0x8B, 0x03, 0x00, 0x01, 0x9D, 0x01, 0x37, 0x04, 0x00, 0x01, 0x51, 0x01, 0xC1, 
0x04, 0x00, 0x27, 0xFE, 0x00, 0x00, 0x1D, 0xFE, 0x03, 0x00, 0x01, 0x37, 0x0C, 0xE9, 0x01, 0xA3, 
0x05, 0x00, 0x01, 0x04, 0x05, 0xE9, 0x01, 0xA3, 0x03, 0x00, 0x01, 0x8B, 0x0B, 0xC3, 0x01, 0x71, 
0x03, 0x00, 0x01, 0x9D, 0x06, 0x00, 0x01, 0x68, 0x03, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x1D, 0xFE, 
0x04, 0x00, 0x01, 0xB2, 0x0B, 0xE9, 0x01, 0x75, 0x06, 0x00, 0x01, 0xD7, 0x04, 0xE9, 0x01, 0xA3, 
0x03, 0x00, 0x01, 0x83, 0x0B, 0xC3, 0x01, 0x52, 0x03, 0x00, 0x01, 0x93, 0x06, 0x00, 0x01, 0x0F, 
0x03, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 0x01, 0x37, 0x0B, 0xE9, 0x01, 0x75, 
0x06, 0x00, 0x01, 0xD0, 0x04, 0xE9, 0x01, 0xB2, 0x03, 0x00, 0x01, 0x7B, 0x0B, 0xC3, 0x00, 0x05, 
0x32, 0x00, 0x00, 0x08, 0x93, 0x00, 0x0A, 0x00, 0x28, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x04, 0x00, 
0x01, 0xA3, 0x0A, 0xE9, 0x01, 0x93, 0x05, 0x00, 0x01, 0x01, 0x01, 0xE4, 0x04, 0xE9, 0x01, 0xC1, 
0x03, 0x00, 0x01, 0x5A, 0x0B, 0xC3, 0x00, 0x05, 0x0C, 0x00, 0x00, 0x37, 0xC1, 0x00, 0x09, 0x00, 
0x29, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x01, 0xD7, 0x09, 0xE9, 0x01, 0xD7, 
0x01, 0x04, 0x04, 0x00, 0x01, 0x58, 0x05, 0xE9, 0x00, 0x06, 0xE4, 0x08, 0x00, 0x00, 0x0C, 0xB5, 
0x09, 0xC3, 0x01, 0x98, 0x03, 0x00, 0x00, 0x03, 0x68, 0xE4, 0x1F, 0x00, 0x04, 0x00, 0x01, 0x04, 
0x03, 0x00, 0x29, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x04, 0x00, 0x01, 0x42, 0x0A, 0xE9, 0x01, 0x93, 
0x03, 0x00, 0x01, 0x0F, 0x01, 0xD7, 0x06, 0xE9, 0x01, 0x68, 0x03, 0x00, 0x01, 0x20, 0x01, 0xA9, 
0x07, 0xC3, 0x01, 0x98, 0x01, 0x0C, 0x03, 0x00, 0x00, 0x08, 0x9D, 0xE9, 0xB2, 0x04, 0x00, 0x00, 
0x04, 0x04, 0x03, 0x00, 0x29, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x04, 0x00, 0x01, 0x93, 0x0A, 0xE9, 
0x00, 0x04, 0xB2, 0x68, 0x7F, 0xD7, 0x07, 0xE9, 0x01, 0xC1, 0x01, 0x01, 0x03, 0x00, 0x00, 0x09, 
0x03, 0x40, 0x71, 0x83, 0x8B, 0x83, 0x67, 0x29, 0x03, 0x00, 0x03, 0x00, 0x01, 0x37, 0x03, 0xE9, 
0x00, 0x04, 0xC1, 0x68, 0x75, 0xA3, 0x04, 0x00, 0x29, 0xFE, 0x00, 0x00, 0x21, 0xFE, 0x03, 0x00, 
0x01, 0x04, 0x01, 0xD0, 0x15, 0xE9, 0x01, 0xA3, 0x01, 0x04, 0x0D, 0x00, 0x01, 0x04, 0x01, 0xC1, 
0x06, 0xE9, 0x01, 0x75, 0x03, 0x00, 0x2A, 0xFE, 0x00, 0x00, 0x21, 0xFE, 0x04, 0x00, 0x01, 0x2D, 
0x01, 0xE4, 0x15, 0xE9, 0x01, 0xA3, 0x01, 0x04, 0x0B, 0x00, 0x01, 0x37, 0x01, 0xD0, 0x06, 0xE9, 
0x01, 0xD7, 0x01, 0x04, 0x03, 0x00, 0x2A, 0xFE, 0x00, 0x00, 0x22, 0xFE, 0x04, 0x00, 0x01, 0x75, 
0x16, 0xE9, 0x00, 0x03, 0xDF, 0x93, 0x1F, 0x00, 0x06, 0x00, 0x00, 0x03, 0x04, 0x51, 0x9D, 0x00, 
0x08, 0xE9, 0x01, 0x5F, 0x04, 0x00, 0x2A, 0xFE, 0x00, 0x00, 0x23, 0xFE, 0x03, 0x00, 0x01, 0x01, 
0x01, 0xA3, 0x18, 0xE9, 0x00, 0x07, 0xD7, 0xC1, 0x9D, 0x93, 0xA3, 0xC1, 0xDF, 0x00, 0x09, 0xE9, 
0x01, 0xC8, 0x01, 0x01, 0x03, 0x00, 0x2B, 0xFE, 0x00, 0x00, 0x23, 0xFE, 0x04, 0x00, 0x01, 0x04, 
0x01, 0xA3, 0x26, 0xE9, 0x01, 0xDF, 0x01, 0x2D, 0x03, 0x00, 0x2C, 0xFE, 0x00, 0x00, 0x24, 0xFE, 
0x04, 0x00, 0x01, 0x01, 0x01, 0x9D, 0x24, 0xE9, 0x01, 0xE4, 0x01, 0x44, 0x04, 0x00, 0x2C, 0xFE, 
0x00, 0x00, 0x25, 0xFE, 0x04, 0x00, 0x01, 0x03, 0x01, 0x93, 0x23, 0xE9, 0x01, 0x68, 0x04, 0x00, 
0x2D, 0xFE, 0x00, 0x00, 0x26, 0xFE, 0x05, 0x00, 0x01, 0x5F, 0x01, 0xDF, 0x20, 0xE9, 0x01, 0x75, 
0x04, 0x00, 0x2E, 0xFE, 0x00, 0x00, 0x27, 0xFE, 0x05, 0x00, 0x01, 0x2D, 0x01, 0xD0, 0x1D, 0xE9, 
0x01, 0xDF, 0x01, 0x44, 0x04, 0x00, 0x2F, 0xFE, 0x00, 0x00, 0x28, 0xFE, 0x05, 0x00, 0x00, 0x03, 
0x04, 0x93, 0xE4, 0x00, 0x1A, 0xE9, 0x01, 0xC8, 0x01, 0x1F, 0x05, 0x00, 0x2F, 0xFE, 0x00, 0x00, 
0x2A, 0xFE, 0x05, 0x00, 0x01, 0x19, 0x01, 0xA3, 0x17, 0xE9, 0x00, 0x03, 0xC8, 0x58, 0x01, 0x00, 
0x05, 0x00, 0x30, 0xFE, 0x00, 0x00, 0x2B, 0xFE, 0x06, 0x00, 0x00, 0x03, 0x37, 0xA3, 0xE4, 0x00, 
0x12, 0xE9, 0x01, 0xB2, 0x01, 0x42, 0x06, 0x00, 0x32, 0xFE, 0x00, 0x00, 0x2C, 0xFE, 0x07, 0x00, 
0x00, 0x04, 0x08, 0x68, 0xB2, 0xE4, 0x0B, 0xE9, 0x00, 0x04, 0xE4, 0xB2, 0x7F, 0x2D, 0x07, 0x00, 
0x33, 0xFE, 0x00, 0x00, 0x2E, 0xFE, 0x08, 0x00, 0x00, 0x0D, 0x08, 0x51, 0x68, 0x93, 0xB2, 0xC8, 
0xC1, 0xB2, 0xA3, 0x9D, 0x7F, 0x42, 0x04, 0x00, 0x08, 0x00, 0x35, 0xFE, 0x00, 0x00, 0x30, 0xFE, 
0x19, 0x00, 0x37, 0xFE, 0x00, 0x00, 0x32, 0xFE, 0x15, 0x00, 0x39, 0xFE, 0x00, 0x00, 0x35, 0xFE, 
0x0F, 0x00, 0x3C, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 
0x00, 0x01, 
};

constexpr unsigned char parrot08[] = {
0x42, 0x4D, 0x78, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x04, 0x00, 0x00, 0x28, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x01, 0x00, 
0x00, 0x00, 0x46, 0x09, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0xFF, 0x00, 
0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x08, 0x04, 
0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x0B, 0x05, 0x08, 0x00, 0x06, 0x0A, 0x07, 0x00, 0x06, 0x08, 
0x0E, 0x00, 0x0E, 0x0B, 0x04, 0x00, 0x0F, 0x07, 0x12, 0x00, 0x0B, 0x0C, 0x12, 0x00, 0x16, 0x0B, 
0x12, 0x00, 0x0C, 0x0B, 0x17, 0x00, 0x0C, 0x10, 0x0D, 0x00, 0x13, 0x11, 0x08, 0x00, 0x12, 0x0C, 
0x1C, 0x00, 0x19, 0x0C, 0x1B, 0x00, 0x18, 0x10, 0x10, 0x00, 0x0A, 0x0D, 0x21, 0x00, 0x08, 0x13, 
0x10, 0x00, 0x1E, 0x0E, 0x1A, 0x00, 0x0A, 0x12, 0x18, 0x00, 0x1B, 0x15, 0x0E, 0x00, 0x1C, 0x10, 
0x1F, 0x00, 0x14, 0x11, 0x1F, 0x00, 0x12, 0x15, 0x13, 0x00, 0x23, 0x10, 0x24, 0x00, 0x1B, 0x10, 
0x28, 0x00, 0x0E, 0x15, 0x1C, 0x00, 0x0E, 0x1A, 0x0D, 0x00, 0x19, 0x19, 0x0D, 0x00, 0x11, 0x13, 
0x25, 0x00, 0x23, 0x13, 0x1F, 0x00, 0x12, 0x1A, 0x15, 0x00, 0x12, 0x13, 0x2E, 0x00, 0x25, 0x1A, 
0x16, 0x00, 0x2E, 0x14, 0x30, 0x00, 0x17, 0x18, 0x2C, 0x00, 0x20, 0x20, 0x0F, 0x00, 0x2D, 0x19, 
0x23, 0x00, 0x13, 0x1C, 0x23, 0x00, 0x13, 0x21, 0x13, 0x00, 0x17, 0x1F, 0x1A, 0x00, 0x24, 0x16, 
0x34, 0x00, 0x32, 0x14, 0x37, 0x00, 0x17, 0x17, 0x38, 0x00, 0x2E, 0x19, 0x2B, 0x00, 0x1C, 0x1D, 
0x32, 0x00, 0x15, 0x21, 0x29, 0x00, 0x32, 0x23, 0x1B, 0x00, 0x26, 0x26, 0x15, 0x00, 0x1D, 0x25, 
0x20, 0x00, 0x16, 0x29, 0x15, 0x00, 0x3B, 0x1A, 0x3B, 0x00, 0x1D, 0x1B, 0x43, 0x00, 0x2F, 0x1B, 
0x40, 0x00, 0x36, 0x1E, 0x34, 0x00, 0x3D, 0x20, 0x33, 0x00, 0x23, 0x21, 0x3D, 0x00, 0x3B, 0x20, 
0x3D, 0x00, 0x3A, 0x29, 0x22, 0x00, 0x44, 0x1D, 0x47, 0x00, 0x1F, 0x1F, 0x4D, 0x00, 0x2C, 0x2D, 
0x1A, 0x00, 0x1A, 0x28, 0x31, 0x00, 0x22, 0x2B, 0x27, 0x00, 0x37, 0x1F, 0x4D, 0x00, 0x3F, 0x23, 
0x41, 0x00, 0x26, 0x27, 0x48, 0x00, 0x47, 0x27, 0x3E, 0x00, 0x4E, 0x22, 0x4E, 0x00, 0x1F, 0x2F, 
0x39, 0x00, 0x25, 0x32, 0x2D, 0x00, 0x25, 0x26, 0x56, 0x00, 0x3F, 0x24, 0x59, 0x00, 0x1F, 0x39, 
0x1E, 0x00, 0x35, 0x37, 0x1E, 0x00, 0x47, 0x33, 0x27, 0x00, 0x53, 0x24, 0x58, 0x00, 0x4F, 0x2B, 
0x42, 0x00, 0x2B, 0x2C, 0x50, 0x00, 0x28, 0x28, 0x5F, 0x00, 0x4D, 0x2A, 0x4D, 0x00, 0x2A, 0x38, 
0x30, 0x00, 0x55, 0x30, 0x49, 0x00, 0x30, 0x2F, 0x59, 0x00, 0x60, 0x29, 0x62, 0x00, 0x2B, 0x2C, 
0x6B, 0x00, 0x49, 0x2B, 0x68, 0x00, 0x55, 0x2F, 0x59, 0x00, 0x26, 0x3A, 0x45, 0x00, 0x31, 0x3F, 
0x36, 0x00, 0x58, 0x3E, 0x2E, 0x00, 0x65, 0x2B, 0x6B, 0x00, 0x26, 0x46, 0x26, 0x00, 0x2F, 0x30, 
0x6F, 0x00, 0x5C, 0x32, 0x59, 0x00, 0x47, 0x46, 0x24, 0x00, 0x62, 0x36, 0x52, 0x00, 0x37, 0x36, 
0x61, 0x00, 0x51, 0x31, 0x75, 0x00, 0x32, 0x33, 0x7A, 0x00, 0x2A, 0x41, 0x4E, 0x00, 0x5E, 0x44, 
0x34, 0x00, 0x38, 0x47, 0x3D, 0x00, 0x65, 0x38, 0x66, 0x00, 0x75, 0x32, 0x79, 0x00, 0x2D, 0x52, 
0x2D, 0x00, 0x58, 0x35, 0x81, 0x00, 0x37, 0x37, 0x86, 0x00, 0x69, 0x4A, 0x37, 0x00, 0x3C, 0x3E, 
0x71, 0x00, 0x72, 0x3E, 0x61, 0x00, 0x53, 0x52, 0x2C, 0x00, 0x39, 0x4D, 0x46, 0x00, 0x30, 0x49, 
0x57, 0x00, 0x62, 0x37, 0x86, 0x00, 0x32, 0x58, 0x2B, 0x00, 0x72, 0x3D, 0x71, 0x00, 0x58, 0x56, 
0x30, 0x00, 0x2F, 0x5B, 0x31, 0x00, 0x3E, 0x3D, 0x93, 0x00, 0x86, 0x3A, 0x88, 0x00, 0x73, 0x52, 
0x3E, 0x00, 0x3F, 0x54, 0x4B, 0x00, 0x45, 0x45, 0x7E, 0x00, 0x69, 0x3D, 0x90, 0x00, 0x85, 0x48, 
0x6F, 0x00, 0x81, 0x45, 0x81, 0x00, 0x41, 0x43, 0xA1, 0x00, 0x37, 0x56, 0x66, 0x00, 0x7F, 0x5A, 
0x41, 0x00, 0x46, 0x5C, 0x4F, 0x00, 0x93, 0x3F, 0x98, 0x00, 0x38, 0x66, 0x36, 0x00, 0x63, 0x63, 
0x34, 0x00, 0x73, 0x43, 0xA0, 0x00, 0x4F, 0x4D, 0x8E, 0x00, 0x9C, 0x42, 0xA1, 0x00, 0x3D, 0x5D, 
0x6D, 0x00, 0x4C, 0x63, 0x55, 0x00, 0x95, 0x51, 0x7C, 0x00, 0x89, 0x62, 0x4A, 0x00, 0x9F, 0x45, 
0xA5, 0x00, 0x4B, 0x4B, 0xB3, 0x00, 0x50, 0x53, 0x97, 0x00, 0x51, 0x68, 0x5A, 0x00, 0x7E, 0x4A, 
0xB1, 0x00, 0x93, 0x51, 0x94, 0x00, 0x40, 0x75, 0x40, 0x00, 0xAB, 0x49, 0xB0, 0x00, 0x56, 0x57, 
0xA1, 0x00, 0x71, 0x72, 0x3F, 0x00, 0x50, 0x6C, 0x60, 0x00, 0x42, 0x67, 0x79, 0x00, 0x98, 0x6A, 
0x53, 0x00, 0x50, 0x50, 0xC3, 0x00, 0xA5, 0x5A, 0x8A, 0x00, 0xA0, 0x57, 0x9C, 0x00, 0x87, 0x4F, 
0xC1, 0x00, 0x56, 0x72, 0x66, 0x00, 0xB8, 0x4F, 0xBF, 0x00, 0x44, 0x80, 0x45, 0x00, 0x60, 0x60, 
0xAF, 0x00, 0xA8, 0x5C, 0xA9, 0x00, 0x7D, 0x7E, 0x46, 0x00, 0x59, 0x58, 0xD5, 0x00, 0x8F, 0x55, 
0xCD, 0x00, 0xA5, 0x75, 0x5D, 0x00, 0xB5, 0x63, 0x98, 0x00, 0x5D, 0x7A, 0x6D, 0x00, 0xC6, 0x54, 
0xCB, 0x00, 0x4C, 0x76, 0x8A, 0x00, 0x4B, 0x89, 0x4B, 0x00, 0x61, 0x7F, 0x6C, 0x00, 0x69, 0x68, 
0xBC, 0x00, 0x5E, 0x5F, 0xE4, 0x00, 0x9B, 0x5B, 0xDD, 0x00, 0xCD, 0x59, 0xD5, 0x00, 0xB9, 0x64, 
0xB8, 0x00, 0xB2, 0x7E, 0x63, 0x00, 0x88, 0x8B, 0x4D, 0x00, 0x66, 0x84, 0x71, 0x00, 0xD8, 0x5B, 
0xDD, 0x00, 0xC7, 0x6D, 0xA7, 0x00, 0x64, 0x62, 0xEE, 0x00, 0x9F, 0x60, 0xE5, 0x00, 0x51, 0x96, 
0x51, 0x00, 0x6E, 0x6F, 0xCC, 0x00, 0x54, 0x81, 0x9B, 0x00, 0x6B, 0x8A, 0x76, 0x00, 0xA9, 0x62, 
0xEB, 0x00, 0x68, 0x66, 0xF4, 0x00, 0xDD, 0x60, 0xE2, 0x00, 0xC3, 0x6B, 0xC6, 0x00, 0xC1, 0x88, 
0x69, 0x00, 0x68, 0x8C, 0x7B, 0x00, 0x96, 0x96, 0x51, 0x00, 0x68, 0x69, 0xFF, 0x00, 0xE4, 0x62, 
0xED, 0x00, 0xD6, 0x75, 0xB3, 0x00, 0xD0, 0x6F, 0xCF, 0x00, 0xB1, 0x66, 0xF8, 0x00, 0x5A, 0xA1, 
0x55, 0x00, 0x77, 0x77, 0xDB, 0x00, 0xCA, 0x8F, 0x6F, 0x00, 0xA1, 0x9F, 0x56, 0x00, 0xB7, 0x6C, 
0xFE, 0x00, 0x5D, 0x8E, 0xAB, 0x00, 0xD7, 0x76, 0xD6, 0x00, 0xF3, 0x69, 0xFA, 0x00, 0xF7, 0x68, 
0xFF, 0x00, 0x5A, 0xA9, 0x5D, 0x00, 0xD7, 0x98, 0x74, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0xEB, 0x80, 
0xC5, 0x00, 0xE0, 0x7B, 0xE3, 0x00, 0x85, 0x82, 0xF1, 0x00, 0xAD, 0xAC, 0x5A, 0x00, 0x64, 0x99, 
0xB8, 0x00, 0xE1, 0xA0, 0x7A, 0x00, 0x63, 0xB5, 0x62, 0x00, 0xF8, 0x87, 0xCF, 0x00, 0x85, 0x88, 
0xF9, 0x00, 0xF1, 0x83, 0xF1, 0x00, 0xE8, 0xA6, 0x81, 0x00, 0xFF, 0x8C, 0xD7, 0x00, 0x8B, 0x8D, 
0xFF, 0x00, 0xF3, 0xAB, 0x80, 0x00, 0xF8, 0x88, 0xFA, 0x00, 0x68, 0xC2, 0x68, 0x00, 0xBE, 0xBE, 
0x67, 0x00, 0x6D, 0xA9, 0xCB, 0x00, 0xF9, 0xB0, 0x86, 0x00, 0xFF, 0x8C, 0xFF, 0x00, 0x70, 0xCB, 
0x6E, 0x00, 0xFE, 0xB5, 0x8B, 0x00, 0xC6, 0xC6, 0x6A, 0x00, 0x71, 0xD3, 0x73, 0x00, 0x78, 0xB7, 
0xDA, 0x00, 0xCE, 0xCF, 0x72, 0x00, 0x78, 0xDB, 0x78, 0x00, 0x7C, 0xE5, 0x7C, 0x00, 0x7F, 0xC4, 
0xEA, 0x00, 0xDB, 0xDD, 0x78, 0x00, 0x81, 0xED, 0x81, 0x00, 0xE3, 0xE5, 0x7E, 0x00, 0x88, 0xCF, 
0xF5, 0x00, 0x87, 0xF5, 0x84, 0x00, 0xEC, 0xEF, 0x87, 0x00, 0x89, 0xD6, 0xFE, 0x00, 0x87, 0xFA, 
0x8C, 0x00, 0xF1, 0xF3, 0x8C, 0x00, 0x89, 0xFF, 0x88, 0x00, 0xFB, 0xF9, 0x80, 0x00, 0xFF, 0xFF, 
0x87, 0x00, 0x06, 0xFE, 0x60, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x07, 0xFE, 0x5F, 0x00, 0x1A, 0xFE, 
0x00, 0x00, 0x07, 0xFE, 0x5F, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0x19, 
0x56, 0x4D, 0x01, 0x08, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x03, 0x00, 0x01, 0x19, 
0x01, 0xD1, 0x55, 0xD2, 0x01, 0x13, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x08, 0xFE, 0x04, 0x00, 
0x01, 0x79, 0x2E, 0xD2, 0x00, 0x0C, 0xC6, 0xA0, 0x8E, 0x79, 0x69, 0x55, 0x45, 0x2B, 0x19, 0x08, 
0x4D, 0xC6, 0x1A, 0xD2, 0x01, 0xD1, 0x01, 0x01, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x09, 0xFE, 
0x03, 0x00, 0x01, 0x04, 0x01, 0xB6, 0x29, 0xD2, 0x00, 0x05, 0xB6, 0x89, 0x5C, 0x23, 0x01, 0x00, 
0x0A, 0x00, 0x01, 0x79, 0x1A, 0xD2, 0x01, 0xB6, 0x04, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x09, 0xFE, 
0x04, 0x00, 0x01, 0x3C, 0x01, 0xD1, 0x24, 0xD2, 0x00, 0x04, 0xD1, 0x84, 0x45, 0x0F, 0x0F, 0x00, 
0x01, 0x89, 0x1A, 0xD2, 0x01, 0xA0, 0x03, 0x00, 0x1B, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x04, 0x00, 
0x01, 0x4D, 0x01, 0xD1, 0x21, 0xD2, 0x00, 0x03, 0xB1, 0x5C, 0x08, 0x00, 0x0D, 0x00, 0x00, 0x06, 
0x04, 0x0F, 0x23, 0x3C, 0x79, 0xD1, 0x1A, 0xD2, 0x01, 0xA0, 0x03, 0x00, 0x1B, 0xFE, 0x00, 0x00, 
0x0B, 0xFE, 0x04, 0x00, 0x01, 0x55, 0x01, 0xD1, 0x1D, 0xD2, 0x00, 0x03, 0xD1, 0x89, 0x34, 0x00, 
0x09, 0x00, 0x00, 0x08, 0x08, 0x45, 0x79, 0x8E, 0xA0, 0xB1, 0xC6, 0xD1, 0x1F, 0xD2, 0x01, 0xB1, 
0x04, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x05, 0x00, 0x01, 0x45, 0x01, 0xC6, 0x1B, 0xD2, 
0x01, 0x89, 0x01, 0x08, 0x06, 0x00, 0x00, 0x05, 0x01, 0x23, 0x55, 0x89, 0xB1, 0x00, 0x27, 0xD2, 
0x01, 0xC6, 0x04, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 0x05, 0x00, 0x01, 0x19, 0x01, 0xB1, 
0x18, 0xD2, 0x01, 0xC6, 0x01, 0x45, 0x06, 0x00, 0x00, 0x03, 0x0A, 0x69, 0xB6, 0x00, 0x1B, 0xD2, 
0x01, 0xA0, 0x01, 0x84, 0x0E, 0xD2, 0x01, 0xD1, 0x01, 0x04, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 
0x0D, 0xFE, 0x05, 0x00, 0x01, 0x04, 0x01, 0x89, 0x16, 0xD2, 0x01, 0x95, 0x01, 0x0A, 0x05, 0x00, 
0x00, 0x03, 0x34, 0x8E, 0xD1, 0x00, 0x1C, 0xD2, 0x00, 0x04, 0xC6, 0x19, 0x23, 0xD1, 0x0E, 0xD2, 
0x01, 0x0F, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x0F, 0xFE, 0x05, 0x00, 0x01, 0x4D, 0x01, 0xC6, 
0x12, 0xD2, 0x01, 0xC6, 0x01, 0x4D, 0x05, 0x00, 0x01, 0x45, 0x01, 0xB1, 0x1F, 0xD2, 0x00, 0x04, 
0x55, 0x00, 0x00, 0xA0, 0x0E, 0xD2, 0x01, 0x3C, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x10, 0xFE, 
0x05, 0x00, 0x01, 0x13, 0x01, 0xA0, 0x10, 0xD2, 0x01, 0xC6, 0x01, 0x23, 0x04, 0x00, 0x01, 0x08, 
0x01, 0x89, 0x20, 0xD2, 0x01, 0x8E, 0x03, 0x00, 0x01, 0x3C, 0x0E, 0xD2, 0x01, 0x95, 0x04, 0x00, 
0x19, 0xFE, 0x00, 0x00, 0x11, 0xFE, 0x05, 0x00, 0x00, 0x03, 0x01, 0x69, 0xD1, 0x00, 0x0D, 0xD2, 
0x01, 0xD1, 0x01, 0x3C, 0x04, 0x00, 0x01, 0x3C, 0x01, 0xC0, 0x20, 0xD2, 0x01, 0xC6, 0x01, 0x08, 
0x03, 0x00, 0x01, 0x01, 0x01, 0xB1, 0x0D, 0xD2, 0x01, 0xD1, 0x01, 0x19, 0x03, 0x00, 0x19, 0xFE, 
0x00, 0x00, 0x13, 0xFE, 0x05, 0x00, 0x01, 0x23, 0x01, 0xB1, 0x0C, 0xD2, 0x01, 0x5C, 0x03, 0x00, 
0x00, 0x03, 0x04, 0x84, 0xD1, 0x00, 0x21, 0xD2, 0x01, 0x3C, 0x05, 0x00, 0x01, 0x5C, 0x0E, 0xD2, 
0x01, 0x79, 0x04, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x14, 0xFE, 0x05, 0x00, 0x00, 0x03, 0x04, 0x79, 
0xD1, 0x00, 0x09, 0xD2, 0x01, 0x79, 0x04, 0x00, 0x01, 0x89, 0x22, 0xD2, 0x01, 0x84, 0x06, 0x00, 
0x01, 0x04, 0x01, 0xC6, 0x0D, 0xD2, 0x01, 0xC6, 0x01, 0x04, 0x03, 0x00, 0x18, 0xFE, 0x00, 0x00, 
0x16, 0xFE, 0x05, 0x00, 0x01, 0x3C, 0x01, 0xC6, 0x07, 0xD2, 0x01, 0x95, 0x01, 0x01, 0x03, 0x00, 
0x01, 0x69, 0x22, 0xD2, 0x01, 0xB1, 0x01, 0x04, 0x03, 0x00, 0x01, 0x29, 0x03, 0x00, 0x01, 0x79, 
0x0E, 0xD2, 0x01, 0x55, 0x03, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x17, 0xFE, 0x05, 0x00, 0x01, 0x19, 
0x01, 0xB6, 0x05, 0xD2, 0x01, 0xD1, 0x01, 0x13, 0x03, 0x00, 0x01, 0x45, 0x01, 0xD1, 0x21, 0xD2, 
0x01, 0xD1, 0x01, 0x23, 0x03, 0x00, 0x00, 0x07, 0x47, 0xAD, 0x03, 0x00, 0x00, 0x0F, 0xD1, 0x00, 
0x0D, 0xD2, 0x01, 0x95, 0x03, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x18, 0xFE, 0x05, 0x00, 0x01, 0x0F, 
0x01, 0xB1, 0x04, 0xD2, 0x01, 0x84, 0x03, 0x00, 0x01, 0x23, 0x01, 0xD1, 0x22, 0xD2, 0x01, 0x69, 
0x03, 0x00, 0x00, 0x04, 0x0C, 0xB5, 0xC3, 0x47, 0x03, 0x00, 0x01, 0x8E, 0x0D, 0xD2, 0x01, 0xD1, 
0x01, 0x04, 0x03, 0x00, 0x17, 0xFE, 0x00, 0x00, 0x1A, 0xFE, 0x04, 0x00, 0x00, 0x0A, 0x13, 0xD1, 
0xD2, 0xD2, 0xD1, 0x16, 0x00, 0x00, 0x01, 0xB1, 0x22, 0xD2, 0x00, 0x09, 0xB1, 0x04, 0x00, 0x00, 
0x03, 0x98, 0xC3, 0xC3, 0x9F, 0x00, 0x03, 0x00, 0x01, 0x2B, 0x0E, 0xD2, 0x01, 0x3C, 0x03, 0x00, 
0x17, 0xFE, 0x00, 0x00, 0x1B, 0xFE, 0x04, 0x00, 0x00, 0x04, 0x79, 0xD2, 0xD2, 0x95, 0x03, 0x00, 
0x01, 0x4D, 0x23, 0xD2, 0x01, 0x4D, 0x03, 0x00, 0x01, 0x5A, 0x04, 0xC3, 0x01, 0x32, 0x03, 0x00, 
0x01, 0xAA, 0x0D, 0xD2, 0x01, 0x84, 0x03, 0x00, 0x17, 0xFE, 0x00, 0x00, 0x1C, 0xFE, 0x03, 0x00, 
0x00, 0x04, 0x08, 0xC6, 0xD2, 0x55, 0x03, 0x00, 0x01, 0xAA, 0x22, 0xD2, 0x00, 0x06, 0xB6, 0x04, 
0x00, 0x00, 0x0C, 0xBD, 0x04, 0xC3, 0x01, 0x8B, 0x03, 0x00, 0x01, 0x4D, 0x0D, 0xD2, 0x01, 0xAA, 
0x03, 0x00, 0x17, 0xFE, 0x00, 0x00, 0x1C, 0xFE, 0x04, 0x00, 0x00, 0x07, 0x84, 0xD1, 0x0F, 0x00, 
0x00, 0x0F, 0xD1, 0x00, 0x22, 0xD2, 0x01, 0x5C, 0x03, 0x00, 0x01, 0x71, 0x06, 0xC3, 0x00, 0x05, 
0x0C, 0x00, 0x00, 0x04, 0xD1, 0x00, 0x0C, 0xD2, 0x01, 0xC6, 0x04, 0x00, 0x16, 0xFE, 0x00, 0x00, 
0x1D, 0xFE, 0x03, 0x00, 0x01, 0x23, 0x01, 0xB1, 0x03, 0x00, 0x01, 0x55, 0x22, 0xD2, 0x00, 0x06, 
0xD1, 0x04, 0x00, 0x00, 0x03, 0xB5, 0x06, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0xA0, 0x0C, 0xD2, 
0x01, 0xD1, 0x01, 0x04, 0x03, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x1D, 0xFE, 0x04, 0x00, 0x01, 0x84, 
0x03, 0x00, 0x01, 0x84, 0x22, 0xD2, 0x01, 0x8E, 0x03, 0x00, 0x01, 0x5A, 0x07, 0xC3, 0x01, 0x98, 
0x03, 0x00, 0x01, 0x69, 0x0D, 0xD2, 0x01, 0x19, 0x03, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 
0x03, 0x00, 0x01, 0x3C, 0x03, 0x00, 0x01, 0x95, 0x22, 0xD2, 0x01, 0x4D, 0x03, 0x00, 0x01, 0x9F, 
0x08, 0xC3, 0x00, 0x04, 0x03, 0x00, 0x00, 0x34, 0x0D, 0xD2, 0x01, 0x34, 0x03, 0x00, 0x16, 0xFE, 
0x00, 0x00, 0x1E, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x03, 0x00, 0x01, 0xB1, 0x21, 0xD2, 0x00, 0x05, 
0xD1, 0x08, 0x00, 0x00, 0x18, 0x00, 0x09, 0xC3, 0x00, 0x05, 0x32, 0x00, 0x00, 0x04, 0xD1, 0x00, 
0x0C, 0xD2, 0x01, 0x4D, 0x03, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x07, 0x00, 0x01, 0xB6, 
0x21, 0xD2, 0x01, 0xA0, 0x03, 0x00, 0x01, 0x67, 0x09, 0xC3, 0x01, 0x67, 0x03, 0x00, 0x01, 0xA0, 
0x0C, 0xD2, 0x01, 0x69, 0x03, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x06, 0x00, 0x01, 0xB1, 
0x21, 0xD2, 0x01, 0x84, 0x03, 0x00, 0x01, 0x8B, 0x09, 0xC3, 0x01, 0x98, 0x03, 0x00, 0x01, 0x69, 
0x0C, 0xD2, 0x01, 0x69, 0x03, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x06, 0x00, 0x01, 0xAA, 
0x21, 0xD2, 0x01, 0x69, 0x03, 0x00, 0x01, 0x9F, 0x09, 0xC3, 0x00, 0x05, 0xBD, 0x03, 0x00, 0x00, 
0x34, 0x00, 0x0C, 0xD2, 0x01, 0x4D, 0x03, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x05, 0x00, 
0x01, 0x89, 0x21, 0xD2, 0x00, 0x05, 0x4D, 0x00, 0x00, 0x03, 0xBD, 0x00, 0x0A, 0xC3, 0x00, 0x05, 
0x32, 0x00, 0x00, 0x04, 0xD1, 0x00, 0x0B, 0xD2, 0x01, 0x34, 0x03, 0x00, 0x16, 0xFE, 0x00, 0x00, 
0x20, 0xFE, 0x05, 0x00, 0x01, 0x69, 0x21, 0xD2, 0x00, 0x04, 0x23, 0x00, 0x00, 0x0C, 0x0B, 0xC3, 
0x01, 0x67, 0x03, 0x00, 0x01, 0xA0, 0x0B, 0xD2, 0x01, 0x0F, 0x03, 0x00, 0x16, 0xFE, 0x00, 0x00, 
0x20, 0xFE, 0x05, 0x00, 0x01, 0x3C, 0x21, 0xD2, 0x00, 0x04, 0x08, 0x00, 0x00, 0x32, 0x0B, 0xC3, 
0x01, 0x8B, 0x03, 0x00, 0x01, 0x8E, 0x0A, 0xD2, 0x01, 0xD1, 0x01, 0x01, 0x03, 0x00, 0x16, 0xFE, 
0x00, 0x00, 0x21, 0xFE, 0x04, 0x00, 0x01, 0x08, 0x01, 0xD1, 0x1F, 0xD2, 0x01, 0xC6, 0x03, 0x00, 
0x01, 0x52, 0x0B, 0xC3, 0x01, 0x91, 0x03, 0x00, 0x01, 0x84, 0x0A, 0xD2, 0x01, 0xB1, 0x04, 0x00, 
0x16, 0xFE, 0x00, 0x00, 0x21, 0xFE, 0x05, 0x00, 0x01, 0xAA, 0x1F, 0xD2, 0x01, 0xAA, 0x03, 0x00, 
0x01, 0x71, 0x0B, 0xC3, 0x01, 0x9F, 0x03, 0x00, 0x01, 0x79, 0x0A, 0xD2, 0x01, 0x79, 0x03, 0x00, 
0x17, 0xFE, 0x00, 0x00, 0x22, 0xFE, 0x04, 0x00, 0x01, 0x4D, 0x1F, 0xD2, 0x01, 0x8E, 0x03, 0x00, 
0x01, 0x83, 0x0B, 0xC3, 0x01, 0xA9, 0x03, 0x00, 0x01, 0x69, 0x0A, 0xD2, 0x01, 0x23, 0x03, 0x00, 
0x17, 0xFE, 0x00, 0x00, 0x23, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x01, 0xD1, 0x1E, 0xD2, 0x01, 0x8E, 
0x03, 0x00, 0x01, 0x8B, 0x0B, 0xC3, 0x01, 0xB5, 0x03, 0x00, 0x01, 0x5C, 0x09, 0xD2, 0x01, 0xC6, 
0x01, 0x01, 0x03, 0x00, 0x17, 0xFE, 0x00, 0x00, 0x23, 0xFE, 0x04, 0x00, 0x01, 0x79, 0x1E, 0xD2, 
0x01, 0x95, 0x03, 0x00, 0x01, 0x83, 0x0C, 0xC3, 0x03, 0x00, 0x01, 0x4D, 0x09, 0xD2, 0x01, 0x84, 
0x03, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x24, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x01, 0xC0, 0x1D, 0xD2, 
0x01, 0xA0, 0x03, 0x00, 0x01, 0x7B, 0x0C, 0xC3, 0x00, 0x04, 0x03, 0x00, 0x00, 0x45, 0x09, 0xD2, 
0x01, 0x4D, 0x03, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x24, 0xFE, 0x04, 0x00, 0x01, 0x4D, 0x13, 0xD2, 
0x00, 0x04, 0xB1, 0x69, 0x69, 0xB1, 0x06, 0xD2, 0x01, 0xA0, 0x03, 0x00, 0x01, 0x71, 0x0C, 0xC3, 
0x00, 0x09, 0x0C, 0x00, 0x00, 0x34, 0xD2, 0xC0, 0x69, 0x5C, 0xA0, 0x00, 0x03, 0xD2, 0x01, 0xD1, 
0x01, 0x0A, 0x03, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x25, 0xFE, 0x04, 0x00, 0x01, 0x89, 0x11, 0xD2, 
0x00, 0x06, 0xA0, 0x04, 0x00, 0x00, 0x04, 0x95, 0x05, 0xD2, 0x01, 0xAA, 0x03, 0x00, 0x01, 0x71, 
0x0C, 0xC3, 0x00, 0x0D, 0x03, 0x00, 0x00, 0x3C, 0xB6, 0x13, 0x00, 0x00, 0x01, 0x84, 0xD2, 0xD2, 
0xB1, 0x00, 0x04, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x26, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x01, 0xB1, 
0x0F, 0xD2, 0x01, 0xD1, 0x01, 0x23, 0x04, 0x00, 0x01, 0x19, 0x01, 0xD1, 0x04, 0xD2, 0x01, 0xB1, 
0x03, 0x00, 0x01, 0x67, 0x0B, 0xC3, 0x01, 0xAD, 0x03, 0x00, 0x01, 0x5C, 0x01, 0x4D, 0x04, 0x00, 
0x00, 0x04, 0x04, 0xC6, 0xD2, 0x79, 0x03, 0x00, 0x19, 0xFE, 0x00, 0x00, 0x26, 0xFE, 0x04, 0x00, 
0x01, 0x23, 0x01, 0xD1, 0x0E, 0xD2, 0x01, 0xB1, 0x06, 0x00, 0x01, 0xA0, 0x04, 0xD2, 0x01, 0xB6, 
0x03, 0x00, 0x01, 0x5A, 0x0B, 0xC3, 0x01, 0x91, 0x03, 0x00, 0x01, 0x79, 0x01, 0x01, 0x05, 0x00, 
0x00, 0x03, 0x84, 0xD2, 0x3C, 0x00, 0x03, 0x00, 0x19, 0xFE, 0x00, 0x00, 0x27, 0xFE, 0x04, 0x00, 
0x01, 0x55, 0x0E, 0xD2, 0x01, 0x8E, 0x06, 0x00, 0x01, 0x84, 0x04, 0xD2, 0x01, 0xC6, 0x03, 0x00, 
0x01, 0x52, 0x0B, 0xC3, 0x01, 0x7B, 0x03, 0x00, 0x01, 0x84, 0x06, 0x00, 0x00, 0x03, 0x5C, 0xD1, 
0x04, 0x00, 0x03, 0x00, 0x19, 0xFE, 0x00, 0x00, 0x28, 0xFE, 0x04, 0x00, 0x01, 0x89, 0x0D, 0xD2, 
0x01, 0x95, 0x06, 0x00, 0x01, 0x89, 0x04, 0xD2, 0x01, 0xC6, 0x03, 0x00, 0x01, 0x47, 0x0B, 0xC3, 
0x01, 0x5A, 0x03, 0x00, 0x01, 0xA0, 0x06, 0x00, 0x01, 0x69, 0x01, 0xA0, 0x04, 0x00, 0x19, 0xFE, 
0x00, 0x00, 0x29, 0xFE, 0x03, 0x00, 0x01, 0x04, 0x01, 0xB1, 0x0C, 0xD2, 0x01, 0xB6, 0x06, 0x00, 
0x01, 0xAA, 0x04, 0xD2, 0x00, 0x05, 0xD1, 0x04, 0x00, 0x00, 0x18, 0x00, 0x0B, 0xC3, 0x00, 0x06, 
0x40, 0x00, 0x00, 0x04, 0xD1, 0x04, 0x05, 0x00, 0x01, 0x8E, 0x01, 0x69, 0x03, 0x00, 0x1A, 0xFE, 
0x00, 0x00, 0x29, 0xFE, 0x04, 0x00, 0x01, 0x23, 0x01, 0xD1, 0x0C, 0xD2, 0x01, 0x3C, 0x04, 0x00, 
0x01, 0x23, 0x06, 0xD2, 0x01, 0x4D, 0x03, 0x00, 0x01, 0x83, 0x09, 0xC3, 0x00, 0x07, 0x9F, 0x03, 
0x00, 0x00, 0x23, 0xD2, 0x69, 0x00, 0x04, 0x00, 0x00, 0x03, 0x0F, 0xD1, 0x23, 0x00, 0x03, 0x00, 
0x1A, 0xFE, 0x00, 0x00, 0x2A, 0xFE, 0x04, 0x00, 0x01, 0x4D, 0x01, 0xD1, 0x0B, 0xD2, 0x00, 0x06, 
0xB6, 0x19, 0x00, 0x00, 0x0F, 0xB1, 0x06, 0xD2, 0x01, 0x95, 0x03, 0x00, 0x00, 0x03, 0x03, 0x71, 
0xB5, 0x00, 0x05, 0xC3, 0x00, 0x03, 0xBD, 0x83, 0x05, 0x00, 0x03, 0x00, 0x00, 0x0A, 0x69, 0xD2, 
0xC6, 0x34, 0x00, 0x00, 0x04, 0xA0, 0xC0, 0x01, 0x03, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x2B, 0xFE, 
0x04, 0x00, 0x01, 0x69, 0x0C, 0xD2, 0x00, 0x04, 0xC6, 0x8E, 0x8E, 0xC6, 0x07, 0xD2, 0x01, 0xD1, 
0x01, 0x23, 0x04, 0x00, 0x00, 0x07, 0x03, 0x32, 0x52, 0x67, 0x5A, 0x47, 0x05, 0x00, 0x04, 0x00, 
0x00, 0x0A, 0x19, 0xD1, 0xD2, 0xD2, 0xD1, 0x95, 0x89, 0xC0, 0xD2, 0x5C, 0x03, 0x00, 0x1B, 0xFE, 
0x00, 0x00, 0x2C, 0xFE, 0x04, 0x00, 0x01, 0x89, 0x17, 0xD2, 0x01, 0xC6, 0x01, 0x23, 0x0D, 0x00, 
0x01, 0x08, 0x01, 0xA0, 0x07, 0xD2, 0x01, 0xB6, 0x01, 0x04, 0x03, 0x00, 0x1B, 0xFE, 0x00, 0x00, 
0x2C, 0xFE, 0x04, 0x00, 0x01, 0x04, 0x01, 0xAA, 0x17, 0xD2, 0x00, 0x03, 0xC6, 0x4D, 0x04, 0x00, 
0x0A, 0x00, 0x01, 0x3C, 0x01, 0xC0, 0x08, 0xD2, 0x01, 0x4D, 0x03, 0x00, 0x1C, 0xFE, 0x00, 0x00, 
0x2D, 0xFE, 0x04, 0x00, 0x01, 0x0A, 0x01, 0xB6, 0x18, 0xD2, 0x00, 0x04, 0xC0, 0x69, 0x19, 0x04, 
0x04, 0x00, 0x00, 0x03, 0x19, 0x69, 0xA0, 0x00, 0x09, 0xD2, 0x01, 0xA0, 0x01, 0x01, 0x03, 0x00, 
0x1C, 0xFE, 0x00, 0x00, 0x2E, 0xFE, 0x04, 0x00, 0x01, 0x23, 0x01, 0xC6, 0x1A, 0xD2, 0x00, 0x05, 
0xD1, 0xB6, 0xB1, 0xC6, 0xD1, 0x00, 0x0B, 0xD2, 0x01, 0xB1, 0x01, 0x08, 0x03, 0x00, 0x1D, 0xFE, 
0x00, 0x00, 0x2F, 0xFE, 0x04, 0x00, 0x01, 0x3C, 0x01, 0xD1, 0x28, 0xD2, 0x01, 0xC6, 0x01, 0x19, 
0x04, 0x00, 0x1D, 0xFE, 0x00, 0x00, 0x30, 0xFE, 0x04, 0x00, 0x01, 0x34, 0x01, 0xC6, 0x26, 0xD2, 
0x01, 0xD1, 0x01, 0x34, 0x04, 0x00, 0x1E, 0xFE, 0x00, 0x00, 0x31, 0xFE, 0x04, 0x00, 0x01, 0x23, 
0x01, 0xC0, 0x24, 0xD2, 0x01, 0xB6, 0x01, 0x23, 0x04, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x32, 0xFE, 
0x04, 0x00, 0x01, 0x13, 0x01, 0xB1, 0x22, 0xD2, 0x01, 0x95, 0x01, 0x08, 0x04, 0x00, 0x20, 0xFE, 
0x00, 0x00, 0x33, 0xFE, 0x04, 0x00, 0x00, 0x03, 0x04, 0x69, 0xD1, 0x00, 0x1E, 0xD2, 0x00, 0x03, 
0xC0, 0x5C, 0x01, 0x00, 0x04, 0x00, 0x21, 0xFE, 0x00, 0x00, 0x34, 0xFE, 0x05, 0x00, 0x01, 0x19, 
0x01, 0xA0, 0x1B, 0xD2, 0x00, 0x03, 0xB1, 0x55, 0x04, 0x00, 0x05, 0x00, 0x22, 0xFE, 0x00, 0x00, 
0x35, 0xFE, 0x06, 0x00, 0x00, 0x03, 0x45, 0xA0, 0xD1, 0x00, 0x16, 0xD2, 0x00, 0x03, 0xB1, 0x4D, 
0x01, 0x00, 0x06, 0x00, 0x23, 0xFE, 0x00, 0x00, 0x36, 0xFE, 0x07, 0x00, 0x00, 0x03, 0x19, 0x79, 
0xC0, 0x00, 0x10, 0xD2, 0x00, 0x04, 0xD1, 0xA0, 0x69, 0x19, 0x08, 0x00, 0x24, 0xFE, 0x00, 0x00, 
0x38, 0xFE, 0x07, 0x00, 0x00, 0x06, 0x04, 0x23, 0x55, 0x84, 0xB1, 0xD1, 0x06, 0xD2, 0x00, 0x06, 
0xD1, 0xB1, 0x95, 0x79, 0x4D, 0x08, 0x08, 0x00, 0x27, 0xFE, 0x00, 0x00, 0x3A, 0xFE, 0x0A, 0x00, 
0x00, 0x08, 0x04, 0x08, 0x0F, 0x13, 0x19, 0x23, 0x16, 0x01, 0x0B, 0x00, 0x29, 0xFE, 0x00, 0x00, 
0x3C, 0xFE, 0x19, 0x00, 0x2B, 0xFE, 0x00, 0x00, 0x3F, 0xFE, 0x13, 0x00, 0x2E, 0xFE, 0x00, 0x00, 
0x43, 0xFE, 0x0A, 0x00, 0x33, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x01, 
};

constexpr unsigned char parrot09[] = {
0x42, 0x4D, 0xCC, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x04, 0x00, 0x00, 0x28, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x01, 0x00, 
0x00, 0x00, 0x9A, 0x09, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0x13, 0x0B, 0x00, 0x00, 0xFF, 0x00, 
0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x08, 0x04, 
0x00, 0x00, 0x02, 0x06, 0x03, 0x00, 0x0B, 0x05, 0x08, 0x00, 0x06, 0x0A, 0x07, 0x00, 0x06, 0x08, 
0x0E, 0x00, 0x0E, 0x0B, 0x04, 0x00, 0x0F, 0x07, 0x12, 0x00, 0x0B, 0x0C, 0x12, 0x00, 0x16, 0x0B, 
0x12, 0x00, 0x0C, 0x0B, 0x17, 0x00, 0x0C, 0x10, 0x0D, 0x00, 0x13, 0x11, 0x08, 0x00, 0x12, 0x0C, 
0x1C, 0x00, 0x19, 0x0C, 0x1B, 0x00, 0x18, 0x10, 0x10, 0x00, 0x0A, 0x0D, 0x21, 0x00, 0x08, 0x13, 
0x10, 0x00, 0x1E, 0x0E, 0x1A, 0x00, 0x0A, 0x12, 0x18, 0x00, 0x1B, 0x15, 0x0E, 0x00, 0x1C, 0x10, 
0x1F, 0x00, 0x14, 0x11, 0x1F, 0x00, 0x12, 0x15, 0x13, 0x00, 0x23, 0x10, 0x24, 0x00, 0x1B, 0x10, 
0x28, 0x00, 0x0E, 0x15, 0x1C, 0x00, 0x0E, 0x1A, 0x0D, 0x00, 0x19, 0x19, 0x0D, 0x00, 0x11, 0x13, 
0x25, 0x00, 0x23, 0x13, 0x1F, 0x00, 0x12, 0x1A, 0x15, 0x00, 0x12, 0x13, 0x2E, 0x00, 0x25, 0x1A, 
0x16, 0x00, 0x2E, 0x14, 0x30, 0x00, 0x17, 0x18, 0x2C, 0x00, 0x20, 0x20, 0x0F, 0x00, 0x2D, 0x19, 
0x23, 0x00, 0x13, 0x1C, 0x23, 0x00, 0x13, 0x21, 0x13, 0x00, 0x17, 0x1F, 0x1A, 0x00, 0x24, 0x16, 
0x34, 0x00, 0x32, 0x14, 0x37, 0x00, 0x17, 0x17, 0x38, 0x00, 0x2E, 0x19, 0x2B, 0x00, 0x1C, 0x1D, 
0x32, 0x00, 0x15, 0x21, 0x29, 0x00, 0x32, 0x23, 0x1B, 0x00, 0x26, 0x26, 0x15, 0x00, 0x1D, 0x25, 
0x20, 0x00, 0x16, 0x29, 0x15, 0x00, 0x3B, 0x1A, 0x3B, 0x00, 0x1D, 0x1B, 0x43, 0x00, 0x2F, 0x1B, 
0x40, 0x00, 0x36, 0x1E, 0x34, 0x00, 0x3D, 0x20, 0x33, 0x00, 0x23, 0x21, 0x3D, 0x00, 0x3B, 0x20, 
0x3D, 0x00, 0x3A, 0x29, 0x22, 0x00, 0x44, 0x1D, 0x47, 0x00, 0x1F, 0x1F, 0x4D, 0x00, 0x2C, 0x2D, 
0x1A, 0x00, 0x1A, 0x28, 0x31, 0x00, 0x22, 0x2B, 0x27, 0x00, 0x37, 0x1F, 0x4D, 0x00, 0x3F, 0x23, 
0x41, 0x00, 0x26, 0x27, 0x48, 0x00, 0x47, 0x27, 0x3E, 0x00, 0x4E, 0x22, 0x4E, 0x00, 0x1F, 0x2F, 
0x39, 0x00, 0x25, 0x32, 0x2D, 0x00, 0x25, 0x26, 0x56, 0x00, 0x3F, 0x24, 0x59, 0x00, 0x1F, 0x39, 
0x1E, 0x00, 0x35, 0x37, 0x1E, 0x00, 0x47, 0x33, 0x27, 0x00, 0x53, 0x24, 0x58, 0x00, 0x4F, 0x2B, 
0x42, 0x00, 0x2B, 0x2C, 0x50, 0x00, 0x28, 0x28, 0x5F, 0x00, 0x4D, 0x2A, 0x4D, 0x00, 0x2A, 0x38, 
0x30, 0x00, 0x55, 0x30, 0x49, 0x00, 0x30, 0x2F, 0x59, 0x00, 0x60, 0x29, 0x62, 0x00, 0x2B, 0x2C, 
0x6B, 0x00, 0x49, 0x2B, 0x68, 0x00, 0x55, 0x2F, 0x59, 0x00, 0x26, 0x3A, 0x45, 0x00, 0x31, 0x3F, 
0x36, 0x00, 0x58, 0x3E, 0x2E, 0x00, 0x65, 0x2B, 0x6B, 0x00, 0x26, 0x46, 0x26, 0x00, 0x2F, 0x30, 
0x6F, 0x00, 0x5C, 0x32, 0x59, 0x00, 0x47, 0x46, 0x24, 0x00, 0x62, 0x36, 0x52, 0x00, 0x37, 0x36, 
0x61, 0x00, 0x51, 0x31, 0x75, 0x00, 0x32, 0x33, 0x7A, 0x00, 0x2A, 0x41, 0x4E, 0x00, 0x5E, 0x44, 
0x34, 0x00, 0x38, 0x47, 0x3D, 0x00, 0x65, 0x38, 0x66, 0x00, 0x75, 0x32, 0x79, 0x00, 0x2D, 0x52, 
0x2D, 0x00, 0x58, 0x35, 0x81, 0x00, 0x37, 0x37, 0x86, 0x00, 0x69, 0x4A, 0x37, 0x00, 0x3C, 0x3E, 
0x71, 0x00, 0x72, 0x3E, 0x61, 0x00, 0x53, 0x52, 0x2C, 0x00, 0x39, 0x4D, 0x46, 0x00, 0x30, 0x49, 
0x57, 0x00, 0x62, 0x37, 0x86, 0x00, 0x32, 0x58, 0x2B, 0x00, 0x72, 0x3D, 0x71, 0x00, 0x58, 0x56, 
0x30, 0x00, 0x2F, 0x5B, 0x31, 0x00, 0x3E, 0x3D, 0x93, 0x00, 0x86, 0x3A, 0x88, 0x00, 0x73, 0x52, 
0x3E, 0x00, 0x3F, 0x54, 0x4B, 0x00, 0x45, 0x45, 0x7E, 0x00, 0x69, 0x3D, 0x90, 0x00, 0x85, 0x48, 
0x6F, 0x00, 0x81, 0x45, 0x81, 0x00, 0x41, 0x43, 0xA1, 0x00, 0x37, 0x56, 0x66, 0x00, 0x7F, 0x5A, 
0x41, 0x00, 0x46, 0x5C, 0x4F, 0x00, 0x93, 0x3F, 0x98, 0x00, 0x38, 0x66, 0x36, 0x00, 0x63, 0x63, 
0x34, 0x00, 0x73, 0x43, 0xA0, 0x00, 0x4F, 0x4D, 0x8E, 0x00, 0x9C, 0x42, 0xA1, 0x00, 0x3D, 0x5D, 
0x6D, 0x00, 0x4C, 0x63, 0x55, 0x00, 0x95, 0x51, 0x7C, 0x00, 0x89, 0x62, 0x4A, 0x00, 0x9F, 0x45, 
0xA5, 0x00, 0x4B, 0x4B, 0xB3, 0x00, 0x50, 0x53, 0x97, 0x00, 0x51, 0x68, 0x5A, 0x00, 0x7E, 0x4A, 
0xB1, 0x00, 0x93, 0x51, 0x94, 0x00, 0x40, 0x75, 0x40, 0x00, 0xAB, 0x49, 0xB0, 0x00, 0x56, 0x57, 
0xA1, 0x00, 0x71, 0x72, 0x3F, 0x00, 0x50, 0x6C, 0x60, 0x00, 0x42, 0x67, 0x79, 0x00, 0x98, 0x6A, 
0x53, 0x00, 0x50, 0x50, 0xC3, 0x00, 0xA5, 0x5A, 0x8A, 0x00, 0xA0, 0x57, 0x9C, 0x00, 0x87, 0x4F, 
0xC1, 0x00, 0x56, 0x72, 0x66, 0x00, 0xB8, 0x4F, 0xBF, 0x00, 0x44, 0x80, 0x45, 0x00, 0x60, 0x60, 
0xAF, 0x00, 0xA8, 0x5C, 0xA9, 0x00, 0x7D, 0x7E, 0x46, 0x00, 0x59, 0x58, 0xD5, 0x00, 0x8F, 0x55, 
0xCD, 0x00, 0xA5, 0x75, 0x5D, 0x00, 0xB5, 0x63, 0x98, 0x00, 0x5D, 0x7A, 0x6D, 0x00, 0xC6, 0x54, 
0xCB, 0x00, 0x4C, 0x76, 0x8A, 0x00, 0x4B, 0x89, 0x4B, 0x00, 0x61, 0x7F, 0x6C, 0x00, 0x69, 0x68, 
0xBC, 0x00, 0x5E, 0x5F, 0xE4, 0x00, 0x9B, 0x5B, 0xDD, 0x00, 0xCD, 0x59, 0xD5, 0x00, 0xB9, 0x64, 
0xB8, 0x00, 0xB2, 0x7E, 0x63, 0x00, 0x88, 0x8B, 0x4D, 0x00, 0x66, 0x84, 0x71, 0x00, 0xD8, 0x5B, 
0xDD, 0x00, 0xC7, 0x6D, 0xA7, 0x00, 0x64, 0x62, 0xEE, 0x00, 0x9F, 0x60, 0xE5, 0x00, 0x51, 0x96, 
0x51, 0x00, 0x6E, 0x6F, 0xCC, 0x00, 0x54, 0x81, 0x9B, 0x00, 0x6B, 0x8A, 0x76, 0x00, 0xA9, 0x62, 
0xEB, 0x00, 0x68, 0x66, 0xF4, 0x00, 0xDD, 0x60, 0xE2, 0x00, 0xC3, 0x6B, 0xC6, 0x00, 0xC1, 0x88, 
0x69, 0x00, 0x68, 0x8C, 0x7B, 0x00, 0x96, 0x96, 0x51, 0x00, 0x68, 0x69, 0xFF, 0x00, 0xE4, 0x62, 
0xED, 0x00, 0xD6, 0x75, 0xB3, 0x00, 0xD0, 0x6F, 0xCF, 0x00, 0xB1, 0x66, 0xF8, 0x00, 0x5A, 0xA1, 
0x55, 0x00, 0x77, 0x77, 0xDB, 0x00, 0xCA, 0x8F, 0x6F, 0x00, 0xA1, 0x9F, 0x56, 0x00, 0xB7, 0x6C, 
0xFE, 0x00, 0x5D, 0x8E, 0xAB, 0x00, 0xD7, 0x76, 0xD6, 0x00, 0xF3, 0x69, 0xFA, 0x00, 0xF7, 0x68, 
0xFF, 0x00, 0x5A, 0xA9, 0x5D, 0x00, 0xD7, 0x98, 0x74, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0xEB, 0x80, 
0xC5, 0x00, 0xE0, 0x7B, 0xE3, 0x00, 0x85, 0x82, 0xF1, 0x00, 0xAD, 0xAC, 0x5A, 0x00, 0x64, 0x99, 
0xB8, 0x00, 0xE1, 0xA0, 0x7A, 0x00, 0x63, 0xB5, 0x62, 0x00, 0xF8, 0x87, 0xCF, 0x00, 0x85, 0x88, 
0xF9, 0x00, 0xF1, 0x83, 0xF1, 0x00, 0xE8, 0xA6, 0x81, 0x00, 0xFF, 0x8C, 0xD7, 0x00, 0x8B, 0x8D, 
0xFF, 0x00, 0xF3, 0xAB, 0x80, 0x00, 0xF8, 0x88, 0xFA, 0x00, 0x68, 0xC2, 0x68, 0x00, 0xBE, 0xBE, 
0x67, 0x00, 0x6D, 0xA9, 0xCB, 0x00, 0xF9, 0xB0, 0x86, 0x00, 0xFF, 0x8C, 0xFF, 0x00, 0x70, 0xCB, 
0x6E, 0x00, 0xFE, 0xB5, 0x8B, 0x00, 0xC6, 0xC6, 0x6A, 0x00, 0x71, 0xD3, 0x73, 0x00, 0x78, 0xB7, 
0xDA, 0x00, 0xCE, 0xCF, 0x72, 0x00, 0x78, 0xDB, 0x78, 0x00, 0x7C, 0xE5, 0x7C, 0x00, 0x7F, 0xC4, 
0xEA, 0x00, 0xDB, 0xDD, 0x78, 0x00, 0x81, 0xED, 0x81, 0x00, 0xE3, 0xE5, 0x7E, 0x00, 0x88, 0xCF, 
0xF5, 0x00, 0x87, 0xF5, 0x84, 0x00, 0xEC, 0xEF, 0x87, 0x00, 0x89, 0xD6, 0xFE, 0x00, 0x87, 0xFA, 
0x8C, 0x00, 0xF1, 0xF3, 0x8C, 0x00, 0x89, 0xFF, 0x88, 0x00, 0xFB, 0xF9, 0x80, 0x00, 0xFF, 0xFF, 
0x87, 0x00, 0x04, 0xFE, 0x6B, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x05, 0xFE, 0x6A, 0x00, 0x11, 0xFE, 
0x00, 0x00, 0x05, 0xFE, 0x6A, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 0x01, 0x08, 
0x60, 0x49, 0x01, 0x1A, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x03, 0x00, 0x01, 0x01, 
0x01, 0xA6, 0x5F, 0xCE, 0x01, 0x36, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x06, 0xFE, 0x04, 0x00, 
0x01, 0x2A, 0x01, 0xC9, 0x5D, 0xCE, 0x01, 0xC9, 0x01, 0x04, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 
0x07, 0xFE, 0x04, 0x00, 0x01, 0x57, 0x5D, 0xCE, 0x01, 0x9E, 0x04, 0x00, 0x12, 0xFE, 0x00, 0x00, 
0x08, 0xFE, 0x04, 0x00, 0x01, 0x57, 0x5C, 0xCE, 0x01, 0x73, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 
0x08, 0xFE, 0x05, 0x00, 0x01, 0x63, 0x38, 0xCE, 0x00, 0x05, 0xBE, 0xB0, 0x9E, 0x92, 0xB9, 0x00, 
0x1E, 0xCE, 0x01, 0x41, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x09, 0xFE, 0x05, 0x00, 0x01, 0x6B, 
0x30, 0xCE, 0x00, 0x07, 0xC9, 0x9E, 0x6B, 0x49, 0x36, 0x1A, 0x04, 0x00, 0x04, 0x00, 0x01, 0x01, 
0x01, 0xA6, 0x1D, 0xCE, 0x01, 0x04, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x0A, 0xFE, 0x05, 0x00, 
0x01, 0x6B, 0x2C, 0xCE, 0x00, 0x04, 0xB9, 0x87, 0x41, 0x08, 0x0B, 0x00, 0x01, 0x6B, 0x1C, 0xCE, 
0x01, 0xC9, 0x04, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x0B, 0xFE, 0x05, 0x00, 0x01, 0x49, 0x01, 0xC9, 
0x27, 0xCE, 0x00, 0x03, 0xB9, 0x63, 0x2A, 0x00, 0x0E, 0x00, 0x01, 0x04, 0x01, 0xB0, 0x1D, 0xCE, 
0x01, 0x04, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x0C, 0xFE, 0x05, 0x00, 0x01, 0x2A, 0x01, 0xB9, 
0x24, 0xCE, 0x00, 0x03, 0xBE, 0x57, 0x01, 0x00, 0x09, 0x00, 0x00, 0x08, 0x06, 0x1A, 0x36, 0x49, 
0x63, 0x7D, 0x87, 0xBE, 0x1E, 0xCE, 0x01, 0x1A, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x0D, 0xFE, 
0x05, 0x00, 0x01, 0x08, 0x01, 0x9E, 0x21, 0xCE, 0x00, 0x03, 0xBE, 0x63, 0x04, 0x00, 0x07, 0x00, 
0x00, 0x04, 0x1A, 0x57, 0x92, 0xBE, 0x26, 0xCE, 0x01, 0x49, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 
0x0F, 0xFE, 0x04, 0x00, 0x01, 0x04, 0x01, 0x7D, 0x1E, 0xCE, 0x00, 0x03, 0xC9, 0x73, 0x04, 0x00, 
0x05, 0x00, 0x00, 0x04, 0x04, 0x41, 0x7D, 0xB0, 0x2A, 0xCE, 0x01, 0x87, 0x04, 0x00, 0x12, 0xFE, 
0x00, 0x00, 0x10, 0xFE, 0x05, 0x00, 0x01, 0x49, 0x01, 0xC9, 0x1B, 0xCE, 0x01, 0xBE, 0x01, 0x2A, 
0x05, 0x00, 0x00, 0x03, 0x08, 0x6B, 0xC9, 0x00, 0x2D, 0xCE, 0x01, 0xC9, 0x01, 0x08, 0x03, 0x00, 
0x12, 0xFE, 0x00, 0x00, 0x11, 0xFE, 0x05, 0x00, 0x01, 0x1A, 0x01, 0xA6, 0x19, 0xCE, 0x01, 0xA6, 
0x01, 0x0E, 0x04, 0x00, 0x00, 0x03, 0x04, 0x63, 0xBE, 0x00, 0x30, 0xCE, 0x01, 0x63, 0x03, 0x00, 
0x12, 0xFE, 0x00, 0x00, 0x12, 0xFE, 0x05, 0x00, 0x01, 0x01, 0x01, 0x6B, 0x17, 0xCE, 0x01, 0x9E, 
0x01, 0x08, 0x03, 0x00, 0x00, 0x03, 0x01, 0x57, 0xBE, 0x00, 0x32, 0xCE, 0x01, 0xA6, 0x04, 0x00, 
0x11, 0xFE, 0x00, 0x00, 0x14, 0xFE, 0x05, 0x00, 0x01, 0x36, 0x01, 0xB0, 0x14, 0xCE, 0x01, 0x87, 
0x01, 0x01, 0x03, 0x00, 0x01, 0x04, 0x01, 0x92, 0x23, 0xCE, 0x01, 0x92, 0x11, 0xCE, 0x01, 0x2A, 
0x03, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x15, 0xFE, 0x05, 0x00, 0x01, 0x04, 0x01, 0x7D, 0x12, 0xCE, 
0x01, 0x87, 0x04, 0x00, 0x01, 0x0E, 0x01, 0xA6, 0x23, 0xCE, 0x00, 0x03, 0x7D, 0x08, 0xC9, 0x00, 
0x10, 0xCE, 0x01, 0x87, 0x04, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x16, 0xFE, 0x06, 0x00, 0x01, 0x36, 
0x01, 0xB0, 0x0F, 0xCE, 0x01, 0xB9, 0x01, 0x08, 0x03, 0x00, 0x01, 0x2A, 0x01, 0xB9, 0x23, 0xCE, 
0x00, 0x04, 0xB0, 0x06, 0x00, 0x87, 0x10, 0xCE, 0x01, 0xC9, 0x01, 0x04, 0x03, 0x00, 0x10, 0xFE, 
0x00, 0x00, 0x18, 0xFE, 0x05, 0x00, 0x01, 0x04, 0x01, 0x7D, 0x0E, 0xCE, 0x01, 0x41, 0x03, 0x00, 
0x01, 0x36, 0x01, 0xBE, 0x23, 0xCE, 0x00, 0x05, 0xC9, 0x2A, 0x00, 0x00, 0x2A, 0x00, 0x11, 0xCE, 
0x01, 0x57, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x19, 0xFE, 0x06, 0x00, 0x01, 0x36, 0x01, 0xB9, 
0x0B, 0xCE, 0x01, 0x87, 0x03, 0x00, 0x01, 0x08, 0x01, 0xBE, 0x24, 0xCE, 0x01, 0x6B, 0x04, 0x00, 
0x01, 0x9E, 0x10, 0xCE, 0x01, 0x9E, 0x04, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x1B, 0xFE, 0x05, 0x00, 
0x01, 0x08, 0x01, 0x87, 0x09, 0xCE, 0x01, 0xBE, 0x01, 0x08, 0x03, 0x00, 0x01, 0x87, 0x24, 0xCE, 
0x01, 0x9E, 0x01, 0x01, 0x04, 0x00, 0x01, 0x41, 0x11, 0xCE, 0x01, 0x1A, 0x03, 0x00, 0x0F, 0xFE, 
0x00, 0x00, 0x1C, 0xFE, 0x06, 0x00, 0x01, 0x49, 0x08, 0xCE, 0x01, 0x41, 0x03, 0x00, 0x01, 0x41, 
0x24, 0xCE, 0x01, 0xC9, 0x01, 0x1A, 0x05, 0x00, 0x01, 0x01, 0x01, 0xB0, 0x10, 0xCE, 0x01, 0x6B, 
0x03, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x1E, 0xFE, 0x05, 0x00, 0x01, 0x41, 0x01, 0xC9, 0x05, 0xCE, 
0x00, 0x06, 0xBE, 0x01, 0x00, 0x00, 0x08, 0xB9, 0x24, 0xCE, 0x01, 0x57, 0x03, 0x00, 0x01, 0x03, 
0x03, 0x00, 0x01, 0x57, 0x10, 0xCE, 0x01, 0xB0, 0x01, 0x01, 0x03, 0x00, 0x0E, 0xFE, 0x00, 0x00, 
0x1F, 0xFE, 0x05, 0x00, 0x01, 0x41, 0x01, 0xC9, 0x04, 0xCE, 0x01, 0x87, 0x03, 0x00, 0x01, 0x73, 
0x24, 0xCE, 0x01, 0x92, 0x03, 0x00, 0x00, 0x07, 0x03, 0x98, 0x05, 0x00, 0x00, 0x04, 0xBE, 0x00, 
0x10, 0xCE, 0x01, 0x36, 0x03, 0x00, 0x0E, 0xFE, 0x00, 0x00, 0x20, 0xFE, 0x05, 0x00, 0x01, 0x63, 
0x04, 0xCE, 0x01, 0x41, 0x03, 0x00, 0x01, 0xB0, 0x23, 0xCE, 0x01, 0xBE, 0x01, 0x08, 0x03, 0x00, 
0x00, 0x03, 0x71, 0xC3, 0x5A, 0x00, 0x03, 0x00, 0x01, 0x73, 0x10, 0xCE, 0x01, 0x57, 0x03, 0x00, 
0x0E, 0xFE, 0x00, 0x00, 0x22, 0xFE, 0x03, 0x00, 0x00, 0x09, 0x04, 0xBE, 0xCE, 0xCE, 0xC9, 0x04, 
0x00, 0x00, 0x1A, 0x00, 0x24, 0xCE, 0x01, 0x41, 0x03, 0x00, 0x00, 0x09, 0x32, 0xBD, 0xC3, 0xA9, 
0x03, 0x00, 0x00, 0x0E, 0xC9, 0x00, 0x0F, 0xCE, 0x01, 0x7D, 0x03, 0x00, 0x0E, 0xFE, 0x00, 0x00, 
0x22, 0xFE, 0x04, 0x00, 0x00, 0x04, 0x57, 0xCE, 0xCE, 0x92, 0x03, 0x00, 0x01, 0x63, 0x23, 0xCE, 
0x01, 0x9E, 0x03, 0x00, 0x01, 0x05, 0x01, 0xAD, 0x03, 0xC3, 0x01, 0x52, 0x03, 0x00, 0x01, 0x87, 
0x0F, 0xCE, 0x01, 0x92, 0x03, 0x00, 0x0E, 0xFE, 0x00, 0x00, 0x23, 0xFE, 0x03, 0x00, 0x00, 0x04, 
0x01, 0xB0, 0xCE, 0x57, 0x03, 0x00, 0x01, 0x9E, 0x23, 0xCE, 0x01, 0x41, 0x03, 0x00, 0x01, 0x83, 
0x04, 0xC3, 0x01, 0x9F, 0x03, 0x00, 0x01, 0x2A, 0x0F, 0xCE, 0x01, 0xA6, 0x03, 0x00, 0x0E, 0xFE, 
0x00, 0x00, 0x24, 0xFE, 0x03, 0x00, 0x00, 0x07, 0x6B, 0xCE, 0x2A, 0x00, 0x00, 0x08, 0xC9, 0x00, 
0x22, 0xCE, 0x00, 0x06, 0xA6, 0x01, 0x00, 0x00, 0x0C, 0xBD, 0x05, 0xC3, 0x01, 0x32, 0x03, 0x00, 
0x01, 0xA6, 0x0E, 0xCE, 0x01, 0xB0, 0x04, 0x00, 0x0D, 0xFE, 0x00, 0x00, 0x24, 0xFE, 0x03, 0x00, 
0x00, 0x06, 0x1A, 0xCE, 0x1A, 0x00, 0x00, 0x2A, 0x23, 0xCE, 0x01, 0x57, 0x03, 0x00, 0x01, 0x7B, 
0x06, 0xC3, 0x01, 0x8B, 0x03, 0x00, 0x01, 0x6B, 0x0E, 0xCE, 0x01, 0xB0, 0x04, 0x00, 0x0D, 0xFE, 
0x00, 0x00, 0x24, 0xFE, 0x04, 0x00, 0x00, 0x05, 0x9E, 0x1A, 0x00, 0x00, 0x2A, 0x00, 0x22, 0xCE, 
0x00, 0x06, 0xC9, 0x08, 0x00, 0x00, 0x0C, 0xBD, 0x06, 0xC3, 0x00, 0x05, 0xB5, 0x03, 0x00, 0x00, 
0x36, 0x00, 0x0E, 0xCE, 0x01, 0xB0, 0x04, 0x00, 0x0D, 0xFE, 0x00, 0x00, 0x25, 0xFE, 0x03, 0x00, 
0x00, 0x05, 0x57, 0x1A, 0x00, 0x00, 0x2A, 0x00, 0x22, 0xCE, 0x01, 0x9E, 0x03, 0x00, 0x01, 0x5A, 
0x08, 0xC3, 0x00, 0x05, 0x29, 0x00, 0x00, 0x04, 0xC9, 0x00, 0x0D, 0xCE, 0x01, 0xA6, 0x04, 0x00, 
0x0D, 0xFE, 0x00, 0x00, 0x25, 0xFE, 0x03, 0x00, 0x00, 0x05, 0x08, 0x1A, 0x00, 0x00, 0x2A, 0x00, 
0x22, 0xCE, 0x01, 0x57, 0x03, 0x00, 0x01, 0x98, 0x08, 0xC3, 0x01, 0x5A, 0x03, 0x00, 0x01, 0xA6, 
0x0D, 0xCE, 0x01, 0x87, 0x03, 0x00, 0x0E, 0xFE, 0x00, 0x00, 0x25, 0xFE, 0x04, 0x00, 0x00, 0x04, 
0x0E, 0x00, 0x00, 0x2A, 0x22, 0xCE, 0x00, 0x04, 0x0E, 0x00, 0x00, 0x0C, 0x09, 0xC3, 0x01, 0x8B, 
0x03, 0x00, 0x01, 0x73, 0x0D, 0xCE, 0x01, 0x6B, 0x03, 0x00, 0x0E, 0xFE, 0x00, 0x00, 0x26, 0xFE, 
0x03, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x2A, 0x21, 0xCE, 0x01, 0xBE, 0x03, 0x00, 0x01, 0x52, 
0x09, 0xC3, 0x00, 0x05, 0xB5, 0x03, 0x00, 0x00, 0x41, 0x00, 0x0D, 0xCE, 0x01, 0x41, 0x03, 0x00, 
0x0E, 0xFE, 0x00, 0x00, 0x26, 0xFE, 0x06, 0x00, 0x01, 0x0E, 0x21, 0xCE, 0x01, 0x9E, 0x03, 0x00, 
0x01, 0x71, 0x0A, 0xC3, 0x00, 0x04, 0x20, 0x00, 0x00, 0x08, 0x0D, 0xCE, 0x01, 0x1A, 0x03, 0x00, 
0x0E, 0xFE, 0x00, 0x00, 0x27, 0xFE, 0x06, 0x00, 0x01, 0xB9, 0x20, 0xCE, 0x01, 0x87, 0x03, 0x00, 
0x01, 0x83, 0x0A, 0xC3, 0x01, 0x5A, 0x03, 0x00, 0x01, 0xA6, 0x0B, 0xCE, 0x01, 0xC9, 0x01, 0x04, 
0x03, 0x00, 0x0E, 0xFE, 0x00, 0x00, 0x27, 0xFE, 0x06, 0x00, 0x01, 0x87, 0x20, 0xCE, 0x01, 0x6B, 
0x03, 0x00, 0x01, 0x9F, 0x0A, 0xC3, 0x01, 0x8B, 0x03, 0x00, 0x01, 0x7D, 0x0B, 0xCE, 0x01, 0xA6, 
0x04, 0x00, 0x0E, 0xFE, 0x00, 0x00, 0x28, 0xFE, 0x05, 0x00, 0x01, 0x49, 0x20, 0xCE, 0x01, 0x49, 
0x03, 0x00, 0x01, 0xB5, 0x0A, 0xC3, 0x01, 0xAD, 0x03, 0x00, 0x01, 0x57, 0x0B, 0xCE, 0x01, 0x7D, 
0x03, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x28, 0xFE, 0x05, 0x00, 0x01, 0x0E, 0x20, 0xCE, 0x00, 0x04, 
0x36, 0x00, 0x00, 0x05, 0x0C, 0xC3, 0x00, 0x04, 0x03, 0x00, 0x00, 0x49, 0x0B, 0xCE, 0x01, 0x36, 
0x03, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x29, 0xFE, 0x05, 0x00, 0x01, 0xA6, 0x1F, 0xCE, 0x00, 0x04, 
0x0E, 0x00, 0x00, 0x29, 0x0C, 0xC3, 0x00, 0x04, 0x05, 0x00, 0x00, 0x41, 0x0A, 0xCE, 0x01, 0xBE, 
0x01, 0x01, 0x03, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x2A, 0xFE, 0x04, 0x00, 0x01, 0x63, 0x1E, 0xCE, 
0x01, 0xC9, 0x03, 0x00, 0x01, 0x47, 0x0C, 0xC3, 0x00, 0x04, 0x0C, 0x00, 0x00, 0x36, 0x0A, 0xCE, 
0x01, 0x87, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x2A, 0xFE, 0x04, 0x00, 0x01, 0x04, 0x01, 0xC9, 
0x1D, 0xCE, 0x01, 0xB9, 0x03, 0x00, 0x01, 0x52, 0x0C, 0xC3, 0x00, 0x04, 0x20, 0x00, 0x00, 0x1A, 
0x0A, 0xCE, 0x01, 0x41, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x2B, 0xFE, 0x04, 0x00, 0x01, 0x57, 
0x1D, 0xCE, 0x01, 0xC9, 0x03, 0x00, 0x01, 0x52, 0x0C, 0xC3, 0x00, 0x04, 0x29, 0x00, 0x00, 0x0E, 
0x09, 0xCE, 0x01, 0xC9, 0x01, 0x04, 0x03, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x2C, 0xFE, 0x04, 0x00, 
0x01, 0x92, 0x1D, 0xCE, 0x03, 0x00, 0x01, 0x47, 0x0C, 0xC3, 0x00, 0x04, 0x32, 0x00, 0x00, 0x04, 
0x09, 0xCE, 0x01, 0x92, 0x04, 0x00, 0x10, 0xFE, 0x00, 0x00, 0x2D, 0xFE, 0x03, 0x00, 0x01, 0x04, 
0x01, 0xA6, 0x12, 0xCE, 0x00, 0x03, 0xB0, 0x9E, 0xC9, 0x00, 0x07, 0xCE, 0x00, 0x04, 0x01, 0x00, 
0x00, 0x40, 0x0C, 0xC3, 0x01, 0x47, 0x03, 0x00, 0x00, 0x05, 0xC9, 0xCE, 0xBE, 0x92, 0xBE, 0x00, 
0x04, 0xCE, 0x01, 0x63, 0x03, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x2D, 0xFE, 0x04, 0x00, 0x01, 0x08, 
0x01, 0xB0, 0x10, 0xCE, 0x00, 0x05, 0x63, 0x00, 0x00, 0x08, 0x9E, 0x00, 0x06, 0xCE, 0x00, 0x04, 
0x08, 0x00, 0x00, 0x32, 0x0C, 0xC3, 0x01, 0x40, 0x03, 0x00, 0x00, 0x06, 0xC9, 0x7D, 0x01, 0x00, 
0x04, 0x87, 0x03, 0xCE, 0x01, 0x1A, 0x03, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x2E, 0xFE, 0x04, 0x00, 
0x01, 0x0E, 0x01, 0xB9, 0x0E, 0xCE, 0x01, 0x87, 0x04, 0x00, 0x01, 0x08, 0x01, 0xBE, 0x05, 0xCE, 
0x00, 0x04, 0x0E, 0x00, 0x00, 0x29, 0x0C, 0xC3, 0x00, 0x05, 0x20, 0x00, 0x00, 0x0E, 0xA6, 0x00, 
0x04, 0x00, 0x00, 0x04, 0x01, 0xB0, 0xCE, 0xBE, 0x04, 0x00, 0x11, 0xFE, 0x00, 0x00, 0x2F, 0xFE, 
0x04, 0x00, 0x01, 0x1A, 0x01, 0xBE, 0x0D, 0xCE, 0x01, 0x1A, 0x05, 0x00, 0x01, 0x7D, 0x05, 0xCE, 
0x00, 0x04, 0x1A, 0x00, 0x00, 0x20, 0x0C, 0xC3, 0x00, 0x05, 0x03, 0x00, 0x00, 0x36, 0x49, 0x00, 
0x05, 0x00, 0x00, 0x03, 0x57, 0xCE, 0x87, 0x00, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x30, 0xFE, 
0x04, 0x00, 0x01, 0x36, 0x01, 0xC9, 0x0B, 0xCE, 0x01, 0xC9, 0x01, 0x01, 0x05, 0x00, 0x01, 0x57, 
0x05, 0xCE, 0x00, 0x04, 0x1A, 0x00, 0x00, 0x18, 0x0B, 0xC3, 0x01, 0xA9, 0x03, 0x00, 0x01, 0x57, 
0x01, 0x1A, 0x05, 0x00, 0x00, 0x03, 0x2A, 0xCE, 0x49, 0x00, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 
0x31, 0xFE, 0x04, 0x00, 0x01, 0x41, 0x0B, 0xCE, 0x01, 0xBE, 0x06, 0x00, 0x01, 0x41, 0x05, 0xCE, 
0x00, 0x04, 0x2A, 0x00, 0x00, 0x0C, 0x0B, 0xC3, 0x01, 0x91, 0x03, 0x00, 0x01, 0x7D, 0x01, 0x08, 
0x05, 0x00, 0x00, 0x03, 0x1A, 0xCE, 0x0E, 0x00, 0x03, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x32, 0xFE, 
0x04, 0x00, 0x01, 0x57, 0x0B, 0xCE, 0x01, 0x04, 0x05, 0x00, 0x01, 0x63, 0x05, 0xCE, 0x00, 0x05, 
0x36, 0x00, 0x00, 0x03, 0xB5, 0x00, 0x0A, 0xC3, 0x01, 0x71, 0x03, 0x00, 0x01, 0x92, 0x01, 0x36, 
0x05, 0x00, 0x01, 0x41, 0x01, 0xA6, 0x04, 0x00, 0x12, 0xFE, 0x00, 0x00, 0x33, 0xFE, 0x04, 0x00, 
0x01, 0x63, 0x0A, 0xCE, 0x01, 0x49, 0x05, 0x00, 0x01, 0x9E, 0x05, 0xCE, 0x01, 0x6B, 0x03, 0x00, 
0x01, 0x7B, 0x0A, 0xC3, 0x01, 0x40, 0x03, 0x00, 0x01, 0xB0, 0x01, 0x73, 0x05, 0x00, 0x01, 0x87, 
0x01, 0x7D, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x34, 0xFE, 0x04, 0x00, 0x01, 0x7D, 0x09, 0xCE, 
0x01, 0xB0, 0x01, 0x08, 0x03, 0x00, 0x01, 0x49, 0x06, 0xCE, 0x01, 0xA6, 0x03, 0x00, 0x01, 0x03, 
0x01, 0x8B, 0x08, 0xC3, 0x01, 0x67, 0x03, 0x00, 0x00, 0x04, 0x08, 0xC9, 0xC9, 0x1A, 0x03, 0x00, 
0x00, 0x03, 0x2A, 0xC9, 0x41, 0x00, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 0x34, 0xFE, 0x04, 0x00, 
0x01, 0x01, 0x01, 0x87, 0x09, 0xCE, 0x00, 0x04, 0xB0, 0x57, 0x36, 0x73, 0x08, 0xCE, 0x01, 0x2A, 
0x04, 0x00, 0x00, 0x08, 0x29, 0x71, 0x91, 0xA9, 0x9F, 0x98, 0x5A, 0x18, 0x04, 0x00, 0x00, 0x0A, 
0x87, 0xCE, 0xCE, 0xBE, 0x63, 0x36, 0x63, 0xC9, 0xB0, 0x01, 0x03, 0x00, 0x13, 0xFE, 0x00, 0x00, 
0x35, 0xFE, 0x04, 0x00, 0x01, 0x04, 0x01, 0x92, 0x14, 0xCE, 0x01, 0xB9, 0x01, 0x1A, 0x0E, 0x00, 
0x01, 0x2A, 0x08, 0xCE, 0x01, 0x49, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x36, 0xFE, 0x04, 0x00, 
0x01, 0x04, 0x01, 0xA6, 0x14, 0xCE, 0x01, 0xBE, 0x01, 0x2A, 0x0B, 0x00, 0x00, 0x03, 0x01, 0x57, 
0xC9, 0x00, 0x07, 0xCE, 0x01, 0xA6, 0x01, 0x01, 0x03, 0x00, 0x14, 0xFE, 0x00, 0x00, 0x37, 0xFE, 
0x04, 0x00, 0x01, 0x08, 0x01, 0xA6, 0x15, 0xCE, 0x01, 0x87, 0x01, 0x2A, 0x07, 0x00, 0x00, 0x03, 
0x04, 0x41, 0x9E, 0x00, 0x09, 0xCE, 0x01, 0x36, 0x03, 0x00, 0x15, 0xFE, 0x00, 0x00, 0x38, 0xFE, 
0x04, 0x00, 0x01, 0x08, 0x01, 0x9E, 0x16, 0xCE, 0x00, 0x08, 0xB0, 0x92, 0x7D, 0x63, 0x73, 0x87, 
0x92, 0xC9, 0x0A, 0xCE, 0x01, 0x6B, 0x04, 0x00, 0x15, 0xFE, 0x00, 0x00, 0x39, 0xFE, 0x04, 0x00, 
0x01, 0x04, 0x01, 0x92, 0x26, 0xCE, 0x01, 0x87, 0x04, 0x00, 0x16, 0xFE, 0x00, 0x00, 0x3A, 0xFE, 
0x04, 0x00, 0x01, 0x01, 0x01, 0x92, 0x24, 0xCE, 0x01, 0x9E, 0x01, 0x01, 0x04, 0x00, 0x16, 0xFE, 
0x00, 0x00, 0x3B, 0xFE, 0x05, 0x00, 0x01, 0x57, 0x01, 0xC9, 0x21, 0xCE, 0x01, 0x92, 0x01, 0x04, 
0x04, 0x00, 0x17, 0xFE, 0x00, 0x00, 0x3C, 0xFE, 0x05, 0x00, 0x01, 0x1A, 0x01, 0xA6, 0x1F, 0xCE, 
0x01, 0x63, 0x05, 0x00, 0x18, 0xFE, 0x00, 0x00, 0x3D, 0xFE, 0x05, 0x00, 0x00, 0x03, 0x01, 0x6B, 
0xC9, 0x00, 0x1B, 0xCE, 0x01, 0xB9, 0x01, 0x36, 0x05, 0x00, 0x19, 0xFE, 0x00, 0x00, 0x3F, 0xFE, 
0x05, 0x00, 0x00, 0x03, 0x08, 0x6B, 0xBE, 0x00, 0x17, 0xCE, 0x00, 0x03, 0xA6, 0x49, 0x01, 0x00, 
0x05, 0x00, 0x1A, 0xFE, 0x00, 0x00, 0x40, 0xFE, 0x06, 0x00, 0x00, 0x03, 0x08, 0x6B, 0xB9, 0x00, 
0x13, 0xCE, 0x01, 0x9E, 0x01, 0x41, 0x07, 0x00, 0x1B, 0xFE, 0x00, 0x00, 0x41, 0xFE, 0x08, 0x00, 
0x00, 0x03, 0x2A, 0x6B, 0xA6, 0x00, 0x0C, 0xCE, 0x00, 0x04, 0xB9, 0x87, 0x57, 0x0E, 0x07, 0x00, 
0x1D, 0xFE, 0x00, 0x00, 0x43, 0xFE, 0x09, 0x00, 0x00, 0x0C, 0x08, 0x36, 0x49, 0x63, 0x87, 0x92, 
0x87, 0x7D, 0x73, 0x63, 0x49, 0x1A, 0x09, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x45, 0xFE, 0x1A, 0x00, 
0x21, 0xFE, 0x00, 0x00, 0x48, 0xFE, 0x15, 0x00, 0x23, 0xFE, 0x00, 0x00, 0x4B, 0xFE, 0x0E, 0x00, 
0x27, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 
0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x00, 0x80, 0xFE, 0x00, 0x01, 
};

